/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.stores;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import org.planx.xmlstore.NameServer;
import org.planx.xmlstore.Node;
import org.planx.xmlstore.Reference;
import org.planx.xmlstore.UnknownReferenceException;
import org.planx.xmlstore.XMLStore;
import org.planx.xmlstore.nameserver.GlobalNameServer;
import org.planx.xmlstore.references.ValueReference;
import org.planx.xmlstore.routing.DistributedMap;
import org.planx.xmlstore.routing.Identifier;
import org.planx.xmlstore.routing.Kademlia;
import org.planx.xmlstore.stores.AbstractXMLStore;
import org.planx.xmlstore.stores.NetworkProxy;
import org.planx.xmlstore.stores.NetworkSkeleton;

public class DistributedXMLStore
extends AbstractXMLStore {
    private NetworkSkeleton networkSkeleton;
    private DistributedMap distMap;
    private InetSocketAddress tcpAddr;
    private NameServer nameServer = null;

    public DistributedXMLStore(XMLStore xmlstore, int udpPort, int tcpPort, InetSocketAddress bootstrap) throws IOException {
        super(xmlstore);
        String name = xmlstore.toString();
        this.distMap = new Kademlia(name, udpPort, tcpPort, bootstrap, null);
        this.tcpAddr = new InetSocketAddress(InetAddress.getLocalHost(), tcpPort);
        this.networkSkeleton = new NetworkSkeleton(xmlstore, tcpPort);
    }

    public NameServer getNameServer() {
        if (this.nameServer == null) {
            this.nameServer = new GlobalNameServer(this.distMap);
        }
        return this.nameServer;
    }

    @Override
    public void close() throws IOException {
        this.checkClosed();
        this.distMap.close();
        this.networkSkeleton.close();
        super.close();
    }

    @Override
    public Reference save(Node node) throws IOException {
        this.checkClosed();
        ValueReference vref = (ValueReference)this.xmlstore.save(node);
        Identifier id = vref.asIdentifier();
        List locations = (List)((Object)this.distMap.get(id));
        if (locations == null) {
            this.distMap.put(id, (Serializable)((Object)Collections.singletonList(this.tcpAddr)));
        }
        return vref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Node resolvedLoad(Reference vref) throws IOException, UnknownReferenceException {
        this.checkClosed();
        ValueReference gref = (ValueReference)vref;
        try {
            return this.xmlstore.load(gref);
        }
        catch (UnknownReferenceException ue) {
            List locations = (List)((Object)this.distMap.get(gref.asIdentifier()));
            if (locations == null) {
                throw new UnknownReferenceException("Reference not found locally or globally");
            }
            Node node = null;
            int max = locations.size();
            for (int i = 0; i < max; ++i) {
                XMLStore extStore = null;
                try {
                    InetSocketAddress addr = (InetSocketAddress)locations.get(i);
                    extStore = new NetworkProxy(addr);
                    node = extStore.load(gref);
                    this.loadTree(node);
                    extStore.close();
                    extStore = null;
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (UnknownReferenceException e) {
                    e.printStackTrace();
                    continue;
                }
                finally {
                    if (extStore != null) {
                        extStore.close();
                        extStore = null;
                    }
                }
            }
            if (node == null) {
                throw new UnknownReferenceException("Could not load node from external peer");
            }
            return node;
        }
    }

    private void loadTree(Node node) {
        List<? extends Node> children = node.getChildren();
        for (Node node2 : children) {
            this.loadTree(node2);
        }
    }
}

