/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.routing.operation;

import java.io.IOException;
import java.util.Map;
import org.planx.xmlstore.routing.Identifier;
import org.planx.xmlstore.routing.Node;
import org.planx.xmlstore.routing.Space;
import org.planx.xmlstore.routing.TimestampedValue;
import org.planx.xmlstore.routing.messaging.Message;
import org.planx.xmlstore.routing.messaging.MessageServer;
import org.planx.xmlstore.routing.operation.OriginReceiver;
import org.planx.xmlstore.routing.operation.StoreMessage;

public class StoreReceiver
extends OriginReceiver {
    private Map localMap;

    public StoreReceiver(MessageServer server, Node local, Space space, Map localMap) {
        super(server, local, space);
        this.localMap = localMap;
    }

    @Override
    public void receive(Message incoming, int comm) throws IOException {
        super.receive(incoming, comm);
        StoreMessage mess = (StoreMessage)incoming;
        Node origin = mess.getOrigin();
        Identifier key = mess.getKey();
        TimestampedValue incmValue = mess.getValue();
        TimestampedValue exstValue = (TimestampedValue)this.localMap.get(key);
        if (exstValue == null || incmValue.timestamp() > exstValue.timestamp()) {
            this.localMap.put(key, incmValue);
        } else if (exstValue != null && mess.updateRequested() && exstValue.timestamp() > incmValue.timestamp()) {
            StoreMessage updmess = new StoreMessage(this.local, key, exstValue, false);
            this.server.send(updmess, origin.getInetAddress(), origin.getPort(), null);
        }
    }
}

