/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.routing.operation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.planx.xmlstore.routing.Node;
import org.planx.xmlstore.routing.operation.OriginMessage;

public class HashMessage
extends OriginMessage {
    protected long baseTime;
    protected List hashes;

    protected HashMessage() {
    }

    public HashMessage(Node origin, long baseTime, List hashes) {
        super(origin);
        this.baseTime = baseTime;
        this.hashes = hashes;
    }

    public HashMessage(DataInput in) throws IOException {
        this.fromStream(in);
    }

    @Override
    public void fromStream(DataInput in) throws IOException {
        super.fromStream(in);
        this.baseTime = in.readLong();
        int len = in.readInt();
        this.hashes = new ArrayList(len);
        for (int i = 0; i < len; ++i) {
            byte[] a = new byte[16];
            in.readFully(a);
            this.hashes.add(a);
        }
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
        super.toStream(out);
        out.writeLong(this.baseTime);
        int len = this.hashes.size();
        out.writeInt(len);
        for (int i = 0; i < len; ++i) {
            out.write((byte[])this.hashes.get(i));
        }
    }

    public long getBaseTime() {
        return this.baseTime;
    }

    public List getHashes() {
        return this.hashes;
    }

    @Override
    public byte code() {
        return 9;
    }

    public String toString() {
        return "HashMessage[origin=" + this.origin + ",baseTime=" + this.baseTime + ",hashes=" + this.hashes + "]";
    }
}

