/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.routing.operation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.planx.xmlstore.routing.Identifier;
import org.planx.xmlstore.routing.Node;
import org.planx.xmlstore.routing.TimestampedValue;
import org.planx.xmlstore.routing.operation.OriginMessage;

public class DataMessage
extends OriginMessage {
    protected Identifier key;
    protected TimestampedValue value;

    protected DataMessage() {
    }

    public DataMessage(Node origin, Identifier key, TimestampedValue value) {
        super(origin);
        this.key = key;
        this.value = value;
    }

    public DataMessage(DataInput in) throws IOException {
        this.fromStream(in);
    }

    @Override
    public void fromStream(DataInput in) throws IOException {
        super.fromStream(in);
        this.key = new Identifier(in);
        this.value = new TimestampedValue(in);
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
        super.toStream(out);
        this.key.toStream(out);
        this.value.toStream(out);
    }

    public Identifier getKey() {
        return this.key;
    }

    public TimestampedValue getValue() {
        return this.value;
    }

    @Override
    public byte code() {
        return 6;
    }

    public String toString() {
        return "DataMessage[origin=" + this.origin + ",key=" + this.key + ",value=" + this.value + "]";
    }
}

