/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.routing.operation;

import java.io.IOException;
import java.io.Serializable;
import org.planx.xmlstore.routing.Configuration;
import org.planx.xmlstore.routing.Identifier;
import org.planx.xmlstore.routing.Node;
import org.planx.xmlstore.routing.RoutingException;
import org.planx.xmlstore.routing.Space;
import org.planx.xmlstore.routing.messaging.Message;
import org.planx.xmlstore.routing.messaging.MessageServer;
import org.planx.xmlstore.routing.operation.DataLookupMessage;
import org.planx.xmlstore.routing.operation.DataMessage;
import org.planx.xmlstore.routing.operation.NodeLookupOperation;

public class DataLookupOperation
extends NodeLookupOperation {
    protected Serializable value = null;

    public DataLookupOperation(Configuration conf, MessageServer server, Space space, Node local, Identifier id) {
        super(conf, server, space, local, id);
        this.lookupMessage = new DataLookupMessage(local, id);
    }

    @Override
    public synchronized Object execute() throws IOException, RoutingException {
        super.execute();
        return this.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void receive(Message incoming, int comm) throws IOException {
        if (incoming instanceof DataMessage) {
            DataMessage mess = (DataMessage)incoming;
            this.space.insertNode(mess.getOrigin());
            if (!this.id.equals(mess.getKey())) throw new IOException("Key in DataMessage received does not match looked up key");
            this.value = mess.getValue().getObject();
            this.error = false;
            this.notify();
            return;
        } else {
            super.receive(incoming, comm);
        }
    }
}

