/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.routing.operation;

import java.io.IOException;
import java.net.InetAddress;
import org.planx.xmlstore.routing.Configuration;
import org.planx.xmlstore.routing.Node;
import org.planx.xmlstore.routing.RoutingException;
import org.planx.xmlstore.routing.Space;
import org.planx.xmlstore.routing.messaging.Message;
import org.planx.xmlstore.routing.messaging.MessageServer;
import org.planx.xmlstore.routing.messaging.Receiver;
import org.planx.xmlstore.routing.operation.AcknowledgeMessage;
import org.planx.xmlstore.routing.operation.ConnectMessage;
import org.planx.xmlstore.routing.operation.NodeLookupOperation;
import org.planx.xmlstore.routing.operation.Operation;
import org.planx.xmlstore.routing.operation.RefreshOperation;

public class ConnectOperation
extends Operation
implements Receiver {
    private static final int MAX_ATTEMPTS = 5;
    private Configuration conf;
    private MessageServer server;
    private Space space;
    private Node local;
    private InetAddress bootstrap;
    private int bootPort;
    private boolean error;
    private int attempts;

    public ConnectOperation(Configuration conf, MessageServer server, Space space, Node local, InetAddress bootstrap, int bootPort) {
        if (bootstrap == null) {
            throw new NullPointerException("Bootstrap node null");
        }
        this.conf = conf;
        this.server = server;
        this.space = space;
        this.local = local;
        this.bootstrap = bootstrap;
        this.bootPort = bootPort;
    }

    @Override
    public synchronized Object execute() throws IOException, RoutingException {
        try {
            this.error = true;
            this.attempts = 0;
            ConnectMessage mess = new ConnectMessage(this.local);
            this.server.send(mess, this.bootstrap, this.bootPort, this);
            this.wait(this.conf.OPERATION_TIMEOUT);
            if (this.error) {
                throw new RoutingException("Bootstrap node did not respond: " + this.bootstrap + ":" + this.bootPort);
            }
            NodeLookupOperation lookup = new NodeLookupOperation(this.conf, this.server, this.space, this.local, this.local.getId());
            ((Operation)lookup).execute();
            RefreshOperation refresh = new RefreshOperation(this.conf, this.server, this.space, this.local);
            ((Operation)refresh).execute();
            return null;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void receive(Message incoming, int comm) throws IOException {
        AcknowledgeMessage mess = (AcknowledgeMessage)incoming;
        this.space.insertNode(mess.getOrigin());
        this.error = false;
        this.notify();
    }

    @Override
    public synchronized void timeout(int comm) throws IOException {
        if (++this.attempts < 5) {
            ConnectMessage mess = new ConnectMessage(this.local);
            this.server.send(mess, this.bootstrap, this.bootPort, this);
        } else {
            this.notify();
        }
    }
}

