/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.regions;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.planx.util.WeakHashSet;
import org.planx.xmlstore.UnknownReferenceException;
import org.planx.xmlstore.XMLStore;
import org.planx.xmlstore.io.FileSystem;
import org.planx.xmlstore.io.FileSystemIdentifier;
import org.planx.xmlstore.io.LocalFileSystem;
import org.planx.xmlstore.io.LocalLocator;
import org.planx.xmlstore.io.Streamer;
import org.planx.xmlstore.io.Streamers;
import org.planx.xmlstore.nodes.NodeConverter;
import org.planx.xmlstore.nodes.SystemNode;
import org.planx.xmlstore.references.ReferenceListener;
import org.planx.xmlstore.regions.HashSharer;
import org.planx.xmlstore.regions.InterRegionEdge;
import org.planx.xmlstore.regions.MSDSharer;
import org.planx.xmlstore.regions.Region;
import org.planx.xmlstore.regions.RegionConfiguration;
import org.planx.xmlstore.regions.Sharer;

public class RegionManager {
    private static final Object PRESENT = new Object();
    private XMLStore xmlstore;
    private FileSystem fs;
    private NodeConverter dnav;
    private RegionConfiguration conf;
    private Map<FileSystemIdentifier, Region> regions;
    private Region head;
    private Map<Region, Object> cache;
    private int idSeq = 0;
    private Collection<ReferenceListener> rootListeners;
    private Map<LocalLocator, Integer> roots;
    private WeakHashMap<LocalLocator, WeakLocator> liveClones;
    private WeakHashSet<LocalLocator> liveRoots;
    private ReferenceQueue<LocalLocator> queue;
    private Sharer sharer;
    private long originalSize = 0L;

    public RegionManager(XMLStore xmlstore) throws IOException {
        this(xmlstore, new RegionConfiguration());
    }

    public RegionManager(XMLStore xmlstore, RegionConfiguration conf) throws IOException {
        this.xmlstore = xmlstore;
        this.conf = conf;
        this.fs = new LocalFileSystem(xmlstore.toString());
        this.dnav = new NodeConverter(xmlstore);
        this.regions = new HashMap<FileSystemIdentifier, Region>();
        this.cache = new LinkedHashMap<Region, Object>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Region, Object> eldest) {
                if (this.size() > ((RegionManager)RegionManager.this).conf.CACHE_SIZE) {
                    Region r = eldest.getKey();
                    try {
                        r.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (UnknownReferenceException e) {
                        e.printStackTrace();
                    }
                    return true;
                }
                return false;
            }
        };
        this.roots = new HashMap<LocalLocator, Integer>();
        this.liveClones = new WeakHashMap();
        this.liveRoots = new WeakHashSet();
        this.queue = new ReferenceQueue();
        this.rootListeners = new ArrayList<ReferenceListener>();
        this.readRootSet();
        Sharer sharer = this.sharer = conf.USE_HASH_SHARER ? new HashSharer(this) : new MSDSharer(this);
        if (conf.ENABLE_SHARER) {
            this.sharer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SystemNode load(LocalLocator loc) throws IOException, UnknownReferenceException {
        this.checkClosed();
        this.expungeStaleRoots();
        Region r = this.lookup(loc);
        if (r == null) {
            throw new UnknownReferenceException(loc);
        }
        Region region = r;
        synchronized (region) {
            SystemNode node = r.load(loc, loc);
            return node;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized LocalLocator save(SystemNode node) throws IOException {
        this.checkClosed();
        this.expungeStaleRoots();
        try {
            Region r;
            if (node.getLocator() != null) {
                return node.getLocator();
            }
            Region region = r = this.head();
            synchronized (region) {
                LocalLocator loc = r.save(node);
                this.addWeakRoot(loc, r);
                return loc;
            }
        }
        catch (UnknownReferenceException e) {
            throw new IOException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush() throws IOException {
        block7: {
            this.checkClosed();
            try {
                if (this.head == null) break block7;
                Region region = this.head;
                synchronized (region) {
                    this.head.close();
                    this.originalSize += (long)this.head.originalSize();
                    if (this.conf.DO_SHARE_NEW) {
                        this.sharer.addRegion(this.head);
                    } else {
                        this.head.flush();
                    }
                    this.head = null;
                }
            }
            catch (UnknownReferenceException e) {
                throw new IOException(e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Region head() throws IOException, UnknownReferenceException {
        if (this.head != null) {
            Region region = this.head;
            synchronized (region) {
                if (this.head.isClosed()) {
                    this.flush();
                }
            }
        }
        if (this.head == null) {
            this.head = new Region(this, ++this.idSeq);
            this.regions.put(this.head.getIdentifier(), this.head);
        }
        return this.head;
    }

    public synchronized void release() throws IOException {
        try {
            this.checkClosed();
            this.flush();
            this.cache.clear();
            for (Region r : this.regions.values()) {
                r.flush();
            }
            this.expungeStaleRoots();
        }
        catch (UnknownReferenceException e) {
            throw new IOException(e.toString());
        }
    }

    public synchronized void discriminate() throws IOException {
        this.compact(true);
    }

    public synchronized void compact(boolean doComplete) throws IOException {
        try {
            while (!doComplete && !this.sharer.isIterated() || doComplete && !this.sharer.isDiscriminated()) {
                this.sharer.share();
            }
        }
        catch (UnknownReferenceException e) {
            IOException ie = new IOException(e.toString());
            ie.setStackTrace(e.getStackTrace());
            throw ie;
        }
    }

    public RegionConfiguration configuration() {
        this.checkClosed();
        return this.conf;
    }

    FileSystem getFileSystem() {
        this.checkClosed();
        return this.fs;
    }

    NodeConverter getConverter() {
        this.checkClosed();
        return this.dnav;
    }

    public Sharer getSharer() {
        this.checkClosed();
        return this.sharer;
    }

    XMLStore getXMLStore() {
        return this.xmlstore;
    }

    synchronized void cache(Region r) throws IOException, UnknownReferenceException {
        this.checkClosed();
        r.cache();
    }

    synchronized void informCached(Region r) {
        this.checkClosed();
        this.cache.put(r, PRESENT);
    }

    synchronized Region lookup(LocalLocator loc) {
        this.checkClosed();
        if (loc == null) {
            return null;
        }
        return this.regions.get(loc.getFileSystemId());
    }

    synchronized void change(FileSystemIdentifier oldId, Region region) {
        this.checkClosed();
        this.regions.remove(oldId);
        this.regions.put(region.getIdentifier(), region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void remove(Region region) {
        this.checkClosed();
        Region region2 = region;
        synchronized (region2) {
            assert (region.incomingSize() == 0);
            assert (region.outgoingSize() == 0);
            this.regions.remove(region.getIdentifier());
            this.cache.remove(region);
            if (this.head == region) {
                this.head = null;
            }
            this.sharer.removeRegion(region);
        }
    }

    synchronized Collection<Region> getRegions() {
        this.checkClosed();
        return this.regions.values();
    }

    public synchronized void retain(LocalLocator loc) throws UnknownReferenceException {
        this.checkClosed();
        this.expungeStaleRoots();
        Integer count = this.roots.get(loc);
        if (count == null) {
            this.addToIncoming(loc, this.lookup(loc));
            count = new Integer(1);
        } else {
            count = count + 1;
        }
        this.roots.put(loc, count);
    }

    public synchronized void release(LocalLocator loc) throws UnknownReferenceException {
        this.checkClosed();
        this.expungeStaleRoots();
        Integer count = this.roots.get(loc);
        if (count != null) {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count - 1);
            if (count <= 0) {
                this.roots.remove(loc);
                this.removeFromIncoming(loc, this.lookup(loc));
            } else {
                this.roots.put(loc, count);
            }
        } else {
            throw new UnknownReferenceException("LocalLocator not in root set " + loc);
        }
    }

    public synchronized void expunge() {
        for (Region r : this.regions.values()) {
            r.clearRefMap();
        }
        this.expungeStaleRoots();
    }

    private void addWeakRoot(LocalLocator loc, Region r) throws UnknownReferenceException {
        this.expungeStaleRoots();
        LocalLocator memLoc = this.liveRoots.get(loc);
        if (memLoc != null) {
            loc.locatorMoved(memLoc);
        } else {
            WeakLocator wc = new WeakLocator(loc, this.queue);
            this.liveClones.put(loc, wc);
            this.liveRoots.add(loc);
            this.addToIncoming(wc.clone, r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expungeStaleRoots() {
        WeakLocator wc;
        while ((wc = (WeakLocator)((PhantomReference)this.queue.poll())) != null) {
            Region r;
            LocalLocator deadRoot = wc.clone;
            wc.clear();
            if (deadRoot == null || this.liveRoots.contains(deadRoot) || this.roots.containsKey(deadRoot) || (r = this.regions.get(deadRoot.getFileSystemId())) == null) continue;
            Region region = r;
            synchronized (region) {
                InterRegionEdge edge = new InterRegionEdge(deadRoot, null, 0, r, null);
                r.removeIncoming(edge);
            }
        }
    }

    synchronized boolean rootMoved(LocalLocator oldLoc, LocalLocator newLoc) {
        LocalLocator memLoc;
        this.checkClosed();
        this.expungeStaleRoots();
        Integer oldCount = this.roots.remove(oldLoc);
        if (oldCount != null) {
            Integer newCount = this.roots.get(newLoc);
            if (newCount == null) {
                this.roots.put(newLoc, oldCount);
            } else {
                this.roots.put(newLoc, newCount + oldCount);
            }
            this.callRootListeners(oldLoc, newLoc);
        }
        if ((memLoc = this.liveRoots.get(oldLoc)) != null) {
            WeakLocator liveClone = this.liveClones.remove(oldLoc);
            if (liveClone != null) {
                liveClone.clear();
            }
            this.liveRoots.remove(oldLoc);
            WeakLocator wc = new WeakLocator(newLoc, this.queue);
            this.liveClones.put(newLoc, wc);
            this.liveRoots.add(newLoc);
            memLoc.locatorMoved(newLoc);
        }
        if (oldCount == null && memLoc == null) {
            try {
                this.removeFromIncoming(newLoc, this.lookup(newLoc));
                return false;
            }
            catch (UnknownReferenceException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToIncoming(LocalLocator loc, Region r) throws UnknownReferenceException {
        if (r == null) {
            throw new UnknownReferenceException(loc);
        }
        Region region = r;
        synchronized (region) {
            InterRegionEdge edge = new InterRegionEdge(loc, null, 0, r, null);
            r.addIncoming(edge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromIncoming(LocalLocator loc, Region r) throws UnknownReferenceException {
        if (!this.liveRoots.contains(loc) && !this.roots.containsKey(loc)) {
            if (r == null) {
                return;
            }
            Region region = r;
            synchronized (region) {
                InterRegionEdge edge = new InterRegionEdge(loc, null, 0, r, null);
                r.removeIncoming(edge);
            }
        }
    }

    public synchronized void addRootListener(ReferenceListener l) {
        this.checkClosed();
        this.rootListeners.add(l);
    }

    public synchronized void removeRootListener(ReferenceListener l) {
        this.checkClosed();
        this.rootListeners.remove(l);
    }

    private void callRootListeners(LocalLocator oldLoc, LocalLocator newLoc) {
        for (ReferenceListener l : this.rootListeners) {
            l.referenceMoved(oldLoc, newLoc);
        }
    }

    public synchronized long size() throws IOException {
        this.checkClosed();
        return this.fs.size();
    }

    public synchronized int numOfRegions() {
        this.checkClosed();
        return this.regions.size();
    }

    public synchronized boolean isDiscriminated() {
        this.checkClosed();
        return this.sharer.isDiscriminated();
    }

    public synchronized String toString() {
        if (this.xmlstore == null) {
            return "RegionManager is closed";
        }
        return "RM[" + this.regions.size() + "]";
    }

    public synchronized Statistics statistics() {
        return this.statistics(false);
    }

    public synchronized Statistics statistics(boolean isVerbose) {
        this.checkClosed();
        this.expungeStaleRoots();
        return new Statistics(this, isVerbose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void close() throws IOException {
        this.checkClosed();
        this.expungeStaleRoots();
        this.sharer.stop();
        try {
            Iterator<Region> i$ = new ArrayList<Region>(this.regions.values()).iterator();
            while (i$.hasNext()) {
                Region r;
                Region region = r = i$.next();
                synchronized (region) {
                    r.flush();
                }
            }
        }
        catch (UnknownReferenceException e) {
            throw new IOException(e.toString());
        }
        this.sharer = null;
        this.regions = null;
        this.xmlstore = null;
        this.fs = null;
        this.dnav = null;
        this.head = null;
        this.cache = null;
        this.rootListeners = null;
        this.roots = null;
        this.liveClones = null;
        this.queue = null;
    }

    private void checkClosed() {
        if (this.xmlstore == null) {
            throw new IllegalStateException("RegionManager closed");
        }
    }

    private synchronized void writeRootSet() throws IOException {
        this.expungeStaleRoots();
        Streamer<LocalLocator> locStreamer = LocalLocator.getStreamer(false);
        DataOutputStream out = new DataOutputStream(new FileOutputStream(this.xmlstore.toString() + ".roots"));
        out.writeInt(this.roots.size());
        for (Map.Entry<LocalLocator, Integer> entry : this.roots.entrySet()) {
            locStreamer.toStream(out, entry.getKey());
            Streamers.writeShortInt(out, entry.getValue());
        }
        out.flush();
        out.close();
    }

    private synchronized void readRootSet() throws IOException {
        this.expungeStaleRoots();
        try {
            Streamer<LocalLocator> locStreamer = LocalLocator.getStreamer(false);
            DataInputStream in = new DataInputStream(new FileInputStream(this.xmlstore.toString() + ".roots"));
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                LocalLocator loc = locStreamer.fromStream(in);
                int count = Streamers.readShortInt(in);
                this.roots.put(loc, count);
            }
            in.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public static class Statistics {
        public boolean isVerbose;
        public long size = 0L;
        public long fileSize;
        public long originalSize;
        public int currentNodes = 0;
        public int originalNodes = 0;
        public int permanentRoots;
        public int transientRoots;
        public int transientClones;
        public int numOfRegions;
        public int cachedRegions;
        public int incomingSize = 0;
        public int outgoingSize = 0;
        public int discriminations = 0;
        public boolean isDiscriminated;
        public boolean isIterated;
        public String roots;
        public String liveRoots;
        public String liveClones;
        public Region.Statistics[] regions = null;
        public long freeMemory;
        public long totalMemory;
        public long maxMemory;

        Statistics(RegionManager m, boolean isVerbose) {
            try {
                this.isVerbose = isVerbose;
                this.isDiscriminated = m.isDiscriminated();
                this.fileSize = m.fs.size();
                this.originalSize = m.originalSize;
                this.permanentRoots = m.roots.size();
                this.transientRoots = m.liveRoots.size();
                this.transientClones = m.liveClones.size();
                this.numOfRegions = m.regions.size();
                this.cachedRegions = m.cache.size();
                this.roots = m.roots.toString();
                this.liveRoots = m.liveRoots.toString();
                this.liveClones = m.liveClones.toString();
                this.discriminations = m.sharer.invocations();
                this.isIterated = m.sharer.isIterated();
                if (isVerbose) {
                    this.regions = new Region.Statistics[m.regions.size()];
                }
                int i = 0;
                for (Region r : m.regions.values()) {
                    if (isVerbose) {
                        this.regions[i++] = r.statistics();
                    }
                    this.currentNodes += r.currentNodes;
                    this.originalNodes += r.originalNodes;
                    this.incomingSize += r.incomingSize();
                    this.outgoingSize += r.outgoingSize();
                    this.size += (long)r.size();
                }
                Runtime rt = Runtime.getRuntime();
                this.freeMemory = rt.freeMemory();
                this.totalMemory = rt.totalMemory();
                this.maxMemory = rt.maxMemory();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String toString() {
            return this.brief();
        }

        public String brief() {
            return "RM[" + this.numOfRegions + "]{size=" + this.size + ",nodes=" + this.currentNodes + ",inset=" + this.incomingSize + ",outset=" + this.outgoingSize + ",freeMem=" + this.freeMemory + "}";
        }

        public String full() {
            String s = "RegionManager\n  Size:             " + this.size + "\n" + "  Original size:    " + this.originalSize + "\n" + "  File size:        " + this.fileSize + "\n" + "  Nodes:            " + this.currentNodes + "\n" + "  Original nodes:   " + this.originalNodes + "\n" + "  Is discriminated: " + this.isDiscriminated + "\n" + "  Is iterated:      " + this.isIterated + "\n" + "  Discriminations:  " + this.discriminations + "\n" + "  Regions:          " + this.numOfRegions + "\n" + "  Regions in cache: " + this.cachedRegions + "\n" + "  Permanent roots:  " + this.permanentRoots + "\n" + "  Transient roots:  " + this.transientRoots + "\n" + "  Incoming size:    " + this.incomingSize + "\n" + "  Outgoing size:    " + this.outgoingSize + "\n" + "  Free memory:      " + this.freeMemory + "\n" + "  Total memory:     " + this.totalMemory + "\n" + "  Max memory:       " + this.maxMemory + "\n";
            if (this.isVerbose) {
                StringBuilder sb = new StringBuilder();
                sb.append(s);
                for (int i = 0; i < this.regions.length; ++i) {
                    sb.append(this.regions[i].full());
                }
                return sb.toString();
            }
            return s;
        }
    }

    private class WeakLocator
    extends PhantomReference<LocalLocator> {
        final LocalLocator clone;

        WeakLocator(LocalLocator loc, ReferenceQueue<LocalLocator> queue) {
            super(loc, queue);
            this.clone = loc.clone();
        }

        public String toString() {
            return "WeakLocator{" + this.clone + "}";
        }
    }
}

