/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.regions;

import java.util.List;
import org.planx.msd.graph.Compactor;
import org.planx.xmlstore.io.LocalLocator;
import org.planx.xmlstore.nodes.SystemNode;
import org.planx.xmlstore.regions.CanonicPolicy;
import org.planx.xmlstore.regions.Region;

public class LeastInterRegionPolicy
extends CanonicPolicy {
    @Override
    public SystemNode chooseCanonical(List<Compactor.Edge> eqCls) {
        SystemNode canon = null;
        int minOutgoing = Integer.MAX_VALUE;
        int minId = Integer.MAX_VALUE;
        for (Compactor.Edge edge : eqCls) {
            int id;
            int outgoing;
            SystemNode current = (SystemNode)edge.node;
            if (current == canon) continue;
            LocalLocator loc = current.getLocator();
            Region r = this.owner(loc);
            if (canon == null) {
                canon = current;
                minOutgoing = this.countOutgoing(current, r);
                minId = r.getLocalId();
            } else if (current != canon && (outgoing = this.countOutgoing(current, r)) < minOutgoing && (id = r.getLocalId()) < minId) {
                canon = current;
                minOutgoing = outgoing;
                minId = id;
            }
            if (minOutgoing != 0) continue;
            break;
        }
        if (canon == null) {
            throw new NullPointerException();
        }
        return canon;
    }

    protected Region owner(LocalLocator loc) {
        if (loc == null) {
            throw new NullPointerException();
        }
        if (this.r1 != null && this.r1.isContained(loc)) {
            return this.r1;
        }
        if (this.r2 != null && this.r2.isContained(loc)) {
            return this.r2;
        }
        return null;
    }

    protected int countOutgoing(SystemNode node, Region r) {
        int outgoing = 0;
        for (SystemNode child : node.getChildren()) {
            if (r.isContained(child.getLocator())) continue;
            ++outgoing;
        }
        return outgoing;
    }
}

