/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.regions;

import org.planx.xmlstore.io.LocalLocator;
import org.planx.xmlstore.regions.Region;

class InterRegionEdge {
    final Origin origin;
    final LocalLocator targetNode;
    final Region targetRegion;

    InterRegionEdge(LocalLocator targetNode, LocalLocator originNode, int childIndex, Region targetRegion, Region originRegion) {
        if (targetNode == null) {
            throw new NullPointerException("target may not be null");
        }
        if (targetRegion == null) {
            throw new NullPointerException("targetRegion may not be null");
        }
        this.targetNode = targetNode == null ? null : targetNode.clone();
        this.targetRegion = targetRegion;
        this.origin = new Origin(originNode, childIndex, originRegion);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InterRegionEdge)) {
            return false;
        }
        InterRegionEdge e = (InterRegionEdge)o;
        return this.origin.equals(e.origin) && this.targetRegion.equals(e.targetRegion) && this.targetNode.equals(e.targetNode);
    }

    public int hashCode() {
        int oh = this.origin.originNode == null ? 0 : this.origin.originNode.hashCode();
        int orh = this.origin.originRegion == null ? 0 : this.origin.originRegion.hashCode();
        return this.targetNode.hashCode() ^ oh ^ this.targetRegion.hashCode() ^ orh + 31 * this.origin.childIndex;
    }

    public String toString() {
        return "target=" + this.targetNode + ", origin=" + this.origin.originNode + ", childIndex=" + this.origin.childIndex + ", targetRegion=" + this.targetRegion + ", originRegion=" + this.origin.originRegion;
    }

    static class Origin {
        final LocalLocator originNode;
        final int childIndex;
        final Region originRegion;

        Origin(LocalLocator originNode, int childIndex, Region originRegion) {
            if (originNode == null && originRegion != null) {
                throw new NullPointerException("origin and originRegion must both be null, originRegion is not");
            }
            if (originRegion == null && originNode != null) {
                throw new NullPointerException("origin and originRegion must both be null, origin is not");
            }
            this.originNode = originNode == null ? null : originNode.clone();
            this.childIndex = childIndex;
            this.originRegion = originRegion;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Origin)) {
                return false;
            }
            Origin e = (Origin)o;
            return this.childIndex == e.childIndex && (this.originRegion == null && e.originRegion == null && this.originNode == null && e.originNode == null || this.originRegion.equals(e.originRegion) && this.originNode.equals(e.originNode));
        }

        public int hashCode() {
            int oh = this.originNode == null ? 0 : this.originNode.hashCode();
            int orh = this.originRegion == null ? 0 : this.originRegion.hashCode();
            return oh ^ orh + 31 * this.childIndex;
        }

        public String toString() {
            return "origin=" + this.originNode + ", childIndex=" + this.childIndex + ", originRegion=" + this.originRegion;
        }
    }
}

