/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.references;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.planx.msd.Discriminator;
import org.planx.msd.DiscriminatorFactory;
import org.planx.msd.Discriminators;
import org.planx.msd.Extractor;
import org.planx.msd.Memory;
import org.planx.msd.array.IntegerArrayDiscriminator;
import org.planx.msd.util.AbstractDiscriminator;
import org.planx.xmlstore.Reference;
import org.planx.xmlstore.io.PolymorphicStreamer;
import org.planx.xmlstore.io.Streamer;
import org.planx.xmlstore.io.Streamers;

public class RelativeReference
implements Reference,
Serializable {
    public static final byte CLASS_ID = 3;
    private Reference root;
    private RelativeReference parent;
    private int[] path;
    private int childIndex;

    public RelativeReference(Reference root) {
        this.root = root;
        this.parent = null;
        this.path = new int[0];
    }

    public RelativeReference(Reference root, int[] path) {
        this.root = root;
        this.parent = null;
        this.path = path;
    }

    public RelativeReference(Reference root, int childIndex) {
        this(root instanceof RelativeReference ? (RelativeReference)root : new RelativeReference(root), childIndex);
    }

    public RelativeReference(RelativeReference parent, int childIndex) {
        this.root = parent.root;
        this.parent = parent;
        this.path = null;
        this.childIndex = childIndex;
    }

    public Reference getRoot() {
        return this.root;
    }

    private int[] internalPath() {
        if (this.parent == null) {
            return this.path;
        }
        return this.getPath();
    }

    public int[] getPath() {
        return this.gather(0);
    }

    private int[] gather(int pos) {
        int[] p;
        if (this.parent != null) {
            p = this.parent.gather(pos + 1);
            p[p.length - pos - 1] = this.childIndex;
        } else {
            p = new int[pos + this.path.length];
            System.arraycopy(this.path, 0, p, 0, this.path.length);
        }
        return p;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelativeReference)) {
            return false;
        }
        RelativeReference vref = (RelativeReference)o;
        return vref.getRoot().equals(this.root) && Arrays.equals(this.internalPath(), vref.getPath());
    }

    public int hashCode() {
        return this.root.hashCode() ^ Arrays.hashCode(this.internalPath());
    }

    public String toString() {
        return this.root + ":" + Arrays.toString(this.internalPath());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.root);
        out.writeObject(this.getPath());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.root = (Reference)in.readObject();
        this.path = (int[])in.readObject();
        this.parent = null;
    }

    public static Streamer<RelativeReference> getStreamer() {
        final PolymorphicStreamer<Reference> vrefStreamer = Streamers.getPolymorphicStreamer(Reference.class);
        return new Streamer<RelativeReference>(){

            @Override
            public void toStream(DataOutput out, RelativeReference vref) throws IOException {
                vrefStreamer.toStream(out, vref.root);
                Streamers.writePosArray(out, vref.internalPath());
            }

            @Override
            public RelativeReference fromStream(DataInput in) throws IOException {
                Reference root = (Reference)vrefStreamer.fromStream(in);
                int[] path = Streamers.readPosArray(in);
                return new RelativeReference(root, path);
            }
        };
    }

    public static Discriminator<RelativeReference> getDiscriminator() {
        return RelativeReference.getDiscriminator(DiscriminatorFactory.instance().getMemory());
    }

    public static Discriminator<RelativeReference> getDiscriminator(Memory memory) {
        return new RelRefDiscriminator(memory);
    }

    private static class RelRefDiscriminator
    extends AbstractDiscriminator<RelativeReference> {
        private Discriminator<Reference> rootDisc = DiscriminatorFactory.instance().getPolymorphicDiscriminator(Reference.class);
        private Discriminator<int[]> pathDisc;

        public RelRefDiscriminator(Memory memory) {
            this.pathDisc = new IntegerArrayDiscriminator(memory);
        }

        @Override
        public <U, S> Collection<List<S>> discriminate(List<? extends U> values, final Extractor<U, ? extends RelativeReference, S> e) {
            Extractor eRoot = new Extractor<U, Reference, U>(){

                @Override
                public Reference getLabel(U elm) {
                    return ((RelativeReference)e.getLabel(elm)).root;
                }

                @Override
                public U getValue(U elm) {
                    return elm;
                }
            };
            Extractor ePath = new Extractor<U, int[], S>(){

                @Override
                public int[] getLabel(U elm) {
                    RelativeReference vref = (RelativeReference)e.getLabel(elm);
                    return vref.internalPath();
                }

                @Override
                public S getValue(U elm) {
                    return e.getValue(elm);
                }
            };
            return Discriminators.discriminate(values, this.rootDisc, eRoot, this.pathDisc, ePath);
        }
    }
}

