/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.nodes;

import java.util.List;
import org.planx.msd.DiscriminatorFactory;
import org.planx.msd.lang.PolymorphicDiscriminator;
import org.planx.util.Array;
import org.planx.util.UnmodifiableArrayList;
import org.planx.xmlstore.Attribute;
import org.planx.xmlstore.Node;
import org.planx.xmlstore.NodeFactory;
import org.planx.xmlstore.Reference;
import org.planx.xmlstore.io.PolymorphicStreamer;
import org.planx.xmlstore.io.Streamers;
import org.planx.xmlstore.nodes.DVMAttribute;
import org.planx.xmlstore.nodes.DVMNode;
import org.planx.xmlstore.nodes.SystemNode;
import org.planx.xmlstore.references.ContentValueReference;
import org.planx.xmlstore.references.ReferenceProxy;
import org.planx.xmlstore.references.RelativeReference;

public final class DVMNodeFactory
extends NodeFactory {
    public DVMNodeFactory() {
        PolymorphicStreamer<Reference> ps = Streamers.getPolymorphicStreamer(Reference.class);
        ps.addStreamer((byte)2, ContentValueReference.class, ContentValueReference.getStreamer());
        ps.addStreamer((byte)3, RelativeReference.class, RelativeReference.getStreamer());
        ps.addStreamer((byte)4, ReferenceProxy.class, ReferenceProxy.getStreamer());
        PolymorphicDiscriminator<Reference> pd = DiscriminatorFactory.instance().getPolymorphicDiscriminator(Reference.class);
        pd.addDiscriminator(ContentValueReference.class, ContentValueReference.getDiscriminator());
        pd.addDiscriminator(RelativeReference.class, RelativeReference.getDiscriminator());
        pd.addDiscriminator(ReferenceProxy.class, ReferenceProxy.getDiscriminator());
    }

    @Override
    public Attribute createAttribute(String name, String value) {
        return new DVMAttribute(name, value);
    }

    @Override
    public Node createElementNode(String tagName) {
        return new DVMNode(0, tagName);
    }

    @Override
    public Node createElementNode(String tagName, List<? extends Node> children) {
        return new DVMNode(0, tagName, DVMNodeFactory.convert(children), null, null, false);
    }

    @Override
    public Node createElementNode(String tagName, List<? extends Node> children, List<Attribute> attrs) {
        return new DVMNode(0, tagName, DVMNodeFactory.convert(children), Array.unmodifiableCopy(attrs), null, false);
    }

    @Override
    public Node createElementNode(String tagName, Node[] children) {
        return new DVMNode(0, tagName, DVMNodeFactory.convert(children), null, null, false);
    }

    @Override
    public Node createElementNode(String tagName, Node[] children, Attribute[] attrs) {
        return new DVMNode(0, tagName, DVMNodeFactory.convert(children), Array.unmodifiableCopy(attrs), null, false);
    }

    @Override
    public Node createElementNode(String tagName, Node child) {
        UnmodifiableArrayList<SystemNode> children = new UnmodifiableArrayList<SystemNode>(new SystemNode[]{DVMNodeFactory.convert(child)});
        return new DVMNode(0, tagName, children, null, null, false);
    }

    @Override
    public Node createCharDataNode(String data) {
        return new DVMNode(1, data);
    }

    public static SystemNode convert(Node n) {
        if (n instanceof SystemNode) {
            return (SystemNode)n;
        }
        if (n.getType() == 1) {
            return new DVMNode(1, n.getNodeValue());
        }
        if (n.getType() != 0) {
            throw new IllegalArgumentException("Unknown node type");
        }
        return new DVMNode(0, n.getNodeValue(), DVMNodeFactory.convert(n.getChildren()), Array.unmodifiableCopy(n.getAttributes()));
    }

    @Override
    public Node replaceChild(Node node, int index, Node child) {
        if (node.getType() != 0) {
            throw new IllegalArgumentException("Node must be ELEMENT type");
        }
        List<? extends Node> childNodes = node.getChildren();
        int size = childNodes.size();
        SystemNode[] children = new SystemNode[size];
        for (int i = 0; i < size; ++i) {
            children[i] = i == index ? DVMNodeFactory.convert(child) : DVMNodeFactory.convert(childNodes.get(i));
        }
        UnmodifiableArrayList<SystemNode> cs = new UnmodifiableArrayList<SystemNode>(children);
        return new DVMNode(0, node.getNodeValue(), cs, node.getAttributes(), null, false);
    }

    @Override
    public Node insertChild(Node n, int index, Node child) {
        int i;
        List<? extends Node> childNodes = n.getChildren();
        SystemNode[] children = new SystemNode[childNodes.size() + 1];
        for (i = 0; i < index; ++i) {
            children[i] = DVMNodeFactory.convert(childNodes.get(i));
        }
        children[index] = DVMNodeFactory.convert(child);
        for (i = index + 1; i < children.length; ++i) {
            children[i] = DVMNodeFactory.convert(childNodes.get(i - 1));
        }
        UnmodifiableArrayList<SystemNode> cs = new UnmodifiableArrayList<SystemNode>(children);
        return new DVMNode(0, n.getNodeValue(), cs, n.getAttributes(), null, false);
    }

    @Override
    public Node removeChild(Node n, int index) {
        int i;
        List<? extends Node> childNodes = n.getChildren();
        SystemNode[] children = new SystemNode[childNodes.size() - 1];
        for (i = 0; i < index; ++i) {
            children[i] = DVMNodeFactory.convert(childNodes.get(i));
        }
        for (i = index; i < children.length; ++i) {
            children[i] = DVMNodeFactory.convert(childNodes.get(i + 1));
        }
        UnmodifiableArrayList<SystemNode> cs = new UnmodifiableArrayList<SystemNode>(children);
        return new DVMNode(0, n.getNodeValue(), cs, n.getAttributes(), null, false);
    }

    private static List<SystemNode> convert(List<? extends Node> nodes) {
        int size = nodes.size();
        SystemNode[] sys = new SystemNode[size];
        for (int i = 0; i < size; ++i) {
            sys[i] = DVMNodeFactory.convert(nodes.get(i));
        }
        return new UnmodifiableArrayList<SystemNode>(sys);
    }

    private static List<SystemNode> convert(Node[] nodes) {
        int size = nodes.length;
        SystemNode[] sys = new SystemNode[size];
        for (int i = 0; i < size; ++i) {
            sys[i] = DVMNodeFactory.convert(nodes[i]);
        }
        return new UnmodifiableArrayList<SystemNode>(sys);
    }
}

