/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.nodes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.planx.util.Array;
import org.planx.util.UnmodifiableArrayList;
import org.planx.xmlstore.Attribute;
import org.planx.xmlstore.Node;
import org.planx.xmlstore.io.LocalLocator;
import org.planx.xmlstore.nodes.AbstractNode;
import org.planx.xmlstore.nodes.SystemNode;

public class DVMNode
extends AbstractNode {
    private static final List<SystemNode> EMPTY_CHILDREN = Collections.EMPTY_LIST;
    private static final List<Attribute> EMPTY_ATTRIBUTES = Collections.EMPTY_LIST;
    private byte type;
    private String value;
    private List<SystemNode> children;
    private List<Attribute> attributes;
    private int hash = 0;
    private boolean isShared = false;
    private int height = -1;
    private LocalLocator loc = null;

    public DVMNode(byte type, String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value may not be null");
        }
        if (type == 0 && value.length() == 0) {
            throw new IllegalArgumentException("ELEMENT cannot have empty value");
        }
        this.type = type;
        this.value = value;
        this.children = EMPTY_CHILDREN;
        this.attributes = EMPTY_ATTRIBUTES;
    }

    public DVMNode(byte type, String value, List<SystemNode> children, List<Attribute> attrs) {
        if (value == null) {
            throw new IllegalArgumentException("Value may not be null");
        }
        switch (type) {
            case 1: {
                if (children != null) {
                    throw new IllegalArgumentException("CHARDATA cannot have children");
                }
                if (attrs != null) {
                    throw new IllegalArgumentException("CHARDATA cannot have attributes");
                }
                this.children = EMPTY_CHILDREN;
                this.attributes = EMPTY_ATTRIBUTES;
                break;
            }
            case 0: {
                if (value.length() == 0) {
                    throw new IllegalArgumentException("ELEMENT cannot have empty value");
                }
                this.children = children == null || children.size() == 0 ? EMPTY_CHILDREN : Array.unmodifiableCopy(children);
                this.attributes = attrs == null || attrs.size() == 0 ? EMPTY_ATTRIBUTES : Array.unmodifiableCopy(attrs);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid node type");
            }
        }
        this.type = type;
        this.value = value;
    }

    public DVMNode(byte type, String value, SystemNode[] children, Attribute[] attrs) {
        if (value == null) {
            throw new IllegalArgumentException("Value may not be null");
        }
        switch (type) {
            case 1: {
                if (children != null) {
                    throw new IllegalArgumentException("CHARDATA cannot have children");
                }
                if (attrs != null) {
                    throw new IllegalArgumentException("CHARDATA cannot have attributes");
                }
                this.children = EMPTY_CHILDREN;
                this.attributes = EMPTY_ATTRIBUTES;
                break;
            }
            case 0: {
                if (value.length() == 0) {
                    throw new IllegalArgumentException("ELEMENT cannot have empty value");
                }
                this.children = children == null || children.length == 0 ? EMPTY_CHILDREN : Array.unmodifiableCopy(children);
                this.attributes = attrs == null || attrs.length == 0 ? EMPTY_ATTRIBUTES : Array.unmodifiableCopy(attrs);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid node type");
            }
        }
        this.type = type;
        this.value = value;
    }

    DVMNode(byte type, String value, List<SystemNode> children, List<Attribute> attrs, LocalLocator loc, boolean isShared) {
        this.type = type;
        this.value = value;
        this.children = children == null ? EMPTY_CHILDREN : children;
        this.attributes = attrs == null ? EMPTY_ATTRIBUTES : attrs;
        this.loc = loc;
        this.isShared = isShared;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public String getNodeValue() {
        return this.value;
    }

    @Override
    public List<SystemNode> getChildren() {
        return this.children;
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getAttribute(String attrName) {
        for (Attribute attr : this.attributes) {
            if (!attr.getName().equals(attrName)) continue;
            return attr.getValue();
        }
        return null;
    }

    @Override
    public String[] getAttributeNames() {
        String[] names = new String[this.attributes.size()];
        int i = 0;
        for (Attribute attr : this.attributes) {
            names[i++] = attr.getName();
        }
        return names;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        return DVMNode.deepEquals(this, (Node)o);
    }

    private static boolean deepEquals(Node n1, Node n2) {
        if (n1.getType() != n2.getType()) {
            return false;
        }
        if (!n1.getNodeValue().equals(n2.getNodeValue())) {
            return false;
        }
        List<Attribute> as1 = n1.getAttributes();
        List<Attribute> as2 = n2.getAttributes();
        int asize = as1.size();
        if (asize != as2.size()) {
            return false;
        }
        Object[] attrs1 = new Attribute[asize];
        attrs1 = as1.toArray(attrs1);
        Arrays.sort(attrs1);
        Object[] attrs2 = new Attribute[asize];
        attrs2 = as2.toArray(attrs2);
        Arrays.sort(attrs2);
        if (!Arrays.equals(attrs1, attrs2)) {
            return false;
        }
        List<? extends Node> cs1 = n1.getChildren();
        List<? extends Node> cs2 = n2.getChildren();
        int csize = cs1.size();
        if (csize != cs2.size()) {
            return false;
        }
        for (int i = 0; i < csize; ++i) {
            if (DVMNode.deepEquals(cs1.get(i), cs2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            int h = this.type;
            h = h * 31 + this.value.hashCode();
            h = h * 31 + ((Object)this.attributes).hashCode();
            for (SystemNode n : this.children) {
                h = h * 31 + n.hashCode();
            }
            this.hash = h;
        }
        return this.hash;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.type == 0) {
            result.append("<" + this.getNodeValue());
            for (Attribute attr : this.attributes) {
                result.append(" " + attr.getName() + "=\"" + attr.getValue() + "\"");
            }
            if (this.children.size() > 0) {
                result.append(">\n");
                for (SystemNode node : this.children) {
                    result.append(node.toString() + "\n");
                }
                result.append("</" + this.getNodeValue() + ">");
            } else {
                result.append("/>");
            }
        } else if (this.type == 1) {
            result.append(this.value);
        }
        return result.toString();
    }

    @Override
    public SystemNode get() {
        return this;
    }

    @Override
    public boolean isShared() {
        return this.isShared;
    }

    @Override
    public void setShared(boolean isShared) {
        this.isShared = isShared;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public void setChild(int index, SystemNode child) {
        if (!(this.children instanceof UnmodifiableArrayList)) {
            this.children = new UnmodifiableArrayList<SystemNode>(this.children);
        }
        ((UnmodifiableArrayList)this.children).internal()[index] = child;
    }

    @Override
    public LocalLocator getLocator() {
        return this.loc;
    }

    @Override
    public void setLocator(LocalLocator loc) {
        this.loc = loc;
    }
}

