/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.nameserver;

import java.io.IOException;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.planx.xmlstore.NameAlreadyBoundException;
import org.planx.xmlstore.NameServer;
import org.planx.xmlstore.Reference;
import org.planx.xmlstore.StaleReferenceException;
import org.planx.xmlstore.routing.DistributedMap;
import org.planx.xmlstore.routing.Identifier;

public class GlobalNameServer
implements NameServer {
    private DistributedMap map;

    public GlobalNameServer(DistributedMap map) {
        this.map = map;
    }

    @Override
    public Reference lookup(String name) throws IOException {
        return (Reference)((Object)this.map.get(GlobalNameServer.getIdentifier(name)));
    }

    @Override
    public void bind(String name, Reference vref) throws IOException, NameAlreadyBoundException {
        Reference tmp = this.lookup(name);
        if (tmp != null && tmp.equals(vref)) {
            return;
        }
        if (tmp != null) {
            throw new NameAlreadyBoundException(name, vref);
        }
        this.map.put(GlobalNameServer.getIdentifier(name), (Serializable)((Object)vref));
    }

    @Override
    public void rebind(String name, Reference oldr, Reference newr) throws IOException, StaleReferenceException {
        Reference tmp = this.lookup(name);
        if (tmp != null && !tmp.equals(oldr)) {
            throw new StaleReferenceException(name, oldr, tmp);
        }
        this.map.put(GlobalNameServer.getIdentifier(name), (Serializable)((Object)newr));
    }

    private static Identifier getIdentifier(String s) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        md.update(s.getBytes());
        return new Identifier(md.digest());
    }
}

