/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.planx.xmlstore.io.Streamer;

public class PolymorphicStreamer<T>
implements Streamer<T> {
    private Map<Byte, DynamicStreamer<? extends T>> map = new HashMap<Byte, DynamicStreamer<? extends T>>();

    public <E extends T> void addStreamer(byte id, Class<? extends E> cls, Streamer<E> streamer) {
        if (cls == null) {
            throw new NullPointerException("Class is null");
        }
        if (streamer == null) {
            throw new NullPointerException("Streamer is null");
        }
        this.map.put(id, new DynamicStreamer<E>(cls, streamer));
    }

    @Override
    public void toStream(DataOutput out, T obj) throws IOException {
        for (Map.Entry<Byte, DynamicStreamer<T>> entry : this.map.entrySet()) {
            DynamicStreamer<T> ds = entry.getValue();
            if (!ds.cls.isInstance(obj)) continue;
            out.writeByte(entry.getKey().byteValue());
            ds.toStream(out, obj);
            return;
        }
        throw new ClassCastException("No Streamer registered for " + obj.getClass());
    }

    @Override
    public T fromStream(DataInput in) throws IOException {
        Byte id = in.readByte();
        DynamicStreamer<T> ds = this.map.get(id);
        if (ds == null) {
            throw new IOException("No Streamer registered with id " + id);
        }
        return ds.fromStream(in);
    }

    private class DynamicStreamer<S extends T>
    implements Streamer<T> {
        private Streamer<S> streamer;
        Class<? extends S> cls;

        public DynamicStreamer(Class<? extends S> cls, Streamer<S> streamer) {
            this.cls = cls;
            this.streamer = streamer;
        }

        @Override
        public void toStream(DataOutput out, T obj) throws IOException {
            S o = this.cls.cast(obj);
            this.streamer.toStream(out, o);
        }

        @Override
        public T fromStream(DataInput in) throws IOException {
            return this.streamer.fromStream(in);
        }
    }
}

