/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.convert;

import java.util.List;
import org.planx.xmlstore.Attribute;
import org.planx.xmlstore.Node;
import org.planx.xmlstore.convert.XMLException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SAXOutputter {
    private ContentHandler content_handler;
    private ErrorHandler error_handler;
    private DTDHandler dtd_handler;
    private EntityResolver entity_resolver;
    private LexicalHandler lexical_handler;
    private DeclHandler decl_handler;

    public SAXOutputter(ContentHandler content) {
        this(content, null, null, null, null);
    }

    public SAXOutputter(ContentHandler content, ErrorHandler error, DTDHandler dtd, EntityResolver entity) {
        this(content, error, dtd, entity, null);
    }

    public SAXOutputter(ContentHandler content, ErrorHandler error, DTDHandler dtd, EntityResolver entity, LexicalHandler lexical) {
        this.content_handler = content;
        this.error_handler = error;
        this.dtd_handler = dtd;
        this.entity_resolver = entity;
        this.lexical_handler = lexical;
    }

    public void output(Node root) throws XMLException {
        this.startDocument();
        this.recurse(root);
        this.endDocument();
    }

    private void recurse(Node n) throws XMLException {
        switch (n.getType()) {
            case 0: {
                String tag = n.getNodeValue();
                AttributesImpl attr = new AttributesImpl();
                List<Attribute> attrs = n.getAttributes();
                for (Attribute a : attrs) {
                    attr.addAttribute("", a.getName(), a.getName(), "CDATA", a.getValue());
                }
                this.startElement(tag, attr);
                List<? extends Node> children = n.getChildren();
                n = null;
                for (Node node : children) {
                    this.recurse(node);
                }
                this.endElement(tag);
                break;
            }
            case 1: {
                this.characters(n.getNodeValue());
                break;
            }
            default: {
                throw new XMLException("recurse: unknown node type");
            }
        }
    }

    private void startDocument() throws XMLException {
        try {
            this.content_handler.startDocument();
        }
        catch (SAXException e) {
            throw new XMLException("SAX(startDocument): " + e);
        }
    }

    private void endDocument() throws XMLException {
        try {
            this.content_handler.endDocument();
        }
        catch (SAXException e) {
            throw new XMLException("SAX(endDocument): " + e);
        }
    }

    private void startElement(String tag, Attributes attr) throws XMLException {
        try {
            this.content_handler.startElement("", tag, tag, attr);
        }
        catch (SAXException e) {
            throw new XMLException("SAX(startElement): " + e);
        }
    }

    private void endElement(String tag) throws XMLException {
        try {
            this.content_handler.endElement("", tag, tag);
        }
        catch (SAXException e) {
            throw new XMLException("SAX(endElement): " + e);
        }
    }

    private void characters(String ch) throws XMLException {
        try {
            this.content_handler.characters(ch.toCharArray(), 0, ch.length());
        }
        catch (SAXException e) {
            throw new XMLException("SAX(characters): " + e);
        }
    }
}

