/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.convert;

import java.util.Arrays;
import java.util.List;
import org.planx.xmlstore.Attribute;
import org.planx.xmlstore.Node;
import org.planx.xmlstore.NodeFactory;
import org.planx.xmlstore.convert.XMLException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class DOMBuilder {
    private DOMBuilder() {
    }

    public static Node build(org.w3c.dom.Node domNode) throws XMLException {
        NodeFactory factory = NodeFactory.instance();
        switch (domNode.getNodeType()) {
            case 3: {
                return factory.createCharDataNode(domNode.getNodeValue());
            }
            case 1: {
                NamedNodeMap domAttrs = domNode.getAttributes();
                Attribute[] attr = new Attribute[domAttrs.getLength()];
                for (int i = 0; i < attr.length; ++i) {
                    org.w3c.dom.Node att = domAttrs.item(i);
                    attr[i] = factory.createAttribute(att.getNodeName(), att.getNodeValue());
                }
                List<Attribute> attributes = Arrays.asList(attr);
                NodeList domChildren = domNode.getChildNodes();
                Node[] dvmChildren = new Node[domChildren.getLength()];
                for (int i = 0; i < dvmChildren.length; ++i) {
                    dvmChildren[i] = DOMBuilder.build(domChildren.item(i));
                }
                List<Node> childNodes = Arrays.asList(dvmChildren);
                return factory.createElementNode(domNode.getNodeName(), childNodes, attributes);
            }
        }
        throw new XMLException("node type " + domNode.getNodeType() + " not supported");
    }
}

