/*
 * Decompiled with CFR 0.152.
 */
package org.planx.util;

import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;

public class WeakHashSet<E>
extends AbstractSet<E>
implements Set<E> {
    private WeakHashMap<E, WeakReference<E>> map;

    public WeakHashSet() {
        this.map = new WeakHashMap();
    }

    public WeakHashSet(Collection<? extends E> c) {
        this.map = new WeakHashMap(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
    }

    public WeakHashSet(int initialCapacity, float loadFactor) {
        this.map = new WeakHashMap(initialCapacity, loadFactor);
    }

    public WeakHashSet(int initialCapacity) {
        this.map = new WeakHashMap(initialCapacity);
    }

    public E get(Object o) {
        WeakReference<E> w = this.map.get(o);
        return w == null ? null : (E)w.get();
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E o) {
        return this.map.put(o, new WeakReference<E>(o)) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

