/*
 * Decompiled with CFR 0.152.
 */
package org.planx.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class WeakCollection<E>
extends AbstractCollection<E> {
    private ReferenceQueue<E> queue = new ReferenceQueue();
    private Entry<E> head = new Entry<Object>(null, null, null, this.queue);
    private int size = 0;

    public WeakCollection() {
        this.head.prev = this.head;
        this.head.next = this.head.prev;
    }

    public WeakCollection(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    @Override
    public boolean add(E elm) {
        this.expungeStaleEntries();
        Entry<E> e = new Entry<E>(elm, this.head, this.head.next, this.queue);
        e.prev.next = e;
        e.next.prev = e;
        ++this.size;
        return true;
    }

    private void remove(Entry<E> e) {
        this.expungeStaleEntries();
        if (e.prev != null) {
            e.prev.next = e.next;
        }
        if (e.next != null) {
            e.next.prev = e.prev;
        }
        e.prev = null;
        e.next = null;
        --this.size;
    }

    @Override
    public int size() {
        this.expungeStaleEntries();
        return this.size;
    }

    private void expungeStaleEntries() {
        Entry e;
        while ((e = (Entry)this.queue.poll()) != null) {
            if (e.prev != null) {
                e.prev.next = e.next;
            }
            if (e.next != null) {
                e.next.prev = e.prev;
            }
            e.prev = null;
            e.next = null;
            --this.size;
        }
    }

    @Override
    public Iterator<E> iterator() {
        this.expungeStaleEntries();
        return new WeakIterator();
    }

    private class WeakIterator
    implements Iterator<E> {
        private Entry<E> last = null;
        private Entry<E> next = WeakCollection.access$100(WeakCollection.this);
        private E nextElm = null;
        private E lastElm = null;

        private WeakIterator() {
        }

        @Override
        public boolean hasNext() {
            while (this.nextElm == null) {
                this.next = this.next.next;
                if (this.next == WeakCollection.this.head) {
                    return false;
                }
                this.nextElm = this.next.get();
            }
            return true;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastElm = this.nextElm;
            this.nextElm = null;
            this.last = this.next;
            return this.lastElm;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.hasNext();
            WeakCollection.this.remove(this.last);
            this.last = null;
            this.lastElm = null;
        }
    }

    private static class Entry<E>
    extends WeakReference<E> {
        Entry<E> prev;
        Entry<E> next;

        Entry(E elm, Entry<E> prev, Entry<E> next, ReferenceQueue<E> queue) {
            super(elm, queue);
            this.prev = prev;
            this.next = next;
        }
    }
}

