/*
 * Decompiled with CFR 0.152.
 */
package org.planx.msd.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.planx.msd.Discriminator;
import org.planx.msd.Discriminators;
import org.planx.msd.Extractor;
import org.planx.msd.Memory;
import org.planx.msd.array.ShortArrayDiscriminator;
import org.planx.msd.util.AbstractDiscriminator;
import org.planx.util.Association;

public class ShortBagDiscriminator<T>
extends AbstractDiscriminator<List<T>> {
    private Discriminator<T> disc;
    private Discriminator<short[]> listDisc;
    private boolean doRemoveDuplicates;

    public ShortBagDiscriminator(Discriminator<T> d, Memory memory) {
        this(d, memory, false);
    }

    ShortBagDiscriminator(Discriminator<T> d, Memory memory, boolean doRemoveDuplicates) {
        this.disc = d;
        this.listDisc = new ShortArrayDiscriminator(memory);
        this.doRemoveDuplicates = doRemoveDuplicates;
    }

    @Override
    public <U, S> Collection<List<S>> discriminate(List<? extends U> values, Extractor<U, ? extends List<T>, S> e) {
        int insize = values.size();
        ArrayList<IWrap<T>> in = new ArrayList<IWrap<T>>();
        ArrayList<Association<short[], S>> sorted = new ArrayList<Association<short[], S>>(insize);
        for (int i = 0; i < insize; ++i) {
            U elm = values.get(i);
            List<T> list = e.getLabel(elm);
            for (T t : list) {
                in.add(new IWrap<T>(t, i));
            }
            short[] newList = new short[list.size()];
            S value = e.getValue(elm);
            sorted.add(new Association<short[], S>(newList, value));
        }
        Extractor ext1 = new Extractor<IWrap<T>, T, IWrap<T>>(){

            @Override
            public T getLabel(IWrap<T> elm) {
                return elm.obj;
            }

            @Override
            public IWrap<T> getValue(IWrap<T> elm) {
                return elm;
            }
        };
        Collection order = this.disc.discriminate(in, ext1);
        if (order.size() > 65536) {
            throw new IndexOutOfBoundsException("Too many distinct equivalence classes");
        }
        int[] sizes = new int[insize];
        int unique = 0;
        for (List group : order) {
            int prevIdx = -1;
            for (IWrap wrap : group) {
                int idx = wrap.i;
                if (!this.doRemoveDuplicates || this.doRemoveDuplicates && idx != prevIdx) {
                    short[] list = (short[])((Association)sorted.get(idx)).getFirst();
                    int n = idx;
                    int n2 = sizes[n];
                    sizes[n] = n2 + 1;
                    list[n2] = unique;
                }
                prevIdx = idx;
            }
            unique = (short)(unique + 1);
        }
        if (this.doRemoveDuplicates) {
            for (int i = 0; i < insize; ++i) {
                int n = sizes[i];
                Association pair = (Association)sorted.get(i);
                short[] ss = (short[])pair.getFirst();
                if (n >= ss.length) continue;
                short[] ns = new short[n];
                System.arraycopy(ss, 0, ns, 0, n);
                pair.setFirst(ns);
            }
        }
        Extractor ext2 = Discriminators.pairExtractor();
        return this.listDisc.discriminate(sorted, ext2);
    }

    private static class IWrap<T> {
        T obj;
        int i;

        public IWrap(T obj, int i) {
            this.obj = obj;
            this.i = i;
        }
    }
}

