/*
 * Decompiled with CFR 0.152.
 */
package org.planx.msd.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.planx.msd.Discriminator;
import org.planx.msd.Discriminators;
import org.planx.msd.Extractor;
import org.planx.msd.Memory;
import org.planx.msd.list.SizeRandomAccessListDiscriminator;
import org.planx.msd.number.IntegerDiscriminator;
import org.planx.msd.util.AbstractDiscriminator;
import org.planx.util.Association;
import org.planx.util.Pair;

public class BagDiscriminator<T>
extends AbstractDiscriminator<List<T>> {
    private Discriminator<T> disc;
    private Discriminator<List<Integer>> listDisc;
    private boolean doRemoveDuplicates;

    public BagDiscriminator(Discriminator<T> d, Memory memory) {
        this(d, memory, false);
    }

    BagDiscriminator(Discriminator<T> d, Memory memory, boolean doRemoveDuplicates) {
        this.disc = d;
        this.listDisc = new SizeRandomAccessListDiscriminator<Integer>(new IntegerDiscriminator(memory), memory);
        this.doRemoveDuplicates = doRemoveDuplicates;
    }

    @Override
    public <U, S> Collection<List<S>> discriminate(List<? extends U> values, Extractor<U, ? extends List<T>, S> e) {
        int insize = values.size();
        ArrayList<IWrap<T>> in = new ArrayList<IWrap<T>>();
        ArrayList sorted = new ArrayList(insize);
        for (int i = 0; i < insize; ++i) {
            U elm = values.get(i);
            List<T> list = e.getLabel(elm);
            for (T t : list) {
                in.add(new IWrap<T>(t, i));
            }
            ArrayList newList = new ArrayList(list.size());
            S s = e.getValue(elm);
            sorted.add(new Association(newList, s));
        }
        Extractor ext1 = new Extractor<IWrap<T>, T, IWrap<T>>(){

            @Override
            public T getLabel(IWrap<T> elm) {
                return elm.obj;
            }

            @Override
            public IWrap<T> getValue(IWrap<T> elm) {
                return elm;
            }
        };
        Collection order = this.disc.discriminate(in, ext1);
        int unique = 0;
        for (List list : order) {
            int prevIdx = -1;
            Integer canon = new Integer(unique);
            for (IWrap wrap : list) {
                int idx = wrap.i;
                if (!this.doRemoveDuplicates || this.doRemoveDuplicates && idx != prevIdx) {
                    Pair p = (Pair)sorted.get(idx);
                    List list2 = (List)p.getFirst();
                    list2.add(canon);
                }
                prevIdx = idx;
            }
            ++unique;
        }
        Extractor ext2 = Discriminators.pairExtractor();
        return this.listDisc.discriminate(sorted, ext2);
    }

    private static class IWrap<T> {
        T obj;
        int i;

        public IWrap(T obj, int i) {
            this.obj = obj;
            this.i = i;
        }
    }
}

