/*
 * Decompiled with CFR 0.152.
 */
package org.planx.msd.array;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.planx.msd.Discriminators;
import org.planx.msd.Extractor;
import org.planx.msd.Memory;
import org.planx.msd.number.IntExtractor;
import org.planx.msd.number.IntegerDiscriminator;
import org.planx.msd.util.AbstractDiscriminator;
import org.planx.util.Array;

public class IntegerArrayDiscriminator
extends AbstractDiscriminator<int[]> {
    private static final int INIT_CAPACITY = 10;
    private IntegerDiscriminator intDisc;

    public IntegerArrayDiscriminator(Memory memory) {
        this.intDisc = new IntegerDiscriminator(memory);
    }

    @Override
    public <U, S> Collection<List<S>> discriminate(List<? extends U> values, final Extractor<U, ? extends int[], S> e) {
        int vsize = values.size();
        if (vsize == 0) {
            return Collections.emptyList();
        }
        if (vsize == 1) {
            List<S> l1 = Collections.singletonList(e.getValue(values.get(0)));
            return Collections.singletonList(l1);
        }
        ArrayList<List<S>> result = new ArrayList<List<S>>();
        ElementExtractor<U> ext = new ElementExtractor<U>(e);
        int[] indexes = new int[10];
        List[] work = new List[10];
        int work_capacity = 10;
        int work_head = 0;
        IntExtractor intExt = new IntExtractor<U, U>(){

            @Override
            public int getLabel(U elm) {
                return ((int[])e.getLabel(elm)).length;
            }

            @Override
            public U getValue(U elm) {
                return elm;
            }
        };
        Collection partition = this.intDisc.discriminate(values, intExt);
        for (List block : partition) {
            if (block.size() > 1) {
                if (work_head + 1 >= work_capacity) {
                    work = Array.ensureCapacity(work, work_head, work_capacity + 1);
                    indexes = Array.ensureCapacity(indexes, work_head, work_capacity + 1);
                    work_capacity = work.length;
                }
                work[work_head] = block;
                ++work_head;
                continue;
            }
            result.add(Discriminators.valueList(block, e));
        }
        while (work_head > 0) {
            if (work_head < work_capacity) {
                work[work_head] = null;
            }
            List block = work[--work_head];
            int index = indexes[work_head];
            if (e.getLabel(block.get(0)).length > index) {
                ext.index = index++;
                partition = this.intDisc.discriminate(block, ext);
                for (List subBlock : partition) {
                    if (subBlock.size() > 1) {
                        if (work_head + 1 >= work_capacity) {
                            work = Array.ensureCapacity(work, work_head, work_capacity + 1);
                            indexes = Array.ensureCapacity(indexes, work_head, work_capacity + 1);
                            work_capacity = work.length;
                        }
                        work[work_head] = subBlock;
                        indexes[work_head] = index;
                        ++work_head;
                        continue;
                    }
                    result.add(Discriminators.valueList(subBlock, e));
                }
                continue;
            }
            result.add(Discriminators.valueList(block, e));
        }
        return result;
    }

    private static class ElementExtractor<E>
    implements Extractor<E, Integer, E> {
        private Extractor<E, ? extends int[], ?> e;
        public int index = 0;

        public ElementExtractor(Extractor<E, ? extends int[], ?> e) {
            this.e = e;
        }

        @Override
        public Integer getLabel(E elm) {
            int[] arr = this.e.getLabel(elm);
            return arr[this.index];
        }

        @Override
        public E getValue(E elm) {
            return elm;
        }
    }
}

