package org.planx.xmlstore.regions;

import java.util.List;
import org.planx.msd.graph.Compactor;
import org.planx.msd.graph.Compactor.Edge;
import org.planx.xmlstore.io.LocalLocator;
import org.planx.xmlstore.nodes.SystemNode;

/**
 * Chooses a node with the least outgoing pointers.
 */
public class LeastInterRegionPolicy extends CanonicPolicy {
    public SystemNode chooseCanonical(List<Compactor<SystemNode>.Edge> eqCls) {
        SystemNode canon = null;
        int minOutgoing = Integer.MAX_VALUE;
        int minId = Integer.MAX_VALUE;

        for (Compactor<SystemNode>.Edge edge : eqCls) {
            SystemNode current = edge.node;
            if (current == canon) continue;

            LocalLocator loc = current.getLocator();
            Region r = owner(loc);

            if (canon == null) {
                canon = current;
                minOutgoing = countOutgoing(current, r);
                minId = r.getLocalId();
            } else if (current != canon) {
                int outgoing = countOutgoing(current, r);
                if (outgoing < minOutgoing) {
                    int id = r.getLocalId();
                    if (id < minId) {
                        canon = current;
                        minOutgoing = outgoing;
                        minId = id;
                    }
                }
            }
            if (minOutgoing == 0) break;
        }
        if (canon == null) throw new NullPointerException();
        return canon;
    }

    protected Region owner(LocalLocator loc) {
        if (loc == null) throw new NullPointerException();
        if (r1 != null && r1.isContained(loc)) return r1;
        if (r2 != null && r2.isContained(loc)) return r2;
        return null;
    }

    protected int countOutgoing(SystemNode node, Region r) {
        int outgoing = 0;
        for (SystemNode child : node.getChildren()) {
            if (!r.isContained(child.getLocator()))
                outgoing++;
        }
        return outgoing;
    }
}
