package org.planx.xmlstore.regions;

import org.planx.xmlstore.io.LocalLocator;

class InterRegionEdge {
    final Origin origin;           // the origin node, child index, and region
    final LocalLocator targetNode; // node pointed to from another region
    final Region targetRegion;     // the identity of the target region

    InterRegionEdge(LocalLocator targetNode, LocalLocator originNode, int childIndex,
                    Region targetRegion, Region originRegion) {
        if (targetNode == null) throw new NullPointerException("target may not be null");
        if (targetRegion == null) throw new NullPointerException("targetRegion may not be null");
        this.targetNode = (targetNode==null)?null:targetNode.clone();//agressive but safe,FIXME
        this.targetRegion = targetRegion;
        this.origin = new Origin(originNode, childIndex, originRegion);
    }

    public boolean equals(Object o) {
        if (o == this) return true;
        if (!(o instanceof InterRegionEdge)) return false;
        InterRegionEdge e = (InterRegionEdge) o;
        return origin.equals(e.origin) &&
               targetRegion.equals(e.targetRegion) &&
               targetNode.equals(e.targetNode);
    }

    public int hashCode() {
        int oh = (origin.originNode == null) ? 0 : origin.originNode.hashCode();
        int orh = (origin.originRegion == null) ? 0 : origin.originRegion.hashCode();
        return targetNode.hashCode() ^ oh ^
               targetRegion.hashCode() ^ orh + 31*origin.childIndex;
    }

    public String toString() {
        return "target="+targetNode+", origin="+origin.originNode+", childIndex="+origin.childIndex+
               ", targetRegion="+targetRegion+", originRegion="+origin.originRegion;
    }

    static class Origin {
        final LocalLocator originNode; // node pointing to target in another region
        final int childIndex;          // the index of the outgoing pointer in origin node
        final Region originRegion;     // the identity of the origin region

        Origin(LocalLocator originNode, int childIndex, Region originRegion) {
            if (originNode == null && originRegion != null) throw new NullPointerException
                 ("origin and originRegion must both be null, originRegion is not");
            if (originRegion == null && originNode != null) throw new NullPointerException
                 ("origin and originRegion must both be null, origin is not");
            this.originNode = (originNode==null)?null:originNode.clone();//agressive but safe,FIXME
            this.childIndex = childIndex;
            this.originRegion = originRegion;
        }

        public boolean equals(Object o) {
            if (o == this) return true;
            if (!(o instanceof Origin)) return false;
            Origin e = (Origin) o;
            return (childIndex == e.childIndex) &&
                   (
                       (originRegion == null && e.originRegion == null &&
                        originNode == null && e.originNode == null)
                   ||
                       (originRegion.equals(e.originRegion) &&
                        originNode.equals(e.originNode))
                   );
        }

        public int hashCode() {
            int oh = (originNode == null) ? 0 : originNode.hashCode();
            int orh = (originRegion == null) ? 0 : originRegion.hashCode();
            return oh ^ orh + 31*childIndex;
        }

        public String toString() {
            return "origin="+originNode+", childIndex="+childIndex+
                   ", originRegion="+originRegion;
        }
    }
}
