package org.planx.xmlstore.nodes;

import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.ExecutionException;
import org.planx.xmlstore.*;

/**
 * @author Kasper Bøgebjerg
 * @author Henning Niss
 * @author Thomas Ambus
 */
public class BlockingNodeProxy extends NodeProxy {
    protected Future<SystemNode> future;

    public BlockingNodeProxy(Reference ref, Future<SystemNode> future) {
        super(ref);
        this.future = future;
    }

    protected SystemNode generate() throws UnknownReferenceException, IOException {
        try {
            return future.get();
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        } catch (ExecutionException e) {
            throw new IOException(e.toString());
        }
    }
}
