package org.planx.util;

import java.lang.ref.*;
import java.util.*;

/**
 * @author Thomas Ambus
 */
public class WeakHashSet<E> extends AbstractSet<E> implements Set<E> {
    private WeakHashMap<E,WeakReference<E>> map;

    public WeakHashSet() {
        map = new WeakHashMap<E,WeakReference<E>>();
    }

    public WeakHashSet(Collection<? extends E> c) {
        map = new WeakHashMap<E,WeakReference<E>>(Math.max((int) (c.size()/.75f) + 1, 16));
        addAll(c);
    }

    public WeakHashSet(int initialCapacity, float loadFactor) {
        map = new WeakHashMap<E,WeakReference<E>>(initialCapacity, loadFactor);
    }

    public WeakHashSet(int initialCapacity) {
        map = new WeakHashMap<E,WeakReference<E>>(initialCapacity);
    }

    public E get(Object o) {
        WeakReference<E> w = map.get(o);
        return (w == null) ? null : w.get();
    }

    public Iterator<E> iterator() {
        return map.keySet().iterator();
    }

    public int size() {
        return map.size();
    }

    public boolean isEmpty() {
        return map.isEmpty();
    }

    public boolean contains(Object o) {
        return map.containsKey(o);
    }

    public boolean add(E o) {
        return map.put(o, new WeakReference<E>(o)) == null;
    }

    public boolean remove(Object o) {
        return map.remove(o) != null;
    }

    public void clear() {
        map.clear();
    }
}
