/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.scanner.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.scanner.InstallableBundle;
import org.ops4j.pax.scanner.InstallableBundles;
import org.ops4j.pax.scanner.MalformedSpecificationException;
import org.ops4j.pax.scanner.ProvisionService;
import org.ops4j.pax.scanner.ProvisionSpec;
import org.ops4j.pax.scanner.ScannedBundle;
import org.ops4j.pax.scanner.Scanner;
import org.ops4j.pax.scanner.ScannerException;
import org.ops4j.pax.scanner.UnsupportedSchemaException;
import org.ops4j.pax.scanner.internal.InstallableBundleImpl;
import org.ops4j.pax.scanner.internal.InstallableBundlesImpl;
import org.osgi.framework.BundleContext;
import org.osgi.service.startlevel.StartLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProvisionServiceImpl
implements ProvisionService {
    private static final Log LOGGER = LogFactory.getLog(ProvisionServiceImpl.class);
    private final Map<String, Scanner> m_scanners;
    private final BundleContext m_bundleContext;
    private StartLevel m_startLevelService;

    public ProvisionServiceImpl(BundleContext bundleContext) {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        this.m_bundleContext = bundleContext;
        this.m_scanners = new HashMap<String, Scanner>();
    }

    @Override
    public List<ScannedBundle> scan(String spec) throws MalformedSpecificationException, ScannerException {
        LOGGER.info("Scan bundles from [" + spec + "]");
        ProvisionSpec provisionSpec = new ProvisionSpec(spec);
        Scanner scanner = this.m_scanners.get(provisionSpec.getScheme());
        if (scanner == null) {
            throw new UnsupportedSchemaException("Unknown provisioning scheme [" + provisionSpec.getScheme() + "]");
        }
        return this.scan(scanner, provisionSpec);
    }

    @Override
    public InstallableBundles wrap(List<ScannedBundle> scannedBundles) {
        ArrayList<InstallableBundle> installables = new ArrayList<InstallableBundle>();
        if (scannedBundles != null) {
            for (ScannedBundle scannedBundle : scannedBundles) {
                installables.add(this.wrap(scannedBundle));
            }
        }
        return this.createSet(installables);
    }

    InstallableBundles createSet(List<InstallableBundle> installables) {
        return new InstallableBundlesImpl(installables);
    }

    InstallableBundle wrap(ScannedBundle scannedBundle) {
        return new InstallableBundleImpl(this.m_bundleContext, scannedBundle, this.m_startLevelService);
    }

    private List<ScannedBundle> scan(Scanner scanner, ProvisionSpec spec) throws ScannerException, MalformedSpecificationException {
        List<ScannedBundle> scannedBundles = scanner.scan(spec);
        if (LOGGER.isWarnEnabled() && scannedBundles == null) {
            LOGGER.warn("Scanner did not return any bundle to install for [" + spec + "]");
        }
        return scannedBundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScanner(Scanner scanner, String scheme) {
        NullArgumentException.validateNotNull(scheme, "Scheme");
        NullArgumentException.validateNotNull(scanner, "Scanner");
        Map<String, Scanner> map = this.m_scanners;
        synchronized (map) {
            this.m_scanners.put(scheme, scanner);
        }
        LOGGER.debug("Added scheme [" + scheme + "] from scanner [" + scanner + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScanner(Scanner scanner) {
        NullArgumentException.validateNotNull(scanner, "Scanner");
        Map<String, Scanner> map = this.m_scanners;
        synchronized (map) {
            for (Map.Entry<String, Scanner> entry : this.m_scanners.entrySet()) {
                if (scanner != entry.getValue()) continue;
                this.m_scanners.remove(entry.getKey());
                LOGGER.debug("Removed scheme [" + entry.getKey() + "] scanner [" + scanner + "]");
            }
        }
    }

    public void setStartLevelService(StartLevel startLevelService) {
        this.m_startLevelService = startLevelService;
    }
}

