/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class XppPathQuery {
    private static final String NODE = "\\w+";
    private static final String PARENT = "\\w+(?:/\\w+)*";
    private static final String TEST = "(.|\\w+)='(.*)'";
    private static final String BIN_OP = "(?:and|or)";
    private static final String PREDICATE = "(.|\\w+)='(.*)'(?:\\s+(?:and|or)\\s+(.|\\w+)='(.*)')*";
    private static final String XPATH = "/?(\\w+(?:/\\w+)*)/(\\w+)\\[\\s*((.|\\w+)='(.*)'(?:\\s+(?:and|or)\\s+(.|\\w+)='(.*)')*)\\s*\\]";
    private final Matcher m_xpathParser;

    public XppPathQuery(String xpath) throws IllegalArgumentException {
        this.m_xpathParser = Pattern.compile(XPATH).matcher(xpath);
        if (!this.m_xpathParser.matches()) {
            throw new IllegalArgumentException("Unsupported XPATH syntax: " + xpath);
        }
    }

    public Xpp3Dom queryParent(Xpp3Dom dom) {
        String[] nodes = this.m_xpathParser.group(1).split("/");
        Xpp3Dom parent = dom;
        for (int i = 0; parent != null && i < nodes.length; parent = parent.getChild(nodes[i]), ++i) {
        }
        return parent;
    }

    public int[] queryChildren(Xpp3Dom parent) {
        String pivotNode = this.m_xpathParser.group(2);
        Pattern testPattern = Pattern.compile(TEST);
        String[] testClauses = this.m_xpathParser.group(3).split("\\s+");
        ArrayList<Xpp3Dom> children = new ArrayList<Xpp3Dom>(Arrays.asList(parent.getChildren()));
        HashSet results = new HashSet();
        for (int i = -1; i < testClauses.length; i += 2) {
            Matcher matcher = testPattern.matcher(testClauses[i + 1]);
            matcher.matches();
            Set selection = this.filter(children, pivotNode, matcher.group(1), matcher.group(2));
            if (i > 0 && "and".equals(testClauses[i])) {
                results.retainAll(selection);
                continue;
            }
            results.addAll(selection);
        }
        int[] indices = new int[results.size()];
        int n = 0;
        Iterator i = results.iterator();
        while (i.hasNext()) {
            indices[n++] = children.indexOf(i.next());
        }
        return indices;
    }

    private Set filter(List children, String pivotNode, String testNode, String testValue) {
        HashSet<Xpp3Dom> results = new HashSet<Xpp3Dom>();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Xpp3Dom node;
            Xpp3Dom test = node = (Xpp3Dom)i.next();
            if (!testNode.startsWith(".")) {
                test = node.getChild(testNode);
            }
            if (!pivotNode.equals(node.getName()) || test == null || !testValue.equals(test.getValue())) continue;
            results.add(node);
        }
        return results;
    }
}

