/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.util;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public final class RoundTripXml {
    private RoundTripXml() {
    }

    public static XmlPullParser createParser() {
        return new RoundTripParser();
    }

    public static XmlSerializer createSerializer() {
        return new RoundTripSerializer();
    }

    private static final class RoundTripSerializer
    extends MXSerializer {
        private static final String NEWLINE = System.getProperty("line.separator");
        private boolean m_handleComment = false;

        RoundTripSerializer() {
            this.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  ");
            this.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", NEWLINE);
        }

        public XmlSerializer startTag(String namespace, String name) throws IOException {
            if (name.startsWith("!--")) {
                this.m_handleComment = true;
                this.closeStartTag();
                if (this.getDepth() <= 1) {
                    this.out.write(this.lineSeparator);
                }
                this.writeIndent();
                String text = name.substring(3);
                this.comment(text.replaceAll("[\r\n\f]", NEWLINE));
                return this;
            }
            List<String> stickyTags = Arrays.asList("groupId", "artifactId", "version");
            if (this.getDepth() <= 1 && !stickyTags.contains(name)) {
                this.closeStartTag();
                this.out.write(this.lineSeparator);
            }
            if (this.m_handleComment) {
                this.m_handleComment = false;
                this.writeIndent();
            }
            return super.startTag(namespace, name);
        }

        public XmlSerializer endTag(String namespace, String name) throws IOException {
            if (!name.startsWith("!--")) {
                if (this.getDepth() == 1) {
                    this.out.write(this.lineSeparator);
                }
                if (this.m_handleComment) {
                    this.m_handleComment = false;
                    --this.depth;
                    this.writeIndent();
                    ++this.depth;
                }
                super.endTag(namespace, name);
            }
            return this;
        }

        public XmlSerializer attribute(String namespace, String name, String value) throws IOException {
            if (!"combine.children".equals(name)) {
                return super.attribute(namespace, name, value);
            }
            return this;
        }

        protected void writeElementContent(String text, Writer writer) throws IOException {
            super.writeElementContent(text.trim(), writer);
        }
    }

    private static final class RoundTripParser
    extends MXParser {
        private boolean m_handleComment = false;

        RoundTripParser() {
        }

        public int next() throws XmlPullParserException, IOException {
            if (this.m_handleComment) {
                this.m_handleComment = false;
                return 3;
            }
            int type = super.nextToken();
            if (9 == this.eventType && 0 < this.depth) {
                this.m_handleComment = true;
                return 2;
            }
            return type;
        }

        public String getName() {
            if (this.m_handleComment) {
                return "!--" + this.getText();
            }
            return super.getName();
        }

        public boolean isEmptyElementTag() throws XmlPullParserException {
            if (this.m_handleComment) {
                return true;
            }
            return super.isEmptyElementTag();
        }

        public int getAttributeCount() {
            if (this.m_handleComment) {
                return 0;
            }
            return super.getAttributeCount();
        }
    }
}

