/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.util;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.ops4j.pax.construct.util.XppPom;

public final class PomUtils {
    private PomUtils() {
    }

    public static Pom readPom(File here) throws IOException {
        File candidate = here;
        if (null == here) {
            throw new IOException("null location");
        }
        if (here.isDirectory()) {
            candidate = new File(here, "pom.xml");
        }
        return new XppPom(candidate);
    }

    public static Pom createModulePom(File here, String groupId, String artifactId) throws IOException {
        File candidate = here;
        if (null == here) {
            throw new IOException("null location");
        }
        if (here.isDirectory()) {
            candidate = new File(here, "pom.xml");
        }
        return new XppPom(candidate, groupId, artifactId);
    }

    public static boolean isBundleProject(MavenProject project) {
        return PomUtils.isBundleProject(project, null, null, null, false);
    }

    public static boolean isBundleProject(MavenProject project, ArtifactResolver resolver, List remoteRepos, ArtifactRepository localRepo, boolean testMetadata) {
        String packaging = project.getPackaging();
        if (packaging != null && packaging.indexOf("bundle") >= 0) {
            return true;
        }
        return PomUtils.isBundleArtifact(project.getArtifact(), resolver, remoteRepos, localRepo, testMetadata);
    }

    public static boolean isBundleArtifact(Artifact artifact, ArtifactResolver resolver, List remoteRepos, ArtifactRepository localRepo, boolean testMetadata) {
        String type = artifact.getType();
        if (null != type && type.indexOf("bundle") >= 0) {
            return true;
        }
        if (!testMetadata || !PomUtils.downloadFile(artifact, resolver, remoteRepos, localRepo)) {
            return false;
        }
        try {
            return PomUtils.isBundleArtifact(new JarFile(artifact.getFile()).getManifest());
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean isBundleArtifact(Manifest manifest) {
        if (null == manifest) {
            return false;
        }
        Attributes mainAttributes = manifest.getMainAttributes();
        return mainAttributes.getValue("Bundle-SymbolicName") != null || mainAttributes.getValue("Bundle-Name") != null;
    }

    public static boolean getFile(Artifact artifact, ArtifactResolver resolver, ArtifactRepository localRepo) {
        return PomUtils.downloadFile(artifact, resolver, Collections.EMPTY_LIST, localRepo);
    }

    public static boolean downloadFile(Artifact artifact, ArtifactResolver resolver, List remoteRepos, ArtifactRepository localRepo) {
        if (artifact.getFile() == null || !artifact.getFile().exists()) {
            try {
                resolver.resolve(artifact, remoteRepos, localRepo);
            }
            catch (AbstractArtifactResolutionException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }
        return true;
    }

    public static String getCompoundId(String groupId, String artifactId) {
        String lhs = groupId.replace('-', '.');
        String rhs = artifactId.replace('-', '.');
        if (rhs.equals(lhs) || rhs.startsWith(lhs + '.')) {
            return artifactId;
        }
        rhs = '.' + rhs;
        int i = rhs.length();
        while (i > 0) {
            if (lhs.endsWith(rhs.substring(0, i))) {
                if (rhs.length() == i) {
                    return groupId;
                }
                return groupId + '.' + artifactId.substring(i);
            }
            i = rhs.lastIndexOf(46, i - 1);
        }
        return groupId + '.' + artifactId;
    }

    public static String getMetaVersion(Artifact artifact) {
        if (artifact.isSnapshot()) {
            try {
                return artifact.getSelectedVersion().toString();
            }
            catch (OverConstrainedVersionException e) {
                return artifact.getVersion();
            }
            catch (NullPointerException e) {
                return artifact.getVersion();
            }
        }
        return artifact.getVersion();
    }

    public static boolean needReleaseVersion(String version) {
        return PomUtils.isEmpty(version) || "RELEASE".equals(version) || "LATEST".equals(version);
    }

    public static String getReleaseVersion(Artifact artifact, ArtifactMetadataSource source, List remoteRepos, ArtifactRepository localRepo, VersionRange range) throws MojoExecutionException {
        try {
            List versions = source.retrieveAvailableVersions(artifact, localRepo, remoteRepos);
            ArtifactVersion releaseVersion = PomUtils.getLatestReleaseInRange(versions, range);
            if (null == releaseVersion) {
                throw new MojoExecutionException("Unable to find release version for " + artifact);
            }
            return releaseVersion.toString();
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException("Unable to find artifact " + artifact);
        }
    }

    private static ArtifactVersion getLatestReleaseInRange(List versions, VersionRange range) {
        DefaultArtifactVersion baseline;
        DefaultArtifactVersion releaseVersion = baseline = new DefaultArtifactVersion("0");
        Iterator i = versions.iterator();
        while (i.hasNext()) {
            ArtifactVersion v = (ArtifactVersion)i.next();
            if (!PomUtils.isCompatible(range, v) || releaseVersion.compareTo((Object)v) > 0) continue;
            releaseVersion = v;
        }
        if (baseline == releaseVersion) {
            return null;
        }
        return releaseVersion;
    }

    private static boolean isCompatible(VersionRange range, ArtifactVersion version) {
        if (version.getMajorVersion() > 10000000 || ArtifactUtils.isSnapshot((String)version.toString())) {
            return false;
        }
        return range == null || range.containsVersion(version);
    }

    public static boolean isEmpty(String param) {
        return null == param || param.trim().length() == 0;
    }

    public static boolean isNotEmpty(String param) {
        return null != param && param.trim().length() > 0;
    }

    public static class ExistingElementException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ExistingElementException(String element) {
            super("Project already has a <" + element + "> which matches, use -Doverwrite or -o to replace it");
        }

        public synchronized Throwable fillInStackTrace() {
            return this;
        }

        public String toString() {
            return "[INFO] not available";
        }
    }

    public static interface Pom {
        public String getId();

        public String getParentId();

        public String getGroupId();

        public String getArtifactId();

        public String getVersion();

        public String getPackaging();

        public List getModuleNames();

        public Pom getContainingPom();

        public Pom getModulePom(String var1);

        public File getFile();

        public File getBasedir();

        public boolean isBundleProject();

        public String getBundleSymbolicName();

        public void setParent(Pom var1, String var2, boolean var3) throws ExistingElementException;

        public void setParent(MavenProject var1, String var2, boolean var3) throws ExistingElementException;

        public void setGroupId(String var1);

        public void setVersion(String var1);

        public void addRepository(Repository var1, boolean var2, boolean var3, boolean var4, boolean var5) throws ExistingElementException;

        public void addModule(String var1, boolean var2) throws ExistingElementException;

        public boolean removeModule(String var1);

        public void addDependency(Dependency var1, boolean var2) throws ExistingElementException;

        public boolean updateDependencyGroup(Dependency var1, String var2);

        public boolean removeDependency(Dependency var1);

        public void addExclusion(String var1, String var2, boolean var3) throws ExistingElementException;

        public boolean removeExclusion(String var1, String var2);

        public Properties getProperties();

        public void setProperty(String var1, String var2);

        public boolean updatePluginVersion(String var1, String var2, String var3);

        public void mergeSection(Pom var1, String var2, String var3, boolean var4);

        public void overlayDetails(Pom var1);

        public void write() throws IOException;
    }
}

