/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.bundle;

import java.io.File;
import java.io.IOException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;
import org.ops4j.pax.construct.util.DirUtils;
import org.ops4j.pax.construct.util.PomIterator;
import org.ops4j.pax.construct.util.PomUtils;

public class MoveBundleMojo
extends AbstractMojo {
    private File baseDirectory;
    private File targetDirectory;
    private String bundleName;
    private boolean repair;

    protected static PomUtils.Pom locateBundlePom(File baseDir, String pathOrName) throws MojoExecutionException {
        PomUtils.Pom bundlePom = null;
        if (null != pathOrName) {
            File path = new File(pathOrName);
            try {
                bundlePom = PomUtils.readPom(path);
            }
            catch (IOException e) {
                bundlePom = DirUtils.findPom(baseDir, path.getName());
            }
        }
        if (null == bundlePom || !bundlePom.isBundleProject()) {
            throw new MojoExecutionException("Cannot find bundle " + pathOrName);
        }
        return bundlePom;
    }

    public void execute() throws MojoExecutionException {
        PomUtils.Pom oldBundlePom = MoveBundleMojo.locateBundlePom(this.baseDirectory, this.bundleName);
        File oldBundleDir = oldBundlePom.getBasedir();
        PomUtils.Pom newModulesPom = this.moveBundleFiles(oldBundlePom);
        this.transferBundleOwnership(oldBundleDir, newModulesPom);
        if (this.repair) {
            String newGroupId = PomUtils.getCompoundId(newModulesPom.getGroupId(), newModulesPom.getArtifactId());
            PomUtils.Pom newBundlePom = newModulesPom.getModulePom(oldBundleDir.getName());
            if (null != newBundlePom) {
                this.changeBundleGroup(newBundlePom, newGroupId);
            }
        }
    }

    private PomUtils.Pom moveBundleFiles(PomUtils.Pom bundlePom) throws MojoExecutionException {
        PomUtils.Pom newModulesPom;
        try {
            newModulesPom = DirUtils.createModuleTree(this.baseDirectory, this.targetDirectory);
        }
        catch (IOException e) {
            newModulesPom = null;
        }
        if (null == newModulesPom) {
            throw new MojoExecutionException("targetDirectory is outside of this project");
        }
        if (!"pom".equals(newModulesPom.getPackaging())) {
            throw new MojoExecutionException("targetDirectory is not a modules directory");
        }
        File oldBundleDir = bundlePom.getBasedir();
        File newBundleDir = new File(newModulesPom.getBasedir(), oldBundleDir.getName());
        this.getLog().info((CharSequence)("Moving " + oldBundleDir + " to " + newBundleDir));
        if (!oldBundleDir.renameTo(newBundleDir)) {
            try {
                FileUtils.copyDirectoryStructure((File)oldBundleDir, (File)newBundleDir);
                FileUtils.deleteDirectory((File)oldBundleDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot move bundle " + this.bundleName + " to " + this.targetDirectory);
            }
        }
        this.updateParentDetails(bundlePom, newBundleDir);
        return newModulesPom;
    }

    private void updateParentDetails(PomUtils.Pom bundlePom, File newBundleDir) {
        String parentId = bundlePom.getParentId();
        if (null != parentId) {
            try {
                DirUtils.updateLogicalParent(newBundleDir, parentId);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Unable to update logical parent " + parentId));
            }
        }
    }

    private void transferBundleOwnership(File oldBundleDir, PomUtils.Pom newModulesPom) {
        String moduleName = oldBundleDir.getName();
        try {
            newModulesPom.addModule(moduleName, true);
            newModulesPom.write();
            PomUtils.Pom oldModulesPom = PomUtils.readPom(oldBundleDir.getParentFile());
            oldModulesPom.removeModule(moduleName);
            oldModulesPom.write();
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Problem transferring bundle ownership");
        }
    }

    private void changeBundleGroup(PomUtils.Pom bundlePom, String newGroupId) {
        try {
            String oldGroupId = bundlePom.getGroupId();
            bundlePom.setGroupId(newGroupId);
            bundlePom.write();
            PomIterator i = new PomIterator(bundlePom.getBasedir());
            while (i.hasNext()) {
                PomUtils.Pom pom = (PomUtils.Pom)i.next();
                if (pom.equals(bundlePom)) continue;
                this.updateBundleReferences(pom, oldGroupId, bundlePom.getGroupId(), bundlePom.getArtifactId());
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Unable to update bundle groupId to " + newGroupId));
        }
    }

    private void updateBundleReferences(PomUtils.Pom pom, String oldGroupId, String newGroupId, String artifactId) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(oldGroupId);
        dependency.setArtifactId(artifactId);
        if (pom.updateDependencyGroup(dependency, newGroupId)) {
            this.getLog().info((CharSequence)("Updating " + newGroupId + ':' + artifactId + " in " + pom));
            try {
                pom.write();
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Problem writing Maven POM: " + pom.getFile()));
            }
        }
    }
}

