/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.vecmath.Point2d;
import org.openscience.cdk.geometry.GeometryUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.OvalElement;
import org.openscience.cdk.renderer.generators.BasicBondGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.parameter.AbstractGeneratorParameter;

public class RingGenerator
extends BasicBondGenerator {
    private IGeneratorParameter<Boolean> showAromaticity = new ShowAromaticity();
    private IGeneratorParameter<Boolean> cdkStyleAromaticity = new CDKStyleAromaticity();
    private IGeneratorParameter<Integer> maxDrawableAromaticRing = new MaxDrawableAromaticRing();
    private IGeneratorParameter<Double> ringProportion = new RingProportion();
    private Set<IRing> painted_rings = new HashSet<IRing>();

    @Override
    public IRenderingElement generateRingElements(IBond bond, IRing ring, RendererModel model) {
        if (this.ringIsAromatic(ring) && ((Boolean)this.showAromaticity.getValue()).booleanValue() && ring.getAtomCount() < (Integer)this.maxDrawableAromaticRing.getValue()) {
            ElementGroup pair = new ElementGroup();
            if (((Boolean)this.cdkStyleAromaticity.getValue()).booleanValue()) {
                pair.add(this.generateBondElement(bond, IBond.Order.SINGLE, model));
                super.setOverrideColor(Color.LIGHT_GRAY);
                pair.add(this.generateInnerElement(bond, ring, model));
                super.setOverrideColor(null);
            } else {
                pair.add(this.generateBondElement(bond, IBond.Order.SINGLE, model));
                if (!this.painted_rings.contains(ring)) {
                    this.painted_rings.add(ring);
                    pair.add(this.generateRingRingElement(bond, ring, model));
                }
            }
            return pair;
        }
        return super.generateRingElements(bond, ring, model);
    }

    private IRenderingElement generateRingRingElement(IBond bond, IRing ring, RendererModel model) {
        Point2d c = GeometryUtil.get2DCenter((IAtomContainer)ring);
        double[] minmax = GeometryUtil.getMinMax((IAtomContainer)ring);
        double width = minmax[2] - minmax[0];
        double height = minmax[3] - minmax[1];
        double radius = Math.min(width, height) * (Double)this.ringProportion.getValue();
        Color color = this.getColorForBond(bond, model);
        return new OvalElement(c.x, c.y, radius, false, color);
    }

    private boolean ringIsAromatic(IRing ring) {
        boolean isAromatic = true;
        for (IAtom atom : ring.atoms()) {
            if (atom.getFlag(32)) continue;
            isAromatic = false;
            break;
        }
        if (!isAromatic) {
            isAromatic = true;
            for (IBond b : ring.bonds()) {
                if (b.getFlag(32)) continue;
                return false;
            }
        }
        return isAromatic;
    }

    @Override
    public List<IGeneratorParameter<?>> getParameters() {
        List<IGeneratorParameter<?>> superPars = super.getParameters();
        ArrayList pars = new ArrayList(superPars.size() + 3);
        pars.addAll(superPars);
        pars.add(this.cdkStyleAromaticity);
        pars.add(this.showAromaticity);
        pars.add(this.maxDrawableAromaticRing);
        pars.add(this.ringProportion);
        return pars;
    }

    public static class RingProportion
    extends AbstractGeneratorParameter<Double> {
        public Double getDefault() {
            return 0.35;
        }
    }

    public static class MaxDrawableAromaticRing
    extends AbstractGeneratorParameter<Integer> {
        public Integer getDefault() {
            return 8;
        }
    }

    public static class CDKStyleAromaticity
    extends AbstractGeneratorParameter<Boolean> {
        public Boolean getDefault() {
            return Boolean.FALSE;
        }
    }

    public static class ShowAromaticity
    extends AbstractGeneratorParameter<Boolean> {
        public Boolean getDefault() {
            return Boolean.TRUE;
        }
    }
}

