/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openscience.cdk.tools.ILoggingTool;

public class LoggingToolFactory {
    public static final String DEFAULT_LOGGING_TOOL_CLASS = "org.openscience.cdk.tools.LoggingTool";
    public static final String STDOUT_LOGGING_TOOL_CLASS = "org.openscience.cdk.tools.SystemOutLoggingTool";
    private static Class<? extends ILoggingTool> userSetILoggerTool;

    public static void setLoggingToolClass(Class<? extends ILoggingTool> loggingTool) {
        userSetILoggerTool = loggingTool;
    }

    public static Class<? extends ILoggingTool> getLoggingToolClass() {
        return userSetILoggerTool;
    }

    public static ILoggingTool createLoggingTool(Class<?> sourceClass) {
        ILoggingTool tool = null;
        if (userSetILoggerTool != null) {
            tool = LoggingToolFactory.instantiateWithCreateMethod(sourceClass, userSetILoggerTool);
        }
        if (tool == null) {
            tool = LoggingToolFactory.initializeLoggingTool(sourceClass, DEFAULT_LOGGING_TOOL_CLASS);
        }
        if (tool == null) {
            tool = LoggingToolFactory.initializeLoggingTool(sourceClass, STDOUT_LOGGING_TOOL_CLASS);
        }
        return tool;
    }

    private static ILoggingTool initializeLoggingTool(Class<?> sourceClass, String className) {
        try {
            Class<?> possibleLoggingToolClass = sourceClass.getClassLoader().loadClass(className);
            if (ILoggingTool.class.isAssignableFrom(possibleLoggingToolClass)) {
                return LoggingToolFactory.instantiateWithCreateMethod(sourceClass, possibleLoggingToolClass);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    private static ILoggingTool instantiateWithCreateMethod(Class<?> sourceClass, Class<?> loggingToolClass) {
        try {
            Method createMethod = loggingToolClass.getMethod("create", Class.class);
            Object createdLoggingTool = createMethod.invoke(null, sourceClass);
            if (createdLoggingTool instanceof ILoggingTool) {
                return (ILoggingTool)createdLoggingTool;
            }
            System.out.println("Expected ILoggingTool, but found a:" + createdLoggingTool.getClass().getName());
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }
}

