/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IMolecularFormulaSet;

public class MolecularFormulaSet
implements Iterable<IMolecularFormula>,
IMolecularFormulaSet,
Cloneable {
    private static final long serialVersionUID = -2043178712150212550L;
    private List<IMolecularFormula> components = new ArrayList<IMolecularFormula>();

    public MolecularFormulaSet() {
    }

    public MolecularFormulaSet(IMolecularFormula formula) {
        this.components.add(0, formula);
    }

    public void add(IMolecularFormulaSet formulaSet) {
        for (IMolecularFormula mf : formulaSet.molecularFormulas()) {
            this.addMolecularFormula(mf);
        }
    }

    public void addMolecularFormula(IMolecularFormula formula) {
        this.components.add(formula);
    }

    public Iterable<IMolecularFormula> molecularFormulas() {
        return this.components;
    }

    @Override
    public Iterator<IMolecularFormula> iterator() {
        return this.components.iterator();
    }

    public int size() {
        return this.components.size();
    }

    public boolean contains(IMolecularFormula formula) {
        return this.components.contains(formula);
    }

    public IMolecularFormula getMolecularFormula(int position) {
        return this.components.get(position);
    }

    public void removeAllMolecularFormulas() {
        this.components.clear();
    }

    public void removeMolecularFormula(IMolecularFormula formula) {
        this.components.remove(formula);
    }

    public void removeMolecularFormula(int position) {
        this.components.remove(position);
    }

    public Object clone() throws CloneNotSupportedException {
        MolecularFormulaSet clone = new MolecularFormulaSet();
        for (IMolecularFormula mf : this.molecularFormulas()) {
            clone.addMolecularFormula((IMolecularFormula)mf.clone());
        }
        return clone;
    }

    public IChemObjectBuilder getBuilder() {
        return DefaultChemObjectBuilder.getInstance();
    }
}

