/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.AtomRef;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.MDLV2000Writer;
import org.openscience.cdk.io.MDLValence;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLV2000Format;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.isomorphism.matchers.Expr;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.isomorphism.matchers.QueryAtom;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.QueryBond;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupBracket;
import org.openscience.cdk.sgroup.SgroupKey;
import org.openscience.cdk.sgroup.SgroupType;
import org.openscience.cdk.stereo.StereoElementFactory;
import org.openscience.cdk.stereo.TetrahedralChirality;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class MDLV2000Reader
extends DefaultChemObjectReader {
    BufferedReader input = null;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLV2000Reader.class);
    private BooleanIOSetting forceReadAs3DCoords;
    private BooleanIOSetting interpretHydrogenIsotopes;
    private BooleanIOSetting addStereoElements;
    private static final Pattern TRAILING_SPACE = Pattern.compile("\\s+$");
    private static final String RECORD_DELIMITER = "$$$$";
    private static final Set<String> PSEUDO_LABELS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("*", "A", "Q", "L", "LP", "R", "R#")));

    public MDLV2000Reader() {
        this(new StringReader(""));
    }

    public MDLV2000Reader(InputStream in) {
        this(new InputStreamReader(in));
    }

    public MDLV2000Reader(InputStream in, IChemObjectReader.Mode mode) {
        this(new InputStreamReader(in), mode);
    }

    public MDLV2000Reader(Reader in) {
        this(in, IChemObjectReader.Mode.RELAXED);
    }

    public MDLV2000Reader(Reader in, IChemObjectReader.Mode mode) {
        this.input = new BufferedReader(in);
        this.initIOSettings();
        this.mode = mode;
    }

    public IResourceFormat getFormat() {
        return MDLV2000Format.getInstance();
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (IChemFile.class.equals(anInterface)) {
                return true;
            }
            if (IChemModel.class.equals(anInterface)) {
                return true;
            }
            if (!IAtomContainer.class.equals(anInterface)) continue;
            return true;
        }
        if (IAtomContainer.class.equals(classObject)) {
            return true;
        }
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        if (IChemModel.class.equals(classObject)) {
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        return superClass != null && this.accepts(superClass);
    }

    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IAtomContainer) {
            return (T)this.readAtomContainer((IAtomContainer)object);
        }
        if (object instanceof IChemFile) {
            return (T)this.readChemFile((IChemFile)object);
        }
        if (object instanceof IChemModel) {
            return (T)this.readChemModel((IChemModel)object);
        }
        throw new CDKException("Only supported are ChemFile and Molecule.");
    }

    private IChemModel readChemModel(IChemModel chemModel) throws CDKException {
        IAtomContainer m;
        IAtomContainerSet setOfMolecules = chemModel.getMoleculeSet();
        if (setOfMolecules == null) {
            setOfMolecules = (IAtomContainerSet)chemModel.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        }
        if ((m = this.readAtomContainer((IAtomContainer)chemModel.getBuilder().newInstance(IAtomContainer.class, new Object[0]))) != null) {
            setOfMolecules.addAtomContainer(m);
        }
        chemModel.setMoleculeSet(setOfMolecules);
        return chemModel;
    }

    private IChemFile readChemFile(IChemFile chemFile) throws CDKException {
        IChemObjectBuilder builder = chemFile.getBuilder();
        IChemSequence sequence = (IChemSequence)builder.newInstance(IChemSequence.class, new Object[0]);
        try {
            IAtomContainer m;
            while ((m = this.readAtomContainer((IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[0]))) != null) {
                sequence.addChemModel(MDLV2000Reader.newModel(m));
            }
        }
        catch (CDKException e) {
            throw e;
        }
        catch (IllegalArgumentException exception) {
            String error = "Error while parsing SDF";
            logger.error((Object)error);
            logger.debug((Object)exception);
            throw new CDKException(error, (Throwable)exception);
        }
        try {
            this.input.close();
        }
        catch (Exception exc) {
            String error = "Error while closing file: " + exc.getMessage();
            logger.error((Object)error);
            throw new CDKException(error, (Throwable)exc);
        }
        chemFile.addChemSequence(sequence);
        return chemFile;
    }

    private static IChemModel newModel(IAtomContainer container) {
        if (container == null) {
            throw new NullPointerException("cannot create chem model for a null container");
        }
        IChemObjectBuilder builder = container.getBuilder();
        IChemModel model = (IChemModel)builder.newInstance(IChemModel.class, new Object[0]);
        IAtomContainerSet containers = (IAtomContainerSet)builder.newInstance(IAtomContainerSet.class, new Object[0]);
        containers.addAtomContainer(container);
        model.setMoleculeSet(containers);
        return model;
    }

    private IAtomContainer readAtomContainer(IAtomContainer molecule) throws CDKException {
        boolean isQuery = molecule instanceof IQueryAtomContainer;
        Object outputContainer = null;
        HashMap<IAtom, Integer> parities = new HashMap<IAtom, Integer>();
        int linecount = 0;
        String title = null;
        String program = null;
        String remark = null;
        String line = "";
        try {
            int offset;
            int i;
            line = this.input.readLine();
            ++linecount;
            if (line == null) {
                return null;
            }
            if (line.startsWith(RECORD_DELIMITER)) {
                return molecule;
            }
            if (line.length() > 0) {
                title = line;
            }
            line = this.input.readLine();
            ++linecount;
            program = line;
            line = this.input.readLine();
            ++linecount;
            if (line.length() > 0) {
                remark = line;
            }
            line = this.input.readLine();
            ++linecount;
            if (line.length() == 0) {
                this.handleError("Unexpected empty line", linecount, 0, 0);
                do {
                    line = this.input.readLine();
                    ++linecount;
                    if (line != null) continue;
                    return null;
                } while (!line.startsWith(RECORD_DELIMITER));
                return molecule;
            }
            CTabVersion version = CTabVersion.ofHeader(line);
            if (version == CTabVersion.V3000) {
                this.handleError("This file must be read with the MDLV3000Reader.");
                throw new CDKException("This file must be read with the MDLV3000Reader.");
            }
            if (version == CTabVersion.UNSPECIFIED) {
                this.handleError("This file must be read with the MDLReader.");
            }
            int nAtoms = MDLV2000Reader.readMolfileInt(line, 0);
            int nBonds = MDLV2000Reader.readMolfileInt(line, 3);
            int chiral = MDLV2000Reader.readMolfileInt(line, 13);
            IAtom[] atoms = new IAtom[nAtoms];
            IBond[] bonds = new IBond[nBonds];
            int[] explicitValence = new int[nAtoms];
            boolean hasX = false;
            boolean hasY = false;
            boolean hasZ = false;
            for (i = 0; i < nAtoms; ++i) {
                IAtom atom;
                line = this.input.readLine();
                atoms[i] = atom = this.readAtomFast(line, molecule.getBuilder(), parities, ++linecount, isQuery);
                Point3d p = atom.getPoint3d();
                hasX = hasX || p.x != 0.0;
                hasY = hasY || p.y != 0.0;
                hasZ = hasZ || p.z != 0.0;
            }
            if (!(hasX || hasY || hasZ)) {
                if (nAtoms == 1) {
                    atoms[0].setPoint2d(new Point2d(0.0, 0.0));
                } else {
                    for (IAtom iAtom : atoms) {
                        iAtom.setPoint3d(null);
                    }
                }
            } else if (!hasZ) {
                if (this.is3Dfile(program)) {
                    hasZ = true;
                } else if (!this.forceReadAs3DCoords.isSet()) {
                    for (IAtom iAtom : atoms) {
                        Point3d p3d = iAtom.getPoint3d();
                        if (p3d == null) continue;
                        iAtom.setPoint2d(new Point2d(p3d.x, p3d.y));
                        iAtom.setPoint3d(null);
                    }
                }
            }
            for (i = 0; i < nBonds; ++i) {
                line = this.input.readLine();
                bonds[i] = this.readBondFast(line, molecule.getBuilder(), atoms, explicitValence, ++linecount, isQuery);
                isQuery = isQuery || bonds[i] instanceof IQueryBond || bonds[i].getOrder() == IBond.Order.UNSET && !bonds[i].isAromatic();
            }
            outputContainer = !isQuery ? molecule : new QueryAtomContainer(molecule.getBuilder());
            if (title != null) {
                outputContainer.setTitle(title);
            }
            if (remark != null) {
                outputContainer.setProperty((Object)"cdk:Remark", (Object)remark);
            }
            if (outputContainer.isEmpty()) {
                outputContainer.setAtoms(atoms);
                outputContainer.setBonds(bonds);
            } else {
                for (IAtom iAtom : atoms) {
                    outputContainer.addAtom(iAtom);
                }
                for (IAtom iAtom : bonds) {
                    outputContainer.addBond((IBond)iAtom);
                }
            }
            if (this.addStereoElements.isSet()) {
                block10: for (Map.Entry e : parities.entrySet()) {
                    ITetrahedralChirality.Stereo winding;
                    int parity = (Integer)e.getValue();
                    if (parity != 1 && parity != 2) continue;
                    int n = 0;
                    IAtom focus = (IAtom)e.getKey();
                    IAtom[] carriers = new IAtom[4];
                    int hidx = -1;
                    for (IAtom nbr : outputContainer.getConnectedAtomsList(focus)) {
                        if (n == 4) continue block10;
                        if (nbr.getAtomicNumber() == 1) {
                            if (hidx >= 0) continue block10;
                            hidx = n;
                        }
                        carriers[n++] = nbr;
                    }
                    if (n < 3 || n < 4 && hidx >= 0) continue;
                    if (n == 3) {
                        carriers[n++] = focus;
                    }
                    if (n != 4) continue;
                    ITetrahedralChirality.Stereo stereo = winding = parity == 1 ? ITetrahedralChirality.Stereo.CLOCKWISE : ITetrahedralChirality.Stereo.ANTI_CLOCKWISE;
                    if (hidx == 0 || hidx == 2) {
                        winding = winding.invert();
                    }
                    outputContainer.addStereoElement((IStereoElement)new TetrahedralChirality(focus, carriers, winding));
                }
            }
            this.readPropertiesFast(this.input, (IAtomContainer)outputContainer, nAtoms);
            MDLV2000Reader.readNonStructuralData(this.input, outputContainer);
            for (int i2 = offset = outputContainer.getAtomCount() - nAtoms; i2 < outputContainer.getAtomCount(); ++i2) {
                int valence = explicitValence[i2 - offset];
                if (valence < 0) {
                    isQuery = true;
                    continue;
                }
                int n = outputContainer.getConnectedSingleElectronsCount(outputContainer.getAtom(i2));
                this.applyMDLValenceModel(outputContainer.getAtom(i2), valence + n, n);
            }
            if (!(outputContainer instanceof IQueryAtomContainer) && !isQuery && this.addStereoElements.isSet() && hasX && hasY) {
                for (IAtom atom : outputContainer.atoms()) {
                    if (!(AtomRef.deref((IAtom)atom) instanceof QueryAtom)) continue;
                    isQuery = true;
                    break;
                }
                if (!isQuery) {
                    if (hasZ) {
                        outputContainer.setStereoElements(StereoElementFactory.using3DCoordinates((IAtomContainer)outputContainer).createAll());
                    } else if (!this.forceReadAs3DCoords.isSet()) {
                        outputContainer.setStereoElements(StereoElementFactory.using2DCoordinates((IAtomContainer)outputContainer).createAll());
                    }
                }
            }
            if (chiral == 0) {
                for (IStereoElement se : outputContainer.stereoElements()) {
                    if (se.getConfigClass() != 16896) continue;
                    se.setGroupInfo(327680);
                }
            }
        }
        catch (CDKException exception) {
            String error = "Error while parsing line " + linecount + ": " + line + " -> " + exception.getMessage();
            logger.error((Object)error);
            throw exception;
        }
        catch (IOException exception) {
            exception.printStackTrace();
            String error = "Error while parsing line " + linecount + ": " + line + " -> " + exception.getMessage();
            logger.error((Object)error);
            this.handleError("Error while parsing line: " + line, linecount, 0, 0, exception);
        }
        return outputContainer;
    }

    private boolean is3Dfile(String program) {
        return program.length() >= 22 && program.substring(20, 22).equals("3D");
    }

    private void applyMDLValenceModel(IAtom atom, int explicitValence, int unpaired) {
        if (atom.getValency() != null) {
            if (atom.getValency() >= explicitValence) {
                atom.setImplicitHydrogenCount(Integer.valueOf(atom.getValency() - (explicitValence - unpaired)));
            } else {
                atom.setImplicitHydrogenCount(Integer.valueOf(0));
            }
        } else {
            int implicitValence;
            Integer charge;
            Integer element = atom.getAtomicNumber();
            if (element == null) {
                element = 0;
            }
            if ((charge = atom.getFormalCharge()) == null) {
                charge = 0;
            }
            if ((implicitValence = MDLValence.implicitValence(element, charge, explicitValence)) < explicitValence) {
                atom.setValency(Integer.valueOf(explicitValence));
                atom.setImplicitHydrogenCount(Integer.valueOf(0));
            } else {
                atom.setValency(Integer.valueOf(implicitValence));
                atom.setImplicitHydrogenCount(Integer.valueOf(implicitValence - explicitValence));
            }
        }
    }

    private void fixHydrogenIsotopes(IAtomContainer molecule, IsotopeFactory isotopeFactory) {
        for (IAtom atom : AtomContainerManipulator.getAtomArray((IAtomContainer)molecule)) {
            IAtom newAtom;
            if (!(atom instanceof IPseudoAtom)) continue;
            IPseudoAtom pseudo = (IPseudoAtom)atom;
            if ("D".equals(pseudo.getLabel())) {
                newAtom = (IAtom)molecule.getBuilder().newInstance(IAtom.class, new Object[]{atom});
                newAtom.setSymbol("H");
                newAtom.setAtomicNumber(Integer.valueOf(1));
                isotopeFactory.configure(newAtom, isotopeFactory.getIsotope("H", 2));
                AtomContainerManipulator.replaceAtomByAtom((IAtomContainer)molecule, (IAtom)atom, (IAtom)newAtom);
                continue;
            }
            if (!"T".equals(pseudo.getLabel())) continue;
            newAtom = (IAtom)molecule.getBuilder().newInstance(IAtom.class, new Object[]{atom});
            newAtom.setSymbol("H");
            newAtom.setAtomicNumber(Integer.valueOf(1));
            isotopeFactory.configure(newAtom, isotopeFactory.getIsotope("H", 3));
            AtomContainerManipulator.replaceAtomByAtom((IAtomContainer)molecule, (IAtom)atom, (IAtom)newAtom);
        }
    }

    public void close() throws IOException {
        this.input.close();
    }

    private void initIOSettings() {
        this.forceReadAs3DCoords = (BooleanIOSetting)this.addSetting((IOSetting)new BooleanIOSetting("ForceReadAs3DCoordinates", IOSetting.Importance.LOW, "Should coordinates always be read as 3D?", "false"));
        this.interpretHydrogenIsotopes = (BooleanIOSetting)this.addSetting((IOSetting)new BooleanIOSetting("InterpretHydrogenIsotopes", IOSetting.Importance.LOW, "Should D and T be interpreted as hydrogen isotopes?", "true"));
        this.addStereoElements = (BooleanIOSetting)this.addSetting((IOSetting)new BooleanIOSetting("AddStereoElements", IOSetting.Importance.LOW, "Detect and create IStereoElements for the input.", "true"));
    }

    public void customizeJob() {
        for (IOSetting setting : this.getSettings()) {
            this.fireIOSettingQuestion(setting);
        }
    }

    private String removeNonDigits(String input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char inputChar = input.charAt(i);
            if (!Character.isDigit(inputChar)) continue;
            sb.append(inputChar);
        }
        return sb.toString();
    }

    IAtom readAtomFast(String line, IChemObjectBuilder builder, int lineNum) throws CDKException, IOException {
        return this.readAtomFast(line, builder, Collections.emptyMap(), lineNum, false);
    }

    IAtom readAtomFast(String line, IChemObjectBuilder builder, Map<IAtom, Integer> parities, int lineNum, boolean isQuery) throws CDKException, IOException {
        String symbol;
        double z;
        double y;
        double x;
        int massDiff = 0;
        int charge = 0;
        int parity = 0;
        int valence = 0;
        int mapping = 0;
        int hcount = 0;
        int length = MDLV2000Reader.length(line);
        if (length > 69) {
            length = 69;
        }
        switch (length) {
            case 63: 
            case 66: 
            case 69: {
                mapping = MDLV2000Reader.readMolfileInt(line, 60);
            }
            case 51: 
            case 54: 
            case 57: 
            case 60: {
                valence = MDLV2000Reader.readMolfileInt(line, 48);
            }
            case 45: 
            case 48: {
                hcount = MDLV2000Reader.readMolfileInt(line, 42);
            }
            case 42: {
                parity = MDLV2000Reader.toInt(line.charAt(41));
            }
            case 39: {
                charge = MDLV2000Reader.toCharge(line.charAt(38));
            }
            case 36: {
                massDiff = MDLV2000Reader.sign(line.charAt(34)) * MDLV2000Reader.toInt(line.charAt(35));
            }
            case 32: 
            case 33: 
            case 34: {
                x = this.readMDLCoordinate(line, 0);
                y = this.readMDLCoordinate(line, 10);
                z = this.readMDLCoordinate(line, 20);
                symbol = line.substring(31, 34).trim().intern();
                break;
            }
            default: {
                this.handleError("invalid line length", lineNum, 0, 0);
                throw new CDKException("invalid line length, " + length + ": " + line);
            }
        }
        IAtom atom = this.createAtom(symbol, builder, lineNum);
        if (isQuery) {
            Expr expr = new Expr(Expr.Type.ELEMENT, atom.getAtomicNumber().intValue());
            if (hcount != 0) {
                if (hcount < 0) {
                    hcount = 0;
                }
                expr.and(new Expr(Expr.Type.IMPL_H_COUNT, hcount));
            }
            atom = new QueryAtom(builder);
            ((QueryAtom)atom).setExpression(expr);
        }
        atom.setPoint3d(new Point3d(x, y, z));
        atom.setFormalCharge(Integer.valueOf(charge));
        atom.setStereoParity(Integer.valueOf(parity));
        if (parity != 0) {
            parities.put(atom, parity);
        }
        if (massDiff != 0 && atom.getAtomicNumber() > 0) {
            IIsotope majorIsotope = Isotopes.getInstance().getMajorIsotope(atom.getAtomicNumber().intValue());
            if (majorIsotope == null) {
                atom.setMassNumber(Integer.valueOf(-1));
            } else {
                atom.setMassNumber(Integer.valueOf(majorIsotope.getMassNumber() + massDiff));
            }
        }
        if (valence > 0 && valence < 16) {
            atom.setValency(Integer.valueOf(valence == 15 ? 0 : valence));
        }
        if (mapping != 0) {
            atom.setProperty((Object)"cdk:AtomAtomMapping", (Object)mapping);
        }
        return atom;
    }

    IBond readBondFast(String line, IChemObjectBuilder builder, IAtom[] atoms, int[] explicitValence, int lineNum) throws CDKException {
        return this.readBondFast(line, builder, atoms, explicitValence, lineNum, false);
    }

    IBond readBondFast(String line, IChemObjectBuilder builder, IAtom[] atoms, int[] explicitValence, int lineNum, boolean isQuery) throws CDKException {
        int type;
        int v;
        int u;
        int length = MDLV2000Reader.length(line);
        if (length > 21) {
            length = 21;
        }
        int stereo = 0;
        switch (length) {
            case 12: 
            case 15: 
            case 18: 
            case 21: {
                stereo = MDLV2000Reader.readUInt(line, 9, 3);
            }
            case 9: {
                u = MDLV2000Reader.readMolfileInt(line, 0) - 1;
                v = MDLV2000Reader.readMolfileInt(line, 3) - 1;
                type = MDLV2000Reader.readMolfileInt(line, 6);
                break;
            }
            default: {
                throw new CDKException("invalid line length: " + length + " " + line);
            }
        }
        IBond bond = builder.newBond();
        bond.setAtoms(new IAtom[]{atoms[u], atoms[v]});
        switch (type) {
            case 1: {
                bond.setOrder(IBond.Order.SINGLE);
                bond.setStereo(this.toStereo(stereo, type));
                break;
            }
            case 2: {
                bond.setOrder(IBond.Order.DOUBLE);
                bond.setStereo(this.toStereo(stereo, type));
                break;
            }
            case 3: {
                bond.setOrder(IBond.Order.TRIPLE);
                break;
            }
            case 4: {
                bond.setOrder(IBond.Order.UNSET);
                bond.setFlag(32, true);
                bond.setFlag(4096, true);
                atoms[u].setFlag(32, true);
                atoms[v].setFlag(32, true);
                break;
            }
            case 5: {
                bond = new QueryBond(bond.getBegin(), bond.getEnd(), Expr.Type.SINGLE_OR_DOUBLE);
                break;
            }
            case 6: {
                bond = new QueryBond(bond.getBegin(), bond.getEnd(), Expr.Type.SINGLE_OR_AROMATIC);
                break;
            }
            case 7: {
                bond = new QueryBond(bond.getBegin(), bond.getEnd(), Expr.Type.DOUBLE_OR_AROMATIC);
                break;
            }
            case 8: {
                bond = new QueryBond(bond.getBegin(), bond.getEnd(), Expr.Type.TRUE);
                break;
            }
            default: {
                throw new CDKException("unrecognised bond type: " + type + ", " + line);
            }
        }
        if (type < 4) {
            int n = u;
            explicitValence[n] = explicitValence[n] + type;
            int n2 = v;
            explicitValence[n2] = explicitValence[n2] + type;
        } else {
            explicitValence[v] = Integer.MIN_VALUE;
            explicitValence[u] = Integer.MIN_VALUE;
        }
        if (isQuery && bond.getClass() != QueryBond.class) {
            IBond.Order order = bond.getOrder();
            Expr expr = null;
            expr = bond.isAromatic() ? new Expr(Expr.Type.IS_AROMATIC) : new Expr(Expr.Type.ORDER, bond.getOrder().numeric().intValue());
            bond = new QueryBond(atoms[u], atoms[v], expr);
        }
        return bond;
    }

    /*
     * Enabled aggressive block sorting
     */
    void readPropertiesFast(BufferedReader input, IAtomContainer container, int nAtoms) throws IOException, CDKException {
        String line;
        int offset = container.getAtomCount() - nAtoms;
        LinkedHashMap<Integer, Sgroup> sgroups = new LinkedHashMap<Integer, Sgroup>();
        block28: while ((line = input.readLine()) != null) {
            int length = line.length();
            PropertyKey key = PropertyKey.of(line);
            switch (key) {
                case ATOM_ALIAS: {
                    int index = MDLV2000Reader.readMolfileInt(line, 3) - 1;
                    String label = input.readLine();
                    if (label == null) {
                        return;
                    }
                    MDLV2000Reader.label(container, offset + index, label);
                    break;
                }
                case ATOM_VALUE: {
                    int index = MDLV2000Reader.readMolfileInt(line, 3) - 1;
                    String comment = line.substring(7);
                    container.getAtom(offset + index).setProperty((Object)"cdk:Comment", (Object)comment);
                    break;
                }
                case GROUP_ABBREVIATION: {
                    String group = input.readLine();
                    if (group != null) break;
                    return;
                }
                case LEGACY_ATOM_LIST: {
                    IAtom atom;
                    int index = MDLV2000Reader.readUInt(line, 0, 3) - 1;
                    boolean negate = line.charAt(3) == 'T' || line.charAt(4) == 'T';
                    Expr expr = new Expr(Expr.Type.TRUE);
                    StringBuilder sb = new StringBuilder();
                    for (int i = 11; i < line.length(); i += 4) {
                        int atomicNumber = MDLV2000Reader.readUInt(line, i, 3);
                        expr.or(new Expr(Expr.Type.ELEMENT, atomicNumber));
                    }
                    if (negate) {
                        expr.negate();
                    }
                    if (AtomRef.deref((IAtom)(atom = container.getAtom(index))) instanceof QueryAtom) {
                        QueryAtom ref = (QueryAtom)AtomRef.deref((IAtom)atom);
                        ref.setExpression(expr);
                        break;
                    }
                    QueryAtom queryAtom = new QueryAtom(expr);
                    queryAtom.setPoint2d(atom.getPoint2d());
                    queryAtom.setPoint3d(atom.getPoint3d());
                    container.setAtom(index, (IAtom)queryAtom);
                    break;
                }
                case M_ALS: {
                    IAtom atom;
                    int elem;
                    int index = MDLV2000Reader.readUInt(line, 7, 3) - 1;
                    boolean negate = line.charAt(13) == 'T' || line.charAt(14) == 'T';
                    Expr expr = new Expr(Expr.Type.TRUE);
                    StringBuilder sb = new StringBuilder();
                    for (int i = 16; i < line.length(); ++i) {
                        if (line.charAt(i) != ' ') {
                            sb.append(line.charAt(i));
                            continue;
                        }
                        if (sb.length() == 0) continue;
                        int elem2 = Elements.ofString((String)sb.toString()).number();
                        if (elem2 != 0) {
                            expr.or(new Expr(Expr.Type.ELEMENT, elem2));
                        }
                        sb.setLength(0);
                    }
                    if (sb.length() != 0 && (elem = Elements.ofString((String)sb.toString()).number()) != 0) {
                        expr.or(new Expr(Expr.Type.ELEMENT, elem));
                    }
                    if (negate) {
                        expr.negate();
                    }
                    if (AtomRef.deref((IAtom)(atom = container.getAtom(index))) instanceof QueryAtom) {
                        QueryAtom ref = (QueryAtom)AtomRef.deref((IAtom)atom);
                        ref.setExpression(expr);
                        break;
                    }
                    QueryAtom queryAtom = new QueryAtom(expr);
                    queryAtom.setPoint2d(atom.getPoint2d());
                    queryAtom.setPoint3d(atom.getPoint3d());
                    container.setAtom(index, (IAtom)queryAtom);
                    break;
                }
                case M_CHG: {
                    int index;
                    int count = MDLV2000Reader.readUInt(line, 6, 3);
                    int st = 10;
                    for (int i = 0; i < count && st + 7 <= length; ++i, st += 8) {
                        index = MDLV2000Reader.readMolfileInt(line, st) - 1;
                        int charge = MDLV2000Reader.readMolfileInt(line, st + 4);
                        container.getAtom(offset + index).setFormalCharge(Integer.valueOf(charge));
                    }
                    break;
                }
                case M_ISO: {
                    int index;
                    int count = MDLV2000Reader.readUInt(line, 6, 3);
                    int st = 10;
                    for (int i = 0; i < count && st + 7 <= length; ++i, st += 8) {
                        index = MDLV2000Reader.readMolfileInt(line, st) - 1;
                        int mass = MDLV2000Reader.readMolfileInt(line, st + 4);
                        if (mass < 0) {
                            this.handleError("Absolute mass number should be >= 0, " + line);
                            continue;
                        }
                        container.getAtom(offset + index).setMassNumber(Integer.valueOf(mass));
                    }
                    break;
                }
                case M_RAD: {
                    int index;
                    int count = MDLV2000Reader.readUInt(line, 6, 3);
                    int st = 10;
                    for (int i = 0; i < count && st + 7 <= length; ++i, st += 8) {
                        index = MDLV2000Reader.readMolfileInt(line, st) - 1;
                        int value = MDLV2000Reader.readMolfileInt(line, st + 4);
                        MDLV2000Writer.SPIN_MULTIPLICITY multiplicity = MDLV2000Writer.SPIN_MULTIPLICITY.ofValue(value);
                        container.getAtom(offset + index).setProperty((Object)"cdk:SpinMultiplicity", (Object)multiplicity);
                        for (int e = 0; e < multiplicity.getSingleElectrons(); ++e) {
                            container.addSingleElectron(offset + index);
                        }
                    }
                    break;
                }
                case M_RGP: {
                    int index;
                    int count = MDLV2000Reader.readUInt(line, 6, 3);
                    int st = 10;
                    for (int i = 0; i < count && st + 7 <= length; ++i, st += 8) {
                        index = MDLV2000Reader.readMolfileInt(line, st) - 1;
                        int number = MDLV2000Reader.readMolfileInt(line, st + 4);
                        MDLV2000Reader.label(container, offset + index, "R" + number);
                    }
                    break;
                }
                case M_ZZC: {
                    if (this.mode == IChemObjectReader.Mode.STRICT) {
                        throw new CDKException("Atom property ZZC is illegal in STRICT mode");
                    }
                    int index = MDLV2000Reader.readMolfileInt(line, 7) - 1;
                    String atomLabel = line.substring(11);
                    container.getAtom(offset + index).setProperty((Object)"cdk:ACDLabsAtomLabel", (Object)atomLabel);
                    break;
                }
                case M_STY: {
                    Sgroup sgroup;
                    int index;
                    int count = MDLV2000Reader.readMolfileInt(line, 6);
                    for (int i = 0; i < count; ++i) {
                        int lnOffset = 10 + i * 8;
                        index = MDLV2000Reader.readMolfileInt(line, lnOffset);
                        if (this.mode == IChemObjectReader.Mode.STRICT && sgroups.containsKey(index)) {
                            this.handleError("STY line must appear before any other line that supplies Sgroup information");
                        }
                        sgroup = new Sgroup();
                        sgroups.put(index, sgroup);
                        SgroupType type = SgroupType.parseCtabKey((String)line.substring(lnOffset + 4, lnOffset + 7));
                        if (type == null) continue;
                        sgroup.setType(type);
                    }
                    break;
                }
                case M_SST: {
                    Sgroup sgroup;
                    int count = MDLV2000Reader.readMolfileInt(line, 6);
                    int st = 10;
                    for (int i = 0; i < count && st + 7 <= length; ++i, st += 8) {
                        sgroup = this.ensureSgroup(sgroups, MDLV2000Reader.readMolfileInt(line, st));
                        if (this.mode == IChemObjectReader.Mode.STRICT && sgroup.getType() != SgroupType.CtabCopolymer) {
                            this.handleError("SST (Sgroup Subtype) specified for a non co-polymer group");
                        }
                        String sst = line.substring(st + 4, st + 7);
                        if (!(this.mode != IChemObjectReader.Mode.STRICT || "ALT".equals(sst) || "RAN".equals(sst) || "BLO".equals(sst))) {
                            this.handleError("Invalid sgroup subtype: " + sst + " expected (ALT, RAN, or BLO)");
                        }
                        sgroup.putValue(SgroupKey.CtabSubType, (Object)sst);
                    }
                    break;
                }
                case M_SAL: {
                    int index;
                    Sgroup sgroup = this.ensureSgroup(sgroups, MDLV2000Reader.readMolfileInt(line, 7));
                    int count = MDLV2000Reader.readMolfileInt(line, 10);
                    int st = 14;
                    for (int i = 0; i < count && st + 3 <= length; ++i, st += 4) {
                        index = MDLV2000Reader.readMolfileInt(line, st) - 1;
                        sgroup.addAtom(container.getAtom(offset + index));
                    }
                    break;
                }
                case M_SBL: {
                    int index;
                    Sgroup sgroup = this.ensureSgroup(sgroups, MDLV2000Reader.readMolfileInt(line, 7));
                    int count = MDLV2000Reader.readMolfileInt(line, 10);
                    int st = 14;
                    for (int i = 0; i < count && st + 3 <= length; ++i, st += 4) {
                        index = MDLV2000Reader.readMolfileInt(line, st) - 1;
                        sgroup.addBond(container.getBond(offset + index));
                    }
                    break;
                }
                case M_SPL: {
                    Sgroup sgroup;
                    int count = MDLV2000Reader.readMolfileInt(line, 6);
                    int st = 10;
                    for (int i = 0; i < count && st + 6 <= length; ++i, st += 8) {
                        sgroup = this.ensureSgroup(sgroups, MDLV2000Reader.readMolfileInt(line, st));
                        sgroup.addParent(this.ensureSgroup(sgroups, MDLV2000Reader.readMolfileInt(line, st + 4)));
                    }
                    break;
                }
                case M_SCN: {
                    Sgroup sgroup;
                    int count = MDLV2000Reader.readMolfileInt(line, 6);
                    int st = 10;
                    for (int i = 0; i < count && st + 6 <= length; ++i, st += 8) {
                        sgroup = this.ensureSgroup(sgroups, MDLV2000Reader.readMolfileInt(line, st));
                        String con = line.substring(st + 4, Math.min(length, st + 7)).trim();
                        if (!(this.mode != IChemObjectReader.Mode.STRICT || "HH".equals(con) || "HT".equals(con) || "EU".equals(con))) {
                            this.handleError("Unknown SCN type (expected: HH, HT, or EU) was " + con);
                        }
                        sgroup.putValue(SgroupKey.CtabConnectivity, (Object)con);
                    }
                    break;
                }
                case M_SDI: {
                    Sgroup sgroup = this.ensureSgroup(sgroups, MDLV2000Reader.readMolfileInt(line, 7));
                    int count = MDLV2000Reader.readMolfileInt(line, 10);
                    assert (count == 4);
                    sgroup.addBracket(new SgroupBracket(this.readMDLCoordinate(line, 13), this.readMDLCoordinate(line, 23), this.readMDLCoordinate(line, 33), this.readMDLCoordinate(line, 43)));
                    break;
                }
                case M_SMT: {
                    Sgroup sgroup = this.ensureSgroup(sgroups, MDLV2000Reader.readMolfileInt(line, 7));
                    sgroup.putValue(SgroupKey.CtabSubScript, (Object)line.substring(11).trim());
                    break;
                }
                case M_SBT: {
                    Sgroup sgroup;
                    int count = MDLV2000Reader.readMolfileInt(line, 6);
                    int st = 10;
                    for (int i = 0; i < count && st + 7 <= length; ++i, st += 8) {
                        sgroup = this.ensureSgroup(sgroups, MDLV2000Reader.readMolfileInt(line, st));
                        sgroup.putValue(SgroupKey.CtabBracketStyle, (Object)MDLV2000Reader.readMolfileInt(line, st + 4));
                    }
                    break;
                }
                case M_SDS: {
                    Sgroup sgroup;
                    int count;
                    if ("EXP".equals(line.substring(7, 10))) {
                        count = MDLV2000Reader.readMolfileInt(line, 10);
                        int st = 14;
                        for (int i = 0; i < count && st + 3 <= length; ++i, st += 4) {
                            sgroup = this.ensureSgroup(sgroups, MDLV2000Reader.readMolfileInt(line, st));
                            sgroup.putValue(SgroupKey.CtabExpansion, (Object)true);
                        }
                        break;
                    } else {
                        if (this.mode != IChemObjectReader.Mode.STRICT) break;
                        this.handleError("Expected EXP to follow SDS tag");
                        break;
                    }
                }
                case M_SPA: {
                    int index;
                    Sgroup sgroup = this.ensureSgroup(sgroups, MDLV2000Reader.readMolfileInt(line, 7));
                    int count = MDLV2000Reader.readMolfileInt(line, 10);
                    HashSet<IAtom> parentAtomList = (HashSet<IAtom>)sgroup.getValue(SgroupKey.CtabParentAtomList);
                    if (parentAtomList == null) {
                        parentAtomList = new HashSet<IAtom>();
                        sgroup.putValue(SgroupKey.CtabParentAtomList, parentAtomList);
                    }
                    int st = 14;
                    for (int i = 0; i < count && st + 3 <= length; ++i, st += 4) {
                        index = MDLV2000Reader.readMolfileInt(line, st) - 1;
                        parentAtomList.add(container.getAtom(offset + index));
                    }
                    break;
                }
                case M_SNC: {
                    Sgroup sgroup;
                    int count = MDLV2000Reader.readMolfileInt(line, 6);
                    int st = 10;
                    for (int i = 0; i < count && st + 7 <= length; ++i, st += 8) {
                        sgroup = this.ensureSgroup(sgroups, MDLV2000Reader.readMolfileInt(line, st));
                        sgroup.putValue(SgroupKey.CtabComponentNumber, (Object)MDLV2000Reader.readMolfileInt(line, st + 4));
                    }
                    break;
                }
                case M_SDT: {
                    String units;
                    Sgroup sgroup = this.ensureSgroup(sgroups, MDLV2000Reader.readMolfileInt(line, 7));
                    if (length < 11) break;
                    String name = line.substring(11, Math.min(41, length)).trim();
                    sgroup.putValue(SgroupKey.DataFieldName, (Object)name);
                    if (length < 41) break;
                    String fmt = line.substring(41, Math.min(43, length)).trim();
                    if (fmt.length() == 1 && fmt.charAt(0) != 'F' && fmt.charAt(0) != 'N' && fmt.charAt(0) != 'T') {
                        this.handleError("Invalid Data Sgroup field format: " + fmt);
                    }
                    if (!fmt.isEmpty()) {
                        sgroup.putValue(SgroupKey.DataFieldFormat, (Object)fmt);
                    }
                    if (length < 43 || (units = line.substring(43, Math.min(63, length)).trim()).isEmpty()) break;
                    sgroup.putValue(SgroupKey.DataFieldUnits, (Object)units);
                    break;
                }
                case M_SDD: {
                    break;
                }
                case M_SCD: 
                case M_SED: {
                    Sgroup sgroup = this.ensureSgroup(sgroups, MDLV2000Reader.readMolfileInt(line, 7));
                    String data = line.substring(11, Math.min(79, length));
                    String curr = (String)sgroup.getValue(SgroupKey.Data);
                    if (curr != null) {
                        data = curr + data;
                    }
                    sgroup.putValue(SgroupKey.Data, (Object)data);
                    break;
                }
                case M_END: {
                    break block28;
                }
            }
        }
        for (IAtom atom : container.atoms()) {
            if (atom.getMassNumber() == null || atom.getMassNumber() >= 0) continue;
            this.handleError("Unstable use of mass delta on " + atom.getSymbol() + " please use M  ISO");
            atom.setMassNumber(null);
        }
        if (!sgroups.isEmpty()) {
            int i;
            ArrayList sgroupOrgList = new ArrayList(sgroups.values());
            ArrayList<Sgroup> sgroupCpyList = new ArrayList<Sgroup>(sgroupOrgList.size());
            for (i = 0; i < sgroupOrgList.size(); ++i) {
                Sgroup cpy = (Sgroup)((Sgroup)sgroupOrgList.get(i)).downcast();
                sgroupCpyList.add(cpy);
            }
            for (i = 0; i < sgroupOrgList.size(); ++i) {
                Sgroup newSgroup = (Sgroup)sgroupCpyList.get(i);
                HashSet oldParents = new HashSet(newSgroup.getParents());
                newSgroup.removeParents(oldParents);
                for (Sgroup parent : oldParents) {
                    newSgroup.addParent((Sgroup)sgroupCpyList.get(sgroupOrgList.indexOf(parent)));
                }
            }
            container.setProperty((Object)"cdk:CtabSgroups", sgroupCpyList);
        }
    }

    private Sgroup ensureSgroup(Map<Integer, Sgroup> map, int idx) throws CDKException {
        Sgroup sgroup = map.get(idx);
        if (sgroup == null) {
            if (this.mode == IChemObjectReader.Mode.STRICT) {
                this.handleError("Sgroups must first be defined by a STY property");
            }
            sgroup = new Sgroup();
            map.put(idx, sgroup);
        }
        return sgroup;
    }

    private IBond.Stereo toStereo(int stereo, int type) throws CDKException {
        switch (stereo) {
            case 0: {
                return type == 2 ? IBond.Stereo.E_Z_BY_COORDINATES : IBond.Stereo.NONE;
            }
            case 1: {
                if (this.mode == IChemObjectReader.Mode.STRICT && type == 2) {
                    throw new CDKException("stereo flag was 'up' but bond order was 2");
                }
                return IBond.Stereo.UP;
            }
            case 3: {
                if (this.mode == IChemObjectReader.Mode.STRICT && type == 1) {
                    throw new CDKException("stereo flag was 'cis/trans' but bond order was 1");
                }
                return IBond.Stereo.E_OR_Z;
            }
            case 4: {
                if (this.mode == IChemObjectReader.Mode.STRICT && type == 2) {
                    throw new CDKException("stereo flag was 'up/down' but bond order was 2");
                }
                return IBond.Stereo.UP_OR_DOWN;
            }
            case 6: {
                if (this.mode == IChemObjectReader.Mode.STRICT && type == 2) {
                    throw new CDKException("stereo flag was 'down' but bond order was 2");
                }
                return IBond.Stereo.DOWN;
            }
        }
        if (this.mode == IChemObjectReader.Mode.STRICT) {
            throw new CDKException("unknown bond stereo type: " + stereo);
        }
        return IBond.Stereo.NONE;
    }

    static int length(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
        }
        return i + 1;
    }

    private IAtom createAtom(String symbol, IChemObjectBuilder builder, int lineNum) throws CDKException {
        Elements elem = Elements.ofString((String)symbol);
        if (elem != Elements.Unknown) {
            IAtom atom = builder.newAtom();
            atom.setSymbol(elem.symbol());
            atom.setAtomicNumber(Integer.valueOf(elem.number()));
            return atom;
        }
        if (symbol.equals("D") && this.interpretHydrogenIsotopes.isSet()) {
            this.handleError("invalid symbol: " + symbol, lineNum, 31, 33);
            IAtom atom = (IAtom)builder.newInstance(IAtom.class, new Object[]{"H"});
            atom.setMassNumber(Integer.valueOf(2));
            return atom;
        }
        if (symbol.equals("T") && this.interpretHydrogenIsotopes.isSet()) {
            this.handleError("invalid symbol: " + symbol, lineNum, 31, 33);
            IAtom atom = (IAtom)builder.newInstance(IAtom.class, new Object[]{"H"});
            atom.setMassNumber(Integer.valueOf(3));
            return atom;
        }
        if (!MDLV2000Reader.isPseudoElement(symbol)) {
            this.handleError("invalid symbol: " + symbol, lineNum, 31, 34);
            if (this.mode == IChemObjectReader.Mode.STRICT) {
                throw new CDKException("invalid symbol: " + symbol);
            }
        }
        if (symbol.equals("R#")) {
            symbol = "R";
        }
        IAtom atom = (IAtom)builder.newInstance(IPseudoAtom.class, new Object[]{symbol});
        atom.setSymbol(symbol);
        atom.setAtomicNumber(Integer.valueOf(0));
        return atom;
    }

    static boolean isPseudoElement(String symbol) {
        return PSEUDO_LABELS.contains(symbol);
    }

    double readMDLCoordinate(String line, int offset) throws CDKException {
        if (line.charAt(offset + 5) != '.') {
            int end;
            int start;
            this.handleError("Bad coordinate format specified, expected 4 decimal places: " + line.substring(offset));
            for (start = offset; line.charAt(start) == ' ' && start < offset + 9; ++start) {
            }
            int dot = -1;
            char c = line.charAt(end);
            for (end = start; c != ' ' && end < offset + 9; ++end) {
                if (c == '.') {
                    dot = end;
                }
                c = line.charAt(end);
            }
            if (start == end) {
                return 0.0;
            }
            if (dot != -1) {
                int sign = MDLV2000Reader.sign(line.charAt(start));
                if (sign < 0) {
                    ++start;
                }
                int integral = MDLV2000Reader.readUInt(line, start, dot - start - 1);
                int fraction = MDLV2000Reader.readUInt(line, dot, end - dot);
                return (double)((long)sign * ((long)integral * 10000L + (long)fraction)) / 10000.0;
            }
            return Double.parseDouble(line.substring(start, end));
        }
        int start = offset;
        while (line.charAt(start) == ' ') {
            ++start;
        }
        int sign = MDLV2000Reader.sign(line.charAt(start));
        if (sign < 0) {
            ++start;
        }
        int integral = MDLV2000Reader.readUInt(line, start, offset + 5 - start);
        int fraction = MDLV2000Reader.readUInt(line, offset + 6, 4);
        return (double)((long)sign * ((long)integral * 10000L + (long)fraction)) / 10000.0;
    }

    private static int toCharge(char c) {
        switch (c) {
            case '1': {
                return 3;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 1;
            }
            case '4': {
                return 0;
            }
            case '5': {
                return -1;
            }
            case '6': {
                return -2;
            }
            case '7': {
                return -3;
            }
        }
        return 0;
    }

    private static int sign(char c) {
        return c == '-' ? -1 : 1;
    }

    private static int toInt(char c) {
        return c >= '0' && c <= '9' ? c - 48 : 0;
    }

    private static int readUInt(String line, int index, int digits) {
        int result = 0;
        while (digits-- > 0) {
            result = result * 10 + MDLV2000Reader.toInt(line.charAt(index++));
        }
        return result;
    }

    private static int readMolfileInt(String line, int index) {
        int sign = 1;
        int result = 0;
        char c = line.charAt(index);
        switch (c) {
            case ' ': {
                break;
            }
            case '-': {
                sign = -1;
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                result = c - 48;
                break;
            }
            default: {
                return 0;
            }
        }
        if (index + 1 == line.length()) {
            return sign * result;
        }
        c = line.charAt(index + 1);
        switch (c) {
            case ' ': {
                if (result <= 0) break;
                return sign * result;
            }
            case '-': {
                if (result > 0) {
                    return sign * result;
                }
                sign = -1;
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                result = result * 10 + (c - 48);
                break;
            }
            default: {
                return sign * result;
            }
        }
        if (index + 2 == line.length()) {
            return sign * result;
        }
        c = line.charAt(index + 2);
        switch (c) {
            case ' ': {
                if (result <= 0) break;
                return sign * result;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                result = result * 10 + (c - 48);
                break;
            }
            default: {
                return sign * result;
            }
        }
        return sign * result;
    }

    static void label(IAtomContainer container, int index, String label) {
        IPseudoAtom pseudoAtom;
        IAtom atom = container.getAtom(index);
        IPseudoAtom iPseudoAtom = pseudoAtom = atom instanceof IPseudoAtom ? (IPseudoAtom)atom : (IPseudoAtom)container.getBuilder().newInstance(IPseudoAtom.class, new Object[0]);
        if (atom.equals(pseudoAtom)) {
            pseudoAtom.setLabel(label);
        } else {
            pseudoAtom.setSymbol(label);
            pseudoAtom.setAtomicNumber(atom.getAtomicNumber());
            pseudoAtom.setPoint2d(atom.getPoint2d());
            pseudoAtom.setPoint3d(atom.getPoint3d());
            pseudoAtom.setMassNumber(atom.getMassNumber());
            pseudoAtom.setFormalCharge(atom.getFormalCharge());
            pseudoAtom.setValency(atom.getValency());
            pseudoAtom.setLabel(label);
            AtomContainerManipulator.replaceAtomByAtom((IAtomContainer)container, (IAtom)atom, (IAtom)pseudoAtom);
        }
    }

    private IAtom readAtomSlow(String line, IChemObjectBuilder builder, int linecount) throws CDKException, IOException {
        IAtom atom;
        block56: {
            Matcher trailingSpaceMatcher = TRAILING_SPACE.matcher(line);
            if (trailingSpaceMatcher.find()) {
                this.handleError("Trailing space found", linecount, trailingSpaceMatcher.start(), trailingSpaceMatcher.end());
                line = trailingSpaceMatcher.replaceAll("");
            }
            double x = Double.parseDouble(line.substring(0, 10).trim());
            double y = Double.parseDouble(line.substring(10, 20).trim());
            double z = Double.parseDouble(line.substring(20, 30).trim());
            String element = line.substring(31, Math.min(line.length(), 34)).trim();
            if (line.length() < 34) {
                this.handleError("Element atom type does not follow V2000 format type should of length three and padded with space if required", linecount, 31, 34);
            }
            logger.debug((Object)"Atom type: ", new Object[]{element});
            Isotopes isotopeFactory = Isotopes.getInstance();
            if (isotopeFactory.isElement(element)) {
                atom = isotopeFactory.configure((IAtom)builder.newInstance(IAtom.class, new Object[]{element}));
            } else if ("A".equals(element)) {
                atom = (IAtom)builder.newInstance(IPseudoAtom.class, new Object[]{element});
            } else if ("Q".equals(element)) {
                atom = (IAtom)builder.newInstance(IPseudoAtom.class, new Object[]{element});
            } else if ("*".equals(element)) {
                atom = (IAtom)builder.newInstance(IPseudoAtom.class, new Object[]{element});
            } else if ("LP".equals(element)) {
                atom = (IAtom)builder.newInstance(IPseudoAtom.class, new Object[]{element});
            } else if ("L".equals(element)) {
                atom = (IAtom)builder.newInstance(IPseudoAtom.class, new Object[]{element});
            } else if (element.equals("R") || element.length() > 0 && element.charAt(0) == 'R') {
                logger.debug((Object)"Atom ", new Object[]{element, " is not an regular element. Creating a PseudoAtom."});
                String[] rGroup = element.split("^R");
                if (rGroup.length > 1) {
                    try {
                        element = "R" + Integer.valueOf(rGroup[rGroup.length - 1]);
                        atom = (IAtom)builder.newInstance(IPseudoAtom.class, new Object[]{element});
                    }
                    catch (Exception ex) {
                        atom = (IAtom)builder.newInstance(IPseudoAtom.class, new Object[]{"R"});
                    }
                } else {
                    atom = (IAtom)builder.newInstance(IPseudoAtom.class, new Object[]{element});
                }
            } else {
                this.handleError("Invalid element type. Must be an existing element, or one in: A, Q, L, LP, *.", linecount, 32, 35);
                atom = (IAtom)builder.newInstance(IPseudoAtom.class, new Object[]{element});
                atom.setSymbol(element);
            }
            atom.setPoint3d(new Point3d(x, y, z));
            if (line.length() >= 36) {
                String massDiffString = line.substring(34, 36).trim();
                logger.debug((Object)"Mass difference: ", new Object[]{massDiffString});
                if (!(atom instanceof IPseudoAtom)) {
                    try {
                        int massDiff = Integer.parseInt(massDiffString);
                        if (massDiff != 0) {
                            IIsotope major = Isotopes.getInstance().getMajorIsotope(element);
                            atom.setMassNumber(Integer.valueOf(major.getMassNumber() + massDiff));
                        }
                    }
                    catch (IOException | NumberFormatException exception) {
                        this.handleError("Could not parse mass difference field.", linecount, 35, 37, exception);
                    }
                } else {
                    logger.error((Object)"Cannot set mass difference for a non-element!");
                }
            } else {
                this.handleError("Mass difference is missing", linecount, 34, 36);
            }
            Integer parity = line.length() > 41 ? Character.digit(line.charAt(41), 10) : 0;
            atom.setStereoParity(parity);
            if (line.length() >= 51) {
                String valenceString = this.removeNonDigits(line.substring(48, 51));
                logger.debug((Object)"Valence: ", new Object[]{valenceString});
                if (!(atom instanceof IPseudoAtom)) {
                    try {
                        int valence = Integer.parseInt(valenceString);
                        if (valence == 0) break block56;
                        if (valence == 15) {
                            atom.setValency(Integer.valueOf(0));
                            break block56;
                        }
                        atom.setValency(Integer.valueOf(valence));
                    }
                    catch (Exception exception) {
                        this.handleError("Could not parse valence information field", linecount, 49, 52, exception);
                    }
                } else {
                    logger.error((Object)"Cannot set valence information for a non-element!");
                }
            }
        }
        if (line.length() >= 39) {
            String chargeCodeString = line.substring(36, 39).trim();
            logger.debug((Object)"Atom charge code: ", new Object[]{chargeCodeString});
            int chargeCode = Integer.parseInt(chargeCodeString);
            if (chargeCode != 0) {
                if (chargeCode == 1) {
                    atom.setFormalCharge(Integer.valueOf(3));
                } else if (chargeCode == 2) {
                    atom.setFormalCharge(Integer.valueOf(2));
                } else if (chargeCode == 3) {
                    atom.setFormalCharge(Integer.valueOf(1));
                } else if (chargeCode != 4) {
                    if (chargeCode == 5) {
                        atom.setFormalCharge(Integer.valueOf(-1));
                    } else if (chargeCode == 6) {
                        atom.setFormalCharge(Integer.valueOf(-2));
                    } else if (chargeCode == 7) {
                        atom.setFormalCharge(Integer.valueOf(-3));
                    }
                }
            }
        } else {
            this.handleError("Atom charge is missing", linecount, 36, 39);
        }
        try {
            String reactionAtomIDString = line.substring(60, 63).trim();
            logger.debug((Object)"Parsing mapping id: ", new Object[]{reactionAtomIDString});
            try {
                int reactionAtomID = Integer.parseInt(reactionAtomIDString);
                if (reactionAtomID != 0) {
                    atom.setProperty((Object)"cdk:AtomAtomMapping", (Object)reactionAtomID);
                }
            }
            catch (Exception exception) {
                logger.error((Object)"Mapping number ", new Object[]{reactionAtomIDString, " is not an integer."});
                logger.debug((Object)exception);
            }
        }
        catch (Exception exception) {
            logger.warn((Object)"A few fields are missing. Older MDL MOL file?");
        }
        if (line.length() >= 78) {
            double shift = Double.parseDouble(line.substring(69, 80).trim());
            atom.setProperty((Object)"first shift", (Object)shift);
        }
        if (line.length() >= 87) {
            double shift = Double.parseDouble(line.substring(79, 87).trim());
            atom.setProperty((Object)"second shift", (Object)shift);
        }
        return atom;
    }

    private IBond readBondSlow(String line, IChemObjectBuilder builder, IAtom[] atoms, int[] explicitValence, int linecount) throws CDKException {
        QueryBond newBond;
        int atom1 = Integer.parseInt(line.substring(0, 3).trim());
        int atom2 = Integer.parseInt(line.substring(3, 6).trim());
        int order = Integer.parseInt(line.substring(6, 9).trim());
        IBond.Stereo stereo = null;
        if (line.length() >= 12) {
            int mdlStereo;
            int n = mdlStereo = line.length() > 12 ? Integer.parseInt(line.substring(9, 12).trim()) : Integer.parseInt(line.substring(9).trim());
            if (mdlStereo == 1) {
                stereo = IBond.Stereo.UP;
            } else if (mdlStereo == 6) {
                stereo = IBond.Stereo.DOWN;
            } else if (mdlStereo == 0) {
                stereo = order == 2 ? IBond.Stereo.E_Z_BY_COORDINATES : IBond.Stereo.NONE;
            } else if (mdlStereo == 3 && order == 2) {
                stereo = IBond.Stereo.E_OR_Z;
            } else if (mdlStereo == 4) {
                stereo = IBond.Stereo.UP_OR_DOWN;
            }
        } else {
            this.handleError("Missing expected stereo field at line: ", linecount, 10, 12);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bond: " + atom1 + " - " + atom2 + "; order " + order));
        }
        IAtom a1 = atoms[atom1 - 1];
        IAtom a2 = atoms[atom2 - 1];
        if (order >= 1 && order <= 3) {
            IBond.Order cdkOrder = IBond.Order.SINGLE;
            if (order == 2) {
                cdkOrder = IBond.Order.DOUBLE;
            }
            if (order == 3) {
                cdkOrder = IBond.Order.TRIPLE;
            }
            newBond = stereo != null ? (IBond)builder.newInstance(IBond.class, new Object[]{a1, a2, cdkOrder, stereo}) : (IBond)builder.newInstance(IBond.class, new Object[]{a1, a2, cdkOrder});
            int n = atom1 - 1;
            explicitValence[n] = explicitValence[n] + cdkOrder.numeric();
            int n2 = atom2 - 1;
            explicitValence[n2] = explicitValence[n2] + cdkOrder.numeric();
        } else if (order == 4) {
            newBond = stereo != null ? (IBond)builder.newInstance(IBond.class, new Object[]{a1, a2, IBond.Order.UNSET, stereo}) : (IBond)builder.newInstance(IBond.class, new Object[]{a1, a2, IBond.Order.UNSET});
            newBond.setFlag(4096, true);
            newBond.setFlag(32, true);
            a1.setFlag(32, true);
            a2.setFlag(32, true);
            explicitValence[atom2 - 1] = Integer.MIN_VALUE;
            explicitValence[atom1 - 1] = Integer.MIN_VALUE;
        } else {
            newBond = new QueryBond(builder);
            IAtom[] bondAtoms = new IAtom[]{a1, a2};
            newBond.setAtoms(bondAtoms);
            switch (order) {
                case 5: {
                    newBond.getExpression().setPrimitive(Expr.Type.SINGLE_OR_DOUBLE);
                    break;
                }
                case 6: {
                    newBond.getExpression().setPrimitive(Expr.Type.SINGLE_OR_AROMATIC);
                    break;
                }
                case 7: {
                    newBond.getExpression().setPrimitive(Expr.Type.DOUBLE_OR_AROMATIC);
                    break;
                }
                case 8: {
                    newBond.getExpression().setPrimitive(Expr.Type.TRUE);
                }
            }
            newBond.setStereo(stereo);
            explicitValence[atom2 - 1] = Integer.MIN_VALUE;
            explicitValence[atom1 - 1] = Integer.MIN_VALUE;
        }
        return newBond;
    }

    private void readPropertiesSlow(BufferedReader input, IAtomContainer container, int nAtoms, int linecount) throws IOException, CDKException {
        logger.info((Object)"Reading property block");
        while (true) {
            String line = input.readLine();
            ++linecount;
            if (line == null) {
                this.handleError("The expected property block is missing!", linecount, 0, 0);
            }
            if (line.startsWith("M  END")) break;
            boolean lineRead = false;
            if (line.startsWith("M  CHG")) {
                int infoCount = Integer.parseInt(line.substring(6, 9).trim());
                StringTokenizer st = new StringTokenizer(line.substring(9));
                for (int i = 1; i <= infoCount; ++i) {
                    String token = st.nextToken();
                    int atomNumber = Integer.parseInt(token.trim());
                    token = st.nextToken();
                    int charge = Integer.parseInt(token.trim());
                    container.getAtom(atomNumber - 1).setFormalCharge(Integer.valueOf(charge));
                }
            } else if (line.matches("A\\s{1,4}\\d+")) {
                int aliasAtomNumber = Integer.parseInt(line.replaceFirst("A\\s{1,4}", ""));
                String alias = input.readLine();
                ++linecount;
                IAtom aliasAtom = container.getAtom(aliasAtomNumber - 1);
                if (aliasAtom instanceof IPseudoAtom) {
                    ((IPseudoAtom)aliasAtom).setLabel(alias);
                    continue;
                }
                IAtom newPseudoAtom = (IAtom)container.getBuilder().newInstance(IPseudoAtom.class, new Object[]{alias});
                newPseudoAtom.setAtomicNumber(aliasAtom.getAtomicNumber());
                if (aliasAtom.getPoint2d() != null) {
                    newPseudoAtom.setPoint2d(aliasAtom.getPoint2d());
                }
                if (aliasAtom.getPoint3d() != null) {
                    newPseudoAtom.setPoint3d(aliasAtom.getPoint3d());
                }
                AtomContainerManipulator.replaceAtomByAtom((IAtomContainer)container, (IAtom)aliasAtom, (IAtom)newPseudoAtom);
            } else if (line.startsWith("M  ISO")) {
                try {
                    String countString = line.substring(6, 10).trim();
                    int infoCount = Integer.parseInt(countString);
                    StringTokenizer st = new StringTokenizer(line.substring(10));
                    for (int i = 1; i <= infoCount; ++i) {
                        int atomNumber = Integer.parseInt(st.nextToken().trim());
                        int absMass = Integer.parseInt(st.nextToken().trim());
                        if (absMass == 0) continue;
                        IAtom isotope = container.getAtom(atomNumber - 1);
                        isotope.setMassNumber(Integer.valueOf(absMass));
                    }
                }
                catch (NumberFormatException exception) {
                    String error = "Error (" + exception.getMessage() + ") while parsing line " + linecount + ": " + line + " in property block.";
                    logger.error((Object)error);
                    this.handleError("NumberFormatException in isotope information.", linecount, 7, 11, exception);
                }
            } else if (line.startsWith("M  RAD")) {
                try {
                    String countString = line.substring(6, 9).trim();
                    int infoCount = Integer.parseInt(countString);
                    StringTokenizer st = new StringTokenizer(line.substring(9));
                    for (int i = 1; i <= infoCount; ++i) {
                        int atomNumber = Integer.parseInt(st.nextToken().trim());
                        int rad = Integer.parseInt(st.nextToken().trim());
                        MDLV2000Writer.SPIN_MULTIPLICITY spin = MDLV2000Writer.SPIN_MULTIPLICITY.None;
                        if (rad <= 0) continue;
                        IAtom radical = container.getAtom(atomNumber - 1);
                        spin = MDLV2000Writer.SPIN_MULTIPLICITY.ofValue(rad);
                        for (int j = 0; j < spin.getSingleElectrons(); ++j) {
                            container.addSingleElectron((ISingleElectron)container.getBuilder().newInstance(ISingleElectron.class, new Object[]{radical}));
                        }
                    }
                }
                catch (NumberFormatException exception) {
                    String error = "Error (" + exception.getMessage() + ") while parsing line " + linecount + ": " + line + " in property block.";
                    logger.error((Object)error);
                    this.handleError("NumberFormatException in radical information", linecount, 7, 10, exception);
                }
            } else if (line.startsWith("G  ")) {
                try {
                    String atomNumberString = line.substring(3, 6).trim();
                    int atomNumber = Integer.parseInt(atomNumberString);
                    String atomName = input.readLine();
                    IAtom prevAtom = container.getAtom(atomNumber - 1);
                    IPseudoAtom pseudoAtom = (IPseudoAtom)container.getBuilder().newInstance(IPseudoAtom.class, new Object[]{atomName});
                    if (prevAtom.getPoint2d() != null) {
                        pseudoAtom.setPoint2d(prevAtom.getPoint2d());
                    }
                    if (prevAtom.getPoint3d() != null) {
                        pseudoAtom.setPoint3d(prevAtom.getPoint3d());
                    }
                    AtomContainerManipulator.replaceAtomByAtom((IAtomContainer)container, (IAtom)prevAtom, (IAtom)pseudoAtom);
                }
                catch (NumberFormatException exception) {
                    String error = "Error (" + exception.toString() + ") while parsing line " + linecount + ": " + line + " in property block.";
                    logger.error((Object)error);
                    this.handleError("NumberFormatException in group information", linecount, 4, 7, exception);
                }
            } else if (line.startsWith("M  RGP")) {
                StringTokenizer st = new StringTokenizer(line);
                st.nextToken();
                st.nextToken();
                st.nextToken();
                while (st.hasMoreTokens()) {
                    Integer position = Integer.valueOf(st.nextToken());
                    int rNumber = Integer.valueOf(st.nextToken());
                    int index = container.getAtomCount() - nAtoms + position - 1;
                    IPseudoAtom pseudoAtom = (IPseudoAtom)container.getAtom(index);
                    if (pseudoAtom == null) continue;
                    pseudoAtom.setLabel("R" + rNumber);
                }
            }
            if (line.startsWith("V  ")) {
                Integer atomNumber = Integer.valueOf(line.substring(3, 6).trim());
                IAtom atomWithComment = container.getAtom(atomNumber - 1);
                atomWithComment.setProperty((Object)"cdk:Comment", (Object)line.substring(7));
            }
            if (lineRead) continue;
            logger.warn((Object)"Skipping line in property block: ", new Object[]{line});
        }
    }

    static void readNonStructuralData(BufferedReader input, IAtomContainer container) throws IOException {
        String line;
        String header = null;
        boolean wrap = false;
        StringBuilder data = new StringBuilder(80);
        while (!MDLV2000Reader.endOfRecord(line = input.readLine())) {
            String newHeader = MDLV2000Reader.dataHeader(line);
            if (newHeader != null) {
                if (header != null) {
                    container.setProperty((Object)header, (Object)data.toString());
                }
                header = newHeader;
                wrap = false;
                data.setLength(0);
                continue;
            }
            if (data.length() > 0 || !line.equals(" ")) {
                line = line.trim();
            }
            if (line.isEmpty()) continue;
            if (!wrap && data.length() > 0) {
                data.append('\n');
            }
            data.append(line);
            wrap = line.length() == 80;
        }
        if (header != null) {
            container.setProperty(header, (Object)data.toString());
        }
    }

    static String dataHeader(String line) {
        if (line.length() > 2 && line.charAt(0) != '>' && line.charAt(1) != ' ') {
            return null;
        }
        int i = line.indexOf(60, 2);
        if (i < 0) {
            return null;
        }
        int j = line.indexOf(62, i);
        if (j < 0) {
            return null;
        }
        return line.substring(i + 1, j);
    }

    private static boolean endOfRecord(String line) {
        return line == null || line.equals(RECORD_DELIMITER);
    }

    static enum CTabVersion {
        V2000,
        V3000,
        UNSPECIFIED;


        static CTabVersion ofHeader(String header) {
            if (header.length() < 39) {
                return UNSPECIFIED;
            }
            char c = header.charAt(34);
            if (c != 'v' && c != 'V') {
                return UNSPECIFIED;
            }
            if (header.charAt(35) == '2') {
                return V2000;
            }
            if (header.charAt(35) == '3') {
                return V3000;
            }
            return UNSPECIFIED;
        }
    }

    static enum PropertyKey {
        ATOM_ALIAS,
        ATOM_VALUE,
        GROUP_ABBREVIATION,
        SKIP,
        M_CHG,
        M_RAD,
        M_ISO,
        M_RBC,
        M_SUB,
        M_UNS,
        M_LIN,
        M_ALS,
        M_APO,
        M_AAL,
        M_RGP,
        M_LOG,
        M_STY,
        M_SST,
        M_SLB,
        M_SCN,
        M_SDS,
        M_SAL,
        M_SBL,
        M_SPA,
        M_SMT,
        M_CRS,
        M_SDI,
        M_SBV,
        M_SDT,
        M_SDD,
        M_SCD,
        M_SED,
        M_SPL,
        M_SNC,
        M_SBT,
        M_$3D,
        M_ZZC,
        M_END,
        UNKNOWN,
        LEGACY_ATOM_LIST;

        private static final Map<String, PropertyKey> mSuffix;
        private static Pattern LEGACY_ATOM_LIST_PATTERN;

        static PropertyKey of(String line) {
            if (line.length() < 5) {
                return UNKNOWN;
            }
            switch (line.charAt(0)) {
                case 'A': {
                    if (line.charAt(1) == ' ' && line.charAt(2) == ' ') {
                        return ATOM_ALIAS;
                    }
                    return UNKNOWN;
                }
                case 'G': {
                    if (line.charAt(1) == ' ' && line.charAt(2) == ' ') {
                        return GROUP_ABBREVIATION;
                    }
                    return UNKNOWN;
                }
                case 'S': {
                    if (line.charAt(1) == ' ' && line.charAt(2) == ' ') {
                        return SKIP;
                    }
                    return UNKNOWN;
                }
                case 'V': {
                    if (line.charAt(1) == ' ' && line.charAt(2) == ' ') {
                        return ATOM_VALUE;
                    }
                    return UNKNOWN;
                }
                case 'M': {
                    if (line.charAt(1) != ' ' || line.charAt(2) != ' ') {
                        return UNKNOWN;
                    }
                    PropertyKey property = mSuffix.get(line.substring(3, 6));
                    if (property != null) {
                        return property;
                    }
                    return UNKNOWN;
                }
            }
            Matcher matcher = LEGACY_ATOM_LIST_PATTERN.matcher(line);
            if (matcher.find()) {
                return LEGACY_ATOM_LIST;
            }
            return UNKNOWN;
        }

        static {
            mSuffix = new HashMap<String, PropertyKey>(60);
            LEGACY_ATOM_LIST_PATTERN = Pattern.compile("^[0-9 ][0-9 ][0-9 ] [T|F]");
            for (PropertyKey p : PropertyKey.values()) {
                if (p.name().charAt(0) != 'M') continue;
                mSuffix.put(p.name().substring(2, 5), p);
            }
        }
    }
}

