/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.attributes;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import org.openrewrite.maven.attributes.Attribute;

public interface Attributed {
    public Map<String, String> getAttributes();

    default public <T extends Attribute> Optional<T> findAttribute(Class<T> clazz) {
        try {
            Method keyMethod = clazz.getMethod("key", new Class[0]);
            String key = (String)keyMethod.invoke(null, new Object[0]);
            String value = this.getAttributes().get(key);
            if (value == null) {
                return Optional.empty();
            }
            Method from = clazz.getMethod("from", String.class);
            return Optional.ofNullable((Attribute)from.invoke(null, value));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return Optional.empty();
        }
    }
}

