/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.internal.MavenXmlMapper;

@JacksonXmlRootElement(localName="settingsSecurity")
public class MavenSecuritySettings {
    private final @Nullable String master;
    private final @Nullable String relocation;

    private static @Nullable MavenSecuritySettings parse(Parser.Input source, ExecutionContext ctx) {
        try {
            return new Interpolator().interpolate((MavenSecuritySettings)MavenXmlMapper.readMapper().readValue((InputStream)source.getSource(ctx), MavenSecuritySettings.class));
        }
        catch (IOException e) {
            ctx.getOnError().accept(new IOException("Failed to parse " + source.getPath(), e));
            return null;
        }
    }

    private static @Nullable MavenSecuritySettings parse(Path settingsPath, ExecutionContext ctx) {
        return MavenSecuritySettings.parse(new Parser.Input(settingsPath, () -> {
            try {
                return Files.newInputStream(settingsPath, new OpenOption[0]);
            }
            catch (IOException e) {
                ctx.getOnError().accept(new IOException("Failed to read settings-security.xml at " + settingsPath, e));
                return null;
            }
        }), ctx);
    }

    public static @Nullable MavenSecuritySettings readMavenSecuritySettingsFromDisk(ExecutionContext ctx) {
        MavenSecuritySettings installSettings;
        Optional<MavenSecuritySettings> userSettings = Optional.of(MavenSecuritySettings.userSecuritySettingsPath()).filter(MavenSecuritySettings::exists).map(path -> MavenSecuritySettings.parse(path, ctx));
        MavenSecuritySettings mergedSettings = userSettings.map(arg_0 -> MavenSecuritySettings.lambda$readMavenSecuritySettingsFromDisk$3(installSettings = (MavenSecuritySettings)MavenSecuritySettings.findMavenHomeSettings().map(path -> MavenSecuritySettings.parse(path, ctx)).orElse(null), arg_0)).orElse(installSettings);
        if (mergedSettings != null && mergedSettings.relocation != null) {
            return mergedSettings.merge(MavenSecuritySettings.parse(Paths.get(mergedSettings.relocation, new String[0]), ctx));
        }
        return mergedSettings;
    }

    private static Path userSecuritySettingsPath() {
        return Paths.get(System.getProperty("user.home"), new String[0]).resolve(".m2/settings-security.xml");
    }

    private static Optional<Path> findMavenHomeSettings() {
        for (String envVariable : Arrays.asList("MVN_HOME", "M2_HOME", "MAVEN_HOME")) {
            for (String s : Optional.ofNullable(System.getenv(envVariable)).map(xva$0 -> Arrays.asList(xva$0)).orElse(Collections.emptyList())) {
                Path resolve = Paths.get(s, new String[0]).resolve("conf/settings-security.xml");
                if (!MavenSecuritySettings.exists(resolve)) continue;
                return Optional.of(resolve);
            }
        }
        return Optional.empty();
    }

    private static boolean exists(Path path) {
        try {
            return path.toFile().exists();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private MavenSecuritySettings merge(@Nullable MavenSecuritySettings installSettings) {
        return installSettings == null ? this : new MavenSecuritySettings(this.master == null ? installSettings.master : this.master, this.relocation == null ? installSettings.relocation : this.relocation);
    }

    @Nullable String decrypt(@Nullable String fieldValue, @Nullable String password) {
        if (fieldValue == null || fieldValue.isEmpty() || password == null) {
            return null;
        }
        try {
            byte[] hash;
            byte[] encryptedText = this.extractPassword(fieldValue);
            byte[] salt = new byte[8];
            System.arraycopy(encryptedText, 0, salt, 0, 8);
            byte padLength = encryptedText[8];
            byte[] encryptedBytes = new byte[encryptedText.length - 9 - padLength];
            System.arraycopy(encryptedText, 9, encryptedBytes, 0, encryptedBytes.length);
            byte[] keyAndIV = new byte[32];
            byte[] pwdBytes = this.extractPassword(password);
            for (int offset = 0; offset < 32; offset += hash.length) {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                digest.update(pwdBytes);
                digest.update(salt);
                hash = digest.digest();
                System.arraycopy(hash, 0, keyAndIV, offset, Math.min(hash.length, 32 - offset));
            }
            SecretKeySpec key = new SecretKeySpec(keyAndIV, 0, 16, "AES");
            IvParameterSpec iv = new IvParameterSpec(keyAndIV, 16, 16);
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(2, (Key)key, iv);
            byte[] clearBytes = cipher.doFinal(encryptedBytes);
            byte paddingLength = clearBytes[clearBytes.length - 1];
            if (paddingLength >= clearBytes.length) {
                return null;
            }
            byte[] decryptedBytes = new byte[clearBytes.length - paddingLength];
            System.arraycopy(clearBytes, 0, decryptedBytes, 0, decryptedBytes.length);
            return new String(decryptedBytes, StandardCharsets.UTF_8);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | NegativeArraySizeException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            return null;
        }
    }

    private byte[] extractPassword(String pwd) throws IllegalArgumentException {
        Pattern pattern = Pattern.compile(".*?[^\\\\]?\\{(.*?)}.*");
        Matcher matcher = pattern.matcher(pwd);
        if (matcher.find()) {
            return Base64.getDecoder().decode(matcher.group(1));
        }
        return pwd.getBytes(StandardCharsets.UTF_8);
    }

    @NonNull
    @Generated
    public String toString() {
        return "MavenSecuritySettings()";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenSecuritySettings)) {
            return false;
        }
        MavenSecuritySettings other = (MavenSecuritySettings)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof MavenSecuritySettings;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public @Nullable String getMaster() {
        return this.master;
    }

    @Generated
    public @Nullable String getRelocation() {
        return this.relocation;
    }

    @Generated
    public MavenSecuritySettings(@Nullable String master, @Nullable String relocation) {
        this.master = master;
        this.relocation = relocation;
    }

    private static /* synthetic */ MavenSecuritySettings lambda$readMavenSecuritySettingsFromDisk$3(MavenSecuritySettings installSettings, MavenSecuritySettings mavenSecuritySettings) {
        return mavenSecuritySettings.merge(installSettings);
    }

    private static class Interpolator {
        private static final PropertyPlaceholderHelper propertyPlaceholders = new PropertyPlaceholderHelper("${", "}", null);
        private static final UnaryOperator<String> propertyResolver = key -> {
            String property = System.getProperty(key);
            if (property != null) {
                return property;
            }
            if (key.startsWith("env.")) {
                return System.getenv().get(key.substring(4));
            }
            return System.getenv().get(key);
        };

        private Interpolator() {
        }

        public MavenSecuritySettings interpolate(MavenSecuritySettings mavenSecuritySettings) {
            return new MavenSecuritySettings(this.interpolate(mavenSecuritySettings.master), this.interpolate(mavenSecuritySettings.relocation));
        }

        private @Nullable String interpolate(@Nullable String s) {
            return s == null ? null : propertyPlaceholders.replacePlaceholders(s, propertyResolver);
        }
    }
}

