/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.ChangePropertyValue;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.trait.MavenPlugin;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public final class AddAnnotationProcessor
extends Recipe {
    private static final String MAVEN_COMPILER_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    private static final String MAVEN_COMPILER_PLUGIN_ARTIFACT_ID = "maven-compiler-plugin";
    @Option(displayName="Group", description="The first part of the coordinate 'org.projectlombok:lombok-mapstruct-binding:0.2.0' of the processor to add.", example="org.projectlombok")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a coordinate 'org.projectlombok:lombok-mapstruct-binding:0.2.0' of the processor to add.", example="lombok-mapstruct-binding")
    private final String artifactId;
    @Option(displayName="Version", description="The third part of a coordinate 'org.projectlombok:lombok-mapstruct-binding:0.2.0' of the processor to add. Note that an exact version is expected", example="0.2.0")
    private final String version;

    public String getDisplayName() {
        return "Add an annotation processor to `maven-compiler-plugin`";
    }

    public String getDescription() {
        return "Add an annotation processor to the maven compiler plugin. Will not do anything if it already exists. Also doesn't add anything when no other annotation processors are defined yet. (Perhaps `ChangePluginConfiguration` can be used).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag plugins = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                plugins = (Xml.Tag)new MavenPlugin.Matcher().asVisitor(plugin -> {
                    if (AddAnnotationProcessor.MAVEN_COMPILER_PLUGIN_GROUP_ID.equals(plugin.getGroupId()) && AddAnnotationProcessor.MAVEN_COMPILER_PLUGIN_ARTIFACT_ID.equals(plugin.getArtifactId())) {
                        final MavenResolutionResult mrr = this.getResolutionResult();
                        final AtomicReference afterVisitor = new AtomicReference();
                        Xml.Tag modifiedPlugin = new XmlIsoVisitor<ExecutionContext>(){

                            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                                Xml.Tag tg = super.visitTag(tag, (Object)ctx);
                                if ("annotationProcessorPaths".equals(tg.getName())) {
                                    for (int i = 0; i < tg.getChildren().size(); ++i) {
                                        String oldVersion;
                                        boolean oldVersionUsesProperty;
                                        String lookupVersion;
                                        VersionComparator comparator;
                                        Xml.Tag child = (Xml.Tag)tg.getChildren().get(i);
                                        if (!AddAnnotationProcessor.this.groupId.equals(child.getChildValue("groupId").orElse(null)) || !AddAnnotationProcessor.this.artifactId.equals(child.getChildValue("artifactId").orElse(null))) continue;
                                        if (!AddAnnotationProcessor.this.version.equals(child.getChildValue("version").orElse(null)) && (comparator = (VersionComparator)Semver.validate((String)(lookupVersion = (oldVersionUsesProperty = (oldVersion = child.getChildValue("version").orElse("")).startsWith("${")) ? mrr.getPom().getValue(oldVersion.trim()) : oldVersion), null).getValue()).compare(AddAnnotationProcessor.this.version, lookupVersion) > 0) {
                                            if (oldVersionUsesProperty) {
                                                afterVisitor.set(new ChangePropertyValue(oldVersion, AddAnnotationProcessor.this.version, null, null).getVisitor());
                                            } else {
                                                List tags = tg.getChildren();
                                                tags.set(i, child.withChildValue("version", AddAnnotationProcessor.this.version));
                                                return tg.withContent(tags);
                                            }
                                        }
                                        return tg;
                                    }
                                    return tg.withContent(ListUtils.concat((List)tg.getChildren(), (Object)Xml.Tag.build((String)String.format("<path>\n<groupId>%s</groupId>\n<artifactId>%s</artifactId>\n<version>%s</version>\n</path>", AddAnnotationProcessor.this.groupId, AddAnnotationProcessor.this.artifactId, AddAnnotationProcessor.this.version))));
                                }
                                return tg;
                            }
                        }.visitTag((Xml.Tag)plugin.getTree(), ctx);
                        if (afterVisitor.get() != null) {
                            this.doAfterVisit((TreeVisitor)afterVisitor.get());
                        }
                        return modifiedPlugin;
                    }
                    return plugin.getTree();
                }).visitNonNull((Tree)plugins, (Object)0);
                if (plugins != tag) {
                    plugins = (Xml.Tag)this.autoFormat((Xml)plugins, ctx);
                }
                return plugins;
            }
        };
    }

    @Generated
    public AddAnnotationProcessor(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddAnnotationProcessor(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddAnnotationProcessor)) {
            return false;
        }
        AddAnnotationProcessor other = (AddAnnotationProcessor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddAnnotationProcessor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

