/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.style;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.style.Style;

public final class CustomImportOrderStyle
implements Style {
    private final List<GroupWithDepth> importOrder;
    private final Boolean separateLineBetweenGroups;
    private final Boolean sortImportsInGroupAlphabetically;
    private final String specialImportsRegExp;
    private final String standardPackageRegExp;
    private final String thirdPartyPackageRegExp;

    public Style applyDefaults() {
        CustomImportOrderStyle def = Checkstyle.customImportOrderStyle();
        return new CustomImportOrderStyle(this.importOrder != null && !this.importOrder.isEmpty() ? this.importOrder : def.importOrder, this.separateLineBetweenGroups, this.sortImportsInGroupAlphabetically, this.specialImportsRegExp != null ? this.specialImportsRegExp : def.specialImportsRegExp, this.standardPackageRegExp != null ? this.standardPackageRegExp : def.standardPackageRegExp, this.thirdPartyPackageRegExp != null ? this.thirdPartyPackageRegExp : def.thirdPartyPackageRegExp);
    }

    public static GroupWithDepth parseGroup(String groupRule) {
        Matcher m = Pattern.compile("^SAME_PACKAGE\\((\\d+)\\)$").matcher(groupRule);
        if (m.matches()) {
            return new GroupWithDepth(CustomImportOrderGroup.SAME_PACKAGE, Integer.parseInt(m.group(1)));
        }
        switch (groupRule) {
            case "STATIC": {
                return new GroupWithDepth(CustomImportOrderGroup.STATIC, null);
            }
            case "STANDARD_JAVA_PACKAGE": {
                return new GroupWithDepth(CustomImportOrderGroup.STANDARD_JAVA_PACKAGE, null);
            }
            case "THIRD_PARTY_PACKAGE": {
                return new GroupWithDepth(CustomImportOrderGroup.THIRD_PARTY_PACKAGE, null);
            }
            case "SPECIAL_IMPORTS": {
                return new GroupWithDepth(CustomImportOrderGroup.SPECIAL_IMPORTS, null);
            }
        }
        throw new IllegalArgumentException("Unknown import group: " + groupRule);
    }

    public static List<GroupWithDepth> parseImportOrder(String input) {
        if (StringUtils.isBlank((String)input)) {
            return Collections.emptyList();
        }
        ArrayList<GroupWithDepth> groups = new ArrayList<GroupWithDepth>();
        for (String rule : input.split("\\s*,\\s*|###")) {
            String groupRule = rule.trim();
            if (groupRule.isEmpty()) continue;
            groups.add(CustomImportOrderStyle.parseGroup(groupRule));
        }
        return groups;
    }

    @Generated
    public CustomImportOrderStyle(List<GroupWithDepth> importOrder, Boolean separateLineBetweenGroups, Boolean sortImportsInGroupAlphabetically, String specialImportsRegExp, String standardPackageRegExp, String thirdPartyPackageRegExp) {
        this.importOrder = importOrder;
        this.separateLineBetweenGroups = separateLineBetweenGroups;
        this.sortImportsInGroupAlphabetically = sortImportsInGroupAlphabetically;
        this.specialImportsRegExp = specialImportsRegExp;
        this.standardPackageRegExp = standardPackageRegExp;
        this.thirdPartyPackageRegExp = thirdPartyPackageRegExp;
    }

    @Generated
    public List<GroupWithDepth> getImportOrder() {
        return this.importOrder;
    }

    @Generated
    public Boolean getSeparateLineBetweenGroups() {
        return this.separateLineBetweenGroups;
    }

    @Generated
    public Boolean getSortImportsInGroupAlphabetically() {
        return this.sortImportsInGroupAlphabetically;
    }

    @Generated
    public String getSpecialImportsRegExp() {
        return this.specialImportsRegExp;
    }

    @Generated
    public String getStandardPackageRegExp() {
        return this.standardPackageRegExp;
    }

    @Generated
    public String getThirdPartyPackageRegExp() {
        return this.thirdPartyPackageRegExp;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomImportOrderStyle)) {
            return false;
        }
        CustomImportOrderStyle other = (CustomImportOrderStyle)o;
        Boolean this$separateLineBetweenGroups = this.getSeparateLineBetweenGroups();
        Boolean other$separateLineBetweenGroups = other.getSeparateLineBetweenGroups();
        if (this$separateLineBetweenGroups == null ? other$separateLineBetweenGroups != null : !((Object)this$separateLineBetweenGroups).equals(other$separateLineBetweenGroups)) {
            return false;
        }
        Boolean this$sortImportsInGroupAlphabetically = this.getSortImportsInGroupAlphabetically();
        Boolean other$sortImportsInGroupAlphabetically = other.getSortImportsInGroupAlphabetically();
        if (this$sortImportsInGroupAlphabetically == null ? other$sortImportsInGroupAlphabetically != null : !((Object)this$sortImportsInGroupAlphabetically).equals(other$sortImportsInGroupAlphabetically)) {
            return false;
        }
        List<GroupWithDepth> this$importOrder = this.getImportOrder();
        List<GroupWithDepth> other$importOrder = other.getImportOrder();
        if (this$importOrder == null ? other$importOrder != null : !((Object)this$importOrder).equals(other$importOrder)) {
            return false;
        }
        String this$specialImportsRegExp = this.getSpecialImportsRegExp();
        String other$specialImportsRegExp = other.getSpecialImportsRegExp();
        if (this$specialImportsRegExp == null ? other$specialImportsRegExp != null : !this$specialImportsRegExp.equals(other$specialImportsRegExp)) {
            return false;
        }
        String this$standardPackageRegExp = this.getStandardPackageRegExp();
        String other$standardPackageRegExp = other.getStandardPackageRegExp();
        if (this$standardPackageRegExp == null ? other$standardPackageRegExp != null : !this$standardPackageRegExp.equals(other$standardPackageRegExp)) {
            return false;
        }
        String this$thirdPartyPackageRegExp = this.getThirdPartyPackageRegExp();
        String other$thirdPartyPackageRegExp = other.getThirdPartyPackageRegExp();
        return !(this$thirdPartyPackageRegExp == null ? other$thirdPartyPackageRegExp != null : !this$thirdPartyPackageRegExp.equals(other$thirdPartyPackageRegExp));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $separateLineBetweenGroups = this.getSeparateLineBetweenGroups();
        result = result * 59 + ($separateLineBetweenGroups == null ? 43 : ((Object)$separateLineBetweenGroups).hashCode());
        Boolean $sortImportsInGroupAlphabetically = this.getSortImportsInGroupAlphabetically();
        result = result * 59 + ($sortImportsInGroupAlphabetically == null ? 43 : ((Object)$sortImportsInGroupAlphabetically).hashCode());
        List<GroupWithDepth> $importOrder = this.getImportOrder();
        result = result * 59 + ($importOrder == null ? 43 : ((Object)$importOrder).hashCode());
        String $specialImportsRegExp = this.getSpecialImportsRegExp();
        result = result * 59 + ($specialImportsRegExp == null ? 43 : $specialImportsRegExp.hashCode());
        String $standardPackageRegExp = this.getStandardPackageRegExp();
        result = result * 59 + ($standardPackageRegExp == null ? 43 : $standardPackageRegExp.hashCode());
        String $thirdPartyPackageRegExp = this.getThirdPartyPackageRegExp();
        result = result * 59 + ($thirdPartyPackageRegExp == null ? 43 : $thirdPartyPackageRegExp.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "CustomImportOrderStyle(importOrder=" + this.getImportOrder() + ", separateLineBetweenGroups=" + this.getSeparateLineBetweenGroups() + ", sortImportsInGroupAlphabetically=" + this.getSortImportsInGroupAlphabetically() + ", specialImportsRegExp=" + this.getSpecialImportsRegExp() + ", standardPackageRegExp=" + this.getStandardPackageRegExp() + ", thirdPartyPackageRegExp=" + this.getThirdPartyPackageRegExp() + ")";
    }

    @NonNull
    @Generated
    public CustomImportOrderStyle withImportOrder(List<GroupWithDepth> importOrder) {
        return this.importOrder == importOrder ? this : new CustomImportOrderStyle(importOrder, this.separateLineBetweenGroups, this.sortImportsInGroupAlphabetically, this.specialImportsRegExp, this.standardPackageRegExp, this.thirdPartyPackageRegExp);
    }

    @NonNull
    @Generated
    public CustomImportOrderStyle withSeparateLineBetweenGroups(Boolean separateLineBetweenGroups) {
        return this.separateLineBetweenGroups == separateLineBetweenGroups ? this : new CustomImportOrderStyle(this.importOrder, separateLineBetweenGroups, this.sortImportsInGroupAlphabetically, this.specialImportsRegExp, this.standardPackageRegExp, this.thirdPartyPackageRegExp);
    }

    @NonNull
    @Generated
    public CustomImportOrderStyle withSortImportsInGroupAlphabetically(Boolean sortImportsInGroupAlphabetically) {
        return this.sortImportsInGroupAlphabetically == sortImportsInGroupAlphabetically ? this : new CustomImportOrderStyle(this.importOrder, this.separateLineBetweenGroups, sortImportsInGroupAlphabetically, this.specialImportsRegExp, this.standardPackageRegExp, this.thirdPartyPackageRegExp);
    }

    @NonNull
    @Generated
    public CustomImportOrderStyle withSpecialImportsRegExp(String specialImportsRegExp) {
        return this.specialImportsRegExp == specialImportsRegExp ? this : new CustomImportOrderStyle(this.importOrder, this.separateLineBetweenGroups, this.sortImportsInGroupAlphabetically, specialImportsRegExp, this.standardPackageRegExp, this.thirdPartyPackageRegExp);
    }

    @NonNull
    @Generated
    public CustomImportOrderStyle withStandardPackageRegExp(String standardPackageRegExp) {
        return this.standardPackageRegExp == standardPackageRegExp ? this : new CustomImportOrderStyle(this.importOrder, this.separateLineBetweenGroups, this.sortImportsInGroupAlphabetically, this.specialImportsRegExp, standardPackageRegExp, this.thirdPartyPackageRegExp);
    }

    @NonNull
    @Generated
    public CustomImportOrderStyle withThirdPartyPackageRegExp(String thirdPartyPackageRegExp) {
        return this.thirdPartyPackageRegExp == thirdPartyPackageRegExp ? this : new CustomImportOrderStyle(this.importOrder, this.separateLineBetweenGroups, this.sortImportsInGroupAlphabetically, this.specialImportsRegExp, this.standardPackageRegExp, thirdPartyPackageRegExp);
    }

    public static final class GroupWithDepth {
        private final CustomImportOrderGroup group;
        private final @Nullable Integer depth;

        public String toString() {
            return (Object)((Object)this.group) + (this.group == CustomImportOrderGroup.SAME_PACKAGE && this.depth != null ? "(" + this.depth + ")" : "");
        }

        @Generated
        public GroupWithDepth(CustomImportOrderGroup group, @Nullable Integer depth) {
            this.group = group;
            this.depth = depth;
        }

        @Generated
        public CustomImportOrderGroup getGroup() {
            return this.group;
        }

        @Generated
        public @Nullable Integer getDepth() {
            return this.depth;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupWithDepth)) {
                return false;
            }
            GroupWithDepth other = (GroupWithDepth)o;
            Integer this$depth = this.getDepth();
            Integer other$depth = other.getDepth();
            if (this$depth == null ? other$depth != null : !((Object)this$depth).equals(other$depth)) {
                return false;
            }
            CustomImportOrderGroup this$group = this.getGroup();
            CustomImportOrderGroup other$group = other.getGroup();
            return !(this$group == null ? other$group != null : !((Object)((Object)this$group)).equals((Object)other$group));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $depth = this.getDepth();
            result = result * 59 + ($depth == null ? 43 : ((Object)$depth).hashCode());
            CustomImportOrderGroup $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : ((Object)((Object)$group)).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public GroupWithDepth withGroup(CustomImportOrderGroup group) {
            return this.group == group ? this : new GroupWithDepth(group, this.depth);
        }

        @NonNull
        @Generated
        public GroupWithDepth withDepth(@Nullable Integer depth) {
            return this.depth == depth ? this : new GroupWithDepth(this.group, depth);
        }
    }

    public static enum CustomImportOrderGroup {
        STATIC,
        SAME_PACKAGE,
        STANDARD_JAVA_PACKAGE,
        THIRD_PARTY_PACKAGE,
        SPECIAL_IMPORTS;

    }
}

