/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.internal;

import org.jspecify.annotations.Nullable;
import org.openrewrite.gradle.internal.Dependency;

public class DependencyStringNotationConverter {
    public static @Nullable Dependency parse(String notation) {
        int idx = notation.lastIndexOf(64);
        if (idx == -1) {
            return DependencyStringNotationConverter.parse(notation, null);
        }
        int versionIdx = notation.lastIndexOf(58);
        if (versionIdx < idx) {
            return DependencyStringNotationConverter.parse(notation.substring(0, idx), notation.substring(idx + 1));
        }
        return DependencyStringNotationConverter.parse(notation, null);
    }

    private static @Nullable Dependency parse(String notation, @Nullable String ext) {
        Dependency dependency = new Dependency(null, null, null, null, ext);
        int count = 0;
        int idx = 0;
        int cur = 0;
        while (++cur < notation.length()) {
            if (':' != notation.charAt(cur)) continue;
            String fragment = notation.substring(idx, cur);
            dependency = DependencyStringNotationConverter.assignValue(dependency, count, fragment);
            idx = cur + 1;
            ++count;
        }
        dependency = DependencyStringNotationConverter.assignValue(dependency, count, notation.substring(idx, cur));
        if (++count < 2 || count > 4) {
            return null;
        }
        return dependency;
    }

    private static Dependency assignValue(Dependency dependency, int count, String fragment) {
        switch (count) {
            case 0: {
                return dependency.withGroupId(fragment);
            }
            case 1: {
                return dependency.withArtifactId(fragment);
            }
            case 2: {
                return dependency.withVersion(fragment);
            }
            case 3: {
                return dependency.withClassifier(fragment);
            }
        }
        throw new IllegalArgumentException("Invalid count parameter: " + count);
    }
}

