/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.staticanalysis.groovy.GroovyFileChecker;
import org.openrewrite.staticanalysis.java.JavaFileChecker;
import org.openrewrite.staticanalysis.kotlin.KotlinFileChecker;

public class UnnecessaryCloseInTryWithResources
extends Recipe {
    public String getDisplayName() {
        return "Unnecessary close in try-with-resources";
    }

    public String getDescription() {
        return "Remove unnecessary `AutoCloseable#close()` statements in try-with-resources.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S4087");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new JavaFileChecker(), new KotlinFileChecker(), new GroovyFileChecker()}), (TreeVisitor)new UnnecessaryAutoCloseableVisitor());
    }

    private static class UnnecessaryAutoCloseableVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final MethodMatcher AUTO_CLOSEABLE_METHOD_MATCHER = new MethodMatcher("java.lang.AutoCloseable close()", true);

        private UnnecessaryAutoCloseableVisitor() {
        }

        public J.Try visitTry(J.Try aTry, ExecutionContext ctx) {
            J.Try tr = super.visitTry(aTry, (Object)ctx);
            if (tr.getResources() != null) {
                String[] resourceNames = new String[tr.getResources().size()];
                for (int i = 0; i < tr.getResources().size(); ++i) {
                    J.Try.Resource tryResource = (J.Try.Resource)tr.getResources().get(i);
                    if (tryResource.getVariableDeclarations() instanceof J.VariableDeclarations) {
                        J.VariableDeclarations varDecls = (J.VariableDeclarations)tryResource.getVariableDeclarations();
                        resourceNames[i] = ((J.VariableDeclarations.NamedVariable)varDecls.getVariables().get(0)).getSimpleName();
                        continue;
                    }
                    if (!(tryResource.getVariableDeclarations() instanceof J.Identifier)) continue;
                    J.Identifier identifier = (J.Identifier)tryResource.getVariableDeclarations();
                    resourceNames[i] = identifier.getSimpleName();
                }
                tr = tr.withBody(tr.getBody().withStatements(ListUtils.map((List)tr.getBody().getStatements(), statement -> {
                    J.MethodInvocation mi;
                    if (statement instanceof J.MethodInvocation && AUTO_CLOSEABLE_METHOD_MATCHER.matches((MethodCall)(mi = (J.MethodInvocation)statement)) && mi.getSelect() instanceof J.Identifier) {
                        String selectName = ((J.Identifier)mi.getSelect()).getSimpleName();
                        for (String resourceName : resourceNames) {
                            if (!resourceName.equals(selectName)) continue;
                            return null;
                        }
                    }
                    return statement;
                })));
            }
            return tr;
        }
    }
}

