/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.dom.attribute.text.TextOutlineLevelAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextUseOutlineLevelAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextUseIndexMarksAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextUseIndexSourceStylesAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextIndexScopeAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextRelativeTabStopPositionAttribute;


/**
 * DOM implementation of OpenDocument element  {@odf.element text:table-of-content-source}.
 *
 */
public class TextTableOfContentSourceElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.TEXT, "table-of-content-source" );


	/**
	 * Create the instance of <code>TextTableOfContentSourceElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public TextTableOfContentSourceElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element text:table-of-content-source}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}



	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextOutlineLevelAttribute</code> , See {@odf.attribute text:outline-level}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextOutlineLevelAttribute()
	{
		TextOutlineLevelAttribute attr = (TextOutlineLevelAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "outline-level" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextOutlineLevelAttribute</code> , See {@odf.attribute text:outline-level}
	 *
	 * @param textOutlineLevelValue   The type is <code>String</code>
	 */
	public void setTextOutlineLevelAttribute( String textOutlineLevelValue )
	{
		TextOutlineLevelAttribute attr =  new TextOutlineLevelAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textOutlineLevelValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextUseOutlineLevelAttribute</code> , See {@odf.attribute text:use-outline-level}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getTextUseOutlineLevelAttribute()
	{
		TextUseOutlineLevelAttribute attr = (TextUseOutlineLevelAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "use-outline-level" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return Boolean.valueOf( TextUseOutlineLevelAttribute.DEFAULT_VALUE );
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextUseOutlineLevelAttribute</code> , See {@odf.attribute text:use-outline-level}
	 *
	 * @param textUseOutlineLevelValue   The type is <code>Boolean</code>
	 */
	public void setTextUseOutlineLevelAttribute( Boolean textUseOutlineLevelValue )
	{
		TextUseOutlineLevelAttribute attr =  new TextUseOutlineLevelAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( textUseOutlineLevelValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextUseIndexMarksAttribute</code> , See {@odf.attribute text:use-index-marks}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getTextUseIndexMarksAttribute()
	{
		TextUseIndexMarksAttribute attr = (TextUseIndexMarksAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "use-index-marks" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextUseIndexMarksAttribute</code> , See {@odf.attribute text:use-index-marks}
	 *
	 * @param textUseIndexMarksValue   The type is <code>Boolean</code>
	 */
	public void setTextUseIndexMarksAttribute( Boolean textUseIndexMarksValue )
	{
		TextUseIndexMarksAttribute attr =  new TextUseIndexMarksAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( textUseIndexMarksValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextUseIndexSourceStylesAttribute</code> , See {@odf.attribute text:use-index-source-styles}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getTextUseIndexSourceStylesAttribute()
	{
		TextUseIndexSourceStylesAttribute attr = (TextUseIndexSourceStylesAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "use-index-source-styles" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextUseIndexSourceStylesAttribute</code> , See {@odf.attribute text:use-index-source-styles}
	 *
	 * @param textUseIndexSourceStylesValue   The type is <code>Boolean</code>
	 */
	public void setTextUseIndexSourceStylesAttribute( Boolean textUseIndexSourceStylesValue )
	{
		TextUseIndexSourceStylesAttribute attr =  new TextUseIndexSourceStylesAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( textUseIndexSourceStylesValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextIndexScopeAttribute</code> , See {@odf.attribute text:index-scope}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextIndexScopeAttribute()
	{
		TextIndexScopeAttribute attr = (TextIndexScopeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "index-scope" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextIndexScopeAttribute</code> , See {@odf.attribute text:index-scope}
	 *
	 * @param textIndexScopeValue   The type is <code>String</code>
	 */
	public void setTextIndexScopeAttribute( String textIndexScopeValue )
	{
		TextIndexScopeAttribute attr =  new TextIndexScopeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textIndexScopeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextRelativeTabStopPositionAttribute</code> , See {@odf.attribute text:relative-tab-stop-position}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getTextRelativeTabStopPositionAttribute()
	{
		TextRelativeTabStopPositionAttribute attr = (TextRelativeTabStopPositionAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "relative-tab-stop-position" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextRelativeTabStopPositionAttribute</code> , See {@odf.attribute text:relative-tab-stop-position}
	 *
	 * @param textRelativeTabStopPositionValue   The type is <code>Boolean</code>
	 */
	public void setTextRelativeTabStopPositionAttribute( Boolean textRelativeTabStopPositionValue )
	{
		TextRelativeTabStopPositionAttribute attr =  new TextRelativeTabStopPositionAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( textRelativeTabStopPositionValue.booleanValue() );
	}

	/**
	 * Create child element {@odf.element text:index-title-template}.
	 *
	 * @return   return  the element {@odf.element text:index-title-template}
	 * DifferentQName 
	 */
	public TextIndexTitleTemplateElement newTextIndexTitleTemplateElement()
	{
		TextIndexTitleTemplateElement  textIndexTitleTemplate = ((OdfFileDom)this.ownerDocument).newOdfElement(TextIndexTitleTemplateElement.class);
		this.appendChild( textIndexTitleTemplate);
		return  textIndexTitleTemplate;
	}                   
               
	/**
	 * Create child element {@odf.element text:table-of-content-entry-template}.
	 *
     * @param textOutlineLevelAttributeValue  the <code>String</code> value of <code>TextOutlineLevelAttribute</code>, see {@odf.attribute  text:outline-level} at specification
	 * @param textStyleNameAttributeValue  the <code>String</code> value of <code>TextStyleNameAttribute</code>, see {@odf.attribute  text:style-name} at specification
	 * @return   return  the element {@odf.element text:table-of-content-entry-template}
	 * DifferentQName 
	 */
    
	public TextTableOfContentEntryTemplateElement newTextTableOfContentEntryTemplateElement(String textOutlineLevelAttributeValue, String textStyleNameAttributeValue)
	{
		TextTableOfContentEntryTemplateElement  textTableOfContentEntryTemplate = ((OdfFileDom)this.ownerDocument).newOdfElement(TextTableOfContentEntryTemplateElement.class);
		textTableOfContentEntryTemplate.setTextOutlineLevelAttribute( textOutlineLevelAttributeValue );
		textTableOfContentEntryTemplate.setTextStyleNameAttribute( textStyleNameAttributeValue );
		this.appendChild( textTableOfContentEntryTemplate);
		return  textTableOfContentEntryTemplate;      
	}
    
	/**
	 * Create child element {@odf.element text:index-source-styles}.
	 *
     * @param textOutlineLevelAttributeValue  the <code>String</code> value of <code>TextOutlineLevelAttribute</code>, see {@odf.attribute  text:outline-level} at specification
	 * @return   return  the element {@odf.element text:index-source-styles}
	 * DifferentQName 
	 */
    
	public TextIndexSourceStylesElement newTextIndexSourceStylesElement(String textOutlineLevelAttributeValue)
	{
		TextIndexSourceStylesElement  textIndexSourceStyles = ((OdfFileDom)this.ownerDocument).newOdfElement(TextIndexSourceStylesElement.class);
		textIndexSourceStyles.setTextOutlineLevelAttribute( textOutlineLevelAttributeValue );
		this.appendChild( textIndexSourceStyles);
		return  textIndexSourceStyles;      
	}
    
}
