/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.dom.attribute.text.TextNoteClassAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextIdAttribute;


/**
 * DOM implementation of OpenDocument element  {@odf.element text:note}.
 *
 */
public class TextNoteElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.TEXT, "note" );


	/**
	 * Create the instance of <code>TextNoteElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public TextNoteElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element text:note}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}

	/**
	 * Initialization of the mandatory attributes of {@link  TextNoteElement}
	 *
     * @param textNoteClassAttributeValue  The mandatory attribute {@odf.attribute  text:note-class}"
     *
	 */
	public void init(String textNoteClassAttributeValue)
	{
		setTextNoteClassAttribute( textNoteClassAttributeValue );
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextNoteClassAttribute</code> , See {@odf.attribute text:note-class}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextNoteClassAttribute()
	{
		TextNoteClassAttribute attr = (TextNoteClassAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "note-class" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextNoteClassAttribute</code> , See {@odf.attribute text:note-class}
	 *
	 * @param textNoteClassValue   The type is <code>String</code>
	 */
	public void setTextNoteClassAttribute( String textNoteClassValue )
	{
		TextNoteClassAttribute attr =  new TextNoteClassAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textNoteClassValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextIdAttribute</code> , See {@odf.attribute text:id}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextIdAttribute()
	{
		TextIdAttribute attr = (TextIdAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "id" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextIdAttribute</code> , See {@odf.attribute text:id}
	 *
	 * @param textIdValue   The type is <code>String</code>
	 */
	public void setTextIdAttribute( String textIdValue )
	{
		TextIdAttribute attr =  new TextIdAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textIdValue );
	}

	/**
	 * Create child element {@odf.element text:note-citation}.
	 *
	 * @return   return  the element {@odf.element text:note-citation}
	 * DifferentQName 
	 */
	public TextNoteCitationElement newTextNoteCitationElement()
	{
		TextNoteCitationElement  textNoteCitation = ((OdfFileDom)this.ownerDocument).newOdfElement(TextNoteCitationElement.class);
		this.appendChild( textNoteCitation);
		return  textNoteCitation;
	}                   
               
	/**
	 * Create child element {@odf.element text:note-body}.
	 *
	 * @return   return  the element {@odf.element text:note-body}
	 * DifferentQName 
	 */
	public TextNoteBodyElement newTextNoteBodyElement()
	{
		TextNoteBodyElement  textNoteBody = ((OdfFileDom)this.ownerDocument).newOdfElement(TextNoteBodyElement.class);
		this.appendChild( textNoteBody);
		return  textNoteBody;
	}                   
               
}
