/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.dom.attribute.text.TextBibliographyTypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextIdentifierAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextAddressAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextAnnoteAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextAuthorAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextBooktitleAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextChapterAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextEditionAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextEditorAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextHowpublishedAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextInstitutionAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextJournalAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextMonthAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextNoteAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextNumberAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextOrganizationsAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextPagesAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextPublisherAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextSchoolAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextSeriesAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextTitleAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextReportTypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextVolumeAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextYearAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextUrlAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextCustom1Attribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextCustom2Attribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextCustom3Attribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextCustom4Attribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextCustom5Attribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextIsbnAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextIssnAttribute;


/**
 * DOM implementation of OpenDocument element  {@odf.element text:bibliography-mark}.
 *
 */
public class TextBibliographyMarkElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.TEXT, "bibliography-mark" );


	/**
	 * Create the instance of <code>TextBibliographyMarkElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public TextBibliographyMarkElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element text:bibliography-mark}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}

	/**
	 * Initialization of the mandatory attributes of {@link  TextBibliographyMarkElement}
	 *
     * @param textBibliographyTypeAttributeValue  The mandatory attribute {@odf.attribute  text:bibliography-type}"
     * @param textIdentifierAttributeValue  The mandatory attribute {@odf.attribute  text:identifier}"
     * @param textAddressAttributeValue  The mandatory attribute {@odf.attribute  text:address}"
     * @param textAnnoteAttributeValue  The mandatory attribute {@odf.attribute  text:annote}"
     * @param textAuthorAttributeValue  The mandatory attribute {@odf.attribute  text:author}"
     * @param textBooktitleAttributeValue  The mandatory attribute {@odf.attribute  text:booktitle}"
     * @param textChapterAttributeValue  The mandatory attribute {@odf.attribute  text:chapter}"
     * @param textEditionAttributeValue  The mandatory attribute {@odf.attribute  text:edition}"
     * @param textEditorAttributeValue  The mandatory attribute {@odf.attribute  text:editor}"
     * @param textHowpublishedAttributeValue  The mandatory attribute {@odf.attribute  text:howpublished}"
     * @param textInstitutionAttributeValue  The mandatory attribute {@odf.attribute  text:institution}"
     * @param textJournalAttributeValue  The mandatory attribute {@odf.attribute  text:journal}"
     * @param textMonthAttributeValue  The mandatory attribute {@odf.attribute  text:month}"
     * @param textNoteAttributeValue  The mandatory attribute {@odf.attribute  text:note}"
     * @param textNumberAttributeValue  The mandatory attribute {@odf.attribute  text:number}"
     * @param textOrganizationsAttributeValue  The mandatory attribute {@odf.attribute  text:organizations}"
     * @param textPagesAttributeValue  The mandatory attribute {@odf.attribute  text:pages}"
     * @param textPublisherAttributeValue  The mandatory attribute {@odf.attribute  text:publisher}"
     * @param textSchoolAttributeValue  The mandatory attribute {@odf.attribute  text:school}"
     * @param textSeriesAttributeValue  The mandatory attribute {@odf.attribute  text:series}"
     * @param textTitleAttributeValue  The mandatory attribute {@odf.attribute  text:title}"
     * @param textReportTypeAttributeValue  The mandatory attribute {@odf.attribute  text:report-type}"
     * @param textVolumeAttributeValue  The mandatory attribute {@odf.attribute  text:volume}"
     * @param textYearAttributeValue  The mandatory attribute {@odf.attribute  text:year}"
     * @param textUrlAttributeValue  The mandatory attribute {@odf.attribute  text:url}"
     * @param textCustom1AttributeValue  The mandatory attribute {@odf.attribute  text:custom1}"
     * @param textCustom2AttributeValue  The mandatory attribute {@odf.attribute  text:custom2}"
     * @param textCustom3AttributeValue  The mandatory attribute {@odf.attribute  text:custom3}"
     * @param textCustom4AttributeValue  The mandatory attribute {@odf.attribute  text:custom4}"
     * @param textCustom5AttributeValue  The mandatory attribute {@odf.attribute  text:custom5}"
     * @param textIsbnAttributeValue  The mandatory attribute {@odf.attribute  text:isbn}"
     * @param textIssnAttributeValue  The mandatory attribute {@odf.attribute  text:issn}"
     *
	 */
	public void init(String textBibliographyTypeAttributeValue, String textIdentifierAttributeValue, String textAddressAttributeValue, String textAnnoteAttributeValue, String textAuthorAttributeValue, String textBooktitleAttributeValue, String textChapterAttributeValue, String textEditionAttributeValue, String textEditorAttributeValue, String textHowpublishedAttributeValue, String textInstitutionAttributeValue, String textJournalAttributeValue, String textMonthAttributeValue, String textNoteAttributeValue, String textNumberAttributeValue, String textOrganizationsAttributeValue, String textPagesAttributeValue, String textPublisherAttributeValue, String textSchoolAttributeValue, String textSeriesAttributeValue, String textTitleAttributeValue, String textReportTypeAttributeValue, String textVolumeAttributeValue, String textYearAttributeValue, String textUrlAttributeValue, String textCustom1AttributeValue, String textCustom2AttributeValue, String textCustom3AttributeValue, String textCustom4AttributeValue, String textCustom5AttributeValue, String textIsbnAttributeValue, String textIssnAttributeValue)
	{
		setTextBibliographyTypeAttribute( textBibliographyTypeAttributeValue );
		setTextIdentifierAttribute( textIdentifierAttributeValue );
		setTextAddressAttribute( textAddressAttributeValue );
		setTextAnnoteAttribute( textAnnoteAttributeValue );
		setTextAuthorAttribute( textAuthorAttributeValue );
		setTextBooktitleAttribute( textBooktitleAttributeValue );
		setTextChapterAttribute( textChapterAttributeValue );
		setTextEditionAttribute( textEditionAttributeValue );
		setTextEditorAttribute( textEditorAttributeValue );
		setTextHowpublishedAttribute( textHowpublishedAttributeValue );
		setTextInstitutionAttribute( textInstitutionAttributeValue );
		setTextJournalAttribute( textJournalAttributeValue );
		setTextMonthAttribute( textMonthAttributeValue );
		setTextNoteAttribute( textNoteAttributeValue );
		setTextNumberAttribute( textNumberAttributeValue );
		setTextOrganizationsAttribute( textOrganizationsAttributeValue );
		setTextPagesAttribute( textPagesAttributeValue );
		setTextPublisherAttribute( textPublisherAttributeValue );
		setTextSchoolAttribute( textSchoolAttributeValue );
		setTextSeriesAttribute( textSeriesAttributeValue );
		setTextTitleAttribute( textTitleAttributeValue );
		setTextReportTypeAttribute( textReportTypeAttributeValue );
		setTextVolumeAttribute( textVolumeAttributeValue );
		setTextYearAttribute( textYearAttributeValue );
		setTextUrlAttribute( textUrlAttributeValue );
		setTextCustom1Attribute( textCustom1AttributeValue );
		setTextCustom2Attribute( textCustom2AttributeValue );
		setTextCustom3Attribute( textCustom3AttributeValue );
		setTextCustom4Attribute( textCustom4AttributeValue );
		setTextCustom5Attribute( textCustom5AttributeValue );
		setTextIsbnAttribute( textIsbnAttributeValue );
		setTextIssnAttribute( textIssnAttributeValue );
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextBibliographyTypeAttribute</code> , See {@odf.attribute text:bibliography-type}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextBibliographyTypeAttribute()
	{
		TextBibliographyTypeAttribute attr = (TextBibliographyTypeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "bibliography-type" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextBibliographyTypeAttribute</code> , See {@odf.attribute text:bibliography-type}
	 *
	 * @param textBibliographyTypeValue   The type is <code>String</code>
	 */
	public void setTextBibliographyTypeAttribute( String textBibliographyTypeValue )
	{
		TextBibliographyTypeAttribute attr =  new TextBibliographyTypeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textBibliographyTypeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextIdentifierAttribute</code> , See {@odf.attribute text:identifier}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextIdentifierAttribute()
	{
		TextIdentifierAttribute attr = (TextIdentifierAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "identifier" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextIdentifierAttribute</code> , See {@odf.attribute text:identifier}
	 *
	 * @param textIdentifierValue   The type is <code>String</code>
	 */
	public void setTextIdentifierAttribute( String textIdentifierValue )
	{
		TextIdentifierAttribute attr =  new TextIdentifierAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textIdentifierValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextAddressAttribute</code> , See {@odf.attribute text:address}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextAddressAttribute()
	{
		TextAddressAttribute attr = (TextAddressAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "address" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextAddressAttribute</code> , See {@odf.attribute text:address}
	 *
	 * @param textAddressValue   The type is <code>String</code>
	 */
	public void setTextAddressAttribute( String textAddressValue )
	{
		TextAddressAttribute attr =  new TextAddressAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textAddressValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextAnnoteAttribute</code> , See {@odf.attribute text:annote}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextAnnoteAttribute()
	{
		TextAnnoteAttribute attr = (TextAnnoteAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "annote" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextAnnoteAttribute</code> , See {@odf.attribute text:annote}
	 *
	 * @param textAnnoteValue   The type is <code>String</code>
	 */
	public void setTextAnnoteAttribute( String textAnnoteValue )
	{
		TextAnnoteAttribute attr =  new TextAnnoteAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textAnnoteValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextAuthorAttribute</code> , See {@odf.attribute text:author}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextAuthorAttribute()
	{
		TextAuthorAttribute attr = (TextAuthorAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "author" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextAuthorAttribute</code> , See {@odf.attribute text:author}
	 *
	 * @param textAuthorValue   The type is <code>String</code>
	 */
	public void setTextAuthorAttribute( String textAuthorValue )
	{
		TextAuthorAttribute attr =  new TextAuthorAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textAuthorValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextBooktitleAttribute</code> , See {@odf.attribute text:booktitle}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextBooktitleAttribute()
	{
		TextBooktitleAttribute attr = (TextBooktitleAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "booktitle" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextBooktitleAttribute</code> , See {@odf.attribute text:booktitle}
	 *
	 * @param textBooktitleValue   The type is <code>String</code>
	 */
	public void setTextBooktitleAttribute( String textBooktitleValue )
	{
		TextBooktitleAttribute attr =  new TextBooktitleAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textBooktitleValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextChapterAttribute</code> , See {@odf.attribute text:chapter}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextChapterAttribute()
	{
		TextChapterAttribute attr = (TextChapterAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "chapter" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextChapterAttribute</code> , See {@odf.attribute text:chapter}
	 *
	 * @param textChapterValue   The type is <code>String</code>
	 */
	public void setTextChapterAttribute( String textChapterValue )
	{
		TextChapterAttribute attr =  new TextChapterAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textChapterValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextEditionAttribute</code> , See {@odf.attribute text:edition}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextEditionAttribute()
	{
		TextEditionAttribute attr = (TextEditionAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "edition" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextEditionAttribute</code> , See {@odf.attribute text:edition}
	 *
	 * @param textEditionValue   The type is <code>String</code>
	 */
	public void setTextEditionAttribute( String textEditionValue )
	{
		TextEditionAttribute attr =  new TextEditionAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textEditionValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextEditorAttribute</code> , See {@odf.attribute text:editor}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextEditorAttribute()
	{
		TextEditorAttribute attr = (TextEditorAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "editor" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextEditorAttribute</code> , See {@odf.attribute text:editor}
	 *
	 * @param textEditorValue   The type is <code>String</code>
	 */
	public void setTextEditorAttribute( String textEditorValue )
	{
		TextEditorAttribute attr =  new TextEditorAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textEditorValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextHowpublishedAttribute</code> , See {@odf.attribute text:howpublished}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextHowpublishedAttribute()
	{
		TextHowpublishedAttribute attr = (TextHowpublishedAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "howpublished" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextHowpublishedAttribute</code> , See {@odf.attribute text:howpublished}
	 *
	 * @param textHowpublishedValue   The type is <code>String</code>
	 */
	public void setTextHowpublishedAttribute( String textHowpublishedValue )
	{
		TextHowpublishedAttribute attr =  new TextHowpublishedAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textHowpublishedValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextInstitutionAttribute</code> , See {@odf.attribute text:institution}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextInstitutionAttribute()
	{
		TextInstitutionAttribute attr = (TextInstitutionAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "institution" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextInstitutionAttribute</code> , See {@odf.attribute text:institution}
	 *
	 * @param textInstitutionValue   The type is <code>String</code>
	 */
	public void setTextInstitutionAttribute( String textInstitutionValue )
	{
		TextInstitutionAttribute attr =  new TextInstitutionAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textInstitutionValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextJournalAttribute</code> , See {@odf.attribute text:journal}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextJournalAttribute()
	{
		TextJournalAttribute attr = (TextJournalAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "journal" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextJournalAttribute</code> , See {@odf.attribute text:journal}
	 *
	 * @param textJournalValue   The type is <code>String</code>
	 */
	public void setTextJournalAttribute( String textJournalValue )
	{
		TextJournalAttribute attr =  new TextJournalAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textJournalValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextMonthAttribute</code> , See {@odf.attribute text:month}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextMonthAttribute()
	{
		TextMonthAttribute attr = (TextMonthAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "month" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextMonthAttribute</code> , See {@odf.attribute text:month}
	 *
	 * @param textMonthValue   The type is <code>String</code>
	 */
	public void setTextMonthAttribute( String textMonthValue )
	{
		TextMonthAttribute attr =  new TextMonthAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textMonthValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextNoteAttribute</code> , See {@odf.attribute text:note}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextNoteAttribute()
	{
		TextNoteAttribute attr = (TextNoteAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "note" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextNoteAttribute</code> , See {@odf.attribute text:note}
	 *
	 * @param textNoteValue   The type is <code>String</code>
	 */
	public void setTextNoteAttribute( String textNoteValue )
	{
		TextNoteAttribute attr =  new TextNoteAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textNoteValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextNumberAttribute</code> , See {@odf.attribute text:number}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextNumberAttribute()
	{
		TextNumberAttribute attr = (TextNumberAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "number" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextNumberAttribute</code> , See {@odf.attribute text:number}
	 *
	 * @param textNumberValue   The type is <code>String</code>
	 */
	public void setTextNumberAttribute( String textNumberValue )
	{
		TextNumberAttribute attr =  new TextNumberAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textNumberValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextOrganizationsAttribute</code> , See {@odf.attribute text:organizations}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextOrganizationsAttribute()
	{
		TextOrganizationsAttribute attr = (TextOrganizationsAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "organizations" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextOrganizationsAttribute</code> , See {@odf.attribute text:organizations}
	 *
	 * @param textOrganizationsValue   The type is <code>String</code>
	 */
	public void setTextOrganizationsAttribute( String textOrganizationsValue )
	{
		TextOrganizationsAttribute attr =  new TextOrganizationsAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textOrganizationsValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextPagesAttribute</code> , See {@odf.attribute text:pages}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextPagesAttribute()
	{
		TextPagesAttribute attr = (TextPagesAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "pages" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextPagesAttribute</code> , See {@odf.attribute text:pages}
	 *
	 * @param textPagesValue   The type is <code>String</code>
	 */
	public void setTextPagesAttribute( String textPagesValue )
	{
		TextPagesAttribute attr =  new TextPagesAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textPagesValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextPublisherAttribute</code> , See {@odf.attribute text:publisher}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextPublisherAttribute()
	{
		TextPublisherAttribute attr = (TextPublisherAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "publisher" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextPublisherAttribute</code> , See {@odf.attribute text:publisher}
	 *
	 * @param textPublisherValue   The type is <code>String</code>
	 */
	public void setTextPublisherAttribute( String textPublisherValue )
	{
		TextPublisherAttribute attr =  new TextPublisherAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textPublisherValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextSchoolAttribute</code> , See {@odf.attribute text:school}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextSchoolAttribute()
	{
		TextSchoolAttribute attr = (TextSchoolAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "school" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextSchoolAttribute</code> , See {@odf.attribute text:school}
	 *
	 * @param textSchoolValue   The type is <code>String</code>
	 */
	public void setTextSchoolAttribute( String textSchoolValue )
	{
		TextSchoolAttribute attr =  new TextSchoolAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textSchoolValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextSeriesAttribute</code> , See {@odf.attribute text:series}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextSeriesAttribute()
	{
		TextSeriesAttribute attr = (TextSeriesAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "series" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextSeriesAttribute</code> , See {@odf.attribute text:series}
	 *
	 * @param textSeriesValue   The type is <code>String</code>
	 */
	public void setTextSeriesAttribute( String textSeriesValue )
	{
		TextSeriesAttribute attr =  new TextSeriesAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textSeriesValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextTitleAttribute</code> , See {@odf.attribute text:title}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextTitleAttribute()
	{
		TextTitleAttribute attr = (TextTitleAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "title" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextTitleAttribute</code> , See {@odf.attribute text:title}
	 *
	 * @param textTitleValue   The type is <code>String</code>
	 */
	public void setTextTitleAttribute( String textTitleValue )
	{
		TextTitleAttribute attr =  new TextTitleAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textTitleValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextReportTypeAttribute</code> , See {@odf.attribute text:report-type}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextReportTypeAttribute()
	{
		TextReportTypeAttribute attr = (TextReportTypeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "report-type" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextReportTypeAttribute</code> , See {@odf.attribute text:report-type}
	 *
	 * @param textReportTypeValue   The type is <code>String</code>
	 */
	public void setTextReportTypeAttribute( String textReportTypeValue )
	{
		TextReportTypeAttribute attr =  new TextReportTypeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textReportTypeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextVolumeAttribute</code> , See {@odf.attribute text:volume}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextVolumeAttribute()
	{
		TextVolumeAttribute attr = (TextVolumeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "volume" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextVolumeAttribute</code> , See {@odf.attribute text:volume}
	 *
	 * @param textVolumeValue   The type is <code>String</code>
	 */
	public void setTextVolumeAttribute( String textVolumeValue )
	{
		TextVolumeAttribute attr =  new TextVolumeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textVolumeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextYearAttribute</code> , See {@odf.attribute text:year}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextYearAttribute()
	{
		TextYearAttribute attr = (TextYearAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "year" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextYearAttribute</code> , See {@odf.attribute text:year}
	 *
	 * @param textYearValue   The type is <code>String</code>
	 */
	public void setTextYearAttribute( String textYearValue )
	{
		TextYearAttribute attr =  new TextYearAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textYearValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextUrlAttribute</code> , See {@odf.attribute text:url}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextUrlAttribute()
	{
		TextUrlAttribute attr = (TextUrlAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "url" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextUrlAttribute</code> , See {@odf.attribute text:url}
	 *
	 * @param textUrlValue   The type is <code>String</code>
	 */
	public void setTextUrlAttribute( String textUrlValue )
	{
		TextUrlAttribute attr =  new TextUrlAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textUrlValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextCustom1Attribute</code> , See {@odf.attribute text:custom1}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextCustom1Attribute()
	{
		TextCustom1Attribute attr = (TextCustom1Attribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "custom1" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextCustom1Attribute</code> , See {@odf.attribute text:custom1}
	 *
	 * @param textCustom1Value   The type is <code>String</code>
	 */
	public void setTextCustom1Attribute( String textCustom1Value )
	{
		TextCustom1Attribute attr =  new TextCustom1Attribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textCustom1Value );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextCustom2Attribute</code> , See {@odf.attribute text:custom2}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextCustom2Attribute()
	{
		TextCustom2Attribute attr = (TextCustom2Attribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "custom2" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextCustom2Attribute</code> , See {@odf.attribute text:custom2}
	 *
	 * @param textCustom2Value   The type is <code>String</code>
	 */
	public void setTextCustom2Attribute( String textCustom2Value )
	{
		TextCustom2Attribute attr =  new TextCustom2Attribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textCustom2Value );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextCustom3Attribute</code> , See {@odf.attribute text:custom3}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextCustom3Attribute()
	{
		TextCustom3Attribute attr = (TextCustom3Attribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "custom3" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextCustom3Attribute</code> , See {@odf.attribute text:custom3}
	 *
	 * @param textCustom3Value   The type is <code>String</code>
	 */
	public void setTextCustom3Attribute( String textCustom3Value )
	{
		TextCustom3Attribute attr =  new TextCustom3Attribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textCustom3Value );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextCustom4Attribute</code> , See {@odf.attribute text:custom4}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextCustom4Attribute()
	{
		TextCustom4Attribute attr = (TextCustom4Attribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "custom4" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextCustom4Attribute</code> , See {@odf.attribute text:custom4}
	 *
	 * @param textCustom4Value   The type is <code>String</code>
	 */
	public void setTextCustom4Attribute( String textCustom4Value )
	{
		TextCustom4Attribute attr =  new TextCustom4Attribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textCustom4Value );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextCustom5Attribute</code> , See {@odf.attribute text:custom5}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextCustom5Attribute()
	{
		TextCustom5Attribute attr = (TextCustom5Attribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "custom5" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextCustom5Attribute</code> , See {@odf.attribute text:custom5}
	 *
	 * @param textCustom5Value   The type is <code>String</code>
	 */
	public void setTextCustom5Attribute( String textCustom5Value )
	{
		TextCustom5Attribute attr =  new TextCustom5Attribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textCustom5Value );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextIsbnAttribute</code> , See {@odf.attribute text:isbn}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextIsbnAttribute()
	{
		TextIsbnAttribute attr = (TextIsbnAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "isbn" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextIsbnAttribute</code> , See {@odf.attribute text:isbn}
	 *
	 * @param textIsbnValue   The type is <code>String</code>
	 */
	public void setTextIsbnAttribute( String textIsbnValue )
	{
		TextIsbnAttribute attr =  new TextIsbnAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textIsbnValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextIssnAttribute</code> , See {@odf.attribute text:issn}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextIssnAttribute()
	{
		TextIssnAttribute attr = (TextIssnAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "issn" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextIssnAttribute</code> , See {@odf.attribute text:issn}
	 *
	 * @param textIssnValue   The type is <code>String</code>
	 */
	public void setTextIssnAttribute( String textIssnValue )
	{
		TextIssnAttribute attr =  new TextIssnAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textIssnValue );
	}

}
