/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeTitleAttribute;
import org.odftoolkit.odfdom.dom.attribute.xlink.XlinkTypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.xlink.XlinkHrefAttribute;
import org.odftoolkit.odfdom.dom.attribute.xlink.XlinkActuateAttribute;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeTargetFrameNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.xlink.XlinkShowAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextVisitedStyleNameAttribute;

import org.odftoolkit.odfdom.dom.element.office.OfficeEventListenersElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeAnnotationElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeAnnotationEndElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawRectElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawLineElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawPolylineElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawPolygonElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawRegularPolygonElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawPathElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawCircleElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawEllipseElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawGElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawPageThumbnailElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawMeasureElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawCaptionElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawConnectorElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawControlElement;
import org.odftoolkit.odfdom.dom.element.dr3d.Dr3dSceneElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawCustomShapeElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawAElement;
import org.odftoolkit.odfdom.dom.element.presentation.PresentationHeaderElement;
import org.odftoolkit.odfdom.dom.element.presentation.PresentationFooterElement;
import org.odftoolkit.odfdom.dom.element.presentation.PresentationDateTimeElement;

/**
 * DOM implementation of OpenDocument element  {@odf.element text:a}.
 *
 */
public class TextAElement extends OdfStylableElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.TEXT, "a" );

	/**
	 * The value set of {@odf.attribute xlink:actuate}.
	 */
	 public enum XlinkActuateAttributeValue {
	 
	 ONREQUEST( XlinkActuateAttribute.Value.ONREQUEST.toString() );
              
		private String mValue;
	 	
		XlinkActuateAttributeValue( String value )
		{
			mValue = value;
		}
		
		@Override
		public String toString()
		{
			return mValue;
		}
		
		public static XlinkActuateAttributeValue enumValueOf( String value )
	    {
	        for( XlinkActuateAttributeValue aIter : values() )
	        {
	            if( value.equals( aIter.toString() ) )
	            {
	                return aIter;
	            }
	        }
	        return null;
	    }
	}
	/**
	 * The value set of {@odf.attribute xlink:show}.
	 */
	 public enum XlinkShowAttributeValue {
	 
	 NEW( XlinkShowAttribute.Value.NEW.toString() ), REPLACE( XlinkShowAttribute.Value.REPLACE.toString() );
              
		private String mValue;
	 	
		XlinkShowAttributeValue( String value )
		{
			mValue = value;
		}
		
		@Override
		public String toString()
		{
			return mValue;
		}
		
		public static XlinkShowAttributeValue enumValueOf( String value )
	    {
	        for( XlinkShowAttributeValue aIter : values() )
	        {
	            if( value.equals( aIter.toString() ) )
	            {
	                return aIter;
	            }
	        }
	        return null;
	    }
	}
	public static final String  DEFAULT_VALUE_XLINK_ACTUATE_ATTRIBUTE = XlinkActuateAttribute.Value.ONREQUEST.toString();

	/**
	 * Create the instance of <code>TextAElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public TextAElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME, OdfStyleFamily.Text, OdfName.newName(OdfNamespaceNames.TEXT, "style-name" )	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element text:a}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}

	/**
	 * Initialization of the mandatory attributes of {@link  TextAElement}
	 *
     * @param xlinkTypeAttributeValue  The mandatory attribute {@odf.attribute  xlink:type}"
     * @param xlinkHrefAttributeValue  The mandatory attribute {@odf.attribute  xlink:href}"
     *
	 */
	public void init(String xlinkTypeAttributeValue, String xlinkHrefAttributeValue)
	{
		setXlinkTypeAttribute( xlinkTypeAttributeValue );
		setXlinkHrefAttribute( xlinkHrefAttributeValue );
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>OfficeNameAttribute</code> , See {@odf.attribute office:name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getOfficeNameAttribute()
	{
		OfficeNameAttribute attr = (OfficeNameAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.OFFICE), "name" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>OfficeNameAttribute</code> , See {@odf.attribute office:name}
	 *
	 * @param officeNameValue   The type is <code>String</code>
	 */
	public void setOfficeNameAttribute( String officeNameValue )
	{
		OfficeNameAttribute attr =  new OfficeNameAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( officeNameValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>OfficeTitleAttribute</code> , See {@odf.attribute office:title}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getOfficeTitleAttribute()
	{
		OfficeTitleAttribute attr = (OfficeTitleAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.OFFICE), "title" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>OfficeTitleAttribute</code> , See {@odf.attribute office:title}
	 *
	 * @param officeTitleValue   The type is <code>String</code>
	 */
	public void setOfficeTitleAttribute( String officeTitleValue )
	{
		OfficeTitleAttribute attr =  new OfficeTitleAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( officeTitleValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>XlinkTypeAttribute</code> , See {@odf.attribute xlink:type}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getXlinkTypeAttribute()
	{
		XlinkTypeAttribute attr = (XlinkTypeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.XLINK), "type" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return XlinkTypeAttribute.DEFAULT_VALUE;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>XlinkTypeAttribute</code> , See {@odf.attribute xlink:type}
	 *
	 * @param xlinkTypeValue   The type is <code>String</code>
	 */
	public void setXlinkTypeAttribute( String xlinkTypeValue )
	{
		XlinkTypeAttribute attr =  new XlinkTypeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( xlinkTypeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>XlinkHrefAttribute</code> , See {@odf.attribute xlink:href}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getXlinkHrefAttribute()
	{
		XlinkHrefAttribute attr = (XlinkHrefAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.XLINK), "href" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>XlinkHrefAttribute</code> , See {@odf.attribute xlink:href}
	 *
	 * @param xlinkHrefValue   The type is <code>String</code>
	 */
	public void setXlinkHrefAttribute( String xlinkHrefValue )
	{
		XlinkHrefAttribute attr =  new XlinkHrefAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( xlinkHrefValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>XlinkActuateAttribute</code> , See {@odf.attribute xlink:actuate}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getXlinkActuateAttribute()
	{
		XlinkActuateAttribute attr = (XlinkActuateAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.XLINK), "actuate" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return DEFAULT_VALUE_XLINK_ACTUATE_ATTRIBUTE;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>XlinkActuateAttribute</code> , See {@odf.attribute xlink:actuate}
	 *
	 * @param xlinkActuateValue   The type is <code>String</code>
	 */
	public void setXlinkActuateAttribute( String xlinkActuateValue )
	{
		XlinkActuateAttribute attr =  new XlinkActuateAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( xlinkActuateValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>OfficeTargetFrameNameAttribute</code> , See {@odf.attribute office:target-frame-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getOfficeTargetFrameNameAttribute()
	{
		OfficeTargetFrameNameAttribute attr = (OfficeTargetFrameNameAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.OFFICE), "target-frame-name" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>OfficeTargetFrameNameAttribute</code> , See {@odf.attribute office:target-frame-name}
	 *
	 * @param officeTargetFrameNameValue   The type is <code>String</code>
	 */
	public void setOfficeTargetFrameNameAttribute( String officeTargetFrameNameValue )
	{
		OfficeTargetFrameNameAttribute attr =  new OfficeTargetFrameNameAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( officeTargetFrameNameValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>XlinkShowAttribute</code> , See {@odf.attribute xlink:show}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getXlinkShowAttribute()
	{
		XlinkShowAttribute attr = (XlinkShowAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.XLINK), "show" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>XlinkShowAttribute</code> , See {@odf.attribute xlink:show}
	 *
	 * @param xlinkShowValue   The type is <code>String</code>
	 */
	public void setXlinkShowAttribute( String xlinkShowValue )
	{
		XlinkShowAttribute attr =  new XlinkShowAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( xlinkShowValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextStyleNameAttribute</code> , See {@odf.attribute text:style-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextStyleNameAttribute()
	{
		TextStyleNameAttribute attr = (TextStyleNameAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "style-name" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextStyleNameAttribute</code> , See {@odf.attribute text:style-name}
	 *
	 * @param textStyleNameValue   The type is <code>String</code>
	 */
	public void setTextStyleNameAttribute( String textStyleNameValue )
	{
		TextStyleNameAttribute attr =  new TextStyleNameAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textStyleNameValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextVisitedStyleNameAttribute</code> , See {@odf.attribute text:visited-style-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextVisitedStyleNameAttribute()
	{
		TextVisitedStyleNameAttribute attr = (TextVisitedStyleNameAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "visited-style-name" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextVisitedStyleNameAttribute</code> , See {@odf.attribute text:visited-style-name}
	 *
	 * @param textVisitedStyleNameValue   The type is <code>String</code>
	 */
	public void setTextVisitedStyleNameAttribute( String textVisitedStyleNameValue )
	{
		TextVisitedStyleNameAttribute attr =  new TextVisitedStyleNameAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textVisitedStyleNameValue );
	}

	/**
	 * Create child element {@odf.element office:event-listeners}.
	 *
	 * @return   return  the element {@odf.element office:event-listeners}
	 * DifferentQName 
	 */
	public OfficeEventListenersElement newOfficeEventListenersElement()
	{
		OfficeEventListenersElement  officeEventListeners = ((OdfFileDom)this.ownerDocument).newOdfElement(OfficeEventListenersElement.class);
		this.appendChild( officeEventListeners);
		return  officeEventListeners;
	}                   
               
	/**
	 * Create child element {@odf.element text:s}.
	 *
	 * @return   return  the element {@odf.element text:s}
	 * DifferentQName 
	 */
	public TextSElement newTextSElement()
	{
		TextSElement  textS = ((OdfFileDom)this.ownerDocument).newOdfElement(TextSElement.class);
		this.appendChild( textS);
		return  textS;
	}                   
               
	/**
	 * Create child element {@odf.element text:tab}.
	 *
	 * @return   return  the element {@odf.element text:tab}
	 * DifferentQName 
	 */
	public TextTabElement newTextTabElement()
	{
		TextTabElement  textTab = ((OdfFileDom)this.ownerDocument).newOdfElement(TextTabElement.class);
		this.appendChild( textTab);
		return  textTab;
	}                   
               
	/**
	 * Create child element {@odf.element text:line-break}.
	 *
	 * @return   return  the element {@odf.element text:line-break}
	 * DifferentQName 
	 */
	public TextLineBreakElement newTextLineBreakElement()
	{
		TextLineBreakElement  textLineBreak = ((OdfFileDom)this.ownerDocument).newOdfElement(TextLineBreakElement.class);
		this.appendChild( textLineBreak);
		return  textLineBreak;
	}                   
               
	/**
	 * Create child element {@odf.element text:soft-page-break}.
	 *
	 * @return   return  the element {@odf.element text:soft-page-break}
	 * DifferentQName 
	 */
	public TextSoftPageBreakElement newTextSoftPageBreakElement()
	{
		TextSoftPageBreakElement  textSoftPageBreak = ((OdfFileDom)this.ownerDocument).newOdfElement(TextSoftPageBreakElement.class);
		this.appendChild( textSoftPageBreak);
		return  textSoftPageBreak;
	}                   
               
	/**
	 * Create child element {@odf.element text:span}.
	 *
	 * @return   return  the element {@odf.element text:span}
	 * DifferentQName 
	 */
	public TextSpanElement newTextSpanElement()
	{
		TextSpanElement  textSpan = ((OdfFileDom)this.ownerDocument).newOdfElement(TextSpanElement.class);
		this.appendChild( textSpan);
		return  textSpan;
	}                   
               
	/**
	 * Create child element {@odf.element text:meta}.
	 *
	 * @return   return  the element {@odf.element text:meta}
	 * DifferentQName 
	 */
	public TextMetaElement newTextMetaElement()
	{
		TextMetaElement  textMeta = ((OdfFileDom)this.ownerDocument).newOdfElement(TextMetaElement.class);
		this.appendChild( textMeta);
		return  textMeta;
	}                   
               
	/**
	 * Create child element {@odf.element text:bookmark}.
	 *
     * @param textNameAttributeValue  the <code>String</code> value of <code>TextNameAttribute</code>, see {@odf.attribute  text:name} at specification
	 * @return   return  the element {@odf.element text:bookmark}
	 * DifferentQName 
	 */
    
	public TextBookmarkElement newTextBookmarkElement(String textNameAttributeValue)
	{
		TextBookmarkElement  textBookmark = ((OdfFileDom)this.ownerDocument).newOdfElement(TextBookmarkElement.class);
		textBookmark.setTextNameAttribute( textNameAttributeValue );
		this.appendChild( textBookmark);
		return  textBookmark;      
	}
    
	/**
	 * Create child element {@odf.element text:bookmark-start}.
	 *
     * @param textNameAttributeValue  the <code>String</code> value of <code>TextNameAttribute</code>, see {@odf.attribute  text:name} at specification
	 * @return   return  the element {@odf.element text:bookmark-start}
	 * DifferentQName 
	 */
    
	public TextBookmarkStartElement newTextBookmarkStartElement(String textNameAttributeValue)
	{
		TextBookmarkStartElement  textBookmarkStart = ((OdfFileDom)this.ownerDocument).newOdfElement(TextBookmarkStartElement.class);
		textBookmarkStart.setTextNameAttribute( textNameAttributeValue );
		this.appendChild( textBookmarkStart);
		return  textBookmarkStart;      
	}
    
	/**
	 * Create child element {@odf.element text:bookmark-end}.
	 *
     * @param textNameAttributeValue  the <code>String</code> value of <code>TextNameAttribute</code>, see {@odf.attribute  text:name} at specification
	 * @return   return  the element {@odf.element text:bookmark-end}
	 * DifferentQName 
	 */
    
	public TextBookmarkEndElement newTextBookmarkEndElement(String textNameAttributeValue)
	{
		TextBookmarkEndElement  textBookmarkEnd = ((OdfFileDom)this.ownerDocument).newOdfElement(TextBookmarkEndElement.class);
		textBookmarkEnd.setTextNameAttribute( textNameAttributeValue );
		this.appendChild( textBookmarkEnd);
		return  textBookmarkEnd;      
	}
    
	/**
	 * Create child element {@odf.element text:reference-mark}.
	 *
     * @param textNameAttributeValue  the <code>String</code> value of <code>TextNameAttribute</code>, see {@odf.attribute  text:name} at specification
	 * @return   return  the element {@odf.element text:reference-mark}
	 * DifferentQName 
	 */
    
	public TextReferenceMarkElement newTextReferenceMarkElement(String textNameAttributeValue)
	{
		TextReferenceMarkElement  textReferenceMark = ((OdfFileDom)this.ownerDocument).newOdfElement(TextReferenceMarkElement.class);
		textReferenceMark.setTextNameAttribute( textNameAttributeValue );
		this.appendChild( textReferenceMark);
		return  textReferenceMark;      
	}
    
	/**
	 * Create child element {@odf.element text:note}.
	 *
     * @param textNoteClassAttributeValue  the <code>String</code> value of <code>TextNoteClassAttribute</code>, see {@odf.attribute  text:note-class} at specification
	 * @return   return  the element {@odf.element text:note}
	 * DifferentQName 
	 */
    
	public TextNoteElement newTextNoteElement(String textNoteClassAttributeValue)
	{
		TextNoteElement  textNote = ((OdfFileDom)this.ownerDocument).newOdfElement(TextNoteElement.class);
		textNote.setTextNoteClassAttribute( textNoteClassAttributeValue );
		this.appendChild( textNote);
		return  textNote;      
	}
    
	/**
	 * Create child element {@odf.element text:ruby}.
	 *
	 * @return   return  the element {@odf.element text:ruby}
	 * DifferentQName 
	 */
	public TextRubyElement newTextRubyElement()
	{
		TextRubyElement  textRuby = ((OdfFileDom)this.ownerDocument).newOdfElement(TextRubyElement.class);
		this.appendChild( textRuby);
		return  textRuby;
	}                   
               
	/**
	 * Create child element {@odf.element office:annotation}.
	 *
	 * @return   return  the element {@odf.element office:annotation}
	 * DifferentQName 
	 */
	public OfficeAnnotationElement newOfficeAnnotationElement()
	{
		OfficeAnnotationElement  officeAnnotation = ((OdfFileDom)this.ownerDocument).newOdfElement(OfficeAnnotationElement.class);
		this.appendChild( officeAnnotation);
		return  officeAnnotation;
	}                   
               
	/**
	 * Create child element {@odf.element office:annotation-end}.
	 *
     * @param officeNameAttributeValue  the <code>String</code> value of <code>OfficeNameAttribute</code>, see {@odf.attribute  office:name} at specification
	 * @return   return  the element {@odf.element office:annotation-end}
	 * DifferentQName 
	 */
    
	public OfficeAnnotationEndElement newOfficeAnnotationEndElement(String officeNameAttributeValue)
	{
		OfficeAnnotationEndElement  officeAnnotationEnd = ((OdfFileDom)this.ownerDocument).newOdfElement(OfficeAnnotationEndElement.class);
		officeAnnotationEnd.setOfficeNameAttribute( officeNameAttributeValue );
		this.appendChild( officeAnnotationEnd);
		return  officeAnnotationEnd;      
	}
    
	/**
	 * Create child element {@odf.element draw:rect}.
	 *
	 * @return   return  the element {@odf.element draw:rect}
	 * DifferentQName 
	 */
	public DrawRectElement newDrawRectElement()
	{
		DrawRectElement  drawRect = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawRectElement.class);
		this.appendChild( drawRect);
		return  drawRect;
	}                   
               
	/**
	 * Create child element {@odf.element draw:line}.
	 *
     * @param svgX1AttributeValue  the <code>String</code> value of <code>SvgX1Attribute</code>, see {@odf.attribute  svg:x1} at specification
	 * @param svgX2AttributeValue  the <code>String</code> value of <code>SvgX2Attribute</code>, see {@odf.attribute  svg:x2} at specification
	 * @param svgY1AttributeValue  the <code>String</code> value of <code>SvgY1Attribute</code>, see {@odf.attribute  svg:y1} at specification
	 * @param svgY2AttributeValue  the <code>String</code> value of <code>SvgY2Attribute</code>, see {@odf.attribute  svg:y2} at specification
	 * @return   return  the element {@odf.element draw:line}
	 * DifferentQName 
	 */
    
	public DrawLineElement newDrawLineElement(String svgX1AttributeValue, String svgX2AttributeValue, String svgY1AttributeValue, String svgY2AttributeValue)
	{
		DrawLineElement  drawLine = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawLineElement.class);
		drawLine.setSvgX1Attribute( svgX1AttributeValue );
		drawLine.setSvgX2Attribute( svgX2AttributeValue );
		drawLine.setSvgY1Attribute( svgY1AttributeValue );
		drawLine.setSvgY2Attribute( svgY2AttributeValue );
		this.appendChild( drawLine);
		return  drawLine;      
	}
    
	/**
	 * Create child element {@odf.element draw:polyline}.
	 *
     * @param drawPointsAttributeValue  the <code>String</code> value of <code>DrawPointsAttribute</code>, see {@odf.attribute  draw:points} at specification
	 * @param svgViewBoxAttributeValue  the <code>String</code> value of <code>SvgViewBoxAttribute</code>, see {@odf.attribute  svg:viewBox} at specification
	 * @return   return  the element {@odf.element draw:polyline}
	 * DifferentQName 
	 */
    
	public DrawPolylineElement newDrawPolylineElement(String drawPointsAttributeValue, String svgViewBoxAttributeValue)
	{
		DrawPolylineElement  drawPolyline = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawPolylineElement.class);
		drawPolyline.setDrawPointsAttribute( drawPointsAttributeValue );
		drawPolyline.setSvgViewBoxAttribute( svgViewBoxAttributeValue );
		this.appendChild( drawPolyline);
		return  drawPolyline;      
	}
    
	/**
	 * Create child element {@odf.element draw:polygon}.
	 *
     * @param drawPointsAttributeValue  the <code>String</code> value of <code>DrawPointsAttribute</code>, see {@odf.attribute  draw:points} at specification
	 * @param svgViewBoxAttributeValue  the <code>String</code> value of <code>SvgViewBoxAttribute</code>, see {@odf.attribute  svg:viewBox} at specification
	 * @return   return  the element {@odf.element draw:polygon}
	 * DifferentQName 
	 */
    
	public DrawPolygonElement newDrawPolygonElement(String drawPointsAttributeValue, String svgViewBoxAttributeValue)
	{
		DrawPolygonElement  drawPolygon = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawPolygonElement.class);
		drawPolygon.setDrawPointsAttribute( drawPointsAttributeValue );
		drawPolygon.setSvgViewBoxAttribute( svgViewBoxAttributeValue );
		this.appendChild( drawPolygon);
		return  drawPolygon;      
	}
    
	/**
	 * Create child element {@odf.element draw:regular-polygon}.
	 *
     * @param drawConcaveAttributeValue  the <code>boolean</code> value of <code>DrawConcaveAttribute</code>, see {@odf.attribute  draw:concave} at specification
	 * @param drawCornersAttributeValue  the <code>int</code> value of <code>DrawCornersAttribute</code>, see {@odf.attribute  draw:corners} at specification
	 * @return   return  the element {@odf.element draw:regular-polygon}
	 * DifferentQName 
	 */
    
	public DrawRegularPolygonElement newDrawRegularPolygonElement(boolean drawConcaveAttributeValue, int drawCornersAttributeValue)
	{
		DrawRegularPolygonElement  drawRegularPolygon = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawRegularPolygonElement.class);
		drawRegularPolygon.setDrawConcaveAttribute( Boolean.valueOf(drawConcaveAttributeValue) );
		drawRegularPolygon.setDrawCornersAttribute( Integer.valueOf(drawCornersAttributeValue) );
		this.appendChild( drawRegularPolygon);
		return  drawRegularPolygon;      
	}
    
	/**
	 * Create child element {@odf.element draw:path}.
	 *
     * @param svgDAttributeValue  the <code>String</code> value of <code>SvgDAttribute</code>, see {@odf.attribute  svg:d} at specification
	 * @param svgViewBoxAttributeValue  the <code>String</code> value of <code>SvgViewBoxAttribute</code>, see {@odf.attribute  svg:viewBox} at specification
	 * @return   return  the element {@odf.element draw:path}
	 * DifferentQName 
	 */
    
	public DrawPathElement newDrawPathElement(String svgDAttributeValue, String svgViewBoxAttributeValue)
	{
		DrawPathElement  drawPath = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawPathElement.class);
		drawPath.setSvgDAttribute( svgDAttributeValue );
		drawPath.setSvgViewBoxAttribute( svgViewBoxAttributeValue );
		this.appendChild( drawPath);
		return  drawPath;      
	}
    
	/**
	 * Create child element {@odf.element draw:circle}.
	 *
	 * @return   return  the element {@odf.element draw:circle}
	 * DifferentQName 
	 */
	public DrawCircleElement newDrawCircleElement()
	{
		DrawCircleElement  drawCircle = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawCircleElement.class);
		this.appendChild( drawCircle);
		return  drawCircle;
	}                   
               
	/**
	 * Create child element {@odf.element draw:ellipse}.
	 *
	 * @return   return  the element {@odf.element draw:ellipse}
	 * DifferentQName 
	 */
	public DrawEllipseElement newDrawEllipseElement()
	{
		DrawEllipseElement  drawEllipse = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawEllipseElement.class);
		this.appendChild( drawEllipse);
		return  drawEllipse;
	}                   
               
	/**
	 * Create child element {@odf.element draw:g}.
	 *
	 * @return   return  the element {@odf.element draw:g}
	 * DifferentQName 
	 */
	public DrawGElement newDrawGElement()
	{
		DrawGElement  drawG = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawGElement.class);
		this.appendChild( drawG);
		return  drawG;
	}                   
               
	/**
	 * Create child element {@odf.element draw:page-thumbnail}.
	 *
	 * @return   return  the element {@odf.element draw:page-thumbnail}
	 * DifferentQName 
	 */
	public DrawPageThumbnailElement newDrawPageThumbnailElement()
	{
		DrawPageThumbnailElement  drawPageThumbnail = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawPageThumbnailElement.class);
		this.appendChild( drawPageThumbnail);
		return  drawPageThumbnail;
	}                   
               
	/**
	 * Create child element {@odf.element draw:frame}.
	 *
	 * @return   return  the element {@odf.element draw:frame}
	 * DifferentQName 
	 */
	public DrawFrameElement newDrawFrameElement()
	{
		DrawFrameElement  drawFrame = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawFrameElement.class);
		this.appendChild( drawFrame);
		return  drawFrame;
	}                   
               
	/**
	 * Create child element {@odf.element draw:measure}.
	 *
     * @param svgX1AttributeValue  the <code>String</code> value of <code>SvgX1Attribute</code>, see {@odf.attribute  svg:x1} at specification
	 * @param svgX2AttributeValue  the <code>String</code> value of <code>SvgX2Attribute</code>, see {@odf.attribute  svg:x2} at specification
	 * @param svgY1AttributeValue  the <code>String</code> value of <code>SvgY1Attribute</code>, see {@odf.attribute  svg:y1} at specification
	 * @param svgY2AttributeValue  the <code>String</code> value of <code>SvgY2Attribute</code>, see {@odf.attribute  svg:y2} at specification
	 * @return   return  the element {@odf.element draw:measure}
	 * DifferentQName 
	 */
    
	public DrawMeasureElement newDrawMeasureElement(String svgX1AttributeValue, String svgX2AttributeValue, String svgY1AttributeValue, String svgY2AttributeValue)
	{
		DrawMeasureElement  drawMeasure = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawMeasureElement.class);
		drawMeasure.setSvgX1Attribute( svgX1AttributeValue );
		drawMeasure.setSvgX2Attribute( svgX2AttributeValue );
		drawMeasure.setSvgY1Attribute( svgY1AttributeValue );
		drawMeasure.setSvgY2Attribute( svgY2AttributeValue );
		this.appendChild( drawMeasure);
		return  drawMeasure;      
	}
    
	/**
	 * Create child element {@odf.element draw:caption}.
	 *
	 * @return   return  the element {@odf.element draw:caption}
	 * DifferentQName 
	 */
	public DrawCaptionElement newDrawCaptionElement()
	{
		DrawCaptionElement  drawCaption = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawCaptionElement.class);
		this.appendChild( drawCaption);
		return  drawCaption;
	}                   
               
	/**
	 * Create child element {@odf.element draw:connector}.
	 *
     * @param svgViewBoxAttributeValue  the <code>String</code> value of <code>SvgViewBoxAttribute</code>, see {@odf.attribute  svg:viewBox} at specification
	 * @return   return  the element {@odf.element draw:connector}
	 * DifferentQName 
	 */
    
	public DrawConnectorElement newDrawConnectorElement(String svgViewBoxAttributeValue)
	{
		DrawConnectorElement  drawConnector = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawConnectorElement.class);
		drawConnector.setSvgViewBoxAttribute( svgViewBoxAttributeValue );
		this.appendChild( drawConnector);
		return  drawConnector;      
	}
    
	/**
	 * Create child element {@odf.element draw:control}.
	 *
     * @param drawControlAttributeValue  the <code>String</code> value of <code>DrawControlAttribute</code>, see {@odf.attribute  draw:control} at specification
	 * @return   return  the element {@odf.element draw:control}
	 * DifferentQName 
	 */
    
	public DrawControlElement newDrawControlElement(String drawControlAttributeValue)
	{
		DrawControlElement  drawControl = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawControlElement.class);
		drawControl.setDrawControlAttribute( drawControlAttributeValue );
		this.appendChild( drawControl);
		return  drawControl;      
	}
    
	/**
	 * Create child element {@odf.element dr3d:scene}.
	 *
	 * @return   return  the element {@odf.element dr3d:scene}
	 * DifferentQName 
	 */
	public Dr3dSceneElement newDr3dSceneElement()
	{
		Dr3dSceneElement  dr3dScene = ((OdfFileDom)this.ownerDocument).newOdfElement(Dr3dSceneElement.class);
		this.appendChild( dr3dScene);
		return  dr3dScene;
	}                   
               
	/**
	 * Create child element {@odf.element draw:custom-shape}.
	 *
	 * @return   return  the element {@odf.element draw:custom-shape}
	 * DifferentQName 
	 */
	public DrawCustomShapeElement newDrawCustomShapeElement()
	{
		DrawCustomShapeElement  drawCustomShape = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawCustomShapeElement.class);
		this.appendChild( drawCustomShape);
		return  drawCustomShape;
	}                   
               
	/**
	 * Create child element {@odf.element draw:a}.
	 *
     * @param xlinkHrefAttributeValue  the <code>String</code> value of <code>XlinkHrefAttribute</code>, see {@odf.attribute  xlink:href} at specification
	 * @param xlinkTypeAttributeValue  the <code>String</code> value of <code>XlinkTypeAttribute</code>, see {@odf.attribute  xlink:type} at specification
	 * @return   return  the element {@odf.element draw:a}
	 * DifferentQName 
	 */
    
	public DrawAElement newDrawAElement(String xlinkHrefAttributeValue, String xlinkTypeAttributeValue)
	{
		DrawAElement  drawA = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawAElement.class);
		drawA.setXlinkHrefAttribute( xlinkHrefAttributeValue );
		drawA.setXlinkTypeAttribute( xlinkTypeAttributeValue );
		this.appendChild( drawA);
		return  drawA;      
	}
    
	/**
	 * Create child element {@odf.element text:date}.
	 *
	 * @return   return  the element {@odf.element text:date}
	 * DifferentQName 
	 */
	public TextDateElement newTextDateElement()
	{
		TextDateElement  textDate = ((OdfFileDom)this.ownerDocument).newOdfElement(TextDateElement.class);
		this.appendChild( textDate);
		return  textDate;
	}                   
               
	/**
	 * Create child element {@odf.element text:time}.
	 *
	 * @return   return  the element {@odf.element text:time}
	 * DifferentQName 
	 */
	public TextTimeElement newTextTimeElement()
	{
		TextTimeElement  textTime = ((OdfFileDom)this.ownerDocument).newOdfElement(TextTimeElement.class);
		this.appendChild( textTime);
		return  textTime;
	}                   
               
	/**
	 * Create child element {@odf.element text:page-number}.
	 *
	 * @return   return  the element {@odf.element text:page-number}
	 * DifferentQName 
	 */
	public TextPageNumberElement newTextPageNumberElement()
	{
		TextPageNumberElement  textPageNumber = ((OdfFileDom)this.ownerDocument).newOdfElement(TextPageNumberElement.class);
		this.appendChild( textPageNumber);
		return  textPageNumber;
	}                   
               
	/**
	 * Create child element {@odf.element text:page-continuation}.
	 *
     * @param textSelectPageAttributeValue  the <code>String</code> value of <code>TextSelectPageAttribute</code>, see {@odf.attribute  text:select-page} at specification
	 * @return   return  the element {@odf.element text:page-continuation}
	 * DifferentQName 
	 */
    
	public TextPageContinuationElement newTextPageContinuationElement(String textSelectPageAttributeValue)
	{
		TextPageContinuationElement  textPageContinuation = ((OdfFileDom)this.ownerDocument).newOdfElement(TextPageContinuationElement.class);
		textPageContinuation.setTextSelectPageAttribute( textSelectPageAttributeValue );
		this.appendChild( textPageContinuation);
		return  textPageContinuation;      
	}
    
	/**
	 * Create child element {@odf.element text:sender-firstname}.
	 *
	 * @return   return  the element {@odf.element text:sender-firstname}
	 * DifferentQName 
	 */
	public TextSenderFirstnameElement newTextSenderFirstnameElement()
	{
		TextSenderFirstnameElement  textSenderFirstname = ((OdfFileDom)this.ownerDocument).newOdfElement(TextSenderFirstnameElement.class);
		this.appendChild( textSenderFirstname);
		return  textSenderFirstname;
	}                   
               
	/**
	 * Create child element {@odf.element text:sender-lastname}.
	 *
	 * @return   return  the element {@odf.element text:sender-lastname}
	 * DifferentQName 
	 */
	public TextSenderLastnameElement newTextSenderLastnameElement()
	{
		TextSenderLastnameElement  textSenderLastname = ((OdfFileDom)this.ownerDocument).newOdfElement(TextSenderLastnameElement.class);
		this.appendChild( textSenderLastname);
		return  textSenderLastname;
	}                   
               
	/**
	 * Create child element {@odf.element text:sender-initials}.
	 *
	 * @return   return  the element {@odf.element text:sender-initials}
	 * DifferentQName 
	 */
	public TextSenderInitialsElement newTextSenderInitialsElement()
	{
		TextSenderInitialsElement  textSenderInitials = ((OdfFileDom)this.ownerDocument).newOdfElement(TextSenderInitialsElement.class);
		this.appendChild( textSenderInitials);
		return  textSenderInitials;
	}                   
               
	/**
	 * Create child element {@odf.element text:sender-title}.
	 *
	 * @return   return  the element {@odf.element text:sender-title}
	 * DifferentQName 
	 */
	public TextSenderTitleElement newTextSenderTitleElement()
	{
		TextSenderTitleElement  textSenderTitle = ((OdfFileDom)this.ownerDocument).newOdfElement(TextSenderTitleElement.class);
		this.appendChild( textSenderTitle);
		return  textSenderTitle;
	}                   
               
	/**
	 * Create child element {@odf.element text:sender-position}.
	 *
	 * @return   return  the element {@odf.element text:sender-position}
	 * DifferentQName 
	 */
	public TextSenderPositionElement newTextSenderPositionElement()
	{
		TextSenderPositionElement  textSenderPosition = ((OdfFileDom)this.ownerDocument).newOdfElement(TextSenderPositionElement.class);
		this.appendChild( textSenderPosition);
		return  textSenderPosition;
	}                   
               
	/**
	 * Create child element {@odf.element text:sender-email}.
	 *
	 * @return   return  the element {@odf.element text:sender-email}
	 * DifferentQName 
	 */
	public TextSenderEmailElement newTextSenderEmailElement()
	{
		TextSenderEmailElement  textSenderEmail = ((OdfFileDom)this.ownerDocument).newOdfElement(TextSenderEmailElement.class);
		this.appendChild( textSenderEmail);
		return  textSenderEmail;
	}                   
               
	/**
	 * Create child element {@odf.element text:sender-phone-private}.
	 *
	 * @return   return  the element {@odf.element text:sender-phone-private}
	 * DifferentQName 
	 */
	public TextSenderPhonePrivateElement newTextSenderPhonePrivateElement()
	{
		TextSenderPhonePrivateElement  textSenderPhonePrivate = ((OdfFileDom)this.ownerDocument).newOdfElement(TextSenderPhonePrivateElement.class);
		this.appendChild( textSenderPhonePrivate);
		return  textSenderPhonePrivate;
	}                   
               
	/**
	 * Create child element {@odf.element text:sender-fax}.
	 *
	 * @return   return  the element {@odf.element text:sender-fax}
	 * DifferentQName 
	 */
	public TextSenderFaxElement newTextSenderFaxElement()
	{
		TextSenderFaxElement  textSenderFax = ((OdfFileDom)this.ownerDocument).newOdfElement(TextSenderFaxElement.class);
		this.appendChild( textSenderFax);
		return  textSenderFax;
	}                   
               
	/**
	 * Create child element {@odf.element text:sender-company}.
	 *
	 * @return   return  the element {@odf.element text:sender-company}
	 * DifferentQName 
	 */
	public TextSenderCompanyElement newTextSenderCompanyElement()
	{
		TextSenderCompanyElement  textSenderCompany = ((OdfFileDom)this.ownerDocument).newOdfElement(TextSenderCompanyElement.class);
		this.appendChild( textSenderCompany);
		return  textSenderCompany;
	}                   
               
	/**
	 * Create child element {@odf.element text:sender-phone-work}.
	 *
	 * @return   return  the element {@odf.element text:sender-phone-work}
	 * DifferentQName 
	 */
	public TextSenderPhoneWorkElement newTextSenderPhoneWorkElement()
	{
		TextSenderPhoneWorkElement  textSenderPhoneWork = ((OdfFileDom)this.ownerDocument).newOdfElement(TextSenderPhoneWorkElement.class);
		this.appendChild( textSenderPhoneWork);
		return  textSenderPhoneWork;
	}                   
               
	/**
	 * Create child element {@odf.element text:sender-street}.
	 *
	 * @return   return  the element {@odf.element text:sender-street}
	 * DifferentQName 
	 */
	public TextSenderStreetElement newTextSenderStreetElement()
	{
		TextSenderStreetElement  textSenderStreet = ((OdfFileDom)this.ownerDocument).newOdfElement(TextSenderStreetElement.class);
		this.appendChild( textSenderStreet);
		return  textSenderStreet;
	}                   
               
	/**
	 * Create child element {@odf.element text:sender-city}.
	 *
	 * @return   return  the element {@odf.element text:sender-city}
	 * DifferentQName 
	 */
	public TextSenderCityElement newTextSenderCityElement()
	{
		TextSenderCityElement  textSenderCity = ((OdfFileDom)this.ownerDocument).newOdfElement(TextSenderCityElement.class);
		this.appendChild( textSenderCity);
		return  textSenderCity;
	}                   
               
	/**
	 * Create child element {@odf.element text:sender-postal-code}.
	 *
	 * @return   return  the element {@odf.element text:sender-postal-code}
	 * DifferentQName 
	 */
	public TextSenderPostalCodeElement newTextSenderPostalCodeElement()
	{
		TextSenderPostalCodeElement  textSenderPostalCode = ((OdfFileDom)this.ownerDocument).newOdfElement(TextSenderPostalCodeElement.class);
		this.appendChild( textSenderPostalCode);
		return  textSenderPostalCode;
	}                   
               
	/**
	 * Create child element {@odf.element text:sender-country}.
	 *
	 * @return   return  the element {@odf.element text:sender-country}
	 * DifferentQName 
	 */
	public TextSenderCountryElement newTextSenderCountryElement()
	{
		TextSenderCountryElement  textSenderCountry = ((OdfFileDom)this.ownerDocument).newOdfElement(TextSenderCountryElement.class);
		this.appendChild( textSenderCountry);
		return  textSenderCountry;
	}                   
               
	/**
	 * Create child element {@odf.element text:sender-state-or-province}.
	 *
	 * @return   return  the element {@odf.element text:sender-state-or-province}
	 * DifferentQName 
	 */
	public TextSenderStateOrProvinceElement newTextSenderStateOrProvinceElement()
	{
		TextSenderStateOrProvinceElement  textSenderStateOrProvince = ((OdfFileDom)this.ownerDocument).newOdfElement(TextSenderStateOrProvinceElement.class);
		this.appendChild( textSenderStateOrProvince);
		return  textSenderStateOrProvince;
	}                   
               
	/**
	 * Create child element {@odf.element text:author-name}.
	 *
	 * @return   return  the element {@odf.element text:author-name}
	 * DifferentQName 
	 */
	public TextAuthorNameElement newTextAuthorNameElement()
	{
		TextAuthorNameElement  textAuthorName = ((OdfFileDom)this.ownerDocument).newOdfElement(TextAuthorNameElement.class);
		this.appendChild( textAuthorName);
		return  textAuthorName;
	}                   
               
	/**
	 * Create child element {@odf.element text:author-initials}.
	 *
	 * @return   return  the element {@odf.element text:author-initials}
	 * DifferentQName 
	 */
	public TextAuthorInitialsElement newTextAuthorInitialsElement()
	{
		TextAuthorInitialsElement  textAuthorInitials = ((OdfFileDom)this.ownerDocument).newOdfElement(TextAuthorInitialsElement.class);
		this.appendChild( textAuthorInitials);
		return  textAuthorInitials;
	}                   
               
	/**
	 * Create child element {@odf.element text:chapter}.
	 *
     * @param textDisplayAttributeValue  the <code>String</code> value of <code>TextDisplayAttribute</code>, see {@odf.attribute  text:display} at specification
	 * @param textOutlineLevelAttributeValue  the <code>String</code> value of <code>TextOutlineLevelAttribute</code>, see {@odf.attribute  text:outline-level} at specification
	 * @return   return  the element {@odf.element text:chapter}
	 * DifferentQName 
	 */
    
	public TextChapterElement newTextChapterElement(String textDisplayAttributeValue, String textOutlineLevelAttributeValue)
	{
		TextChapterElement  textChapter = ((OdfFileDom)this.ownerDocument).newOdfElement(TextChapterElement.class);
		textChapter.setTextDisplayAttribute( textDisplayAttributeValue );
		textChapter.setTextOutlineLevelAttribute( textOutlineLevelAttributeValue );
		this.appendChild( textChapter);
		return  textChapter;      
	}
    
	/**
	 * Create child element {@odf.element text:file-name}.
	 *
	 * @return   return  the element {@odf.element text:file-name}
	 * DifferentQName 
	 */
	public TextFileNameElement newTextFileNameElement()
	{
		TextFileNameElement  textFileName = ((OdfFileDom)this.ownerDocument).newOdfElement(TextFileNameElement.class);
		this.appendChild( textFileName);
		return  textFileName;
	}                   
               
	/**
	 * Create child element {@odf.element text:template-name}.
	 *
	 * @return   return  the element {@odf.element text:template-name}
	 * DifferentQName 
	 */
	public TextTemplateNameElement newTextTemplateNameElement()
	{
		TextTemplateNameElement  textTemplateName = ((OdfFileDom)this.ownerDocument).newOdfElement(TextTemplateNameElement.class);
		this.appendChild( textTemplateName);
		return  textTemplateName;
	}                   
               
	/**
	 * Create child element {@odf.element text:sheet-name}.
	 *
	 * @return   return  the element {@odf.element text:sheet-name}
	 * DifferentQName 
	 */
	public TextSheetNameElement newTextSheetNameElement()
	{
		TextSheetNameElement  textSheetName = ((OdfFileDom)this.ownerDocument).newOdfElement(TextSheetNameElement.class);
		this.appendChild( textSheetName);
		return  textSheetName;
	}                   
               
	/**
	 * Create child element {@odf.element text:variable-set}.
	 *
     * @param officeValueAttributeValue  the <code>double</code> value of <code>OfficeValueAttribute</code>, see {@odf.attribute  office:value} at specification
	 * @param officeValueTypeAttributeValue  the <code>String</code> value of <code>OfficeValueTypeAttribute</code>, see {@odf.attribute  office:value-type} at specification
	 * @param textNameAttributeValue  the <code>String</code> value of <code>TextNameAttribute</code>, see {@odf.attribute  text:name} at specification
	 * @return   return  the element {@odf.element text:variable-set}
	 * DifferentQName 
	 */
    
	public TextVariableSetElement newTextVariableSetElement(double officeValueAttributeValue, String officeValueTypeAttributeValue, String textNameAttributeValue)
	{
		TextVariableSetElement  textVariableSet = ((OdfFileDom)this.ownerDocument).newOdfElement(TextVariableSetElement.class);
		textVariableSet.setOfficeValueAttribute( Double.valueOf(officeValueAttributeValue) );
		textVariableSet.setOfficeValueTypeAttribute( officeValueTypeAttributeValue );
		textVariableSet.setTextNameAttribute( textNameAttributeValue );
		this.appendChild( textVariableSet);
		return  textVariableSet;      
	}
    
	/**
	 * Create child element {@odf.element text:variable-set}.
	 *
     * @param officeDateValueAttributeValue  the <code>String</code> value of <code>OfficeDateValueAttribute</code>, see {@odf.attribute  office:date-value} at specification
	 * @param officeValueTypeAttributeValue  the <code>String</code> value of <code>OfficeValueTypeAttribute</code>, see {@odf.attribute  office:value-type} at specification
	 * @param textNameAttributeValue  the <code>String</code> value of <code>TextNameAttribute</code>, see {@odf.attribute  text:name} at specification
	 * @return   return  the element {@odf.element text:variable-set}
	 * DifferentQName 
	 */
    
	public TextVariableSetElement newTextVariableSetElement(String officeDateValueAttributeValue, String officeValueTypeAttributeValue, String textNameAttributeValue)
	{
		TextVariableSetElement  textVariableSet = ((OdfFileDom)this.ownerDocument).newOdfElement(TextVariableSetElement.class);
		textVariableSet.setOfficeDateValueAttribute( officeDateValueAttributeValue );
		textVariableSet.setOfficeValueTypeAttribute( officeValueTypeAttributeValue );
		textVariableSet.setTextNameAttribute( textNameAttributeValue );
		this.appendChild( textVariableSet);
		return  textVariableSet;      
	}
    
	/**
	 * Create child element {@odf.element text:variable-set}.
	 *
     * @param officeTimeValueAttributeValue  the <code>String</code> value of <code>OfficeTimeValueAttribute</code>, see {@odf.attribute  office:time-value} at specification
	 * @param officeValueTypeAttributeValue  the <code>String</code> value of <code>OfficeValueTypeAttribute</code>, see {@odf.attribute  office:value-type} at specification
	 * @param textNameAttributeValue  the <code>String</code> value of <code>TextNameAttribute</code>, see {@odf.attribute  text:name} at specification
	 * @return   return  the element {@odf.element text:variable-set}
	 * DifferentQName office:time-value
	 */
    
	public TextVariableSetElement newTextVariableSetElementByTimeValue(String officeTimeValueAttributeValue, String officeValueTypeAttributeValue, String textNameAttributeValue)
	{
		TextVariableSetElement  textVariableSet = ((OdfFileDom)this.ownerDocument).newOdfElement(TextVariableSetElement.class);
		textVariableSet.setOfficeTimeValueAttribute( officeTimeValueAttributeValue );
		textVariableSet.setOfficeValueTypeAttribute( officeValueTypeAttributeValue );
		textVariableSet.setTextNameAttribute( textNameAttributeValue );
		this.appendChild( textVariableSet);
		return  textVariableSet;      
	}
    
	/**
	 * Create child element {@odf.element text:variable-set}.
	 *
     * @param officeBooleanValueAttributeValue  the <code>boolean</code> value of <code>OfficeBooleanValueAttribute</code>, see {@odf.attribute  office:boolean-value} at specification
	 * @param officeValueTypeAttributeValue  the <code>String</code> value of <code>OfficeValueTypeAttribute</code>, see {@odf.attribute  office:value-type} at specification
	 * @param textNameAttributeValue  the <code>String</code> value of <code>TextNameAttribute</code>, see {@odf.attribute  text:name} at specification
	 * @return   return  the element {@odf.element text:variable-set}
	 * DifferentQName 
	 */
    
	public TextVariableSetElement newTextVariableSetElement(boolean officeBooleanValueAttributeValue, String officeValueTypeAttributeValue, String textNameAttributeValue)
	{
		TextVariableSetElement  textVariableSet = ((OdfFileDom)this.ownerDocument).newOdfElement(TextVariableSetElement.class);
		textVariableSet.setOfficeBooleanValueAttribute( Boolean.valueOf(officeBooleanValueAttributeValue) );
		textVariableSet.setOfficeValueTypeAttribute( officeValueTypeAttributeValue );
		textVariableSet.setTextNameAttribute( textNameAttributeValue );
		this.appendChild( textVariableSet);
		return  textVariableSet;      
	}
    
	/**
	 * Create child element {@odf.element text:variable-set}.
	 *
     * @param officeValueTypeAttributeValue  the <code>String</code> value of <code>OfficeValueTypeAttribute</code>, see {@odf.attribute  office:value-type} at specification
	 * @param textNameAttributeValue  the <code>String</code> value of <code>TextNameAttribute</code>, see {@odf.attribute  text:name} at specification
	 * @return   return  the element {@odf.element text:variable-set}
	 * DifferentQName 
	 */
    
	public TextVariableSetElement newTextVariableSetElement(String officeValueTypeAttributeValue, String textNameAttributeValue)
	{
		TextVariableSetElement  textVariableSet = ((OdfFileDom)this.ownerDocument).newOdfElement(TextVariableSetElement.class);
		textVariableSet.setOfficeValueTypeAttribute( officeValueTypeAttributeValue );
		textVariableSet.setTextNameAttribute( textNameAttributeValue );
		this.appendChild( textVariableSet);
		return  textVariableSet;      
	}
    
	/**
	 * Create child element {@odf.element text:variable-get}.
	 *
     * @param textNameAttributeValue  the <code>String</code> value of <code>TextNameAttribute</code>, see {@odf.attribute  text:name} at specification
	 * @return   return  the element {@odf.element text:variable-get}
	 * DifferentQName 
	 */
    
	public TextVariableGetElement newTextVariableGetElement(String textNameAttributeValue)
	{
		TextVariableGetElement  textVariableGet = ((OdfFileDom)this.ownerDocument).newOdfElement(TextVariableGetElement.class);
		textVariableGet.setTextNameAttribute( textNameAttributeValue );
		this.appendChild( textVariableGet);
		return  textVariableGet;      
	}
    
	/**
	 * Create child element {@odf.element text:variable-input}.
	 *
     * @param officeValueTypeAttributeValue  the <code>String</code> value of <code>OfficeValueTypeAttribute</code>, see {@odf.attribute  office:value-type} at specification
	 * @param textNameAttributeValue  the <code>String</code> value of <code>TextNameAttribute</code>, see {@odf.attribute  text:name} at specification
	 * @return   return  the element {@odf.element text:variable-input}
	 * DifferentQName 
	 */
    
	public TextVariableInputElement newTextVariableInputElement(String officeValueTypeAttributeValue, String textNameAttributeValue)
	{
		TextVariableInputElement  textVariableInput = ((OdfFileDom)this.ownerDocument).newOdfElement(TextVariableInputElement.class);
		textVariableInput.setOfficeValueTypeAttribute( officeValueTypeAttributeValue );
		textVariableInput.setTextNameAttribute( textNameAttributeValue );
		this.appendChild( textVariableInput);
		return  textVariableInput;      
	}
    
	/**
	 * Create child element {@odf.element text:user-field-get}.
	 *
     * @param textNameAttributeValue  the <code>String</code> value of <code>TextNameAttribute</code>, see {@odf.attribute  text:name} at specification
	 * @return   return  the element {@odf.element text:user-field-get}
	 * DifferentQName 
	 */
    
	public TextUserFieldGetElement newTextUserFieldGetElement(String textNameAttributeValue)
	{
		TextUserFieldGetElement  textUserFieldGet = ((OdfFileDom)this.ownerDocument).newOdfElement(TextUserFieldGetElement.class);
		textUserFieldGet.setTextNameAttribute( textNameAttributeValue );
		this.appendChild( textUserFieldGet);
		return  textUserFieldGet;      
	}
    
	/**
	 * Create child element {@odf.element text:user-field-input}.
	 *
     * @param textNameAttributeValue  the <code>String</code> value of <code>TextNameAttribute</code>, see {@odf.attribute  text:name} at specification
	 * @return   return  the element {@odf.element text:user-field-input}
	 * DifferentQName 
	 */
    
	public TextUserFieldInputElement newTextUserFieldInputElement(String textNameAttributeValue)
	{
		TextUserFieldInputElement  textUserFieldInput = ((OdfFileDom)this.ownerDocument).newOdfElement(TextUserFieldInputElement.class);
		textUserFieldInput.setTextNameAttribute( textNameAttributeValue );
		this.appendChild( textUserFieldInput);
		return  textUserFieldInput;      
	}
    
	/**
	 * Create child element {@odf.element text:sequence}.
	 *
     * @param textNameAttributeValue  the <code>String</code> value of <code>TextNameAttribute</code>, see {@odf.attribute  text:name} at specification
	 * @return   return  the element {@odf.element text:sequence}
	 * DifferentQName 
	 */
    
	public TextSequenceElement newTextSequenceElement(String textNameAttributeValue)
	{
		TextSequenceElement  textSequence = ((OdfFileDom)this.ownerDocument).newOdfElement(TextSequenceElement.class);
		textSequence.setTextNameAttribute( textNameAttributeValue );
		this.appendChild( textSequence);
		return  textSequence;      
	}
    
	/**
	 * Create child element {@odf.element text:expression}.
	 *
	 * @return   return  the element {@odf.element text:expression}
	 * DifferentQName 
	 */
	public TextExpressionElement newTextExpressionElement()
	{
		TextExpressionElement  textExpression = ((OdfFileDom)this.ownerDocument).newOdfElement(TextExpressionElement.class);
		this.appendChild( textExpression);
		return  textExpression;
	}                   
               
	/**
	 * Create child element {@odf.element text:text-input}.
	 *
	 * @return   return  the element {@odf.element text:text-input}
	 * DifferentQName 
	 */
	public TextTextInputElement newTextTextInputElement()
	{
		TextTextInputElement  textTextInput = ((OdfFileDom)this.ownerDocument).newOdfElement(TextTextInputElement.class);
		this.appendChild( textTextInput);
		return  textTextInput;
	}                   
               
	/**
	 * Create child element {@odf.element text:initial-creator}.
	 *
	 * @return   return  the element {@odf.element text:initial-creator}
	 * DifferentQName 
	 */
	public TextInitialCreatorElement newTextInitialCreatorElement()
	{
		TextInitialCreatorElement  textInitialCreator = ((OdfFileDom)this.ownerDocument).newOdfElement(TextInitialCreatorElement.class);
		this.appendChild( textInitialCreator);
		return  textInitialCreator;
	}                   
               
	/**
	 * Create child element {@odf.element text:creation-date}.
	 *
	 * @return   return  the element {@odf.element text:creation-date}
	 * DifferentQName 
	 */
	public TextCreationDateElement newTextCreationDateElement()
	{
		TextCreationDateElement  textCreationDate = ((OdfFileDom)this.ownerDocument).newOdfElement(TextCreationDateElement.class);
		this.appendChild( textCreationDate);
		return  textCreationDate;
	}                   
               
	/**
	 * Create child element {@odf.element text:creation-time}.
	 *
	 * @return   return  the element {@odf.element text:creation-time}
	 * DifferentQName 
	 */
	public TextCreationTimeElement newTextCreationTimeElement()
	{
		TextCreationTimeElement  textCreationTime = ((OdfFileDom)this.ownerDocument).newOdfElement(TextCreationTimeElement.class);
		this.appendChild( textCreationTime);
		return  textCreationTime;
	}                   
               
	/**
	 * Create child element {@odf.element text:description}.
	 *
	 * @return   return  the element {@odf.element text:description}
	 * DifferentQName 
	 */
	public TextDescriptionElement newTextDescriptionElement()
	{
		TextDescriptionElement  textDescription = ((OdfFileDom)this.ownerDocument).newOdfElement(TextDescriptionElement.class);
		this.appendChild( textDescription);
		return  textDescription;
	}                   
               
	/**
	 * Create child element {@odf.element text:user-defined}.
	 *
	 * @return   return  the element {@odf.element text:user-defined}
	 * DifferentQName 
	 */
	public TextUserDefinedElement newTextUserDefinedElement()
	{
		TextUserDefinedElement  textUserDefined = ((OdfFileDom)this.ownerDocument).newOdfElement(TextUserDefinedElement.class);
		this.appendChild( textUserDefined);
		return  textUserDefined;
	}                   
               
	/**
	 * Create child element {@odf.element text:print-time}.
	 *
	 * @return   return  the element {@odf.element text:print-time}
	 * DifferentQName 
	 */
	public TextPrintTimeElement newTextPrintTimeElement()
	{
		TextPrintTimeElement  textPrintTime = ((OdfFileDom)this.ownerDocument).newOdfElement(TextPrintTimeElement.class);
		this.appendChild( textPrintTime);
		return  textPrintTime;
	}                   
               
	/**
	 * Create child element {@odf.element text:print-date}.
	 *
	 * @return   return  the element {@odf.element text:print-date}
	 * DifferentQName 
	 */
	public TextPrintDateElement newTextPrintDateElement()
	{
		TextPrintDateElement  textPrintDate = ((OdfFileDom)this.ownerDocument).newOdfElement(TextPrintDateElement.class);
		this.appendChild( textPrintDate);
		return  textPrintDate;
	}                   
               
	/**
	 * Create child element {@odf.element text:printed-by}.
	 *
	 * @return   return  the element {@odf.element text:printed-by}
	 * DifferentQName 
	 */
	public TextPrintedByElement newTextPrintedByElement()
	{
		TextPrintedByElement  textPrintedBy = ((OdfFileDom)this.ownerDocument).newOdfElement(TextPrintedByElement.class);
		this.appendChild( textPrintedBy);
		return  textPrintedBy;
	}                   
               
	/**
	 * Create child element {@odf.element text:title}.
	 *
	 * @return   return  the element {@odf.element text:title}
	 * DifferentQName 
	 */
	public TextTitleElement newTextTitleElement()
	{
		TextTitleElement  textTitle = ((OdfFileDom)this.ownerDocument).newOdfElement(TextTitleElement.class);
		this.appendChild( textTitle);
		return  textTitle;
	}                   
               
	/**
	 * Create child element {@odf.element text:subject}.
	 *
	 * @return   return  the element {@odf.element text:subject}
	 * DifferentQName 
	 */
	public TextSubjectElement newTextSubjectElement()
	{
		TextSubjectElement  textSubject = ((OdfFileDom)this.ownerDocument).newOdfElement(TextSubjectElement.class);
		this.appendChild( textSubject);
		return  textSubject;
	}                   
               
	/**
	 * Create child element {@odf.element text:keywords}.
	 *
	 * @return   return  the element {@odf.element text:keywords}
	 * DifferentQName 
	 */
	public TextKeywordsElement newTextKeywordsElement()
	{
		TextKeywordsElement  textKeywords = ((OdfFileDom)this.ownerDocument).newOdfElement(TextKeywordsElement.class);
		this.appendChild( textKeywords);
		return  textKeywords;
	}                   
               
	/**
	 * Create child element {@odf.element text:editing-cycles}.
	 *
	 * @return   return  the element {@odf.element text:editing-cycles}
	 * DifferentQName 
	 */
	public TextEditingCyclesElement newTextEditingCyclesElement()
	{
		TextEditingCyclesElement  textEditingCycles = ((OdfFileDom)this.ownerDocument).newOdfElement(TextEditingCyclesElement.class);
		this.appendChild( textEditingCycles);
		return  textEditingCycles;
	}                   
               
	/**
	 * Create child element {@odf.element text:editing-duration}.
	 *
	 * @return   return  the element {@odf.element text:editing-duration}
	 * DifferentQName 
	 */
	public TextEditingDurationElement newTextEditingDurationElement()
	{
		TextEditingDurationElement  textEditingDuration = ((OdfFileDom)this.ownerDocument).newOdfElement(TextEditingDurationElement.class);
		this.appendChild( textEditingDuration);
		return  textEditingDuration;
	}                   
               
	/**
	 * Create child element {@odf.element text:modification-time}.
	 *
	 * @return   return  the element {@odf.element text:modification-time}
	 * DifferentQName 
	 */
	public TextModificationTimeElement newTextModificationTimeElement()
	{
		TextModificationTimeElement  textModificationTime = ((OdfFileDom)this.ownerDocument).newOdfElement(TextModificationTimeElement.class);
		this.appendChild( textModificationTime);
		return  textModificationTime;
	}                   
               
	/**
	 * Create child element {@odf.element text:modification-date}.
	 *
	 * @return   return  the element {@odf.element text:modification-date}
	 * DifferentQName 
	 */
	public TextModificationDateElement newTextModificationDateElement()
	{
		TextModificationDateElement  textModificationDate = ((OdfFileDom)this.ownerDocument).newOdfElement(TextModificationDateElement.class);
		this.appendChild( textModificationDate);
		return  textModificationDate;
	}                   
               
	/**
	 * Create child element {@odf.element text:creator}.
	 *
	 * @return   return  the element {@odf.element text:creator}
	 * DifferentQName 
	 */
	public TextCreatorElement newTextCreatorElement()
	{
		TextCreatorElement  textCreator = ((OdfFileDom)this.ownerDocument).newOdfElement(TextCreatorElement.class);
		this.appendChild( textCreator);
		return  textCreator;
	}                   
               
	/**
	 * Create child element {@odf.element text:database-display}.
	 *
     * @param textColumnNameAttributeValue  the <code>String</code> value of <code>TextColumnNameAttribute</code>, see {@odf.attribute  text:column-name} at specification
	 * @param textTableNameAttributeValue  the <code>String</code> value of <code>TextTableNameAttribute</code>, see {@odf.attribute  text:table-name} at specification
	 * @return   return  the element {@odf.element text:database-display}
	 * DifferentQName 
	 */
    
	public TextDatabaseDisplayElement newTextDatabaseDisplayElement(String textColumnNameAttributeValue, String textTableNameAttributeValue)
	{
		TextDatabaseDisplayElement  textDatabaseDisplay = ((OdfFileDom)this.ownerDocument).newOdfElement(TextDatabaseDisplayElement.class);
		textDatabaseDisplay.setTextColumnNameAttribute( textColumnNameAttributeValue );
		textDatabaseDisplay.setTextTableNameAttribute( textTableNameAttributeValue );
		this.appendChild( textDatabaseDisplay);
		return  textDatabaseDisplay;      
	}
    
	/**
	 * Create child element {@odf.element text:database-next}.
	 *
     * @param textTableNameAttributeValue  the <code>String</code> value of <code>TextTableNameAttribute</code>, see {@odf.attribute  text:table-name} at specification
	 * @return   return  the element {@odf.element text:database-next}
	 * DifferentQName 
	 */
    
	public TextDatabaseNextElement newTextDatabaseNextElement(String textTableNameAttributeValue)
	{
		TextDatabaseNextElement  textDatabaseNext = ((OdfFileDom)this.ownerDocument).newOdfElement(TextDatabaseNextElement.class);
		textDatabaseNext.setTextTableNameAttribute( textTableNameAttributeValue );
		this.appendChild( textDatabaseNext);
		return  textDatabaseNext;      
	}
    
	/**
	 * Create child element {@odf.element text:database-row-select}.
	 *
     * @param textTableNameAttributeValue  the <code>String</code> value of <code>TextTableNameAttribute</code>, see {@odf.attribute  text:table-name} at specification
	 * @return   return  the element {@odf.element text:database-row-select}
	 * DifferentQName 
	 */
    
	public TextDatabaseRowSelectElement newTextDatabaseRowSelectElement(String textTableNameAttributeValue)
	{
		TextDatabaseRowSelectElement  textDatabaseRowSelect = ((OdfFileDom)this.ownerDocument).newOdfElement(TextDatabaseRowSelectElement.class);
		textDatabaseRowSelect.setTextTableNameAttribute( textTableNameAttributeValue );
		this.appendChild( textDatabaseRowSelect);
		return  textDatabaseRowSelect;      
	}
    
	/**
	 * Create child element {@odf.element text:database-row-number}.
	 *
     * @param textTableNameAttributeValue  the <code>String</code> value of <code>TextTableNameAttribute</code>, see {@odf.attribute  text:table-name} at specification
	 * @return   return  the element {@odf.element text:database-row-number}
	 * DifferentQName 
	 */
    
	public TextDatabaseRowNumberElement newTextDatabaseRowNumberElement(String textTableNameAttributeValue)
	{
		TextDatabaseRowNumberElement  textDatabaseRowNumber = ((OdfFileDom)this.ownerDocument).newOdfElement(TextDatabaseRowNumberElement.class);
		textDatabaseRowNumber.setTextTableNameAttribute( textTableNameAttributeValue );
		this.appendChild( textDatabaseRowNumber);
		return  textDatabaseRowNumber;      
	}
    
	/**
	 * Create child element {@odf.element text:database-name}.
	 *
     * @param textTableNameAttributeValue  the <code>String</code> value of <code>TextTableNameAttribute</code>, see {@odf.attribute  text:table-name} at specification
	 * @return   return  the element {@odf.element text:database-name}
	 * DifferentQName 
	 */
    
	public TextDatabaseNameElement newTextDatabaseNameElement(String textTableNameAttributeValue)
	{
		TextDatabaseNameElement  textDatabaseName = ((OdfFileDom)this.ownerDocument).newOdfElement(TextDatabaseNameElement.class);
		textDatabaseName.setTextTableNameAttribute( textTableNameAttributeValue );
		this.appendChild( textDatabaseName);
		return  textDatabaseName;      
	}
    
	/**
	 * Create child element {@odf.element text:page-variable-set}.
	 *
	 * @return   return  the element {@odf.element text:page-variable-set}
	 * DifferentQName 
	 */
	public TextPageVariableSetElement newTextPageVariableSetElement()
	{
		TextPageVariableSetElement  textPageVariableSet = ((OdfFileDom)this.ownerDocument).newOdfElement(TextPageVariableSetElement.class);
		this.appendChild( textPageVariableSet);
		return  textPageVariableSet;
	}                   
               
	/**
	 * Create child element {@odf.element text:page-variable-get}.
	 *
	 * @return   return  the element {@odf.element text:page-variable-get}
	 * DifferentQName 
	 */
	public TextPageVariableGetElement newTextPageVariableGetElement()
	{
		TextPageVariableGetElement  textPageVariableGet = ((OdfFileDom)this.ownerDocument).newOdfElement(TextPageVariableGetElement.class);
		this.appendChild( textPageVariableGet);
		return  textPageVariableGet;
	}                   
               
	/**
	 * Create child element {@odf.element text:placeholder}.
	 *
     * @param textPlaceholderTypeAttributeValue  the <code>String</code> value of <code>TextPlaceholderTypeAttribute</code>, see {@odf.attribute  text:placeholder-type} at specification
	 * @return   return  the element {@odf.element text:placeholder}
	 * DifferentQName 
	 */
    
	public TextPlaceholderElement newTextPlaceholderElement(String textPlaceholderTypeAttributeValue)
	{
		TextPlaceholderElement  textPlaceholder = ((OdfFileDom)this.ownerDocument).newOdfElement(TextPlaceholderElement.class);
		textPlaceholder.setTextPlaceholderTypeAttribute( textPlaceholderTypeAttributeValue );
		this.appendChild( textPlaceholder);
		return  textPlaceholder;      
	}
    
	/**
	 * Create child element {@odf.element text:conditional-text}.
	 *
     * @param textConditionAttributeValue  the <code>String</code> value of <code>TextConditionAttribute</code>, see {@odf.attribute  text:condition} at specification
	 * @param textStringValueIfFalseAttributeValue  the <code>String</code> value of <code>TextStringValueIfFalseAttribute</code>, see {@odf.attribute  text:string-value-if-false} at specification
	 * @param textStringValueIfTrueAttributeValue  the <code>String</code> value of <code>TextStringValueIfTrueAttribute</code>, see {@odf.attribute  text:string-value-if-true} at specification
	 * @return   return  the element {@odf.element text:conditional-text}
	 * DifferentQName 
	 */
    
	public TextConditionalTextElement newTextConditionalTextElement(String textConditionAttributeValue, String textStringValueIfFalseAttributeValue, String textStringValueIfTrueAttributeValue)
	{
		TextConditionalTextElement  textConditionalText = ((OdfFileDom)this.ownerDocument).newOdfElement(TextConditionalTextElement.class);
		textConditionalText.setTextConditionAttribute( textConditionAttributeValue );
		textConditionalText.setTextStringValueIfFalseAttribute( textStringValueIfFalseAttributeValue );
		textConditionalText.setTextStringValueIfTrueAttribute( textStringValueIfTrueAttributeValue );
		this.appendChild( textConditionalText);
		return  textConditionalText;      
	}
    
	/**
	 * Create child element {@odf.element text:hidden-text}.
	 *
     * @param textConditionAttributeValue  the <code>String</code> value of <code>TextConditionAttribute</code>, see {@odf.attribute  text:condition} at specification
	 * @param textStringValueAttributeValue  the <code>String</code> value of <code>TextStringValueAttribute</code>, see {@odf.attribute  text:string-value} at specification
	 * @return   return  the element {@odf.element text:hidden-text}
	 * DifferentQName 
	 */
    
	public TextHiddenTextElement newTextHiddenTextElement(String textConditionAttributeValue, String textStringValueAttributeValue)
	{
		TextHiddenTextElement  textHiddenText = ((OdfFileDom)this.ownerDocument).newOdfElement(TextHiddenTextElement.class);
		textHiddenText.setTextConditionAttribute( textConditionAttributeValue );
		textHiddenText.setTextStringValueAttribute( textStringValueAttributeValue );
		this.appendChild( textHiddenText);
		return  textHiddenText;      
	}
    
	/**
	 * Create child element {@odf.element text:note-ref}.
	 *
     * @param textNoteClassAttributeValue  the <code>String</code> value of <code>TextNoteClassAttribute</code>, see {@odf.attribute  text:note-class} at specification
	 * @return   return  the element {@odf.element text:note-ref}
	 * DifferentQName 
	 */
    
	public TextNoteRefElement newTextNoteRefElement(String textNoteClassAttributeValue)
	{
		TextNoteRefElement  textNoteRef = ((OdfFileDom)this.ownerDocument).newOdfElement(TextNoteRefElement.class);
		textNoteRef.setTextNoteClassAttribute( textNoteClassAttributeValue );
		this.appendChild( textNoteRef);
		return  textNoteRef;      
	}
    
	/**
	 * Create child element {@odf.element text:sequence-ref}.
	 *
	 * @return   return  the element {@odf.element text:sequence-ref}
	 * DifferentQName 
	 */
	public TextSequenceRefElement newTextSequenceRefElement()
	{
		TextSequenceRefElement  textSequenceRef = ((OdfFileDom)this.ownerDocument).newOdfElement(TextSequenceRefElement.class);
		this.appendChild( textSequenceRef);
		return  textSequenceRef;
	}                   
               
	/**
	 * Create child element {@odf.element text:script}.
	 *
	 * @return   return  the element {@odf.element text:script}
	 * DifferentQName 
	 */
	public TextScriptElement newTextScriptElement()
	{
		TextScriptElement  textScript = ((OdfFileDom)this.ownerDocument).newOdfElement(TextScriptElement.class);
		this.appendChild( textScript);
		return  textScript;
	}                   
               
	/**
	 * Create child element {@odf.element text:execute-macro}.
	 *
	 * @return   return  the element {@odf.element text:execute-macro}
	 * DifferentQName 
	 */
	public TextExecuteMacroElement newTextExecuteMacroElement()
	{
		TextExecuteMacroElement  textExecuteMacro = ((OdfFileDom)this.ownerDocument).newOdfElement(TextExecuteMacroElement.class);
		this.appendChild( textExecuteMacro);
		return  textExecuteMacro;
	}                   
               
	/**
	 * Create child element {@odf.element text:hidden-paragraph}.
	 *
     * @param textConditionAttributeValue  the <code>String</code> value of <code>TextConditionAttribute</code>, see {@odf.attribute  text:condition} at specification
	 * @return   return  the element {@odf.element text:hidden-paragraph}
	 * DifferentQName 
	 */
    
	public TextHiddenParagraphElement newTextHiddenParagraphElement(String textConditionAttributeValue)
	{
		TextHiddenParagraphElement  textHiddenParagraph = ((OdfFileDom)this.ownerDocument).newOdfElement(TextHiddenParagraphElement.class);
		textHiddenParagraph.setTextConditionAttribute( textConditionAttributeValue );
		this.appendChild( textHiddenParagraph);
		return  textHiddenParagraph;      
	}
    
	/**
	 * Create child element {@odf.element text:dde-connection}.
	 *
     * @param textConnectionNameAttributeValue  the <code>String</code> value of <code>TextConnectionNameAttribute</code>, see {@odf.attribute  text:connection-name} at specification
	 * @return   return  the element {@odf.element text:dde-connection}
	 * DifferentQName 
	 */
    
	public TextDdeConnectionElement newTextDdeConnectionElement(String textConnectionNameAttributeValue)
	{
		TextDdeConnectionElement  textDdeConnection = ((OdfFileDom)this.ownerDocument).newOdfElement(TextDdeConnectionElement.class);
		textDdeConnection.setTextConnectionNameAttribute( textConnectionNameAttributeValue );
		this.appendChild( textDdeConnection);
		return  textDdeConnection;      
	}
    
	/**
	 * Create child element {@odf.element text:measure}.
	 *
     * @param textKindAttributeValue  the <code>String</code> value of <code>TextKindAttribute</code>, see {@odf.attribute  text:kind} at specification
	 * @return   return  the element {@odf.element text:measure}
	 * DifferentQName 
	 */
    
	public TextMeasureElement newTextMeasureElement(String textKindAttributeValue)
	{
		TextMeasureElement  textMeasure = ((OdfFileDom)this.ownerDocument).newOdfElement(TextMeasureElement.class);
		textMeasure.setTextKindAttribute( textKindAttributeValue );
		this.appendChild( textMeasure);
		return  textMeasure;      
	}
    
	/**
	 * Create child element {@odf.element text:table-formula}.
	 *
	 * @return   return  the element {@odf.element text:table-formula}
	 * DifferentQName 
	 */
	public TextTableFormulaElement newTextTableFormulaElement()
	{
		TextTableFormulaElement  textTableFormula = ((OdfFileDom)this.ownerDocument).newOdfElement(TextTableFormulaElement.class);
		this.appendChild( textTableFormula);
		return  textTableFormula;
	}                   
               
	/**
	 * Create child element {@odf.element text:meta-field}.
	 *
     * @param xmlIdAttributeValue  the <code>String</code> value of <code>XmlIdAttribute</code>, see {@odf.attribute  xml:id} at specification
	 * @return   return  the element {@odf.element text:meta-field}
	 * DifferentQName 
	 */
    
	public TextMetaFieldElement newTextMetaFieldElement(String xmlIdAttributeValue)
	{
		TextMetaFieldElement  textMetaField = ((OdfFileDom)this.ownerDocument).newOdfElement(TextMetaFieldElement.class);
		textMetaField.setXmlIdAttribute( xmlIdAttributeValue );
		this.appendChild( textMetaField);
		return  textMetaField;      
	}
    
	/**
	 * Create child element {@odf.element text:toc-mark-start}.
	 *
     * @param textIdAttributeValue  the <code>String</code> value of <code>TextIdAttribute</code>, see {@odf.attribute  text:id} at specification
	 * @return   return  the element {@odf.element text:toc-mark-start}
	 * DifferentQName 
	 */
    
	public TextTocMarkStartElement newTextTocMarkStartElement(String textIdAttributeValue)
	{
		TextTocMarkStartElement  textTocMarkStart = ((OdfFileDom)this.ownerDocument).newOdfElement(TextTocMarkStartElement.class);
		textTocMarkStart.setTextIdAttribute( textIdAttributeValue );
		this.appendChild( textTocMarkStart);
		return  textTocMarkStart;      
	}
    
	/**
	 * Create child element {@odf.element text:toc-mark-end}.
	 *
     * @param textIdAttributeValue  the <code>String</code> value of <code>TextIdAttribute</code>, see {@odf.attribute  text:id} at specification
	 * @return   return  the element {@odf.element text:toc-mark-end}
	 * DifferentQName 
	 */
    
	public TextTocMarkEndElement newTextTocMarkEndElement(String textIdAttributeValue)
	{
		TextTocMarkEndElement  textTocMarkEnd = ((OdfFileDom)this.ownerDocument).newOdfElement(TextTocMarkEndElement.class);
		textTocMarkEnd.setTextIdAttribute( textIdAttributeValue );
		this.appendChild( textTocMarkEnd);
		return  textTocMarkEnd;      
	}
    
	/**
	 * Create child element {@odf.element text:toc-mark}.
	 *
     * @param textStringValueAttributeValue  the <code>String</code> value of <code>TextStringValueAttribute</code>, see {@odf.attribute  text:string-value} at specification
	 * @return   return  the element {@odf.element text:toc-mark}
	 * DifferentQName 
	 */
    
	public TextTocMarkElement newTextTocMarkElement(String textStringValueAttributeValue)
	{
		TextTocMarkElement  textTocMark = ((OdfFileDom)this.ownerDocument).newOdfElement(TextTocMarkElement.class);
		textTocMark.setTextStringValueAttribute( textStringValueAttributeValue );
		this.appendChild( textTocMark);
		return  textTocMark;      
	}
    
	/**
	 * Create child element {@odf.element text:user-index-mark-start}.
	 *
     * @param textIdAttributeValue  the <code>String</code> value of <code>TextIdAttribute</code>, see {@odf.attribute  text:id} at specification
	 * @param textIndexNameAttributeValue  the <code>String</code> value of <code>TextIndexNameAttribute</code>, see {@odf.attribute  text:index-name} at specification
	 * @return   return  the element {@odf.element text:user-index-mark-start}
	 * DifferentQName 
	 */
    
	public TextUserIndexMarkStartElement newTextUserIndexMarkStartElement(String textIdAttributeValue, String textIndexNameAttributeValue)
	{
		TextUserIndexMarkStartElement  textUserIndexMarkStart = ((OdfFileDom)this.ownerDocument).newOdfElement(TextUserIndexMarkStartElement.class);
		textUserIndexMarkStart.setTextIdAttribute( textIdAttributeValue );
		textUserIndexMarkStart.setTextIndexNameAttribute( textIndexNameAttributeValue );
		this.appendChild( textUserIndexMarkStart);
		return  textUserIndexMarkStart;      
	}
    
	/**
	 * Create child element {@odf.element text:user-index-mark-end}.
	 *
     * @param textIdAttributeValue  the <code>String</code> value of <code>TextIdAttribute</code>, see {@odf.attribute  text:id} at specification
	 * @return   return  the element {@odf.element text:user-index-mark-end}
	 * DifferentQName 
	 */
    
	public TextUserIndexMarkEndElement newTextUserIndexMarkEndElement(String textIdAttributeValue)
	{
		TextUserIndexMarkEndElement  textUserIndexMarkEnd = ((OdfFileDom)this.ownerDocument).newOdfElement(TextUserIndexMarkEndElement.class);
		textUserIndexMarkEnd.setTextIdAttribute( textIdAttributeValue );
		this.appendChild( textUserIndexMarkEnd);
		return  textUserIndexMarkEnd;      
	}
    
	/**
	 * Create child element {@odf.element text:user-index-mark}.
	 *
     * @param textIndexNameAttributeValue  the <code>String</code> value of <code>TextIndexNameAttribute</code>, see {@odf.attribute  text:index-name} at specification
	 * @param textStringValueAttributeValue  the <code>String</code> value of <code>TextStringValueAttribute</code>, see {@odf.attribute  text:string-value} at specification
	 * @return   return  the element {@odf.element text:user-index-mark}
	 * DifferentQName 
	 */
    
	public TextUserIndexMarkElement newTextUserIndexMarkElement(String textIndexNameAttributeValue, String textStringValueAttributeValue)
	{
		TextUserIndexMarkElement  textUserIndexMark = ((OdfFileDom)this.ownerDocument).newOdfElement(TextUserIndexMarkElement.class);
		textUserIndexMark.setTextIndexNameAttribute( textIndexNameAttributeValue );
		textUserIndexMark.setTextStringValueAttribute( textStringValueAttributeValue );
		this.appendChild( textUserIndexMark);
		return  textUserIndexMark;      
	}
    
	/**
	 * Create child element {@odf.element text:alphabetical-index-mark-start}.
	 *
     * @param textIdAttributeValue  the <code>String</code> value of <code>TextIdAttribute</code>, see {@odf.attribute  text:id} at specification
	 * @return   return  the element {@odf.element text:alphabetical-index-mark-start}
	 * DifferentQName 
	 */
    
	public TextAlphabeticalIndexMarkStartElement newTextAlphabeticalIndexMarkStartElement(String textIdAttributeValue)
	{
		TextAlphabeticalIndexMarkStartElement  textAlphabeticalIndexMarkStart = ((OdfFileDom)this.ownerDocument).newOdfElement(TextAlphabeticalIndexMarkStartElement.class);
		textAlphabeticalIndexMarkStart.setTextIdAttribute( textIdAttributeValue );
		this.appendChild( textAlphabeticalIndexMarkStart);
		return  textAlphabeticalIndexMarkStart;      
	}
    
	/**
	 * Create child element {@odf.element text:alphabetical-index-mark-end}.
	 *
     * @param textIdAttributeValue  the <code>String</code> value of <code>TextIdAttribute</code>, see {@odf.attribute  text:id} at specification
	 * @return   return  the element {@odf.element text:alphabetical-index-mark-end}
	 * DifferentQName 
	 */
    
	public TextAlphabeticalIndexMarkEndElement newTextAlphabeticalIndexMarkEndElement(String textIdAttributeValue)
	{
		TextAlphabeticalIndexMarkEndElement  textAlphabeticalIndexMarkEnd = ((OdfFileDom)this.ownerDocument).newOdfElement(TextAlphabeticalIndexMarkEndElement.class);
		textAlphabeticalIndexMarkEnd.setTextIdAttribute( textIdAttributeValue );
		this.appendChild( textAlphabeticalIndexMarkEnd);
		return  textAlphabeticalIndexMarkEnd;      
	}
    
	/**
	 * Create child element {@odf.element text:alphabetical-index-mark}.
	 *
     * @param textStringValueAttributeValue  the <code>String</code> value of <code>TextStringValueAttribute</code>, see {@odf.attribute  text:string-value} at specification
	 * @return   return  the element {@odf.element text:alphabetical-index-mark}
	 * DifferentQName 
	 */
    
	public TextAlphabeticalIndexMarkElement newTextAlphabeticalIndexMarkElement(String textStringValueAttributeValue)
	{
		TextAlphabeticalIndexMarkElement  textAlphabeticalIndexMark = ((OdfFileDom)this.ownerDocument).newOdfElement(TextAlphabeticalIndexMarkElement.class);
		textAlphabeticalIndexMark.setTextStringValueAttribute( textStringValueAttributeValue );
		this.appendChild( textAlphabeticalIndexMark);
		return  textAlphabeticalIndexMark;      
	}
    
	/**
	 * Create child element {@odf.element text:bibliography-mark}.
	 *
     * @param textBibliographyTypeAttributeValue  the <code>String</code> value of <code>TextBibliographyTypeAttribute</code>, see {@odf.attribute  text:bibliography-type} at specification
	 * @return   return  the element {@odf.element text:bibliography-mark}
	 * DifferentQName 
	 */
    
	public TextBibliographyMarkElement newTextBibliographyMarkElement(String textBibliographyTypeAttributeValue)
	{
		TextBibliographyMarkElement  textBibliographyMark = ((OdfFileDom)this.ownerDocument).newOdfElement(TextBibliographyMarkElement.class);
		textBibliographyMark.setTextBibliographyTypeAttribute( textBibliographyTypeAttributeValue );
		this.appendChild( textBibliographyMark);
		return  textBibliographyMark;      
	}
    
	/**
	 * Create child element {@odf.element presentation:header}.
	 *
	 * @return   return  the element {@odf.element presentation:header}
	 * DifferentQName 
	 */
	public PresentationHeaderElement newPresentationHeaderElement()
	{
		PresentationHeaderElement  presentationHeader = ((OdfFileDom)this.ownerDocument).newOdfElement(PresentationHeaderElement.class);
		this.appendChild( presentationHeader);
		return  presentationHeader;
	}                   
               
	/**
	 * Create child element {@odf.element presentation:footer}.
	 *
	 * @return   return  the element {@odf.element presentation:footer}
	 * DifferentQName 
	 */
	public PresentationFooterElement newPresentationFooterElement()
	{
		PresentationFooterElement  presentationFooter = ((OdfFileDom)this.ownerDocument).newOdfElement(PresentationFooterElement.class);
		this.appendChild( presentationFooter);
		return  presentationFooter;
	}                   
               
	/**
	 * Create child element {@odf.element presentation:date-time}.
	 *
	 * @return   return  the element {@odf.element presentation:date-time}
	 * DifferentQName 
	 */
	public PresentationDateTimeElement newPresentationDateTimeElement()
	{
		PresentationDateTimeElement  presentationDateTime = ((OdfFileDom)this.ownerDocument).newOdfElement(PresentationDateTimeElement.class);
		this.appendChild( presentationDateTime);
		return  presentationDateTime;
	}                   
               
}
