/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.dom.attribute.table.TableIdAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableAcceptanceStateAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableRejectingChangeIdAttribute;

import org.odftoolkit.odfdom.dom.element.office.OfficeChangeInfoElement;

/**
 * DOM implementation of OpenDocument element  {@odf.element table:movement}.
 *
 */
public class TableMovementElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.TABLE, "movement" );


	/**
	 * Create the instance of <code>TableMovementElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public TableMovementElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element table:movement}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}

	/**
	 * Initialization of the mandatory attributes of {@link  TableMovementElement}
	 *
     * @param tableIdAttributeValue  The mandatory attribute {@odf.attribute  table:id}"
     *
	 */
	public void init(String tableIdAttributeValue)
	{
		setTableIdAttribute( tableIdAttributeValue );
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableIdAttribute</code> , See {@odf.attribute table:id}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTableIdAttribute()
	{
		TableIdAttribute attr = (TableIdAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TABLE), "id" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TableIdAttribute</code> , See {@odf.attribute table:id}
	 *
	 * @param tableIdValue   The type is <code>String</code>
	 */
	public void setTableIdAttribute( String tableIdValue )
	{
		TableIdAttribute attr =  new TableIdAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( tableIdValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableAcceptanceStateAttribute</code> , See {@odf.attribute table:acceptance-state}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTableAcceptanceStateAttribute()
	{
		TableAcceptanceStateAttribute attr = (TableAcceptanceStateAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TABLE), "acceptance-state" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return TableAcceptanceStateAttribute.DEFAULT_VALUE;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TableAcceptanceStateAttribute</code> , See {@odf.attribute table:acceptance-state}
	 *
	 * @param tableAcceptanceStateValue   The type is <code>String</code>
	 */
	public void setTableAcceptanceStateAttribute( String tableAcceptanceStateValue )
	{
		TableAcceptanceStateAttribute attr =  new TableAcceptanceStateAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( tableAcceptanceStateValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableRejectingChangeIdAttribute</code> , See {@odf.attribute table:rejecting-change-id}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTableRejectingChangeIdAttribute()
	{
		TableRejectingChangeIdAttribute attr = (TableRejectingChangeIdAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TABLE), "rejecting-change-id" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TableRejectingChangeIdAttribute</code> , See {@odf.attribute table:rejecting-change-id}
	 *
	 * @param tableRejectingChangeIdValue   The type is <code>String</code>
	 */
	public void setTableRejectingChangeIdAttribute( String tableRejectingChangeIdValue )
	{
		TableRejectingChangeIdAttribute attr =  new TableRejectingChangeIdAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( tableRejectingChangeIdValue );
	}

	/**
	 * Create child element {@odf.element table:source-range-address}.
	 *
	 * @return   return  the element {@odf.element table:source-range-address}
	 * DifferentQName 
	 */
	public TableSourceRangeAddressElement newTableSourceRangeAddressElement()
	{
		TableSourceRangeAddressElement  tableSourceRangeAddress = ((OdfFileDom)this.ownerDocument).newOdfElement(TableSourceRangeAddressElement.class);
		this.appendChild( tableSourceRangeAddress);
		return  tableSourceRangeAddress;
	}                   
               
	/**
	 * Create child element {@odf.element table:target-range-address}.
	 *
	 * @return   return  the element {@odf.element table:target-range-address}
	 * DifferentQName 
	 */
	public TableTargetRangeAddressElement newTableTargetRangeAddressElement()
	{
		TableTargetRangeAddressElement  tableTargetRangeAddress = ((OdfFileDom)this.ownerDocument).newOdfElement(TableTargetRangeAddressElement.class);
		this.appendChild( tableTargetRangeAddress);
		return  tableTargetRangeAddress;
	}                   
               
	/**
	 * Create child element {@odf.element office:change-info}.
	 *
	 * @return   return  the element {@odf.element office:change-info}
	 * DifferentQName 
	 */
	public OfficeChangeInfoElement newOfficeChangeInfoElement()
	{
		OfficeChangeInfoElement  officeChangeInfo = ((OdfFileDom)this.ownerDocument).newOdfElement(OfficeChangeInfoElement.class);
		this.appendChild( officeChangeInfo);
		return  officeChangeInfo;
	}                   
               
	/**
	 * Create child element {@odf.element table:dependencies}.
	 *
	 * @return   return  the element {@odf.element table:dependencies}
	 * DifferentQName 
	 */
	public TableDependenciesElement newTableDependenciesElement()
	{
		TableDependenciesElement  tableDependencies = ((OdfFileDom)this.ownerDocument).newOdfElement(TableDependenciesElement.class);
		this.appendChild( tableDependencies);
		return  tableDependencies;
	}                   
               
	/**
	 * Create child element {@odf.element table:deletions}.
	 *
	 * @return   return  the element {@odf.element table:deletions}
	 * DifferentQName 
	 */
	public TableDeletionsElement newTableDeletionsElement()
	{
		TableDeletionsElement  tableDeletions = ((OdfFileDom)this.ownerDocument).newOdfElement(TableDeletionsElement.class);
		this.appendChild( tableDeletions);
		return  tableDeletions;
	}                   
               
}
