/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.dom.attribute.fo.FoLineHeightAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleLineHeightAtLeastAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleLineSpacingAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontIndependentLineSpacingAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoTextAlignAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoTextAlignLastAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleJustifySingleWordAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoKeepTogetherAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoWidowsAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoOrphansAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTabStopDistanceAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoHyphenationKeepAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoHyphenationLadderCountAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleRegisterTrueAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoTextIndentAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleAutoTextIndentAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBreakBeforeAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBreakAfterAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBackgroundColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleJoinBorderAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleShadowAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoKeepWithNextAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextNumberLinesAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextLineNumberAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextAutospaceAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StylePunctuationWrapAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleLineBreakAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleVerticalAlignAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleWritingModeAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleWritingModeAutomaticAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleSnapToLayoutGridAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StylePageNumberAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBackgroundTransparencyAttribute;

import org.odftoolkit.odfdom.dom.element.office.OfficeBinaryDataElement;

/**
 * DOM implementation of OpenDocument element  {@odf.element style:paragraph-properties}.
 *
 */
public class StyleParagraphPropertiesElement extends OdfStylePropertiesBase
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.STYLE, "paragraph-properties" );

	/**
	 * The value set of {@odf.attribute style:vertical-align}.
	 */
	 public enum StyleVerticalAlignAttributeValue {
	 
	 AUTO( StyleVerticalAlignAttribute.Value.AUTO.toString() ), BASELINE( StyleVerticalAlignAttribute.Value.BASELINE.toString() ), BOTTOM( StyleVerticalAlignAttribute.Value.BOTTOM.toString() ), MIDDLE( StyleVerticalAlignAttribute.Value.MIDDLE.toString() ), TOP( StyleVerticalAlignAttribute.Value.TOP.toString() );
              
		private String mValue;
	 	
		StyleVerticalAlignAttributeValue( String value )
		{
			mValue = value;
		}
		
		@Override
		public String toString()
		{
			return mValue;
		}
		
		public static StyleVerticalAlignAttributeValue enumValueOf( String value )
	    {
	        for( StyleVerticalAlignAttributeValue aIter : values() )
	        {
	            if( value.equals( aIter.toString() ) )
	            {
	                return aIter;
	            }
	        }
	        return null;
	    }
	}

	/**
	 * Create the instance of <code>StyleParagraphPropertiesElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public StyleParagraphPropertiesElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element style:paragraph-properties}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}

    public final static OdfStyleProperty LineHeight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "line-height"));
    public final static OdfStyleProperty LineHeightAtLeast = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.STYLE, "line-height-at-least"));
    public final static OdfStyleProperty LineSpacing = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.STYLE, "line-spacing"));
    public final static OdfStyleProperty FontIndependentLineSpacing = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.STYLE, "font-independent-line-spacing"));
    public final static OdfStyleProperty TextAlign = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "text-align"));
    public final static OdfStyleProperty TextAlignLast = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "text-align-last"));
    public final static OdfStyleProperty JustifySingleWord = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.STYLE, "justify-single-word"));
    public final static OdfStyleProperty KeepTogether = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "keep-together"));
    public final static OdfStyleProperty Widows = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "widows"));
    public final static OdfStyleProperty Orphans = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "orphans"));
    public final static OdfStyleProperty TabStopDistance = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.STYLE, "tab-stop-distance"));
    public final static OdfStyleProperty HyphenationKeep = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "hyphenation-keep"));
    public final static OdfStyleProperty HyphenationLadderCount = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "hyphenation-ladder-count"));
    public final static OdfStyleProperty RegisterTrue = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.STYLE, "register-true"));
    public final static OdfStyleProperty MarginLeft = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "margin-left"));
    public final static OdfStyleProperty MarginRight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "margin-right"));
    public final static OdfStyleProperty TextIndent = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "text-indent"));
    public final static OdfStyleProperty AutoTextIndent = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.STYLE, "auto-text-indent"));
    public final static OdfStyleProperty MarginTop = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "margin-top"));
    public final static OdfStyleProperty MarginBottom = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "margin-bottom"));
    public final static OdfStyleProperty Margin = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "margin"));
    public final static OdfStyleProperty BreakBefore = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "break-before"));
    public final static OdfStyleProperty BreakAfter = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "break-after"));
    public final static OdfStyleProperty BackgroundColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "background-color"));
    public final static OdfStyleProperty Border = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "border"));
    public final static OdfStyleProperty BorderTop = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "border-top"));
    public final static OdfStyleProperty BorderBottom = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "border-bottom"));
    public final static OdfStyleProperty BorderLeft = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "border-left"));
    public final static OdfStyleProperty BorderRight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "border-right"));
    public final static OdfStyleProperty BorderLineWidth = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.STYLE, "border-line-width"));
    public final static OdfStyleProperty BorderLineWidthTop = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.STYLE, "border-line-width-top"));
    public final static OdfStyleProperty BorderLineWidthBottom = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.STYLE, "border-line-width-bottom"));
    public final static OdfStyleProperty BorderLineWidthLeft = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.STYLE, "border-line-width-left"));
    public final static OdfStyleProperty BorderLineWidthRight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.STYLE, "border-line-width-right"));
    public final static OdfStyleProperty JoinBorder = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.STYLE, "join-border"));
    public final static OdfStyleProperty Padding = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "padding"));
    public final static OdfStyleProperty PaddingTop = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "padding-top"));
    public final static OdfStyleProperty PaddingBottom = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "padding-bottom"));
    public final static OdfStyleProperty PaddingLeft = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "padding-left"));
    public final static OdfStyleProperty PaddingRight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "padding-right"));
    public final static OdfStyleProperty Shadow = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.STYLE, "shadow"));
    public final static OdfStyleProperty KeepWithNext = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.FO, "keep-with-next"));
    public final static OdfStyleProperty NumberLines = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.TEXT, "number-lines"));
    public final static OdfStyleProperty LineNumber = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.TEXT, "line-number"));
    public final static OdfStyleProperty TextAutospace = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.STYLE, "text-autospace"));
    public final static OdfStyleProperty PunctuationWrap = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.STYLE, "punctuation-wrap"));
    public final static OdfStyleProperty LineBreak = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.STYLE, "line-break"));
    public final static OdfStyleProperty VerticalAlign = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.STYLE, "vertical-align"));
    public final static OdfStyleProperty WritingMode = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.STYLE, "writing-mode"));
    public final static OdfStyleProperty WritingModeAutomatic = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.STYLE, "writing-mode-automatic"));
    public final static OdfStyleProperty SnapToLayoutGrid = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.STYLE, "snap-to-layout-grid"));
    public final static OdfStyleProperty PageNumber = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.STYLE, "page-number"));
    public final static OdfStyleProperty BackgroundTransparency = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, OdfName.newName(OdfNamespaceNames.STYLE, "background-transparency"));


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoLineHeightAttribute</code> , See {@odf.attribute fo:line-height}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoLineHeightAttribute()
	{
		FoLineHeightAttribute attr = (FoLineHeightAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "line-height" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoLineHeightAttribute</code> , See {@odf.attribute fo:line-height}
	 *
	 * @param foLineHeightValue   The type is <code>String</code>
	 */
	public void setFoLineHeightAttribute( String foLineHeightValue )
	{
		FoLineHeightAttribute attr =  new FoLineHeightAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foLineHeightValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleLineHeightAtLeastAttribute</code> , See {@odf.attribute style:line-height-at-least}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleLineHeightAtLeastAttribute()
	{
		StyleLineHeightAtLeastAttribute attr = (StyleLineHeightAtLeastAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "line-height-at-least" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleLineHeightAtLeastAttribute</code> , See {@odf.attribute style:line-height-at-least}
	 *
	 * @param styleLineHeightAtLeastValue   The type is <code>String</code>
	 */
	public void setStyleLineHeightAtLeastAttribute( String styleLineHeightAtLeastValue )
	{
		StyleLineHeightAtLeastAttribute attr =  new StyleLineHeightAtLeastAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleLineHeightAtLeastValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleLineSpacingAttribute</code> , See {@odf.attribute style:line-spacing}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleLineSpacingAttribute()
	{
		StyleLineSpacingAttribute attr = (StyleLineSpacingAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "line-spacing" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleLineSpacingAttribute</code> , See {@odf.attribute style:line-spacing}
	 *
	 * @param styleLineSpacingValue   The type is <code>String</code>
	 */
	public void setStyleLineSpacingAttribute( String styleLineSpacingValue )
	{
		StyleLineSpacingAttribute attr =  new StyleLineSpacingAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleLineSpacingValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleFontIndependentLineSpacingAttribute</code> , See {@odf.attribute style:font-independent-line-spacing}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getStyleFontIndependentLineSpacingAttribute()
	{
		StyleFontIndependentLineSpacingAttribute attr = (StyleFontIndependentLineSpacingAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "font-independent-line-spacing" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleFontIndependentLineSpacingAttribute</code> , See {@odf.attribute style:font-independent-line-spacing}
	 *
	 * @param styleFontIndependentLineSpacingValue   The type is <code>Boolean</code>
	 */
	public void setStyleFontIndependentLineSpacingAttribute( Boolean styleFontIndependentLineSpacingValue )
	{
		StyleFontIndependentLineSpacingAttribute attr =  new StyleFontIndependentLineSpacingAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( styleFontIndependentLineSpacingValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoTextAlignAttribute</code> , See {@odf.attribute fo:text-align}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoTextAlignAttribute()
	{
		FoTextAlignAttribute attr = (FoTextAlignAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "text-align" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoTextAlignAttribute</code> , See {@odf.attribute fo:text-align}
	 *
	 * @param foTextAlignValue   The type is <code>String</code>
	 */
	public void setFoTextAlignAttribute( String foTextAlignValue )
	{
		FoTextAlignAttribute attr =  new FoTextAlignAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foTextAlignValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoTextAlignLastAttribute</code> , See {@odf.attribute fo:text-align-last}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoTextAlignLastAttribute()
	{
		FoTextAlignLastAttribute attr = (FoTextAlignLastAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "text-align-last" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoTextAlignLastAttribute</code> , See {@odf.attribute fo:text-align-last}
	 *
	 * @param foTextAlignLastValue   The type is <code>String</code>
	 */
	public void setFoTextAlignLastAttribute( String foTextAlignLastValue )
	{
		FoTextAlignLastAttribute attr =  new FoTextAlignLastAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foTextAlignLastValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleJustifySingleWordAttribute</code> , See {@odf.attribute style:justify-single-word}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getStyleJustifySingleWordAttribute()
	{
		StyleJustifySingleWordAttribute attr = (StyleJustifySingleWordAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "justify-single-word" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleJustifySingleWordAttribute</code> , See {@odf.attribute style:justify-single-word}
	 *
	 * @param styleJustifySingleWordValue   The type is <code>Boolean</code>
	 */
	public void setStyleJustifySingleWordAttribute( Boolean styleJustifySingleWordValue )
	{
		StyleJustifySingleWordAttribute attr =  new StyleJustifySingleWordAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( styleJustifySingleWordValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoKeepTogetherAttribute</code> , See {@odf.attribute fo:keep-together}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoKeepTogetherAttribute()
	{
		FoKeepTogetherAttribute attr = (FoKeepTogetherAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "keep-together" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoKeepTogetherAttribute</code> , See {@odf.attribute fo:keep-together}
	 *
	 * @param foKeepTogetherValue   The type is <code>String</code>
	 */
	public void setFoKeepTogetherAttribute( String foKeepTogetherValue )
	{
		FoKeepTogetherAttribute attr =  new FoKeepTogetherAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foKeepTogetherValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoWidowsAttribute</code> , See {@odf.attribute fo:widows}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getFoWidowsAttribute()
	{
		FoWidowsAttribute attr = (FoWidowsAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "widows" ) ;
		if( attr != null ){
			return Integer.valueOf( attr.intValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoWidowsAttribute</code> , See {@odf.attribute fo:widows}
	 *
	 * @param foWidowsValue   The type is <code>Integer</code>
	 */
	public void setFoWidowsAttribute( Integer foWidowsValue )
	{
		FoWidowsAttribute attr =  new FoWidowsAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setIntValue( foWidowsValue.intValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoOrphansAttribute</code> , See {@odf.attribute fo:orphans}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getFoOrphansAttribute()
	{
		FoOrphansAttribute attr = (FoOrphansAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "orphans" ) ;
		if( attr != null ){
			return Integer.valueOf( attr.intValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoOrphansAttribute</code> , See {@odf.attribute fo:orphans}
	 *
	 * @param foOrphansValue   The type is <code>Integer</code>
	 */
	public void setFoOrphansAttribute( Integer foOrphansValue )
	{
		FoOrphansAttribute attr =  new FoOrphansAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setIntValue( foOrphansValue.intValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleTabStopDistanceAttribute</code> , See {@odf.attribute style:tab-stop-distance}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleTabStopDistanceAttribute()
	{
		StyleTabStopDistanceAttribute attr = (StyleTabStopDistanceAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "tab-stop-distance" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleTabStopDistanceAttribute</code> , See {@odf.attribute style:tab-stop-distance}
	 *
	 * @param styleTabStopDistanceValue   The type is <code>String</code>
	 */
	public void setStyleTabStopDistanceAttribute( String styleTabStopDistanceValue )
	{
		StyleTabStopDistanceAttribute attr =  new StyleTabStopDistanceAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleTabStopDistanceValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoHyphenationKeepAttribute</code> , See {@odf.attribute fo:hyphenation-keep}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoHyphenationKeepAttribute()
	{
		FoHyphenationKeepAttribute attr = (FoHyphenationKeepAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "hyphenation-keep" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoHyphenationKeepAttribute</code> , See {@odf.attribute fo:hyphenation-keep}
	 *
	 * @param foHyphenationKeepValue   The type is <code>String</code>
	 */
	public void setFoHyphenationKeepAttribute( String foHyphenationKeepValue )
	{
		FoHyphenationKeepAttribute attr =  new FoHyphenationKeepAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foHyphenationKeepValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoHyphenationLadderCountAttribute</code> , See {@odf.attribute fo:hyphenation-ladder-count}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoHyphenationLadderCountAttribute()
	{
		FoHyphenationLadderCountAttribute attr = (FoHyphenationLadderCountAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "hyphenation-ladder-count" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoHyphenationLadderCountAttribute</code> , See {@odf.attribute fo:hyphenation-ladder-count}
	 *
	 * @param foHyphenationLadderCountValue   The type is <code>String</code>
	 */
	public void setFoHyphenationLadderCountAttribute( String foHyphenationLadderCountValue )
	{
		FoHyphenationLadderCountAttribute attr =  new FoHyphenationLadderCountAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foHyphenationLadderCountValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleRegisterTrueAttribute</code> , See {@odf.attribute style:register-true}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getStyleRegisterTrueAttribute()
	{
		StyleRegisterTrueAttribute attr = (StyleRegisterTrueAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "register-true" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleRegisterTrueAttribute</code> , See {@odf.attribute style:register-true}
	 *
	 * @param styleRegisterTrueValue   The type is <code>Boolean</code>
	 */
	public void setStyleRegisterTrueAttribute( Boolean styleRegisterTrueValue )
	{
		StyleRegisterTrueAttribute attr =  new StyleRegisterTrueAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( styleRegisterTrueValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoMarginLeftAttribute</code> , See {@odf.attribute fo:margin-left}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoMarginLeftAttribute()
	{
		FoMarginLeftAttribute attr = (FoMarginLeftAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "margin-left" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoMarginLeftAttribute</code> , See {@odf.attribute fo:margin-left}
	 *
	 * @param foMarginLeftValue   The type is <code>String</code>
	 */
	public void setFoMarginLeftAttribute( String foMarginLeftValue )
	{
		FoMarginLeftAttribute attr =  new FoMarginLeftAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foMarginLeftValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoMarginRightAttribute</code> , See {@odf.attribute fo:margin-right}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoMarginRightAttribute()
	{
		FoMarginRightAttribute attr = (FoMarginRightAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "margin-right" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoMarginRightAttribute</code> , See {@odf.attribute fo:margin-right}
	 *
	 * @param foMarginRightValue   The type is <code>String</code>
	 */
	public void setFoMarginRightAttribute( String foMarginRightValue )
	{
		FoMarginRightAttribute attr =  new FoMarginRightAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foMarginRightValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoTextIndentAttribute</code> , See {@odf.attribute fo:text-indent}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoTextIndentAttribute()
	{
		FoTextIndentAttribute attr = (FoTextIndentAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "text-indent" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoTextIndentAttribute</code> , See {@odf.attribute fo:text-indent}
	 *
	 * @param foTextIndentValue   The type is <code>String</code>
	 */
	public void setFoTextIndentAttribute( String foTextIndentValue )
	{
		FoTextIndentAttribute attr =  new FoTextIndentAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foTextIndentValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleAutoTextIndentAttribute</code> , See {@odf.attribute style:auto-text-indent}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getStyleAutoTextIndentAttribute()
	{
		StyleAutoTextIndentAttribute attr = (StyleAutoTextIndentAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "auto-text-indent" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleAutoTextIndentAttribute</code> , See {@odf.attribute style:auto-text-indent}
	 *
	 * @param styleAutoTextIndentValue   The type is <code>Boolean</code>
	 */
	public void setStyleAutoTextIndentAttribute( Boolean styleAutoTextIndentValue )
	{
		StyleAutoTextIndentAttribute attr =  new StyleAutoTextIndentAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( styleAutoTextIndentValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoMarginTopAttribute</code> , See {@odf.attribute fo:margin-top}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoMarginTopAttribute()
	{
		FoMarginTopAttribute attr = (FoMarginTopAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "margin-top" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoMarginTopAttribute</code> , See {@odf.attribute fo:margin-top}
	 *
	 * @param foMarginTopValue   The type is <code>String</code>
	 */
	public void setFoMarginTopAttribute( String foMarginTopValue )
	{
		FoMarginTopAttribute attr =  new FoMarginTopAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foMarginTopValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoMarginBottomAttribute</code> , See {@odf.attribute fo:margin-bottom}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoMarginBottomAttribute()
	{
		FoMarginBottomAttribute attr = (FoMarginBottomAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "margin-bottom" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoMarginBottomAttribute</code> , See {@odf.attribute fo:margin-bottom}
	 *
	 * @param foMarginBottomValue   The type is <code>String</code>
	 */
	public void setFoMarginBottomAttribute( String foMarginBottomValue )
	{
		FoMarginBottomAttribute attr =  new FoMarginBottomAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foMarginBottomValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoMarginAttribute</code> , See {@odf.attribute fo:margin}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoMarginAttribute()
	{
		FoMarginAttribute attr = (FoMarginAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "margin" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoMarginAttribute</code> , See {@odf.attribute fo:margin}
	 *
	 * @param foMarginValue   The type is <code>String</code>
	 */
	public void setFoMarginAttribute( String foMarginValue )
	{
		FoMarginAttribute attr =  new FoMarginAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foMarginValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoBreakBeforeAttribute</code> , See {@odf.attribute fo:break-before}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoBreakBeforeAttribute()
	{
		FoBreakBeforeAttribute attr = (FoBreakBeforeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "break-before" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoBreakBeforeAttribute</code> , See {@odf.attribute fo:break-before}
	 *
	 * @param foBreakBeforeValue   The type is <code>String</code>
	 */
	public void setFoBreakBeforeAttribute( String foBreakBeforeValue )
	{
		FoBreakBeforeAttribute attr =  new FoBreakBeforeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foBreakBeforeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoBreakAfterAttribute</code> , See {@odf.attribute fo:break-after}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoBreakAfterAttribute()
	{
		FoBreakAfterAttribute attr = (FoBreakAfterAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "break-after" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoBreakAfterAttribute</code> , See {@odf.attribute fo:break-after}
	 *
	 * @param foBreakAfterValue   The type is <code>String</code>
	 */
	public void setFoBreakAfterAttribute( String foBreakAfterValue )
	{
		FoBreakAfterAttribute attr =  new FoBreakAfterAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foBreakAfterValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoBackgroundColorAttribute</code> , See {@odf.attribute fo:background-color}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoBackgroundColorAttribute()
	{
		FoBackgroundColorAttribute attr = (FoBackgroundColorAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "background-color" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoBackgroundColorAttribute</code> , See {@odf.attribute fo:background-color}
	 *
	 * @param foBackgroundColorValue   The type is <code>String</code>
	 */
	public void setFoBackgroundColorAttribute( String foBackgroundColorValue )
	{
		FoBackgroundColorAttribute attr =  new FoBackgroundColorAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foBackgroundColorValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoBorderAttribute</code> , See {@odf.attribute fo:border}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoBorderAttribute()
	{
		FoBorderAttribute attr = (FoBorderAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "border" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoBorderAttribute</code> , See {@odf.attribute fo:border}
	 *
	 * @param foBorderValue   The type is <code>String</code>
	 */
	public void setFoBorderAttribute( String foBorderValue )
	{
		FoBorderAttribute attr =  new FoBorderAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foBorderValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoBorderTopAttribute</code> , See {@odf.attribute fo:border-top}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoBorderTopAttribute()
	{
		FoBorderTopAttribute attr = (FoBorderTopAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "border-top" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoBorderTopAttribute</code> , See {@odf.attribute fo:border-top}
	 *
	 * @param foBorderTopValue   The type is <code>String</code>
	 */
	public void setFoBorderTopAttribute( String foBorderTopValue )
	{
		FoBorderTopAttribute attr =  new FoBorderTopAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foBorderTopValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoBorderBottomAttribute</code> , See {@odf.attribute fo:border-bottom}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoBorderBottomAttribute()
	{
		FoBorderBottomAttribute attr = (FoBorderBottomAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "border-bottom" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoBorderBottomAttribute</code> , See {@odf.attribute fo:border-bottom}
	 *
	 * @param foBorderBottomValue   The type is <code>String</code>
	 */
	public void setFoBorderBottomAttribute( String foBorderBottomValue )
	{
		FoBorderBottomAttribute attr =  new FoBorderBottomAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foBorderBottomValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoBorderLeftAttribute</code> , See {@odf.attribute fo:border-left}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoBorderLeftAttribute()
	{
		FoBorderLeftAttribute attr = (FoBorderLeftAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "border-left" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoBorderLeftAttribute</code> , See {@odf.attribute fo:border-left}
	 *
	 * @param foBorderLeftValue   The type is <code>String</code>
	 */
	public void setFoBorderLeftAttribute( String foBorderLeftValue )
	{
		FoBorderLeftAttribute attr =  new FoBorderLeftAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foBorderLeftValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoBorderRightAttribute</code> , See {@odf.attribute fo:border-right}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoBorderRightAttribute()
	{
		FoBorderRightAttribute attr = (FoBorderRightAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "border-right" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoBorderRightAttribute</code> , See {@odf.attribute fo:border-right}
	 *
	 * @param foBorderRightValue   The type is <code>String</code>
	 */
	public void setFoBorderRightAttribute( String foBorderRightValue )
	{
		FoBorderRightAttribute attr =  new FoBorderRightAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foBorderRightValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleBorderLineWidthAttribute</code> , See {@odf.attribute style:border-line-width}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleBorderLineWidthAttribute()
	{
		StyleBorderLineWidthAttribute attr = (StyleBorderLineWidthAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "border-line-width" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthAttribute</code> , See {@odf.attribute style:border-line-width}
	 *
	 * @param styleBorderLineWidthValue   The type is <code>String</code>
	 */
	public void setStyleBorderLineWidthAttribute( String styleBorderLineWidthValue )
	{
		StyleBorderLineWidthAttribute attr =  new StyleBorderLineWidthAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleBorderLineWidthValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleBorderLineWidthTopAttribute</code> , See {@odf.attribute style:border-line-width-top}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleBorderLineWidthTopAttribute()
	{
		StyleBorderLineWidthTopAttribute attr = (StyleBorderLineWidthTopAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "border-line-width-top" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthTopAttribute</code> , See {@odf.attribute style:border-line-width-top}
	 *
	 * @param styleBorderLineWidthTopValue   The type is <code>String</code>
	 */
	public void setStyleBorderLineWidthTopAttribute( String styleBorderLineWidthTopValue )
	{
		StyleBorderLineWidthTopAttribute attr =  new StyleBorderLineWidthTopAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleBorderLineWidthTopValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleBorderLineWidthBottomAttribute</code> , See {@odf.attribute style:border-line-width-bottom}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleBorderLineWidthBottomAttribute()
	{
		StyleBorderLineWidthBottomAttribute attr = (StyleBorderLineWidthBottomAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "border-line-width-bottom" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthBottomAttribute</code> , See {@odf.attribute style:border-line-width-bottom}
	 *
	 * @param styleBorderLineWidthBottomValue   The type is <code>String</code>
	 */
	public void setStyleBorderLineWidthBottomAttribute( String styleBorderLineWidthBottomValue )
	{
		StyleBorderLineWidthBottomAttribute attr =  new StyleBorderLineWidthBottomAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleBorderLineWidthBottomValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleBorderLineWidthLeftAttribute</code> , See {@odf.attribute style:border-line-width-left}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleBorderLineWidthLeftAttribute()
	{
		StyleBorderLineWidthLeftAttribute attr = (StyleBorderLineWidthLeftAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "border-line-width-left" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthLeftAttribute</code> , See {@odf.attribute style:border-line-width-left}
	 *
	 * @param styleBorderLineWidthLeftValue   The type is <code>String</code>
	 */
	public void setStyleBorderLineWidthLeftAttribute( String styleBorderLineWidthLeftValue )
	{
		StyleBorderLineWidthLeftAttribute attr =  new StyleBorderLineWidthLeftAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleBorderLineWidthLeftValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleBorderLineWidthRightAttribute</code> , See {@odf.attribute style:border-line-width-right}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleBorderLineWidthRightAttribute()
	{
		StyleBorderLineWidthRightAttribute attr = (StyleBorderLineWidthRightAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "border-line-width-right" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthRightAttribute</code> , See {@odf.attribute style:border-line-width-right}
	 *
	 * @param styleBorderLineWidthRightValue   The type is <code>String</code>
	 */
	public void setStyleBorderLineWidthRightAttribute( String styleBorderLineWidthRightValue )
	{
		StyleBorderLineWidthRightAttribute attr =  new StyleBorderLineWidthRightAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleBorderLineWidthRightValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleJoinBorderAttribute</code> , See {@odf.attribute style:join-border}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getStyleJoinBorderAttribute()
	{
		StyleJoinBorderAttribute attr = (StyleJoinBorderAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "join-border" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleJoinBorderAttribute</code> , See {@odf.attribute style:join-border}
	 *
	 * @param styleJoinBorderValue   The type is <code>Boolean</code>
	 */
	public void setStyleJoinBorderAttribute( Boolean styleJoinBorderValue )
	{
		StyleJoinBorderAttribute attr =  new StyleJoinBorderAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( styleJoinBorderValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoPaddingAttribute</code> , See {@odf.attribute fo:padding}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoPaddingAttribute()
	{
		FoPaddingAttribute attr = (FoPaddingAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "padding" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoPaddingAttribute</code> , See {@odf.attribute fo:padding}
	 *
	 * @param foPaddingValue   The type is <code>String</code>
	 */
	public void setFoPaddingAttribute( String foPaddingValue )
	{
		FoPaddingAttribute attr =  new FoPaddingAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foPaddingValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoPaddingTopAttribute</code> , See {@odf.attribute fo:padding-top}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoPaddingTopAttribute()
	{
		FoPaddingTopAttribute attr = (FoPaddingTopAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "padding-top" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoPaddingTopAttribute</code> , See {@odf.attribute fo:padding-top}
	 *
	 * @param foPaddingTopValue   The type is <code>String</code>
	 */
	public void setFoPaddingTopAttribute( String foPaddingTopValue )
	{
		FoPaddingTopAttribute attr =  new FoPaddingTopAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foPaddingTopValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoPaddingBottomAttribute</code> , See {@odf.attribute fo:padding-bottom}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoPaddingBottomAttribute()
	{
		FoPaddingBottomAttribute attr = (FoPaddingBottomAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "padding-bottom" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoPaddingBottomAttribute</code> , See {@odf.attribute fo:padding-bottom}
	 *
	 * @param foPaddingBottomValue   The type is <code>String</code>
	 */
	public void setFoPaddingBottomAttribute( String foPaddingBottomValue )
	{
		FoPaddingBottomAttribute attr =  new FoPaddingBottomAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foPaddingBottomValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoPaddingLeftAttribute</code> , See {@odf.attribute fo:padding-left}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoPaddingLeftAttribute()
	{
		FoPaddingLeftAttribute attr = (FoPaddingLeftAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "padding-left" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoPaddingLeftAttribute</code> , See {@odf.attribute fo:padding-left}
	 *
	 * @param foPaddingLeftValue   The type is <code>String</code>
	 */
	public void setFoPaddingLeftAttribute( String foPaddingLeftValue )
	{
		FoPaddingLeftAttribute attr =  new FoPaddingLeftAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foPaddingLeftValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoPaddingRightAttribute</code> , See {@odf.attribute fo:padding-right}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoPaddingRightAttribute()
	{
		FoPaddingRightAttribute attr = (FoPaddingRightAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "padding-right" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoPaddingRightAttribute</code> , See {@odf.attribute fo:padding-right}
	 *
	 * @param foPaddingRightValue   The type is <code>String</code>
	 */
	public void setFoPaddingRightAttribute( String foPaddingRightValue )
	{
		FoPaddingRightAttribute attr =  new FoPaddingRightAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foPaddingRightValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleShadowAttribute</code> , See {@odf.attribute style:shadow}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleShadowAttribute()
	{
		StyleShadowAttribute attr = (StyleShadowAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "shadow" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleShadowAttribute</code> , See {@odf.attribute style:shadow}
	 *
	 * @param styleShadowValue   The type is <code>String</code>
	 */
	public void setStyleShadowAttribute( String styleShadowValue )
	{
		StyleShadowAttribute attr =  new StyleShadowAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleShadowValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoKeepWithNextAttribute</code> , See {@odf.attribute fo:keep-with-next}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoKeepWithNextAttribute()
	{
		FoKeepWithNextAttribute attr = (FoKeepWithNextAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "keep-with-next" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoKeepWithNextAttribute</code> , See {@odf.attribute fo:keep-with-next}
	 *
	 * @param foKeepWithNextValue   The type is <code>String</code>
	 */
	public void setFoKeepWithNextAttribute( String foKeepWithNextValue )
	{
		FoKeepWithNextAttribute attr =  new FoKeepWithNextAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foKeepWithNextValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextNumberLinesAttribute</code> , See {@odf.attribute text:number-lines}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getTextNumberLinesAttribute()
	{
		TextNumberLinesAttribute attr = (TextNumberLinesAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "number-lines" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextNumberLinesAttribute</code> , See {@odf.attribute text:number-lines}
	 *
	 * @param textNumberLinesValue   The type is <code>Boolean</code>
	 */
	public void setTextNumberLinesAttribute( Boolean textNumberLinesValue )
	{
		TextNumberLinesAttribute attr =  new TextNumberLinesAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( textNumberLinesValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextLineNumberAttribute</code> , See {@odf.attribute text:line-number}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getTextLineNumberAttribute()
	{
		TextLineNumberAttribute attr = (TextLineNumberAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "line-number" ) ;
		if( attr != null ){
			return Integer.valueOf( attr.intValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextLineNumberAttribute</code> , See {@odf.attribute text:line-number}
	 *
	 * @param textLineNumberValue   The type is <code>Integer</code>
	 */
	public void setTextLineNumberAttribute( Integer textLineNumberValue )
	{
		TextLineNumberAttribute attr =  new TextLineNumberAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setIntValue( textLineNumberValue.intValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleTextAutospaceAttribute</code> , See {@odf.attribute style:text-autospace}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleTextAutospaceAttribute()
	{
		StyleTextAutospaceAttribute attr = (StyleTextAutospaceAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "text-autospace" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleTextAutospaceAttribute</code> , See {@odf.attribute style:text-autospace}
	 *
	 * @param styleTextAutospaceValue   The type is <code>String</code>
	 */
	public void setStyleTextAutospaceAttribute( String styleTextAutospaceValue )
	{
		StyleTextAutospaceAttribute attr =  new StyleTextAutospaceAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleTextAutospaceValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StylePunctuationWrapAttribute</code> , See {@odf.attribute style:punctuation-wrap}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStylePunctuationWrapAttribute()
	{
		StylePunctuationWrapAttribute attr = (StylePunctuationWrapAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "punctuation-wrap" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StylePunctuationWrapAttribute</code> , See {@odf.attribute style:punctuation-wrap}
	 *
	 * @param stylePunctuationWrapValue   The type is <code>String</code>
	 */
	public void setStylePunctuationWrapAttribute( String stylePunctuationWrapValue )
	{
		StylePunctuationWrapAttribute attr =  new StylePunctuationWrapAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( stylePunctuationWrapValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleLineBreakAttribute</code> , See {@odf.attribute style:line-break}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleLineBreakAttribute()
	{
		StyleLineBreakAttribute attr = (StyleLineBreakAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "line-break" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleLineBreakAttribute</code> , See {@odf.attribute style:line-break}
	 *
	 * @param styleLineBreakValue   The type is <code>String</code>
	 */
	public void setStyleLineBreakAttribute( String styleLineBreakValue )
	{
		StyleLineBreakAttribute attr =  new StyleLineBreakAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleLineBreakValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleVerticalAlignAttribute</code> , See {@odf.attribute style:vertical-align}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleVerticalAlignAttribute()
	{
		StyleVerticalAlignAttribute attr = (StyleVerticalAlignAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "vertical-align" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleVerticalAlignAttribute</code> , See {@odf.attribute style:vertical-align}
	 *
	 * @param styleVerticalAlignValue   The type is <code>String</code>
	 */
	public void setStyleVerticalAlignAttribute( String styleVerticalAlignValue )
	{
		StyleVerticalAlignAttribute attr =  new StyleVerticalAlignAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleVerticalAlignValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleWritingModeAttribute</code> , See {@odf.attribute style:writing-mode}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleWritingModeAttribute()
	{
		StyleWritingModeAttribute attr = (StyleWritingModeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "writing-mode" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleWritingModeAttribute</code> , See {@odf.attribute style:writing-mode}
	 *
	 * @param styleWritingModeValue   The type is <code>String</code>
	 */
	public void setStyleWritingModeAttribute( String styleWritingModeValue )
	{
		StyleWritingModeAttribute attr =  new StyleWritingModeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleWritingModeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleWritingModeAutomaticAttribute</code> , See {@odf.attribute style:writing-mode-automatic}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getStyleWritingModeAutomaticAttribute()
	{
		StyleWritingModeAutomaticAttribute attr = (StyleWritingModeAutomaticAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "writing-mode-automatic" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleWritingModeAutomaticAttribute</code> , See {@odf.attribute style:writing-mode-automatic}
	 *
	 * @param styleWritingModeAutomaticValue   The type is <code>Boolean</code>
	 */
	public void setStyleWritingModeAutomaticAttribute( Boolean styleWritingModeAutomaticValue )
	{
		StyleWritingModeAutomaticAttribute attr =  new StyleWritingModeAutomaticAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( styleWritingModeAutomaticValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleSnapToLayoutGridAttribute</code> , See {@odf.attribute style:snap-to-layout-grid}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getStyleSnapToLayoutGridAttribute()
	{
		StyleSnapToLayoutGridAttribute attr = (StyleSnapToLayoutGridAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "snap-to-layout-grid" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleSnapToLayoutGridAttribute</code> , See {@odf.attribute style:snap-to-layout-grid}
	 *
	 * @param styleSnapToLayoutGridValue   The type is <code>Boolean</code>
	 */
	public void setStyleSnapToLayoutGridAttribute( Boolean styleSnapToLayoutGridValue )
	{
		StyleSnapToLayoutGridAttribute attr =  new StyleSnapToLayoutGridAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( styleSnapToLayoutGridValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StylePageNumberAttribute</code> , See {@odf.attribute style:page-number}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStylePageNumberAttribute()
	{
		StylePageNumberAttribute attr = (StylePageNumberAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "page-number" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StylePageNumberAttribute</code> , See {@odf.attribute style:page-number}
	 *
	 * @param stylePageNumberValue   The type is <code>String</code>
	 */
	public void setStylePageNumberAttribute( String stylePageNumberValue )
	{
		StylePageNumberAttribute attr =  new StylePageNumberAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( stylePageNumberValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleBackgroundTransparencyAttribute</code> , See {@odf.attribute style:background-transparency}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleBackgroundTransparencyAttribute()
	{
		StyleBackgroundTransparencyAttribute attr = (StyleBackgroundTransparencyAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "background-transparency" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleBackgroundTransparencyAttribute</code> , See {@odf.attribute style:background-transparency}
	 *
	 * @param styleBackgroundTransparencyValue   The type is <code>String</code>
	 */
	public void setStyleBackgroundTransparencyAttribute( String styleBackgroundTransparencyValue )
	{
		StyleBackgroundTransparencyAttribute attr =  new StyleBackgroundTransparencyAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleBackgroundTransparencyValue );
	}

	/**
	 * Create child element {@odf.element style:tab-stop}.
	 *
     * @param stylePositionAttributeValue  the <code>String</code> value of <code>StylePositionAttribute</code>, see {@odf.attribute  style:position} at specification
	 * @param styleTypeAttributeValue  the <code>String</code> value of <code>StyleTypeAttribute</code>, see {@odf.attribute  style:type} at specification
	 * @return   return  the element {@odf.element style:tab-stop}
	 * DifferentQName 
	 */
    
	public StyleTabStopElement newStyleTabStopElement(String stylePositionAttributeValue, String styleTypeAttributeValue)
	{
		StyleTabStopElement  styleTabStop = ((OdfFileDom)this.ownerDocument).newOdfElement(StyleTabStopElement.class);
		styleTabStop.setStylePositionAttribute( stylePositionAttributeValue );
		styleTabStop.setStyleTypeAttribute( styleTypeAttributeValue );
		this.appendChild( styleTabStop);
		return  styleTabStop;      
	}
    
	/**
	 * Create child element {@odf.element office:binary-data}.
	 *
	 * @return   return  the element {@odf.element office:binary-data}
	 * DifferentQName 
	 */
	public OfficeBinaryDataElement newOfficeBinaryDataElement()
	{
		OfficeBinaryDataElement  officeBinaryData = ((OdfFileDom)this.ownerDocument).newOdfElement(OfficeBinaryDataElement.class);
		this.appendChild( officeBinaryData);
		return  officeBinaryData;
	}                   
               
}
