/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFillAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFillColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawSecondaryFillColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFillGradientNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawGradientStepCountAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFillHatchNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFillHatchSolidAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFillImageNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleRepeatAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFillImageWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFillImageHeightAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFillImageRefPointXAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFillImageRefPointYAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFillImageRefPointAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawTileRepeatOffsetAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawOpacityAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawOpacityNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.svg.SvgFillRuleAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationTransitionTypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationTransitionStyleAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationTransitionSpeedAttribute;
import org.odftoolkit.odfdom.dom.attribute.smil.SmilTypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.smil.SmilSubtypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.smil.SmilDirectionAttribute;
import org.odftoolkit.odfdom.dom.attribute.smil.SmilFadeColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationDurationAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationVisibilityAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawBackgroundSizeAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationBackgroundObjectsVisibleAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationBackgroundVisibleAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationDisplayHeaderAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationDisplayFooterAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationDisplayPageNumberAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationDisplayDateTimeAttribute;

import org.odftoolkit.odfdom.dom.element.presentation.PresentationSoundElement;

/**
 * DOM implementation of OpenDocument element  {@odf.element style:drawing-page-properties}.
 *
 */
public class StyleDrawingPagePropertiesElement extends OdfStylePropertiesBase
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.STYLE, "drawing-page-properties" );


	/**
	 * Create the instance of <code>StyleDrawingPagePropertiesElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public StyleDrawingPagePropertiesElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element style:drawing-page-properties}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}

    public final static OdfStyleProperty Fill = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.DRAW, "fill"));
    public final static OdfStyleProperty FillColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.DRAW, "fill-color"));
    public final static OdfStyleProperty SecondaryFillColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.DRAW, "secondary-fill-color"));
    public final static OdfStyleProperty FillGradientName = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.DRAW, "fill-gradient-name"));
    public final static OdfStyleProperty GradientStepCount = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.DRAW, "gradient-step-count"));
    public final static OdfStyleProperty FillHatchName = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.DRAW, "fill-hatch-name"));
    public final static OdfStyleProperty FillHatchSolid = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.DRAW, "fill-hatch-solid"));
    public final static OdfStyleProperty FillImageName = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.DRAW, "fill-image-name"));
    public final static OdfStyleProperty Repeat = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.STYLE, "repeat"));
    public final static OdfStyleProperty FillImageWidth = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.DRAW, "fill-image-width"));
    public final static OdfStyleProperty FillImageHeight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.DRAW, "fill-image-height"));
    public final static OdfStyleProperty FillImageRefPointX = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.DRAW, "fill-image-ref-point-x"));
    public final static OdfStyleProperty FillImageRefPointY = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.DRAW, "fill-image-ref-point-y"));
    public final static OdfStyleProperty FillImageRefPoint = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.DRAW, "fill-image-ref-point"));
    public final static OdfStyleProperty TileRepeatOffset = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.DRAW, "tile-repeat-offset"));
    public final static OdfStyleProperty Opacity = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.DRAW, "opacity"));
    public final static OdfStyleProperty OpacityName = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.DRAW, "opacity-name"));
    public final static OdfStyleProperty FillRule = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.SVG, "fill-rule"));
    public final static OdfStyleProperty TransitionType = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.PRESENTATION, "transition-type"));
    public final static OdfStyleProperty TransitionStyle = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.PRESENTATION, "transition-style"));
    public final static OdfStyleProperty TransitionSpeed = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.PRESENTATION, "transition-speed"));
    public final static OdfStyleProperty Type = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.SMIL, "type"));
    public final static OdfStyleProperty Subtype = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.SMIL, "subtype"));
    public final static OdfStyleProperty Direction = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.SMIL, "direction"));
    public final static OdfStyleProperty FadeColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.SMIL, "fadeColor"));
    public final static OdfStyleProperty Duration = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.PRESENTATION, "duration"));
    public final static OdfStyleProperty Visibility = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.PRESENTATION, "visibility"));
    public final static OdfStyleProperty BackgroundSize = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.DRAW, "background-size"));
    public final static OdfStyleProperty BackgroundObjectsVisible = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.PRESENTATION, "background-objects-visible"));
    public final static OdfStyleProperty BackgroundVisible = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.PRESENTATION, "background-visible"));
    public final static OdfStyleProperty DisplayHeader = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.PRESENTATION, "display-header"));
    public final static OdfStyleProperty DisplayFooter = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.PRESENTATION, "display-footer"));
    public final static OdfStyleProperty DisplayPageNumber = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.PRESENTATION, "display-page-number"));
    public final static OdfStyleProperty DisplayDateTime = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.newName(OdfNamespaceNames.PRESENTATION, "display-date-time"));


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFillAttribute</code> , See {@odf.attribute draw:fill}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawFillAttribute()
	{
		DrawFillAttribute attr = (DrawFillAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "fill" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFillAttribute</code> , See {@odf.attribute draw:fill}
	 *
	 * @param drawFillValue   The type is <code>String</code>
	 */
	public void setDrawFillAttribute( String drawFillValue )
	{
		DrawFillAttribute attr =  new DrawFillAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawFillValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFillColorAttribute</code> , See {@odf.attribute draw:fill-color}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawFillColorAttribute()
	{
		DrawFillColorAttribute attr = (DrawFillColorAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "fill-color" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFillColorAttribute</code> , See {@odf.attribute draw:fill-color}
	 *
	 * @param drawFillColorValue   The type is <code>String</code>
	 */
	public void setDrawFillColorAttribute( String drawFillColorValue )
	{
		DrawFillColorAttribute attr =  new DrawFillColorAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawFillColorValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawSecondaryFillColorAttribute</code> , See {@odf.attribute draw:secondary-fill-color}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawSecondaryFillColorAttribute()
	{
		DrawSecondaryFillColorAttribute attr = (DrawSecondaryFillColorAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "secondary-fill-color" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawSecondaryFillColorAttribute</code> , See {@odf.attribute draw:secondary-fill-color}
	 *
	 * @param drawSecondaryFillColorValue   The type is <code>String</code>
	 */
	public void setDrawSecondaryFillColorAttribute( String drawSecondaryFillColorValue )
	{
		DrawSecondaryFillColorAttribute attr =  new DrawSecondaryFillColorAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawSecondaryFillColorValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFillGradientNameAttribute</code> , See {@odf.attribute draw:fill-gradient-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawFillGradientNameAttribute()
	{
		DrawFillGradientNameAttribute attr = (DrawFillGradientNameAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "fill-gradient-name" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFillGradientNameAttribute</code> , See {@odf.attribute draw:fill-gradient-name}
	 *
	 * @param drawFillGradientNameValue   The type is <code>String</code>
	 */
	public void setDrawFillGradientNameAttribute( String drawFillGradientNameValue )
	{
		DrawFillGradientNameAttribute attr =  new DrawFillGradientNameAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawFillGradientNameValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawGradientStepCountAttribute</code> , See {@odf.attribute draw:gradient-step-count}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getDrawGradientStepCountAttribute()
	{
		DrawGradientStepCountAttribute attr = (DrawGradientStepCountAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "gradient-step-count" ) ;
		if( attr != null ){
			return Integer.valueOf( attr.intValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawGradientStepCountAttribute</code> , See {@odf.attribute draw:gradient-step-count}
	 *
	 * @param drawGradientStepCountValue   The type is <code>Integer</code>
	 */
	public void setDrawGradientStepCountAttribute( Integer drawGradientStepCountValue )
	{
		DrawGradientStepCountAttribute attr =  new DrawGradientStepCountAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setIntValue( drawGradientStepCountValue.intValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFillHatchNameAttribute</code> , See {@odf.attribute draw:fill-hatch-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawFillHatchNameAttribute()
	{
		DrawFillHatchNameAttribute attr = (DrawFillHatchNameAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "fill-hatch-name" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFillHatchNameAttribute</code> , See {@odf.attribute draw:fill-hatch-name}
	 *
	 * @param drawFillHatchNameValue   The type is <code>String</code>
	 */
	public void setDrawFillHatchNameAttribute( String drawFillHatchNameValue )
	{
		DrawFillHatchNameAttribute attr =  new DrawFillHatchNameAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawFillHatchNameValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFillHatchSolidAttribute</code> , See {@odf.attribute draw:fill-hatch-solid}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getDrawFillHatchSolidAttribute()
	{
		DrawFillHatchSolidAttribute attr = (DrawFillHatchSolidAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "fill-hatch-solid" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFillHatchSolidAttribute</code> , See {@odf.attribute draw:fill-hatch-solid}
	 *
	 * @param drawFillHatchSolidValue   The type is <code>Boolean</code>
	 */
	public void setDrawFillHatchSolidAttribute( Boolean drawFillHatchSolidValue )
	{
		DrawFillHatchSolidAttribute attr =  new DrawFillHatchSolidAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( drawFillHatchSolidValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFillImageNameAttribute</code> , See {@odf.attribute draw:fill-image-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawFillImageNameAttribute()
	{
		DrawFillImageNameAttribute attr = (DrawFillImageNameAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "fill-image-name" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFillImageNameAttribute</code> , See {@odf.attribute draw:fill-image-name}
	 *
	 * @param drawFillImageNameValue   The type is <code>String</code>
	 */
	public void setDrawFillImageNameAttribute( String drawFillImageNameValue )
	{
		DrawFillImageNameAttribute attr =  new DrawFillImageNameAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawFillImageNameValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleRepeatAttribute</code> , See {@odf.attribute style:repeat}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleRepeatAttribute()
	{
		StyleRepeatAttribute attr = (StyleRepeatAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "repeat" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleRepeatAttribute</code> , See {@odf.attribute style:repeat}
	 *
	 * @param styleRepeatValue   The type is <code>String</code>
	 */
	public void setStyleRepeatAttribute( String styleRepeatValue )
	{
		StyleRepeatAttribute attr =  new StyleRepeatAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleRepeatValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFillImageWidthAttribute</code> , See {@odf.attribute draw:fill-image-width}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawFillImageWidthAttribute()
	{
		DrawFillImageWidthAttribute attr = (DrawFillImageWidthAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "fill-image-width" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFillImageWidthAttribute</code> , See {@odf.attribute draw:fill-image-width}
	 *
	 * @param drawFillImageWidthValue   The type is <code>String</code>
	 */
	public void setDrawFillImageWidthAttribute( String drawFillImageWidthValue )
	{
		DrawFillImageWidthAttribute attr =  new DrawFillImageWidthAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawFillImageWidthValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFillImageHeightAttribute</code> , See {@odf.attribute draw:fill-image-height}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawFillImageHeightAttribute()
	{
		DrawFillImageHeightAttribute attr = (DrawFillImageHeightAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "fill-image-height" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFillImageHeightAttribute</code> , See {@odf.attribute draw:fill-image-height}
	 *
	 * @param drawFillImageHeightValue   The type is <code>String</code>
	 */
	public void setDrawFillImageHeightAttribute( String drawFillImageHeightValue )
	{
		DrawFillImageHeightAttribute attr =  new DrawFillImageHeightAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawFillImageHeightValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFillImageRefPointXAttribute</code> , See {@odf.attribute draw:fill-image-ref-point-x}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawFillImageRefPointXAttribute()
	{
		DrawFillImageRefPointXAttribute attr = (DrawFillImageRefPointXAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "fill-image-ref-point-x" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFillImageRefPointXAttribute</code> , See {@odf.attribute draw:fill-image-ref-point-x}
	 *
	 * @param drawFillImageRefPointXValue   The type is <code>String</code>
	 */
	public void setDrawFillImageRefPointXAttribute( String drawFillImageRefPointXValue )
	{
		DrawFillImageRefPointXAttribute attr =  new DrawFillImageRefPointXAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawFillImageRefPointXValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFillImageRefPointYAttribute</code> , See {@odf.attribute draw:fill-image-ref-point-y}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawFillImageRefPointYAttribute()
	{
		DrawFillImageRefPointYAttribute attr = (DrawFillImageRefPointYAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "fill-image-ref-point-y" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFillImageRefPointYAttribute</code> , See {@odf.attribute draw:fill-image-ref-point-y}
	 *
	 * @param drawFillImageRefPointYValue   The type is <code>String</code>
	 */
	public void setDrawFillImageRefPointYAttribute( String drawFillImageRefPointYValue )
	{
		DrawFillImageRefPointYAttribute attr =  new DrawFillImageRefPointYAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawFillImageRefPointYValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFillImageRefPointAttribute</code> , See {@odf.attribute draw:fill-image-ref-point}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawFillImageRefPointAttribute()
	{
		DrawFillImageRefPointAttribute attr = (DrawFillImageRefPointAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "fill-image-ref-point" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFillImageRefPointAttribute</code> , See {@odf.attribute draw:fill-image-ref-point}
	 *
	 * @param drawFillImageRefPointValue   The type is <code>String</code>
	 */
	public void setDrawFillImageRefPointAttribute( String drawFillImageRefPointValue )
	{
		DrawFillImageRefPointAttribute attr =  new DrawFillImageRefPointAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawFillImageRefPointValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawTileRepeatOffsetAttribute</code> , See {@odf.attribute draw:tile-repeat-offset}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawTileRepeatOffsetAttribute()
	{
		DrawTileRepeatOffsetAttribute attr = (DrawTileRepeatOffsetAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "tile-repeat-offset" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawTileRepeatOffsetAttribute</code> , See {@odf.attribute draw:tile-repeat-offset}
	 *
	 * @param drawTileRepeatOffsetValue   The type is <code>String</code>
	 */
	public void setDrawTileRepeatOffsetAttribute( String drawTileRepeatOffsetValue )
	{
		DrawTileRepeatOffsetAttribute attr =  new DrawTileRepeatOffsetAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawTileRepeatOffsetValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawOpacityAttribute</code> , See {@odf.attribute draw:opacity}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawOpacityAttribute()
	{
		DrawOpacityAttribute attr = (DrawOpacityAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "opacity" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawOpacityAttribute</code> , See {@odf.attribute draw:opacity}
	 *
	 * @param drawOpacityValue   The type is <code>String</code>
	 */
	public void setDrawOpacityAttribute( String drawOpacityValue )
	{
		DrawOpacityAttribute attr =  new DrawOpacityAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawOpacityValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawOpacityNameAttribute</code> , See {@odf.attribute draw:opacity-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawOpacityNameAttribute()
	{
		DrawOpacityNameAttribute attr = (DrawOpacityNameAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "opacity-name" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawOpacityNameAttribute</code> , See {@odf.attribute draw:opacity-name}
	 *
	 * @param drawOpacityNameValue   The type is <code>String</code>
	 */
	public void setDrawOpacityNameAttribute( String drawOpacityNameValue )
	{
		DrawOpacityNameAttribute attr =  new DrawOpacityNameAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawOpacityNameValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>SvgFillRuleAttribute</code> , See {@odf.attribute svg:fill-rule}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getSvgFillRuleAttribute()
	{
		SvgFillRuleAttribute attr = (SvgFillRuleAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.SVG), "fill-rule" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>SvgFillRuleAttribute</code> , See {@odf.attribute svg:fill-rule}
	 *
	 * @param svgFillRuleValue   The type is <code>String</code>
	 */
	public void setSvgFillRuleAttribute( String svgFillRuleValue )
	{
		SvgFillRuleAttribute attr =  new SvgFillRuleAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( svgFillRuleValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>PresentationTransitionTypeAttribute</code> , See {@odf.attribute presentation:transition-type}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getPresentationTransitionTypeAttribute()
	{
		PresentationTransitionTypeAttribute attr = (PresentationTransitionTypeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION), "transition-type" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>PresentationTransitionTypeAttribute</code> , See {@odf.attribute presentation:transition-type}
	 *
	 * @param presentationTransitionTypeValue   The type is <code>String</code>
	 */
	public void setPresentationTransitionTypeAttribute( String presentationTransitionTypeValue )
	{
		PresentationTransitionTypeAttribute attr =  new PresentationTransitionTypeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( presentationTransitionTypeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>PresentationTransitionStyleAttribute</code> , See {@odf.attribute presentation:transition-style}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getPresentationTransitionStyleAttribute()
	{
		PresentationTransitionStyleAttribute attr = (PresentationTransitionStyleAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION), "transition-style" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>PresentationTransitionStyleAttribute</code> , See {@odf.attribute presentation:transition-style}
	 *
	 * @param presentationTransitionStyleValue   The type is <code>String</code>
	 */
	public void setPresentationTransitionStyleAttribute( String presentationTransitionStyleValue )
	{
		PresentationTransitionStyleAttribute attr =  new PresentationTransitionStyleAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( presentationTransitionStyleValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>PresentationTransitionSpeedAttribute</code> , See {@odf.attribute presentation:transition-speed}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getPresentationTransitionSpeedAttribute()
	{
		PresentationTransitionSpeedAttribute attr = (PresentationTransitionSpeedAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION), "transition-speed" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>PresentationTransitionSpeedAttribute</code> , See {@odf.attribute presentation:transition-speed}
	 *
	 * @param presentationTransitionSpeedValue   The type is <code>String</code>
	 */
	public void setPresentationTransitionSpeedAttribute( String presentationTransitionSpeedValue )
	{
		PresentationTransitionSpeedAttribute attr =  new PresentationTransitionSpeedAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( presentationTransitionSpeedValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>SmilTypeAttribute</code> , See {@odf.attribute smil:type}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getSmilTypeAttribute()
	{
		SmilTypeAttribute attr = (SmilTypeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.SMIL), "type" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>SmilTypeAttribute</code> , See {@odf.attribute smil:type}
	 *
	 * @param smilTypeValue   The type is <code>String</code>
	 */
	public void setSmilTypeAttribute( String smilTypeValue )
	{
		SmilTypeAttribute attr =  new SmilTypeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( smilTypeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>SmilSubtypeAttribute</code> , See {@odf.attribute smil:subtype}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getSmilSubtypeAttribute()
	{
		SmilSubtypeAttribute attr = (SmilSubtypeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.SMIL), "subtype" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>SmilSubtypeAttribute</code> , See {@odf.attribute smil:subtype}
	 *
	 * @param smilSubtypeValue   The type is <code>String</code>
	 */
	public void setSmilSubtypeAttribute( String smilSubtypeValue )
	{
		SmilSubtypeAttribute attr =  new SmilSubtypeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( smilSubtypeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>SmilDirectionAttribute</code> , See {@odf.attribute smil:direction}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getSmilDirectionAttribute()
	{
		SmilDirectionAttribute attr = (SmilDirectionAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.SMIL), "direction" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>SmilDirectionAttribute</code> , See {@odf.attribute smil:direction}
	 *
	 * @param smilDirectionValue   The type is <code>String</code>
	 */
	public void setSmilDirectionAttribute( String smilDirectionValue )
	{
		SmilDirectionAttribute attr =  new SmilDirectionAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( smilDirectionValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>SmilFadeColorAttribute</code> , See {@odf.attribute smil:fadeColor}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getSmilFadeColorAttribute()
	{
		SmilFadeColorAttribute attr = (SmilFadeColorAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.SMIL), "fadeColor" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return SmilFadeColorAttribute.DEFAULT_VALUE;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>SmilFadeColorAttribute</code> , See {@odf.attribute smil:fadeColor}
	 *
	 * @param smilFadeColorValue   The type is <code>String</code>
	 */
	public void setSmilFadeColorAttribute( String smilFadeColorValue )
	{
		SmilFadeColorAttribute attr =  new SmilFadeColorAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( smilFadeColorValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>PresentationDurationAttribute</code> , See {@odf.attribute presentation:duration}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getPresentationDurationAttribute()
	{
		PresentationDurationAttribute attr = (PresentationDurationAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION), "duration" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>PresentationDurationAttribute</code> , See {@odf.attribute presentation:duration}
	 *
	 * @param presentationDurationValue   The type is <code>String</code>
	 */
	public void setPresentationDurationAttribute( String presentationDurationValue )
	{
		PresentationDurationAttribute attr =  new PresentationDurationAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( presentationDurationValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>PresentationVisibilityAttribute</code> , See {@odf.attribute presentation:visibility}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getPresentationVisibilityAttribute()
	{
		PresentationVisibilityAttribute attr = (PresentationVisibilityAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION), "visibility" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>PresentationVisibilityAttribute</code> , See {@odf.attribute presentation:visibility}
	 *
	 * @param presentationVisibilityValue   The type is <code>String</code>
	 */
	public void setPresentationVisibilityAttribute( String presentationVisibilityValue )
	{
		PresentationVisibilityAttribute attr =  new PresentationVisibilityAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( presentationVisibilityValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawBackgroundSizeAttribute</code> , See {@odf.attribute draw:background-size}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawBackgroundSizeAttribute()
	{
		DrawBackgroundSizeAttribute attr = (DrawBackgroundSizeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "background-size" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawBackgroundSizeAttribute</code> , See {@odf.attribute draw:background-size}
	 *
	 * @param drawBackgroundSizeValue   The type is <code>String</code>
	 */
	public void setDrawBackgroundSizeAttribute( String drawBackgroundSizeValue )
	{
		DrawBackgroundSizeAttribute attr =  new DrawBackgroundSizeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawBackgroundSizeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>PresentationBackgroundObjectsVisibleAttribute</code> , See {@odf.attribute presentation:background-objects-visible}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getPresentationBackgroundObjectsVisibleAttribute()
	{
		PresentationBackgroundObjectsVisibleAttribute attr = (PresentationBackgroundObjectsVisibleAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION), "background-objects-visible" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>PresentationBackgroundObjectsVisibleAttribute</code> , See {@odf.attribute presentation:background-objects-visible}
	 *
	 * @param presentationBackgroundObjectsVisibleValue   The type is <code>Boolean</code>
	 */
	public void setPresentationBackgroundObjectsVisibleAttribute( Boolean presentationBackgroundObjectsVisibleValue )
	{
		PresentationBackgroundObjectsVisibleAttribute attr =  new PresentationBackgroundObjectsVisibleAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( presentationBackgroundObjectsVisibleValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>PresentationBackgroundVisibleAttribute</code> , See {@odf.attribute presentation:background-visible}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getPresentationBackgroundVisibleAttribute()
	{
		PresentationBackgroundVisibleAttribute attr = (PresentationBackgroundVisibleAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION), "background-visible" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>PresentationBackgroundVisibleAttribute</code> , See {@odf.attribute presentation:background-visible}
	 *
	 * @param presentationBackgroundVisibleValue   The type is <code>Boolean</code>
	 */
	public void setPresentationBackgroundVisibleAttribute( Boolean presentationBackgroundVisibleValue )
	{
		PresentationBackgroundVisibleAttribute attr =  new PresentationBackgroundVisibleAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( presentationBackgroundVisibleValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>PresentationDisplayHeaderAttribute</code> , See {@odf.attribute presentation:display-header}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getPresentationDisplayHeaderAttribute()
	{
		PresentationDisplayHeaderAttribute attr = (PresentationDisplayHeaderAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION), "display-header" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>PresentationDisplayHeaderAttribute</code> , See {@odf.attribute presentation:display-header}
	 *
	 * @param presentationDisplayHeaderValue   The type is <code>Boolean</code>
	 */
	public void setPresentationDisplayHeaderAttribute( Boolean presentationDisplayHeaderValue )
	{
		PresentationDisplayHeaderAttribute attr =  new PresentationDisplayHeaderAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( presentationDisplayHeaderValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>PresentationDisplayFooterAttribute</code> , See {@odf.attribute presentation:display-footer}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getPresentationDisplayFooterAttribute()
	{
		PresentationDisplayFooterAttribute attr = (PresentationDisplayFooterAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION), "display-footer" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>PresentationDisplayFooterAttribute</code> , See {@odf.attribute presentation:display-footer}
	 *
	 * @param presentationDisplayFooterValue   The type is <code>Boolean</code>
	 */
	public void setPresentationDisplayFooterAttribute( Boolean presentationDisplayFooterValue )
	{
		PresentationDisplayFooterAttribute attr =  new PresentationDisplayFooterAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( presentationDisplayFooterValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>PresentationDisplayPageNumberAttribute</code> , See {@odf.attribute presentation:display-page-number}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getPresentationDisplayPageNumberAttribute()
	{
		PresentationDisplayPageNumberAttribute attr = (PresentationDisplayPageNumberAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION), "display-page-number" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>PresentationDisplayPageNumberAttribute</code> , See {@odf.attribute presentation:display-page-number}
	 *
	 * @param presentationDisplayPageNumberValue   The type is <code>Boolean</code>
	 */
	public void setPresentationDisplayPageNumberAttribute( Boolean presentationDisplayPageNumberValue )
	{
		PresentationDisplayPageNumberAttribute attr =  new PresentationDisplayPageNumberAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( presentationDisplayPageNumberValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>PresentationDisplayDateTimeAttribute</code> , See {@odf.attribute presentation:display-date-time}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getPresentationDisplayDateTimeAttribute()
	{
		PresentationDisplayDateTimeAttribute attr = (PresentationDisplayDateTimeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION), "display-date-time" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>PresentationDisplayDateTimeAttribute</code> , See {@odf.attribute presentation:display-date-time}
	 *
	 * @param presentationDisplayDateTimeValue   The type is <code>Boolean</code>
	 */
	public void setPresentationDisplayDateTimeAttribute( Boolean presentationDisplayDateTimeValue )
	{
		PresentationDisplayDateTimeAttribute attr =  new PresentationDisplayDateTimeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( presentationDisplayDateTimeValue.booleanValue() );
	}

	/**
	 * Create child element {@odf.element presentation:sound}.
	 *
     * @param xlinkHrefAttributeValue  the <code>String</code> value of <code>XlinkHrefAttribute</code>, see {@odf.attribute  xlink:href} at specification
	 * @param xlinkTypeAttributeValue  the <code>String</code> value of <code>XlinkTypeAttribute</code>, see {@odf.attribute  xlink:type} at specification
	 * @return   return  the element {@odf.element presentation:sound}
	 * DifferentQName 
	 */
    
	public PresentationSoundElement newPresentationSoundElement(String xlinkHrefAttributeValue, String xlinkTypeAttributeValue)
	{
		PresentationSoundElement  presentationSound = ((OdfFileDom)this.ownerDocument).newOdfElement(PresentationSoundElement.class);
		presentationSound.setXlinkHrefAttribute( xlinkHrefAttributeValue );
		presentationSound.setXlinkTypeAttribute( xlinkTypeAttributeValue );
		this.appendChild( presentationSound);
		return  presentationSound;      
	}
    
}
