/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.office;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.OdfContainerElementBase;

import org.odftoolkit.odfdom.dom.element.style.StyleStyleElement;
import org.odftoolkit.odfdom.dom.element.text.TextListStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberNumberStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberCurrencyStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberPercentageStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberDateStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTimeStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberBooleanStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTextStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleDefaultStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleDefaultPageLayoutElement;
import org.odftoolkit.odfdom.dom.element.text.TextOutlineStyleElement;
import org.odftoolkit.odfdom.dom.element.text.TextNotesConfigurationElement;
import org.odftoolkit.odfdom.dom.element.text.TextBibliographyConfigurationElement;
import org.odftoolkit.odfdom.dom.element.text.TextLinenumberingConfigurationElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawGradientElement;
import org.odftoolkit.odfdom.dom.element.svg.SvgLinearGradientElement;
import org.odftoolkit.odfdom.dom.element.svg.SvgRadialGradientElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawHatchElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawFillImageElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawMarkerElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawStrokeDashElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawOpacityElement;
import org.odftoolkit.odfdom.dom.element.style.StylePresentationPageLayoutElement;

/**
 * DOM implementation of OpenDocument element  {@odf.element office:styles}.
 *
 */
public class OfficeStylesElement extends OdfContainerElementBase
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.OFFICE, "styles" );


	/**
	 * Create the instance of <code>OfficeStylesElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public OfficeStylesElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element office:styles}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}


	/**
	 * Create child element {@odf.element style:style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element style:style}
	 * DifferentQName 
	 */
    
	public StyleStyleElement newStyleStyleElement(String styleNameAttributeValue)
	{
		StyleStyleElement  styleStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(StyleStyleElement.class);
		styleStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( styleStyle);
		return  styleStyle;      
	}
    
	/**
	 * Create child element {@odf.element text:list-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element text:list-style}
	 * DifferentQName 
	 */
    
	public TextListStyleElement newTextListStyleElement(String styleNameAttributeValue)
	{
		TextListStyleElement  textListStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(TextListStyleElement.class);
		textListStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( textListStyle);
		return  textListStyle;      
	}
    
	/**
	 * Create child element {@odf.element number:number-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element number:number-style}
	 * DifferentQName 
	 */
    
	public NumberNumberStyleElement newNumberNumberStyleElement(String styleNameAttributeValue)
	{
		NumberNumberStyleElement  numberNumberStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberNumberStyleElement.class);
		numberNumberStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( numberNumberStyle);
		return  numberNumberStyle;      
	}
    
	/**
	 * Create child element {@odf.element number:currency-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element number:currency-style}
	 * DifferentQName 
	 */
    
	public NumberCurrencyStyleElement newNumberCurrencyStyleElement(String styleNameAttributeValue)
	{
		NumberCurrencyStyleElement  numberCurrencyStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberCurrencyStyleElement.class);
		numberCurrencyStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( numberCurrencyStyle);
		return  numberCurrencyStyle;      
	}
    
	/**
	 * Create child element {@odf.element number:percentage-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element number:percentage-style}
	 * DifferentQName 
	 */
    
	public NumberPercentageStyleElement newNumberPercentageStyleElement(String styleNameAttributeValue)
	{
		NumberPercentageStyleElement  numberPercentageStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberPercentageStyleElement.class);
		numberPercentageStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( numberPercentageStyle);
		return  numberPercentageStyle;      
	}
    
	/**
	 * Create child element {@odf.element number:date-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element number:date-style}
	 * DifferentQName 
	 */
    
	public NumberDateStyleElement newNumberDateStyleElement(String styleNameAttributeValue)
	{
		NumberDateStyleElement  numberDateStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberDateStyleElement.class);
		numberDateStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( numberDateStyle);
		return  numberDateStyle;      
	}
    
	/**
	 * Create child element {@odf.element number:time-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element number:time-style}
	 * DifferentQName 
	 */
    
	public NumberTimeStyleElement newNumberTimeStyleElement(String styleNameAttributeValue)
	{
		NumberTimeStyleElement  numberTimeStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberTimeStyleElement.class);
		numberTimeStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( numberTimeStyle);
		return  numberTimeStyle;      
	}
    
	/**
	 * Create child element {@odf.element number:boolean-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element number:boolean-style}
	 * DifferentQName 
	 */
    
	public NumberBooleanStyleElement newNumberBooleanStyleElement(String styleNameAttributeValue)
	{
		NumberBooleanStyleElement  numberBooleanStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberBooleanStyleElement.class);
		numberBooleanStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( numberBooleanStyle);
		return  numberBooleanStyle;      
	}
    
	/**
	 * Create child element {@odf.element number:text-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element number:text-style}
	 * DifferentQName 
	 */
    
	public NumberTextStyleElement newNumberTextStyleElement(String styleNameAttributeValue)
	{
		NumberTextStyleElement  numberTextStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberTextStyleElement.class);
		numberTextStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( numberTextStyle);
		return  numberTextStyle;      
	}
    
	/**
	 * Create child element {@odf.element style:default-style}.
	 *
	 * @return   return  the element {@odf.element style:default-style}
	 * DifferentQName 
	 */
	public StyleDefaultStyleElement newStyleDefaultStyleElement()
	{
		StyleDefaultStyleElement  styleDefaultStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(StyleDefaultStyleElement.class);
		this.appendChild( styleDefaultStyle);
		return  styleDefaultStyle;
	}                   
               
	/**
	 * Create child element {@odf.element style:default-page-layout}.
	 *
	 * @return   return  the element {@odf.element style:default-page-layout}
	 * DifferentQName 
	 */
	public StyleDefaultPageLayoutElement newStyleDefaultPageLayoutElement()
	{
		StyleDefaultPageLayoutElement  styleDefaultPageLayout = ((OdfFileDom)this.ownerDocument).newOdfElement(StyleDefaultPageLayoutElement.class);
		this.appendChild( styleDefaultPageLayout);
		return  styleDefaultPageLayout;
	}                   
               
	/**
	 * Create child element {@odf.element text:outline-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element text:outline-style}
	 * DifferentQName 
	 */
    
	public TextOutlineStyleElement newTextOutlineStyleElement(String styleNameAttributeValue)
	{
		TextOutlineStyleElement  textOutlineStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(TextOutlineStyleElement.class);
		textOutlineStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( textOutlineStyle);
		return  textOutlineStyle;      
	}
    
	/**
	 * Create child element {@odf.element text:notes-configuration}.
	 *
     * @param textNoteClassAttributeValue  the <code>String</code> value of <code>TextNoteClassAttribute</code>, see {@odf.attribute  text:note-class} at specification
	 * @return   return  the element {@odf.element text:notes-configuration}
	 * DifferentQName 
	 */
    
	public TextNotesConfigurationElement newTextNotesConfigurationElement(String textNoteClassAttributeValue)
	{
		TextNotesConfigurationElement  textNotesConfiguration = ((OdfFileDom)this.ownerDocument).newOdfElement(TextNotesConfigurationElement.class);
		textNotesConfiguration.setTextNoteClassAttribute( textNoteClassAttributeValue );
		this.appendChild( textNotesConfiguration);
		return  textNotesConfiguration;      
	}
    
	/**
	 * Create child element {@odf.element text:bibliography-configuration}.
	 *
	 * @return   return  the element {@odf.element text:bibliography-configuration}
	 * DifferentQName 
	 */
	public TextBibliographyConfigurationElement newTextBibliographyConfigurationElement()
	{
		TextBibliographyConfigurationElement  textBibliographyConfiguration = ((OdfFileDom)this.ownerDocument).newOdfElement(TextBibliographyConfigurationElement.class);
		this.appendChild( textBibliographyConfiguration);
		return  textBibliographyConfiguration;
	}                   
               
	/**
	 * Create child element {@odf.element text:linenumbering-configuration}.
	 *
	 * @return   return  the element {@odf.element text:linenumbering-configuration}
	 * DifferentQName 
	 */
	public TextLinenumberingConfigurationElement newTextLinenumberingConfigurationElement()
	{
		TextLinenumberingConfigurationElement  textLinenumberingConfiguration = ((OdfFileDom)this.ownerDocument).newOdfElement(TextLinenumberingConfigurationElement.class);
		this.appendChild( textLinenumberingConfiguration);
		return  textLinenumberingConfiguration;
	}                   
               
	/**
	 * Create child element {@odf.element draw:gradient}.
	 *
     * @param drawStyleAttributeValue  the <code>String</code> value of <code>DrawStyleAttribute</code>, see {@odf.attribute  draw:style} at specification
	 * @return   return  the element {@odf.element draw:gradient}
	 * DifferentQName 
	 */
    
	public DrawGradientElement newDrawGradientElement(String drawStyleAttributeValue)
	{
		DrawGradientElement  drawGradient = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawGradientElement.class);
		drawGradient.setDrawStyleAttribute( drawStyleAttributeValue );
		this.appendChild( drawGradient);
		return  drawGradient;      
	}
    
	/**
	 * Create child element {@odf.element svg:linearGradient}.
	 *
     * @param drawNameAttributeValue  the <code>String</code> value of <code>DrawNameAttribute</code>, see {@odf.attribute  draw:name} at specification
	 * @return   return  the element {@odf.element svg:linearGradient}
	 * DifferentQName 
	 */
    
	public SvgLinearGradientElement newSvgLinearGradientElement(String drawNameAttributeValue)
	{
		SvgLinearGradientElement  svgLinearGradient = ((OdfFileDom)this.ownerDocument).newOdfElement(SvgLinearGradientElement.class);
		svgLinearGradient.setDrawNameAttribute( drawNameAttributeValue );
		this.appendChild( svgLinearGradient);
		return  svgLinearGradient;      
	}
    
	/**
	 * Create child element {@odf.element svg:radialGradient}.
	 *
     * @param drawNameAttributeValue  the <code>String</code> value of <code>DrawNameAttribute</code>, see {@odf.attribute  draw:name} at specification
	 * @return   return  the element {@odf.element svg:radialGradient}
	 * DifferentQName 
	 */
    
	public SvgRadialGradientElement newSvgRadialGradientElement(String drawNameAttributeValue)
	{
		SvgRadialGradientElement  svgRadialGradient = ((OdfFileDom)this.ownerDocument).newOdfElement(SvgRadialGradientElement.class);
		svgRadialGradient.setDrawNameAttribute( drawNameAttributeValue );
		this.appendChild( svgRadialGradient);
		return  svgRadialGradient;      
	}
    
	/**
	 * Create child element {@odf.element draw:hatch}.
	 *
     * @param drawNameAttributeValue  the <code>String</code> value of <code>DrawNameAttribute</code>, see {@odf.attribute  draw:name} at specification
	 * @param drawStyleAttributeValue  the <code>String</code> value of <code>DrawStyleAttribute</code>, see {@odf.attribute  draw:style} at specification
	 * @return   return  the element {@odf.element draw:hatch}
	 * DifferentQName 
	 */
    
	public DrawHatchElement newDrawHatchElement(String drawNameAttributeValue, String drawStyleAttributeValue)
	{
		DrawHatchElement  drawHatch = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawHatchElement.class);
		drawHatch.setDrawNameAttribute( drawNameAttributeValue );
		drawHatch.setDrawStyleAttribute( drawStyleAttributeValue );
		this.appendChild( drawHatch);
		return  drawHatch;      
	}
    
	/**
	 * Create child element {@odf.element draw:fill-image}.
	 *
     * @param drawNameAttributeValue  the <code>String</code> value of <code>DrawNameAttribute</code>, see {@odf.attribute  draw:name} at specification
	 * @param xlinkHrefAttributeValue  the <code>String</code> value of <code>XlinkHrefAttribute</code>, see {@odf.attribute  xlink:href} at specification
	 * @param xlinkTypeAttributeValue  the <code>String</code> value of <code>XlinkTypeAttribute</code>, see {@odf.attribute  xlink:type} at specification
	 * @return   return  the element {@odf.element draw:fill-image}
	 * DifferentQName 
	 */
    
	public DrawFillImageElement newDrawFillImageElement(String drawNameAttributeValue, String xlinkHrefAttributeValue, String xlinkTypeAttributeValue)
	{
		DrawFillImageElement  drawFillImage = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawFillImageElement.class);
		drawFillImage.setDrawNameAttribute( drawNameAttributeValue );
		drawFillImage.setXlinkHrefAttribute( xlinkHrefAttributeValue );
		drawFillImage.setXlinkTypeAttribute( xlinkTypeAttributeValue );
		this.appendChild( drawFillImage);
		return  drawFillImage;      
	}
    
	/**
	 * Create child element {@odf.element draw:marker}.
	 *
     * @param drawNameAttributeValue  the <code>String</code> value of <code>DrawNameAttribute</code>, see {@odf.attribute  draw:name} at specification
	 * @param svgDAttributeValue  the <code>String</code> value of <code>SvgDAttribute</code>, see {@odf.attribute  svg:d} at specification
	 * @param svgViewBoxAttributeValue  the <code>String</code> value of <code>SvgViewBoxAttribute</code>, see {@odf.attribute  svg:viewBox} at specification
	 * @return   return  the element {@odf.element draw:marker}
	 * DifferentQName 
	 */
    
	public DrawMarkerElement newDrawMarkerElement(String drawNameAttributeValue, String svgDAttributeValue, String svgViewBoxAttributeValue)
	{
		DrawMarkerElement  drawMarker = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawMarkerElement.class);
		drawMarker.setDrawNameAttribute( drawNameAttributeValue );
		drawMarker.setSvgDAttribute( svgDAttributeValue );
		drawMarker.setSvgViewBoxAttribute( svgViewBoxAttributeValue );
		this.appendChild( drawMarker);
		return  drawMarker;      
	}
    
	/**
	 * Create child element {@odf.element draw:stroke-dash}.
	 *
     * @param drawNameAttributeValue  the <code>String</code> value of <code>DrawNameAttribute</code>, see {@odf.attribute  draw:name} at specification
	 * @return   return  the element {@odf.element draw:stroke-dash}
	 * DifferentQName 
	 */
    
	public DrawStrokeDashElement newDrawStrokeDashElement(String drawNameAttributeValue)
	{
		DrawStrokeDashElement  drawStrokeDash = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawStrokeDashElement.class);
		drawStrokeDash.setDrawNameAttribute( drawNameAttributeValue );
		this.appendChild( drawStrokeDash);
		return  drawStrokeDash;      
	}
    
	/**
	 * Create child element {@odf.element draw:opacity}.
	 *
     * @param drawStyleAttributeValue  the <code>String</code> value of <code>DrawStyleAttribute</code>, see {@odf.attribute  draw:style} at specification
	 * @return   return  the element {@odf.element draw:opacity}
	 * DifferentQName 
	 */
    
	public DrawOpacityElement newDrawOpacityElement(String drawStyleAttributeValue)
	{
		DrawOpacityElement  drawOpacity = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawOpacityElement.class);
		drawOpacity.setDrawStyleAttribute( drawStyleAttributeValue );
		this.appendChild( drawOpacity);
		return  drawOpacity;      
	}
    
	/**
	 * Create child element {@odf.element style:presentation-page-layout}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element style:presentation-page-layout}
	 * DifferentQName 
	 */
    
	public StylePresentationPageLayoutElement newStylePresentationPageLayoutElement(String styleNameAttributeValue)
	{
		StylePresentationPageLayoutElement  stylePresentationPageLayout = ((OdfFileDom)this.ownerDocument).newOdfElement(StylePresentationPageLayoutElement.class);
		stylePresentationPageLayout.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( stylePresentationPageLayout);
		return  stylePresentationPageLayout;      
	}
    
}
