/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    
package org.odftoolkit.odfdom.dom.attribute.text;

import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.OdfAttribute;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.text.TextChapterElement;
import org.odftoolkit.odfdom.dom.element.text.TextExpressionElement;
import org.odftoolkit.odfdom.dom.element.text.TextFileNameElement;
import org.odftoolkit.odfdom.dom.element.text.TextIndexEntryChapterElement;
import org.odftoolkit.odfdom.dom.element.text.TextSectionElement;
import org.odftoolkit.odfdom.dom.element.text.TextTableFormulaElement;
import org.odftoolkit.odfdom.dom.element.text.TextTemplateNameElement;
import org.odftoolkit.odfdom.dom.element.text.TextUserFieldGetElement;
import org.odftoolkit.odfdom.dom.element.text.TextVariableGetElement;
import org.odftoolkit.odfdom.dom.element.text.TextVariableInputElement;
import org.odftoolkit.odfdom.dom.element.text.TextVariableSetElement;
     
/**
 * DOM implementation of OpenDocument attribute  {@odf.attribute text:display}.
 *
 */
public class TextDisplayAttribute extends OdfAttribute {

	public static final OdfName ATTRIBUTE_NAME = OdfName.newName( OdfNamespaceNames.TEXT, "display" );
	public static final String DEFAULT_VALUE = "number";

	/**
	 * Create the instance of OpenDocument attribute {@odf.attribute text:display}.
	 * 
	 * @param ownerDocument       The type is <code>OdfFileDom</code>
	 */
	public TextDisplayAttribute(OdfFileDom ownerDocument) {
		super(ownerDocument, ATTRIBUTE_NAME);
	}
	
	/**
	 * Returns the attribute name.
	 * 
	 * @return the <code>OdfName</code> for {@odf.attribute text:display}.
	 */
	@Override
	public OdfName getOdfName() {
		return ATTRIBUTE_NAME;
	}
	
	/**
	 * @return Returns the name of this attribute.
	 */
	@Override
	public String getName() {
		return ATTRIBUTE_NAME.getLocalName();
	}

	/**
	 * The value set of {@odf.attribute text:display}.
	 */
	public enum Value {
	 
	 AREA( "area" ), CONDITION( "condition" ), FORMULA( "formula" ), FULL( "full" ), NAME( "name" ), NAME_AND_EXTENSION( "name-and-extension" ), NONE( "none" ), NUMBER( "number" ), NUMBER_AND_NAME( "number-and-name" ), PATH( "path" ), PLAIN_NUMBER( "plain-number" ), PLAIN_NUMBER_AND_NAME( "plain-number-and-name" ), TITLE( "title" ), TRUE( "true" ), VALUE( "value" );
              
		private String mValue;

		Value( String value )
		{
			mValue = value;
		}
	 	
		@Override
		public String toString()
		{
			return mValue;
		}
		
		public static Value enumValueOf( String value )
	    {
	        for( Value aIter : values() )
	        {
	            if( value.equals( aIter.toString() ) )
	            {
	                return aIter;
	            }
	        }
	        return null;
	    }
	}
	 
	/**
	 * @param attrValue The <code>Enum</code> value of the attribute.
	 */
	public void setEnumValue(Value attrValue) {
		setValue(attrValue.toString());
	}
    
	/**
	 * @return Returns the <code>Enum</code> value of the attribute
	 */
	public Value getEnumValue(){
		return Value.enumValueOf(this.getValue());
	}
    
	/**
	 * @param attrValue The <code>String</code> value of the attribute.
	 * @throws IllegalArgumentException If the provided attribute value is invalid
	 */
	@Override
	public void setValue(String attrValue) {
		OdfElement parentElement = (OdfElement)getOwnerElement();
		if( parentElement != null ){
			try {
				if( parentElement instanceof StyleTextPropertiesElement ){
					super.setValue(StyleTextPropertiesElement.TextDisplayAttributeValue.enumValueOf(attrValue).toString());
				}else if( parentElement instanceof TextChapterElement ){
					super.setValue(TextChapterElement.TextDisplayAttributeValue.enumValueOf(attrValue).toString());
				}else if( parentElement instanceof TextExpressionElement ){
					super.setValue(TextExpressionElement.TextDisplayAttributeValue.enumValueOf(attrValue).toString());
				}else if( parentElement instanceof TextFileNameElement ){
					super.setValue(TextFileNameElement.TextDisplayAttributeValue.enumValueOf(attrValue).toString());
				}else if( parentElement instanceof TextIndexEntryChapterElement ){
					super.setValue(TextIndexEntryChapterElement.TextDisplayAttributeValue.enumValueOf(attrValue).toString());
				}else if( parentElement instanceof TextSectionElement ){
					super.setValue(TextSectionElement.TextDisplayAttributeValue.enumValueOf(attrValue).toString());
				}else if( parentElement instanceof TextTableFormulaElement ){
					super.setValue(TextTableFormulaElement.TextDisplayAttributeValue.enumValueOf(attrValue).toString());
				}else if( parentElement instanceof TextTemplateNameElement ){
					super.setValue(TextTemplateNameElement.TextDisplayAttributeValue.enumValueOf(attrValue).toString());
				}else if( parentElement instanceof TextUserFieldGetElement ){
					super.setValue(TextUserFieldGetElement.TextDisplayAttributeValue.enumValueOf(attrValue).toString());
				}else if( parentElement instanceof TextVariableGetElement ){
					super.setValue(TextVariableGetElement.TextDisplayAttributeValue.enumValueOf(attrValue).toString());
				}else if( parentElement instanceof TextVariableInputElement ){
					super.setValue(TextVariableInputElement.TextDisplayAttributeValue.enumValueOf(attrValue).toString());
				}else if( parentElement instanceof TextVariableSetElement ){
					super.setValue(TextVariableSetElement.TextDisplayAttributeValue.enumValueOf(attrValue).toString());
				}			
			} catch (NullPointerException e) {
				// TODO: validation handling/logging
				throw new IllegalArgumentException(e);
			}
			  catch (IllegalArgumentException e) {
				// TODO: validation handling/logging
				throw (e);
			}
		}else{
			//2DO:what should do when the owner element is null?
			super.setValue(attrValue);
		}
	}
    
	/**
	 * @return Returns the <code>String</code> value of the attribute
	 */
	@Override
	public String getValue(){
		OdfElement parentElement = (OdfElement)getOwnerElement();
		if( parentElement != null ){
			try {
				if( parentElement instanceof StyleTextPropertiesElement ){
					return super.getValue();
				}else if( parentElement instanceof TextChapterElement ){
					return TextChapterElement.TextDisplayAttributeValue.enumValueOf(super.getValue()).toString();
				}else if( parentElement instanceof TextExpressionElement ){
					return TextExpressionElement.TextDisplayAttributeValue.enumValueOf(super.getValue()).toString();
				}else if( parentElement instanceof TextFileNameElement ){
					return TextFileNameElement.TextDisplayAttributeValue.enumValueOf(super.getValue()).toString();
				}else if( parentElement instanceof TextIndexEntryChapterElement ){
					return TextIndexEntryChapterElement.TextDisplayAttributeValue.enumValueOf(super.getValue()).toString();
				}else if( parentElement instanceof TextSectionElement ){
					return TextSectionElement.TextDisplayAttributeValue.enumValueOf(super.getValue()).toString();
				}else if( parentElement instanceof TextTableFormulaElement ){
					return TextTableFormulaElement.TextDisplayAttributeValue.enumValueOf(super.getValue()).toString();
				}else if( parentElement instanceof TextTemplateNameElement ){
					return TextTemplateNameElement.TextDisplayAttributeValue.enumValueOf(super.getValue()).toString();
				}else if( parentElement instanceof TextUserFieldGetElement ){
					return TextUserFieldGetElement.TextDisplayAttributeValue.enumValueOf(super.getValue()).toString();
				}else if( parentElement instanceof TextVariableGetElement ){
					return TextVariableGetElement.TextDisplayAttributeValue.enumValueOf(super.getValue()).toString();
				}else if( parentElement instanceof TextVariableInputElement ){
					return TextVariableInputElement.TextDisplayAttributeValue.enumValueOf(super.getValue()).toString();
				}else if( parentElement instanceof TextVariableSetElement ){
					return TextVariableSetElement.TextDisplayAttributeValue.enumValueOf(super.getValue()).toString();
				}			
			} catch (IllegalArgumentException e) {
				// TODO: validation handling/logging
				throw new NumberFormatException("the value of text:display is not valid");
			}
		}else{
			//2DO:what should do when the owner element is null?
			return super.getValue();
		}
		return null;
	}
	/**
	 * Returns the default value of {@odf.attribute text:display} dependent of its element name
	 * 
	 * @return the default value as <code>String</code>, 
	 *         return <code>null</code> if the default value does not exist
	 */
	@Override
	public String getDefault() {
		OdfElement parentElement = (OdfElement)getOwnerElement();
		String defaultValue = null;
		if (parentElement != null) {
			defaultValue = DEFAULT_VALUE;			
		}
		return defaultValue;
	}

	/**
	 * Default value indicator. As the attribute default value is dependent from its element, the attribute has only a default, when a parent element exists.
	 * 
	 * @return <code>true</code> if {@odf.attribute text:display} has an element parent 
	 *         otherwise return <code>false</code> as undefined.
	 */
	@Override
	public boolean hasDefault() {
		return getOwnerElement() == null ? false : true;
	}
	
	/**
	 * @return Returns whether this attribute is known to be of type ID (i.e. xml:id ?)
	 */
	@Override
	public boolean isId() {
		return false;
    
	}
}
