/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.publication.externalize;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.entities.WikittyLabelHelper;
import org.nuiton.wikitty.entities.WikittyLabelImpl;
import org.nuiton.wikitty.publication.AbstractWikittyFileService;
import org.nuiton.wikitty.publication.MimeTypePubHelper;
import org.nuiton.wikitty.publication.WikittyFileUtil;
import org.nuiton.wikitty.publication.WikittyPropertieIndex;
import org.nuiton.wikitty.publication.entities.WikittyPubDataHelper;
import org.nuiton.wikitty.publication.entities.WikittyPubDataImpl;
import org.nuiton.wikitty.publication.entities.WikittyPubTextCompiledHelper;
import org.nuiton.wikitty.publication.entities.WikittyPubTextCompiledImpl;
import org.nuiton.wikitty.publication.entities.WikittyPubTextHelper;
import org.nuiton.wikitty.publication.entities.WikittyPubTextImpl;
import org.nuiton.wikitty.publication.externalize.JarUtil;
import org.nuiton.wikitty.publication.externalize.WikittyPublicationExternalize;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.TreeNodeResult;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittyListener;

public class WikittyServiceJarLoader
extends AbstractWikittyFileService {
    public static String JAR_LOCATION_KEY = "wikitty.publication.repository.jar";
    public static String JAR_PATH_SEPARATOR = "/";
    private static Log log = LogFactory.getLog(WikittyServiceJarLoader.class);
    protected String dirLocation;
    protected String MD5;
    protected Map<JarFile, WikittyPropertieIndex> index;
    protected MimeTypePubHelper mimeHelper = new MimeTypePubHelper();

    public WikittyServiceJarLoader(ApplicationConfig config) {
        this.dirLocation = config.getOption(JAR_LOCATION_KEY);
        this.index = new HashMap<JarFile, WikittyPropertieIndex>();
        this.MD5 = StringUtil.encodeMD5((String)"");
        this.constructIndex();
    }

    protected void constructIndex() {
        block6: {
            try {
                log.info((Object)("Initialize Jar Index on dir" + this.dirLocation));
                File jarLocation = new File(this.dirLocation);
                File[] jarFiles = jarLocation.listFiles(JarUtil.jarFilter);
                String sumMd5 = "";
                if (jarFiles != null) {
                    for (File jf : jarFiles) {
                        sumMd5 = sumMd5 + jf.getAbsolutePath();
                    }
                }
                if (!(sumMd5 = StringUtil.encodeMD5((String)sumMd5)).equals(this.MD5)) {
                    this.index = new HashMap<JarFile, WikittyPropertieIndex>();
                    for (File jf : jarFiles) {
                        JarFile tempJF = new JarFile(jf);
                        JarEntry metaEntry = tempJF.getJarEntry(WikittyFileUtil.WIKITTY_FILE_META_PROPERTIES_FILE);
                        JarEntry idEntry = tempJF.getJarEntry(WikittyFileUtil.WIKITTY_ID_PROPERTIES_FILE);
                        Properties wikittyIndex = new Properties();
                        wikittyIndex.load(tempJF.getInputStream(idEntry));
                        Properties wikittyMetadata = new Properties();
                        wikittyMetadata.load(tempJF.getInputStream(metaEntry));
                        WikittyPropertieIndex indexProps = new WikittyPropertieIndex(wikittyIndex, wikittyMetadata);
                        this.index.put(tempJF, indexProps);
                    }
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"Error while loading jars:", (Throwable)e);
            }
        }
    }

    public void addWikittyServiceListener(WikittyListener listener, WikittyService.ServiceListenerType type) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void removeWikittyServiceListener(WikittyListener listener, WikittyService.ServiceListenerType type) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String login(String login, String password) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void logout(String securityToken) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public WikittyEvent clear(String securityToken) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public boolean canWrite(String securityToken, Wikitty wikitty) {
        return false;
    }

    public boolean canDelete(String securityToken, String wikittyId) {
        return false;
    }

    public boolean canRead(String securityToken, String wikittyId) {
        return this.exists(securityToken, wikittyId);
    }

    public boolean exists(String securityToken, String wikittyId) {
        return this.exists(wikittyId);
    }

    protected boolean exists(String wikittyId) {
        boolean result = false;
        for (WikittyPropertieIndex in : this.index.values()) {
            if (!(result = result || in.containtId(wikittyId))) continue;
            break;
        }
        return result;
    }

    public boolean isDeleted(String securityToken, String wikittyId) {
        return false;
    }

    public WikittyEvent replay(String securityToken, List<WikittyEvent> events, boolean force) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public WikittyEvent store(String securityToken, Collection<Wikitty> wikitties, boolean force) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<String> getAllExtensionIds(String securityToken) {
        LinkedList<String> result = new LinkedList<String>();
        result.add("WikittyPubData");
        result.add("WikittyPubText");
        result.add("WikittyPubTextCompiled");
        result.add("WikittyLabel");
        return result;
    }

    public List<String> getAllExtensionsRequires(String securityToken, String extensionName) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public WikittyEvent storeExtension(String securityToken, Collection<WikittyExtension> exts) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public WikittyEvent deleteExtension(String securityToken, Collection<String> extNames) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public WikittyExtension restoreExtension(String securityToken, String extensionId) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken, String name) {
        WikittyExtension result = super.restoreExtensionLastVersion(securityToken, name);
        if (result != null) {
            return result;
        }
        if (name.equals("WikittyPubTextCompiled")) {
            return WikittyPubTextCompiledImpl.extensionWikittyPubTextCompiled;
        }
        return null;
    }

    public List<Wikitty> restore(String securityToken, List<String> ids) {
        LinkedList<Wikitty> result = new LinkedList<Wikitty>();
        for (String wikittyId : ids) {
            result.add(this.restore(wikittyId));
        }
        return result;
    }

    public WikittyEvent delete(String securityToken, Collection<String> ids) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    protected Map<String, Wikitty> getAllWikitties() {
        this.constructIndex();
        HashMap<String, Wikitty> result = new HashMap<String, Wikitty>();
        for (WikittyPropertieIndex in : this.index.values()) {
            for (Object oId : in.getIds()) {
                String id = oId.toString();
                result.put(id, this.restore(id));
            }
        }
        return result;
    }

    public WikittyEvent deleteTree(String securityToken, String treeNodeId) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public TreeNodeResult<String> findTreeNode(String securityToken, String wikittyId, int depth, boolean count, Criteria filter) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Wikitty restoreVersion(String securityToken, String wikittyId, String version) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void syncSearchEngine(String securityToken) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    protected Wikitty restore(String wikittyId) {
        WikittyImpl wikit;
        block10: {
            wikit = null;
            if (!this.exists(wikittyId)) {
                return null;
            }
            Properties wikittyMetadata = null;
            Properties wikittyIndex = null;
            JarFile wikittyJarRepository = null;
            for (Map.Entry<JarFile, WikittyPropertieIndex> en : this.index.entrySet()) {
                if (!en.getValue().containtId(wikittyId)) continue;
                wikittyJarRepository = en.getKey();
                wikittyIndex = en.getValue().getWikittyIndex();
                wikittyMetadata = en.getValue().getWikittyMetadata();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("restoring on " + wikittyJarRepository));
            }
            String mime = wikittyMetadata.getProperty(wikittyId + WikittyPublicationExternalize.MIME_SUFFIX);
            String fileExtension = this.mimeHelper.getExtensionForMime(mime);
            String path = wikittyIndex.getProperty(wikittyId);
            String version = wikittyMetadata.getProperty(wikittyId + WikittyPublicationExternalize.VERSION_SUFFIX);
            JarEntry wikittyJared = wikittyJarRepository.getJarEntry(path + "." + fileExtension);
            wikit = new WikittyImpl(wikittyId);
            wikit.setVersion(version);
            wikit.addExtension(WikittyLabelImpl.extensionWikittyLabel);
            String[] namPath = StringUtil.split((String)path, (String)JAR_PATH_SEPARATOR);
            String wikittyName = namPath[namPath.length - 1];
            String label = "";
            for (int i = 0; i < namPath.length - 1; ++i) {
                label = label + namPath[i];
                if (i >= namPath.length - 2) continue;
                label = label + WikittyFileUtil.WIKITTY_LABEL_SEPARATOR;
            }
            WikittyLabelHelper.addLabels((Wikitty)wikit, (String)label);
            try {
                if (this.mimeHelper.isPubTextMime(mime)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Handle Wikitty pubtext: " + wikit));
                    }
                    wikit.addExtension(WikittyPubTextImpl.extensions);
                    wikit.addExtension(WikittyPubTextCompiledImpl.extensionWikittyPubTextCompiled);
                    WikittyPubTextHelper.setMimeType((Wikitty)wikit, mime);
                    WikittyPubTextHelper.setName((Wikitty)wikit, wikittyName);
                    JarEntry wikittyclass = wikittyJarRepository.getJarEntry(path + WikittyPublicationExternalize.COMPILED_EXTENSION);
                    WikittyPubTextHelper.setContent((Wikitty)wikit, JarUtil.getStringContent(wikittyJarRepository, wikittyJared));
                    byte[] bytCont = JarUtil.getByteContent(wikittyJarRepository, wikittyclass);
                    WikittyPubTextCompiledHelper.setByteCode((Wikitty)wikit, bytCont);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Handle Wikitty pubdata: " + wikit));
                    }
                    wikit.addExtension(WikittyPubDataImpl.extensionWikittyPubData);
                    WikittyPubDataHelper.setMimeType((Wikitty)wikit, mime);
                    WikittyPubDataHelper.setName((Wikitty)wikit, wikittyName);
                    WikittyPubDataHelper.setContent((Wikitty)wikit, JarUtil.getByteContent(wikittyJarRepository, wikittyJared));
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block10;
                log.error((Object)("Error while reading jar:" + wikittyJarRepository.getName()), (Throwable)e);
            }
        }
        return wikit;
    }
}

